/*
 * Decompiled with CFR 0.152.
 */
package org.jimmutable.aws.blob_store;

import java.io.File;
import org.jimmutable.aws.s3.S3Path;
import org.jimmutable.core.utils.Validator;

public class BlobStoreUploadRequest {
    private S3Path base_path;
    private String fixed_portion_of_name;
    private String extension;
    private File src;

    public BlobStoreUploadRequest(File src, S3Path base_path, String fixed_portion_of_name, String extension) {
        Validator.notNull((Object[])new Object[]{src, base_path, fixed_portion_of_name, extension});
        this.src = src;
        this.base_path = base_path;
        this.fixed_portion_of_name = fixed_portion_of_name.trim().toLowerCase();
        this.extension = extension.trim().toLowerCase();
        Validator.containsOnlyValidCharacters((String)this.fixed_portion_of_name, (Validator.ValidCharacters[])new Validator.ValidCharacters[]{Validator.LOWERCASE_LETTERS, Validator.NUMBERS, Validator.DASH});
        Validator.containsOnlyValidCharacters((String)this.extension, (Validator.ValidCharacters[])new Validator.ValidCharacters[]{Validator.LOWERCASE_LETTERS, Validator.NUMBERS});
    }

    public S3Path getSimpleBasePath() {
        return this.base_path;
    }

    public String getSimpleFixedPortionOfName() {
        return this.fixed_portion_of_name;
    }

    public String getSimpleExtension() {
        return this.extension;
    }
}

