/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.quarkus.extension;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.jgroups.JChannel;
import org.jgroups.protocols.TP;
import org.jgroups.quarkus.extension.JChannelConfig;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.NonReflectiveProbeHandler;

@ApplicationScoped
public class JChannelProducer {
    JChannel channel;
    DiagnosticsHandler.ProbeHandler handler;

    void create(JChannelConfig cfg) throws Exception {
        this.channel = new JChannel(cfg.config);
        this.handler = new NonReflectiveProbeHandler(this.channel).initialize((Collection)this.channel.getProtocolStack().getProtocols());
    }

    @Singleton
    @Produces
    public JChannel channel() {
        return this.channel;
    }

    @Singleton
    public void connect(String cluster) throws Exception {
        this.channel.connect(cluster);
        TP transport = this.channel.getProtocolStack().getTransport();
        DiagnosticsHandler diag_handler = transport.getDiagnosticsHandler();
        if (diag_handler != null) {
            Set probe_handlers = diag_handler.getProbeHandlers();
            probe_handlers.removeIf(probe_handler -> {
                String[] keys = probe_handler.supportedKeys();
                return keys != null && Stream.of(keys).anyMatch(s -> s.startsWith("jmx"));
            });
        }
        this.channel.getProtocolStack().getTransport().registerProbeHandler(this.handler);
    }
}

