/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.View;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.raft.testfwk.RaftTestUtils;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.Util;

public class Utils {
    public static boolean majorityReached(View old, View new_view, int majority) {
        return (old == null || old.size() < majority) && new_view.size() >= majority;
    }

    public static boolean majorityLost(View old, View new_view, int majority) {
        return old != null && old.size() >= majority && new_view.size() < majority;
    }

    public static Majority computeMajority(View old, View new_view, int majority, Address leader) {
        if (Utils.majorityReached(old, new_view, majority)) {
            return Majority.reached;
        }
        if (Utils.majorityLost(old, new_view, majority)) {
            return Majority.lost;
        }
        if (leader != null && !new_view.containsMember(leader)) {
            return Majority.leader_lost;
        }
        return Majority.no_change;
    }

    public static boolean isMajorityReached(Collection<String> oldMembers, Collection<String> newMembers, int majority) {
        return (oldMembers == null || oldMembers.size() < majority) && newMembers.size() >= majority;
    }

    public static boolean isMajorityLost(Collection<String> oldMembers, Collection<String> newMembers, int majority) {
        return oldMembers != null && oldMembers.size() >= majority && newMembers.size() < majority;
    }

    public static Majority computeMajority(View oldView, View newView, RAFT raft) {
        Collection<String> newMembers;
        List<String> allRaftMembers = raft.members();
        Collection<String> oldMembers = Utils.convertJGroupsMemberToRaftMember(oldView, allRaftMembers);
        if (Utils.isMajorityReached(oldMembers, newMembers = Utils.convertJGroupsMemberToRaftMember(newView, allRaftMembers), raft.majority())) {
            return Majority.reached;
        }
        if (Utils.isMajorityLost(oldMembers, newMembers, raft.majority())) {
            return Majority.lost;
        }
        if (raft.leader() != null && !newView.containsMember(raft.leader())) {
            return Majority.leader_lost;
        }
        return Majority.no_change;
    }

    public static boolean viewCoordinatorChanged(View prev, View curr) {
        if (prev == null) {
            return true;
        }
        return !Objects.equals(prev.getCoord(), curr.getCoord());
    }

    @Deprecated(since="1.0.13", forRemoval=true)
    public static void deleteLog(RAFT r) throws Exception {
        RaftTestUtils.deleteRaftLog(r);
    }

    public static boolean isRaftMember(String raftId, Collection<String> raftMembers) {
        return raftMembers.contains(raftId);
    }

    private static Collection<String> convertJGroupsMemberToRaftMember(View view, Collection<String> raftMembers) {
        if (view == null) {
            return null;
        }
        return Arrays.stream(view.getMembersRaw()).map(Utils::extractRaftId).filter(raftMembers::contains).collect(Collectors.toSet());
    }

    public static String extractRaftId(Address address) {
        if (!(address instanceof ExtendedUUID)) {
            throw new IllegalStateException("Address is not ExtendedUUID");
        }
        ExtendedUUID uuid = (ExtendedUUID)address;
        return Util.bytesToString((byte[])uuid.get(RAFT.raft_id_key));
    }

    public static enum Majority {
        reached,
        lost,
        leader_lost,
        no_change;

    }
}

