/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jgroups.util.SizeStreamable;
import org.jgroups.util.Util;

public class PersistentState
implements SizeStreamable {
    private final List<String> members = new ArrayList<String>();

    public List<String> getMembers() {
        return new ArrayList<String>(this.members);
    }

    public void setMembers(Collection<String> value) {
        this.members.clear();
        this.members.addAll(new HashSet<String>(value));
    }

    public void writeTo(DataOutput out) throws IOException {
        int size = this.members.size();
        out.writeInt(size);
        for (String member : this.members) {
            out.writeUTF(member);
        }
    }

    public void readFrom(DataInput in) throws IOException {
        int size = in.readInt();
        ArrayList<String> tmp = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            tmp.add(in.readUTF());
        }
        this.setMembers(tmp);
    }

    public int serializedSize() {
        int size = 4;
        for (String member : this.members) {
            size += Util.size((String)member);
        }
        return size;
    }

    public String toString() {
        return String.format("members=%s", this.members);
    }
}

