/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control.gauge.linear.elements;

import jfxtras.scene.control.gauge.linear.AbstractLinearGauge;
import jfxtras.scene.control.gauge.linear.elements.Segment;

public class PercentSegment
implements Segment {
    private final String id;
    private final double minPercent;
    private final double maxPercent;
    private final AbstractLinearGauge<?> linearGauge;

    public PercentSegment(AbstractLinearGauge<?> linearGauge, double minPercent, double maxPercent, String id) {
        this.id = id;
        this.minPercent = minPercent;
        this.maxPercent = maxPercent;
        this.linearGauge = linearGauge;
    }

    public PercentSegment(AbstractLinearGauge<?> linearGauge, double minPercent, double maxPercent) {
        this.id = null;
        this.minPercent = minPercent;
        this.maxPercent = maxPercent;
        this.linearGauge = linearGauge;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public double getMinValue() {
        double minValue = this.linearGauge.getMinValue();
        double maxValue = this.linearGauge.getMaxValue();
        return minValue + (maxValue - minValue) * this.minPercent / 100.0;
    }

    @Override
    public double getMaxValue() {
        double minValue = this.linearGauge.getMinValue();
        double maxValue = this.linearGauge.getMaxValue();
        return minValue + (maxValue - minValue) * this.maxPercent / 100.0;
    }
}

