/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.gauge.linear.skin;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.SimpleStyleableStringProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.StringConverter;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import jfxtras.css.CssMetaDataForSkinProperty;
import jfxtras.scene.control.gauge.linear.AbstractLinearGauge;
import jfxtras.scene.control.gauge.linear.elements.Indicator;
import jfxtras.scene.control.gauge.linear.elements.Marker;
import jfxtras.scene.control.gauge.linear.elements.Segment;

public class AbstractLinearGaugeSkin<T, C extends AbstractLinearGauge<?>>
extends SkinBase<C> {
    private ObjectProperty<Animated> animatedProperty = new SimpleStyleableObjectProperty(StyleableProperties.ANIMATED_CSSMETADATA, (Object)((Animated)((Object)StyleableProperties.ANIMATED_CSSMETADATA.getInitialValue(null))));
    private SimpleStyleableStringProperty valueFormatProperty = new SimpleStyleableStringProperty(StyleableProperties.VALUE_FORMAT_CSSMETADATA, (String)StyleableProperties.VALUE_FORMAT_CSSMETADATA.getInitialValue(null)){};

    public AbstractLinearGaugeSkin(C control) {
        super(control);
    }

    public final ObjectProperty<Animated> animatedProperty() {
        return this.animatedProperty;
    }

    public final void setAnimated(Animated value) {
        this.animatedProperty().set((Object)value);
    }

    public final Animated getAnimated() {
        return (Animated)((Object)this.animatedProperty.get());
    }

    public final T withAnimated(Animated value) {
        this.setAnimated(value);
        return (T)((Object)this);
    }

    public final SimpleStyleableStringProperty valueFormatProperty() {
        return this.valueFormatProperty;
    }

    public final void setValueFormat(String value) {
        this.valueFormatProperty.set(value);
    }

    public final String getValueFormat() {
        return this.valueFormatProperty.get();
    }

    public final T withValueFormat(String value) {
        this.setValueFormat(value);
        return (T)((Object)this);
    }

    protected String valueFormat(double value) {
        return new DecimalFormat(this.getValueFormat()).format(value);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return AbstractLinearGaugeSkin.getClassCssMetaData();
    }

    protected String validateValue() {
        double controlMinValue = ((AbstractLinearGauge)this.getSkinnable()).getMinValue();
        double controlMaxValue = ((AbstractLinearGauge)this.getSkinnable()).getMaxValue();
        double controlValue = ((AbstractLinearGauge)this.getSkinnable()).getValue();
        if (controlMinValue > controlMaxValue) {
            return String.format("Min-value (%f) cannot be greater than max-value (%f)", controlMinValue, controlMaxValue);
        }
        if (controlMinValue > controlValue) {
            return String.format("Min-value (%f) cannot be greater than the value (%f)", controlMinValue, controlValue);
        }
        if (controlValue > controlMaxValue) {
            return String.format("Value (%f) cannot be greater than max-value (%f)", controlValue, controlMaxValue);
        }
        return null;
    }

    protected String validateSegment(Segment segment) {
        double controlMinValue = ((AbstractLinearGauge)this.getSkinnable()).getMinValue();
        double controlMaxValue = ((AbstractLinearGauge)this.getSkinnable()).getMaxValue();
        double segmentMinValue = segment.getMinValue();
        double segmentMaxValue = segment.getMaxValue();
        if (segmentMinValue < controlMinValue) {
            return String.format("Segments min-value (%f) cannot be less than the controls min-value (%f)", segmentMinValue, controlMinValue);
        }
        if (segmentMaxValue > controlMaxValue) {
            return String.format("Segments max-value (%f) cannot be greater than the controls max-value (%f)", segmentMaxValue, controlMaxValue);
        }
        return null;
    }

    protected String validateMarker(Marker marker) {
        double controlMinValue = ((AbstractLinearGauge)this.getSkinnable()).getMinValue();
        double controlMaxValue = ((AbstractLinearGauge)this.getSkinnable()).getMaxValue();
        double markerValue = marker.getValue();
        if (markerValue < controlMinValue) {
            return String.format("Marker value (%f) cannot be less than the controls min-value (%f)", markerValue, controlMinValue);
        }
        if (markerValue > controlMaxValue) {
            return String.format("Marker max-value (%f) cannot be greater than the controls max-value (%f)", markerValue, controlMaxValue);
        }
        return null;
    }

    protected boolean validateValueAndHandleInvalid() {
        return true;
    }

    void activateSegments(Map<Segment, ? extends Node> segmentToNode) {
        double lValue = ((AbstractLinearGauge)this.getSkinnable()).getValue();
        int cnt = 0;
        for (Segment segment : segmentToNode.keySet()) {
            double segmentMinValue = segment.getMinValue();
            double segmentMaxValue = segment.getMaxValue();
            String lSegmentActiveId = "segment" + cnt + "-active";
            String lSegmentIdActiveId = "segment-" + segment.getId() + "-active";
            ((AbstractLinearGauge)this.getSkinnable()).getStyleClass().remove((Object)lSegmentActiveId);
            segmentToNode.get(segment).getStyleClass().remove((Object)"segment-active");
            if (segment.getId() != null) {
                ((AbstractLinearGauge)this.getSkinnable()).getStyleClass().remove((Object)lSegmentIdActiveId);
            }
            if (segmentMinValue <= lValue && lValue <= segmentMaxValue) {
                ((AbstractLinearGauge)this.getSkinnable()).getStyleClass().add((Object)lSegmentActiveId);
                segmentToNode.get(segment).getStyleClass().add((Object)"segment-active");
                if (segment.getId() != null) {
                    ((AbstractLinearGauge)this.getSkinnable()).getStyleClass().add((Object)lSegmentIdActiveId);
                }
            }
            ++cnt;
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<AbstractLinearGauge<?>, Animated> ANIMATED_CSSMETADATA = new CssMetaDataForSkinProperty<AbstractLinearGauge<?>, AbstractLinearGaugeSkin<?, ?>, Animated>("-fxx-animated", (StyleConverter)new EnumConverter(Animated.class), Animated.YES){

            protected ObjectProperty<Animated> getProperty(AbstractLinearGaugeSkin<?, ?> s) {
                return s.animatedProperty;
            }
        };
        private static final CssMetaData<AbstractLinearGauge<?>, String> VALUE_FORMAT_CSSMETADATA = new CssMetaDataForSkinProperty<AbstractLinearGauge<?>, AbstractLinearGaugeSkin<?, ?>, String>("-fxx-value-format", StringConverter.getInstance(), "0"){

            protected SimpleStyleableStringProperty getProperty(AbstractLinearGaugeSkin<?, ?> s) {
                return s.valueFormatProperty;
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<Object> styleables = new ArrayList<Object>(SkinBase.getClassCssMetaData());
            styleables.add(ANIMATED_CSSMETADATA);
            styleables.add(VALUE_FORMAT_CSSMETADATA);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    public static enum Animated {
        YES,
        NO;

    }

    protected abstract class AbstractIndicatorPane
    extends Pane {
        private final Map<Indicator, Region> indicatorToRegion = new HashMap<Indicator, Region>();

        protected AbstractIndicatorPane() {
            ((AbstractLinearGauge)AbstractLinearGaugeSkin.this.getSkinnable()).indicators().addListener(change -> this.createAndAddIndicators());
            this.createAndAddIndicators();
        }

        private void createAndAddIndicators() {
            this.getChildren().clear();
            this.indicatorToRegion.clear();
            for (Indicator indicator : ((AbstractLinearGauge)AbstractLinearGaugeSkin.this.getSkinnable()).indicators()) {
                Region region = new Region();
                this.getChildren().add((Object)region);
                this.indicatorToRegion.put(indicator, region);
                Scale scale = new Scale();
                region.getTransforms().add((Object)scale);
                region.getStyleClass().addAll((Object[])new String[]{"indicator", indicator.getId() + "-indicator"});
                region.setId(indicator.getId());
            }
        }

        protected void layoutChildren() {
            super.layoutChildren();
            double scaleFactor = this.calculateScaleFactor();
            for (Indicator indicator : ((AbstractLinearGauge)AbstractLinearGaugeSkin.this.getSkinnable()).indicators()) {
                int idx = indicator.getIdx();
                Region region = this.indicatorToRegion.get(indicator);
                if (region == null) continue;
                Point2D point2D = this.calculateLocation(idx);
                if (point2D != null) {
                    region.layoutXProperty().set(point2D.getX());
                    region.layoutYProperty().set(point2D.getY());
                }
                Scale scale = (Scale)region.getTransforms().get(0);
                scale.setX(scaleFactor);
                scale.setY(scale.getX());
            }
        }

        protected abstract double calculateScaleFactor();

        protected abstract Point2D calculateLocation(int var1);
    }

    protected abstract class AbstractMarkerPane
    extends Pane {
        protected final Map<Marker, Region> markerToRegion = new HashMap<Marker, Region>();

        protected AbstractMarkerPane() {
            ((AbstractLinearGauge)AbstractLinearGaugeSkin.this.getSkinnable()).markers().addListener(change -> this.createAndAddMarkers());
            this.createAndAddMarkers();
        }

        private void createAndAddMarkers() {
            this.getChildren().clear();
            this.markerToRegion.clear();
            int markerCnt = 0;
            for (Marker marker : ((AbstractLinearGauge)AbstractLinearGaugeSkin.this.getSkinnable()).markers()) {
                Region region = new Region();
                this.getChildren().add((Object)region);
                this.markerToRegion.put(marker, region);
                Rotate rotate = new Rotate(0.0);
                rotate.setPivotX(0.0);
                rotate.setPivotY(0.0);
                region.getTransforms().add((Object)rotate);
                Scale scale = new Scale();
                region.getTransforms().add((Object)scale);
                region.getStyleClass().addAll((Object[])new String[]{"marker", "marker" + markerCnt});
                if (marker.getId() != null) {
                    region.setId(marker.getId());
                }
                ++markerCnt;
            }
        }

        protected void layoutChildren() {
            super.layoutChildren();
            for (Marker marker : ((AbstractLinearGauge)AbstractLinearGaugeSkin.this.getSkinnable()).markers()) {
                String message = AbstractLinearGaugeSkin.this.validateMarker(marker);
                if (message != null) {
                    new Throwable(message).printStackTrace();
                    continue;
                }
                Region region = this.markerToRegion.get(marker);
                Rotate rotate = (Rotate)region.getTransforms().get(0);
                Scale scale = (Scale)region.getTransforms().get(1);
                this.positionAndScaleMarker(marker, rotate, scale);
            }
        }

        protected abstract void positionAndScaleMarker(Marker var1, Rotate var2, Scale var3);
    }

    protected abstract class AbstractValuePane
    extends Pane {
        protected final Text valueText = new Text("");
        protected final Pane valueTextPane = new StackPane(new Node[]{this.valueText});
        protected final Scale valueScale = new Scale(1.0, 1.0);
        protected final Text hiddenText = new Text("");

        protected AbstractValuePane() {
            this.getChildren().add((Object)this.valueTextPane);
            this.valueText.getStyleClass().add((Object)"value");
            this.valueTextPane.getTransforms().setAll((Object[])new Transform[]{this.valueScale});
            ((AbstractLinearGauge)AbstractLinearGaugeSkin.this.getSkinnable()).valueProperty().addListener(observable -> {
                if (!AbstractLinearGaugeSkin.this.validateValueAndHandleInvalid()) {
                    return;
                }
                this.setValueText();
            });
            ((AbstractLinearGauge)AbstractLinearGaugeSkin.this.getSkinnable()).minValueProperty().addListener(observable -> {
                if (!AbstractLinearGaugeSkin.this.validateValueAndHandleInvalid()) {
                    return;
                }
                this.scaleValueText();
            });
            ((AbstractLinearGauge)AbstractLinearGaugeSkin.this.getSkinnable()).maxValueProperty().addListener(observable -> {
                if (!AbstractLinearGaugeSkin.this.validateValueAndHandleInvalid()) {
                    return;
                }
                this.scaleValueText();
            });
            this.hiddenText.getStyleClass().add((Object)"value");
            this.hiddenText.setVisible(false);
            this.getChildren().add((Object)this.hiddenText);
            this.setValueText();
            this.scaleValueText();
        }

        protected void layoutChildren() {
            super.layoutChildren();
            this.setValueText();
            this.scaleValueText();
        }

        private void setValueText() {
            if (!AbstractLinearGaugeSkin.this.validateValueAndHandleInvalid()) {
                return;
            }
            this.valueText.setText(AbstractLinearGaugeSkin.this.valueFormat(((AbstractLinearGauge)AbstractLinearGaugeSkin.this.getSkinnable()).getValue()));
        }

        protected void scaleValueText() {
        }
    }
}

