/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.cli;

import com.sampullara.cli.Argument;
import com.sampullara.cli.Help;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Args {
    public static final int EX_USAGE = 64;
    public static final ValueCreator FROM_STRING_CONSTRUCTOR = new ValueCreator(){

        @Override
        public Object createValue(Class<?> type, String value) {
            Object v = null;
            try {
                Constructor<?> init = type.getDeclaredConstructor(String.class);
                v = init.newInstance(value);
            }
            catch (NoSuchMethodException init) {
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to convert " + value + " to type " + type.getName(), e);
            }
            return v;
        }
    };
    public static final ValueCreator ENUM_CREATOR = new ValueCreator(){

        public Object createValue(Class type, String value) {
            if (Enum.class.isAssignableFrom(type)) {
                return Enum.valueOf(type, value);
            }
            return null;
        }
    };
    private static final List<ValueCreator> DEFAULT_VALUE_CREATORS = Arrays.asList(FROM_STRING_CONSTRUCTOR, ENUM_CREATOR);
    private static List<ValueCreator> valueCreators = new ArrayList<ValueCreator>(DEFAULT_VALUE_CREATORS);

    public static List<String> parseOrExit(Object target, String[] args2) {
        try {
            return Args.parse(target, args2);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            Args.usage(target);
            System.exit(64);
            throw e;
        }
    }

    public static List<String> parse(Object target, String[] args2) {
        return Args.parse(target, args2, true);
    }

    public static List<String> parse(Object target, String[] args2, boolean failOnExtraFlags) {
        Class<?> clazz;
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.addAll(Arrays.asList(args2));
        if (target instanceof Class) {
            clazz = (Class<?>)target;
        } else {
            clazz = target.getClass();
            try {
                BeanInfo info = Introspector.getBeanInfo(clazz);
                for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                    Args.processProperty(target, pd, arguments);
                }
            }
            catch (IntrospectionException info) {
                // empty catch block
            }
        }
        for (Class<?> currentClazz = clazz; currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
            for (Field field : currentClazz.getDeclaredFields()) {
                Args.processField(target, field, arguments);
            }
        }
        if (failOnExtraFlags) {
            for (String argument : arguments) {
                if (!argument.startsWith("-")) continue;
                throw new IllegalArgumentException("Invalid argument: " + argument);
            }
        }
        return arguments;
    }

    private static void processField(Object target, Field field, List<String> arguments) {
        Argument argument = field.getAnnotation(Argument.class);
        if (argument != null) {
            String value;
            boolean set = false;
            Iterator<String> i = arguments.iterator();
            while (i.hasNext()) {
                String arg = i.next();
                String prefix = argument.prefix();
                String delimiter = argument.delimiter();
                if (!arg.startsWith(prefix)) continue;
                String name = Args.getName(argument, field);
                String alias = Args.getAlias(argument);
                arg = arg.substring(prefix.length());
                Class<?> type = field.getType();
                if (arg.equals(name) || alias != null && arg.equals(alias)) {
                    i.remove();
                    Object value2 = Args.consumeArgumentValue(type, argument, i);
                    if (!set) {
                        Args.setField(type, field, target, value2, delimiter);
                    } else {
                        Args.addArgument(type, field, target, value2, delimiter);
                    }
                    set = true;
                }
                if (!set || type.isArray()) continue;
                break;
            }
            if (!set && !argument.envvar().equals("") && (value = System.getenv(argument.envvar())) != null) {
                Class<?> type = field.getType();
                Args.setField(type, field, target, value, argument.delimiter());
                set = true;
            }
            if (!set && argument.required()) {
                String name = Args.getName(argument, field);
                throw new IllegalArgumentException("You must set argument " + name);
            }
        }
    }

    private static void addArgument(Class type, Field field, Object target, Object value, String delimiter) {
        try {
            Object[] os = (Object[])field.get(target);
            Object[] vs = (Object[])Args.getValue(type, value, delimiter);
            Object[] s = (Object[])Array.newInstance(type.getComponentType(), os.length + vs.length);
            System.arraycopy(os, 0, s, 0, os.length);
            System.arraycopy(vs, 0, s, os.length, vs.length);
            field.set(target, s);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set field " + field, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type.getName() + " that takes a string", e);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Could not set field " + field, iae);
        }
    }

    private static void addPropertyArgument(Class type, PropertyDescriptor property, Object target, Object value, String delimiter) {
        try {
            Object[] os = (Object[])property.getReadMethod().invoke(target, new Object[0]);
            Object[] vs = (Object[])Args.getValue(type, value, delimiter);
            Object[] s = (Object[])Array.newInstance(type.getComponentType(), os.length + vs.length);
            System.arraycopy(os, 0, s, 0, os.length);
            System.arraycopy(vs, 0, s, os.length, vs.length);
            property.getWriteMethod().invoke(target, new Object[]{s});
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set property " + property, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type.getName() + " that takes a string", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to validate argument " + value + " for " + property);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Could not set property " + property, iae);
        }
    }

    private static void processProperty(Object target, PropertyDescriptor property, List<String> arguments) {
        Argument argument;
        Method writeMethod = property.getWriteMethod();
        if (writeMethod != null && (argument = writeMethod.getAnnotation(Argument.class)) != null) {
            boolean set = false;
            Iterator<String> i = arguments.iterator();
            while (i.hasNext()) {
                String arg = i.next();
                String prefix = argument.prefix();
                String delimiter = argument.delimiter();
                if (!arg.startsWith(prefix)) continue;
                String name = Args.getName(argument, property);
                String alias = Args.getAlias(argument);
                arg = arg.substring(prefix.length());
                Class<?> type = property.getPropertyType();
                if (arg.equals(name) || alias != null && arg.equals(alias)) {
                    i.remove();
                    Object value = Args.consumeArgumentValue(type, argument, i);
                    if (!set) {
                        Args.setProperty(type, property, target, value, delimiter);
                    } else {
                        Args.addPropertyArgument(type, property, target, value, delimiter);
                    }
                    set = true;
                }
                if (!set || type.isArray()) continue;
                break;
            }
            if (!set && argument.required()) {
                String name = Args.getName(argument, property);
                throw new IllegalArgumentException("You must set argument " + name);
            }
        }
    }

    public static void usage(Object target) {
        Args.usage(System.err, target);
    }

    public static void usage(PrintStream errStream, Object target) {
        Args.usage(errStream, target, target instanceof Class ? (Class<?>)target : target.getClass());
    }

    public static void usage(PrintStream errStream, Object target, Class mainClass) {
        Class<?> clazz = target instanceof Class ? (Class<?>)target : target.getClass();
        Help help = clazz.getAnnotation(Help.class);
        if (help != null && !help.value().equals("")) {
            errStream.println(help.value());
        }
        errStream.println("Usage: " + mainClass.getName());
        for (Class<?> currentClazz = clazz; currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
            for (Field field : currentClazz.getDeclaredFields()) {
                Args.fieldUsage(errStream, target, field);
            }
        }
        try {
            BeanInfo info = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                Args.propertyUsage(errStream, target, pd);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    private static void fieldUsage(PrintStream errStream, Object target, Field field) {
        Argument argument = field.getAnnotation(Argument.class);
        if (argument != null) {
            String name = Args.getName(argument, field);
            String alias = Args.getAlias(argument);
            String prefix = argument.prefix();
            String delimiter = argument.delimiter();
            String description = argument.description();
            Class<? extends Callable<List<String>>> valuesProvider = argument.valuesProvider();
            Args.makeAccessible(field);
            try {
                Object defaultValue = field.get(target);
                Class<?> type = field.getType();
                Args.propertyUsage(errStream, prefix, name, alias, type, delimiter, description, defaultValue, Args.getPossibleValues(type, valuesProvider));
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not use this field " + field + " as an argument field", e);
            }
        }
    }

    private static void propertyUsage(PrintStream errStream, Object target, PropertyDescriptor field) {
        Argument argument;
        Method writeMethod = field.getWriteMethod();
        if (writeMethod != null && (argument = writeMethod.getAnnotation(Argument.class)) != null) {
            String name = Args.getName(argument, field);
            String alias = Args.getAlias(argument);
            String prefix = argument.prefix();
            String delimiter = argument.delimiter();
            String description = argument.description();
            Class<? extends Callable<List<String>>> valuesProvider = argument.valuesProvider();
            try {
                Method readMethod = field.getReadMethod();
                Object defaultValue = readMethod == null ? null : readMethod.invoke(target, (Object[])null);
                Class<?> type = field.getPropertyType();
                Args.propertyUsage(errStream, prefix, name, alias, type, delimiter, description, defaultValue, Args.getPossibleValues(type, valuesProvider));
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not use this field " + field + " as an argument field", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Could not get default value for " + field, e);
            }
        }
    }

    private static void propertyUsage(PrintStream errStream, String prefix, String name, String alias, Class<?> type, String delimiter, String description, Object defaultValue, List<String> possibleValues) {
        StringBuilder sb = new StringBuilder("  ");
        sb.append(prefix);
        sb.append(name);
        if (alias != null) {
            sb.append(" (");
            sb.append(prefix);
            sb.append(alias);
            sb.append(")");
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            sb.append(" [flag] ");
            sb.append(description);
        } else {
            String typeName;
            sb.append(" [");
            if (type.isArray()) {
                typeName = Args.getTypeName(type.getComponentType());
                sb.append(typeName);
                sb.append("[");
                sb.append(delimiter);
                sb.append("]");
            } else {
                typeName = Args.getTypeName(type);
                sb.append(typeName);
            }
            sb.append("] ");
            sb.append(description);
            if (defaultValue != null) {
                sb.append(" (");
                if (type.isArray()) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    int len = Array.getLength(defaultValue);
                    for (int i = 0; i < len; ++i) {
                        list.add(Array.get(defaultValue, i));
                    }
                    sb.append(list);
                } else {
                    sb.append(defaultValue);
                }
                sb.append(")");
            }
        }
        if (possibleValues != null && !possibleValues.isEmpty()) {
            sb.append(System.getProperty("line.separator"));
            sb.append("    Possible values are: ");
            boolean first = true;
            for (String possibleValue : possibleValues) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(possibleValue);
            }
        }
        errStream.println(sb);
    }

    private static String getTypeName(Class<?> type) {
        String typeName = type.getName();
        int beginIndex = typeName.lastIndexOf(".");
        typeName = typeName.substring(beginIndex + 1);
        return typeName;
    }

    static String getName(Argument argument, PropertyDescriptor property) {
        String name = argument.value();
        if (name.equals("")) {
            name = property.getName();
        }
        return name;
    }

    private static Object consumeArgumentValue(Class<?> type, Argument argument, Iterator<String> i) {
        Object value;
        if (type == Boolean.TYPE || type == Boolean.class) {
            value = true;
        } else if (i.hasNext()) {
            value = i.next();
            i.remove();
        } else {
            throw new IllegalArgumentException("Must have a value for non-boolean argument " + argument.value());
        }
        return value;
    }

    static void setProperty(Class<?> type, PropertyDescriptor property, Object target, Object value, String delimiter) {
        try {
            value = Args.getValue(type, value, delimiter);
            property.getWriteMethod().invoke(target, value);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set property " + property, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type.getName() + " that takes a string", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to validate argument " + value + " for " + property);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Could not set property " + property, iae);
        }
    }

    static String getAlias(Argument argument) {
        String alias = argument.alias();
        if (alias.equals("")) {
            alias = null;
        }
        return alias;
    }

    static String getName(Argument argument, Field field) {
        String name = argument.value();
        if (name.equals("")) {
            name = field.getName();
        }
        return name;
    }

    static void setField(Class<?> type, Field field, Object target, Object value, String delimiter) {
        Args.makeAccessible(field);
        try {
            value = Args.getValue(type, value, delimiter);
            field.set(target, value);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set field " + field, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type.getName() + " that takes a string", e);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Could not set field " + field, iae);
        }
    }

    private static Object getValue(Class<?> type, Object value, String delimiter) throws NoSuchMethodException {
        if (type != String.class && type != Boolean.class && type != Boolean.TYPE) {
            String string = (String)value;
            if (type.isArray()) {
                String[] strings = string.split(delimiter);
                if ((type = type.getComponentType()) == String.class) {
                    value = strings;
                } else {
                    Object[] array = (Object[])Array.newInstance(type, strings.length);
                    for (int i = 0; i < array.length; ++i) {
                        array[i] = Args.createValue(type, strings[i]);
                    }
                    value = array;
                }
            } else {
                value = Args.createValue(type, string);
            }
        }
        return value;
    }

    private static Object createValue(Class<?> type, String valueAsString) throws NoSuchMethodException {
        for (ValueCreator valueCreator : valueCreators) {
            Object createdValue = valueCreator.createValue(type, valueAsString);
            if (createdValue == null) continue;
            return createdValue;
        }
        throw new IllegalArgumentException(String.format("cannot instanciate any %s object using %s value", type.toString(), valueAsString));
    }

    private static void makeAccessible(AccessibleObject ao) {
        Member member;
        if (ao instanceof Member && !Modifier.isPublic((member = (Member)((Object)ao)).getModifiers())) {
            ao.setAccessible(true);
        }
    }

    private static List<String> getPossibleValues(Class<?> type, Class<? extends Callable<List<String>>> provider) {
        if (type.isEnum()) {
            return Args.getEnumPossibleValues(type);
        }
        return Args.getPossibleValuesViaProvider(provider);
    }

    private static List<String> getPossibleValuesViaProvider(Class<? extends Callable<List<String>>> provider) {
        try {
            return provider.newInstance().call();
        }
        catch (InstantiationException e) {
            return Collections.emptyList();
        }
        catch (IllegalAccessException e) {
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<String> getEnumPossibleValues(Class<?> clazz) {
        return Args.getEnumPossibleValuesImpl(clazz);
    }

    private static <T extends Enum<T>> List<String> getEnumPossibleValuesImpl(Class<T> clazz) {
        ArrayList<String> result = new ArrayList<String>();
        for (Enum value : (Enum[])clazz.getEnumConstants()) {
            result.add(value.name());
        }
        return result;
    }

    public static ValueCreator byStaticMethodInvocation(final Class<?> compatibleType, final String methodName) {
        return new ValueCreator(){

            @Override
            public Object createValue(Class<?> type, String value) {
                if (compatibleType.isAssignableFrom(type)) {
                    try {
                        Method m = type.getMethod(methodName, String.class);
                        return m.invoke(null, value);
                    }
                    catch (NoSuchMethodException m) {
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("could not invoke %s#%s to create an obejct from %s", type.toString(), methodName, value));
                    }
                }
                return null;
            }
        };
    }

    public static void registerValueCreator(ValueCreator vc) {
        valueCreators.add(vc);
    }

    public static void resetValueCreators() {
        valueCreators.clear();
        valueCreators.addAll(DEFAULT_VALUE_CREATORS);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ValueCreator {
        public Object createValue(Class<?> var1, String var2);
    }
}

