/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.verifier;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.DigestException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.datasource.DataSource;
import org.jetbrains.zip.signer.datasource.FileChannelDataSource;
import org.jetbrains.zip.signer.digest.DigestUtils;
import org.jetbrains.zip.signer.exceptions.ZipVerificationException;
import org.jetbrains.zip.signer.metadata.ContentDigestAlgorithm;
import org.jetbrains.zip.signer.metadata.Digest;
import org.jetbrains.zip.signer.metadata.SignatureAlgorithm;
import org.jetbrains.zip.signer.metadata.SignatureData;
import org.jetbrains.zip.signer.metadata.SignerBlock;
import org.jetbrains.zip.signer.metadata.ZipMetadata;
import org.jetbrains.zip.signer.signer.CertificateUtils;
import org.jetbrains.zip.signer.verifier.DefaultSignatureVerifier;
import org.jetbrains.zip.signer.verifier.InvalidSignatureResult;
import org.jetbrains.zip.signer.verifier.MissingSignatureResult;
import org.jetbrains.zip.signer.verifier.SuccessfulVerificationResult;
import org.jetbrains.zip.signer.verifier.ZipVerificationResult;
import org.jetbrains.zip.signer.zip.ZipSections;
import org.jetbrains.zip.signer.zip.ZipSectionsInformation;
import org.jetbrains.zip.signer.zip.ZipUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0012\u001a\u00020\u00042\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0014H\u0002J2\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00142\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001c\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00140\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/zip/signer/verifier/ZipVerifier;", "", "()V", "checkDigests", "", "zipSections", "Lorg/jetbrains/zip/signer/zip/ZipSections;", "zipMetadata", "Lorg/jetbrains/zip/signer/metadata/ZipMetadata;", "checkDigests$lib", "verify", "Lorg/jetbrains/zip/signer/verifier/ZipVerificationResult;", "file", "Ljava/io/File;", "path", "Ljava/nio/file/Path;", "dataSource", "Lorg/jetbrains/zip/signer/datasource/DataSource;", "verifyCertificateChains", "certificateChains", "", "Ljava/security/cert/Certificate;", "verifySignatures", "Ljava/security/cert/X509Certificate;", "digests", "", "Lorg/jetbrains/zip/signer/metadata/ContentDigestAlgorithm;", "Lorg/jetbrains/zip/signer/metadata/Digest;", "signer", "Lorg/jetbrains/zip/signer/metadata/SignerBlock;", "certFactory", "Ljava/security/cert/CertificateFactory;", "lib"})
@ExperimentalUnsignedTypes
@SourceDebugExtension(value={"SMAP\nZipVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipVerifier.kt\norg/jetbrains/zip/signer/verifier/ZipVerifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1#2:132\n1747#3,3:133\n1194#3,2:136\n1222#3,4:138\n1549#3:142\n1620#3,3:143\n1549#3:146\n1620#3,3:147\n1855#3,2:150\n1549#3:152\n1620#3,3:153\n1855#3,2:156\n*S KotlinDebug\n*F\n+ 1 ZipVerifier.kt\norg/jetbrains/zip/signer/verifier/ZipVerifier\n*L\n80#1:133,3\n87#1:136,2\n87#1:138,4\n88#1:142\n88#1:143,3\n98#1:146\n98#1:147,3\n105#1:150,2\n118#1:152\n118#1:153,3\n123#1:156,2\n*E\n"})
public final class ZipVerifier {
    @NotNull
    public static final ZipVerifier INSTANCE = new ZipVerifier();

    private ZipVerifier() {
    }

    @JvmStatic
    @NotNull
    public static final ZipVerificationResult verify(@NotNull File file) throws IOException {
        Intrinsics.checkNotNullParameter(file, "file");
        Path path = file.toPath();
        Intrinsics.checkNotNullExpressionValue(path, "toPath(...)");
        return ZipVerifier.verify(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final ZipVerificationResult verify(@NotNull Path path) throws IOException {
        ZipVerificationResult zipVerificationResult;
        Intrinsics.checkNotNullParameter(path, "path");
        Object object = new OpenOption[]{StandardOpenOption.READ};
        object = FileChannel.open(path, object);
        Throwable throwable = null;
        try {
            FileChannel it = (FileChannel)object;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            zipVerificationResult = INSTANCE.verify(new FileChannelDataSource(it, 0L, null, 6, null));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
        return zipVerificationResult;
    }

    private final ZipVerificationResult verify(DataSource dataSource) {
        ZipSectionsInformation zipSectionsInformation = ZipUtils.INSTANCE.findZipSectionsInformation(dataSource);
        ZipMetadata zipMetadata = ZipMetadata.Companion.findInZip(dataSource, zipSectionsInformation);
        if (zipMetadata == null) {
            return MissingSignatureResult.INSTANCE;
        }
        ZipMetadata zipMetadata2 = zipMetadata;
        ZipSections zipSections = ZipUtils.INSTANCE.findZipSections$lib(dataSource, zipSectionsInformation, zipMetadata2);
        return this.verify(zipSections, zipMetadata2);
    }

    private final ZipVerificationResult verify(ZipSections zipSections, ZipMetadata zipMetadata) {
        ZipVerificationResult zipVerificationResult;
        try {
            this.checkDigests$lib(zipSections, zipMetadata);
            List<List<X509Certificate>> certificateChains = this.verifySignatures(zipMetadata);
            this.verifyCertificateChains(certificateChains);
            zipVerificationResult = new SuccessfulVerificationResult(certificateChains);
        }
        catch (ZipVerificationException e) {
            zipVerificationResult = new InvalidSignatureResult(e.getMessage());
        }
        return zipVerificationResult;
    }

    private final void verifyCertificateChains(List<? extends List<? extends Certificate>> certificateChains) {
        boolean bl;
        block4: {
            Iterable $this$any$iv = certificateChains;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    List it = (List)element$iv;
                    boolean bl2 = false;
                    if (!(!CertificateUtils.INSTANCE.isValidCertificateChain(it))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new ZipVerificationException("One of signature blocks contains invalid certificate chain");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<X509Certificate>> verifySignatures(ZipMetadata zipMetadata) {
        void $this$mapTo$iv$iv;
        Object object;
        void $this$associateByTo$iv$iv;
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        Iterable $this$associateBy$iv = zipMetadata.getDigests();
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Digest digest = (Digest)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(it.getAlgorithm(), element$iv$iv);
        }
        Map digests = destination$iv$iv;
        Iterable $this$map$iv = zipMetadata.getSigners();
        boolean $i$f$map = false;
        Iterable capacity$iv22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object element$iv$iv;
            element$iv$iv = (SignerBlock)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            Intrinsics.checkNotNull(certFactory);
            object.add(INSTANCE.verifySignatures(digests, (SignerBlock)it, certFactory));
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<X509Certificate> verifySignatures(Map<ContentDigestAlgorithm, Digest> digests, SignerBlock signer, CertificateFactory certFactory) {
        void $this$mapTo$iv$iv;
        if (signer.getSignatures().isEmpty()) {
            throw new ZipVerificationException("Signer block contains no signatures");
        }
        Iterable $this$map$iv = signer.getEncodedCertificates();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            byte[] byArray = (byte[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Certificate certificate = certFactory.generateCertificate(new ByteArrayInputStream((byte[])it));
            Intrinsics.checkNotNull(certificate, "null cannot be cast to non-null type java.security.cert.X509Certificate");
            collection.add((X509Certificate)certificate);
        }
        List certificates = (List)destination$iv$iv;
        if (certificates.isEmpty()) {
            throw new ZipVerificationException("Signer has no certificates");
        }
        Iterable $this$forEach$iv = signer.getSignatures();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Digest digest;
            SignatureData signature = (SignatureData)element$iv;
            boolean bl = false;
            SignatureAlgorithm signatureAlgorithm = signature.getAlgorithm();
            if (digests.get((Object)signature.getAlgorithm().getContentDigestAlgorithm()) == null) {
                throw new ZipVerificationException("Missing digest " + signature.getAlgorithm().getContentDigestAlgorithm());
            }
            new DefaultSignatureVerifier(certificates, signatureAlgorithm).verify(digest.getDigestBytes(), signature.getSignatureBytes());
        }
        return certificates;
    }

    /*
     * WARNING - void declaration
     */
    public final void checkDigests$lib(@NotNull ZipSections zipSections, @NotNull ZipMetadata zipMetadata) {
        List $this$map$iv;
        Intrinsics.checkNotNullParameter(zipSections, "zipSections");
        Intrinsics.checkNotNullParameter(zipMetadata, "zipMetadata");
        try {
            void $this$mapTo$iv$iv;
            Iterable iterable = zipMetadata.getDigests();
            DigestUtils digestUtils = DigestUtils.INSTANCE;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Digest digest = (Digest)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getAlgorithm());
            }
            $this$map$iv = DigestUtils.computeDigest$default(digestUtils, (List)destination$iv$iv, zipSections, 0, 4, null);
        }
        catch (DigestException e) {
            throw new ZipVerificationException("Failed to compute content digests");
        }
        List actualContentDigests = $this$map$iv;
        Iterable $this$forEach$iv = actualContentDigests;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Digest expectedDigest;
            Object v0;
            Digest digest;
            block6: {
                digest = (Digest)element$iv;
                boolean bl = false;
                Iterable iterable = zipMetadata.getDigests();
                for (Object e : iterable) {
                    Digest it = (Digest)e;
                    boolean bl2 = false;
                    if (!(it.getAlgorithm() == digest.getAlgorithm())) continue;
                    v0 = e;
                    break block6;
                }
                v0 = null;
            }
            if ((Digest)v0 == null) {
                throw new RuntimeException("Missing " + digest.getAlgorithm() + " digest in metadata");
            }
            if (Arrays.equals(expectedDigest.getDigestBytes(), digest.getDigestBytes())) continue;
            throw new ZipVerificationException("ZIP integrity check failed. " + digest.getAlgorithm() + "s digest mismatch.");
        }
    }
}

