/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.metadata;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.zip.signer.datasource.DataSource;
import org.jetbrains.zip.signer.metadata.Digest;
import org.jetbrains.zip.signer.metadata.SignerBlock;
import org.jetbrains.zip.signer.proto.DigestProto;
import org.jetbrains.zip.signer.proto.SignerBlockProto;
import org.jetbrains.zip.signer.proto.ZipMetadataProto;
import org.jetbrains.zip.signer.proto.ZipSignatureBlockProto;
import org.jetbrains.zip.signer.zip.ZipSectionsInformation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B#\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007B+\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u0013R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/zip/signer/metadata/ZipMetadata;", "", "digests", "", "Lorg/jetbrains/zip/signer/metadata/Digest;", "signers", "Lorg/jetbrains/zip/signer/metadata/SignerBlock;", "(Ljava/util/List;Ljava/util/List;)V", "protobufRepresentation", "Lorg/jetbrains/zip/signer/proto/ZipMetadataProto;", "(Ljava/util/List;Ljava/util/List;Lorg/jetbrains/zip/signer/proto/ZipMetadataProto;)V", "getDigests", "()Ljava/util/List;", "getSigners", "size", "", "getSize", "()I", "toByteArray", "", "Companion", "lib"})
@ExperimentalUnsignedTypes
@SourceDebugExtension(value={"SMAP\nZipMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipMetadata.kt\norg/jetbrains/zip/signer/metadata/ZipMetadata\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1549#2:99\n1620#2,3:100\n1549#2:103\n1620#2,3:104\n*S KotlinDebug\n*F\n+ 1 ZipMetadata.kt\norg/jetbrains/zip/signer/metadata/ZipMetadata\n*L\n75#1:99\n75#1:100,3\n76#1:103\n76#1:104,3\n*E\n"})
public final class ZipMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Digest> digests;
    @NotNull
    private final List<SignerBlock> signers;
    @NotNull
    private final ZipMetadataProto protobufRepresentation;
    private final int size;
    private static final long SIGNATURE_BLOCK_MAGIC_HI = 3617552046287187010L;
    private static final long SIGNATURE_BLOCK_MAGIC_LO = 2334950737559900224L;
    private static final int signatureBlockHeaderSize = 8;
    private static final int signatureBlockFooterSize = 24;
    private static final int signatureBlockMetadataSize = 32;

    private ZipMetadata(List<Digest> digests, List<SignerBlock> signers, ZipMetadataProto protobufRepresentation) {
        this.digests = digests;
        this.signers = signers;
        this.protobufRepresentation = protobufRepresentation;
        this.size = 32 + this.protobufRepresentation.getSerializedSize();
    }

    @NotNull
    public final List<Digest> getDigests() {
        return this.digests;
    }

    @NotNull
    public final List<SignerBlock> getSigners() {
        return this.signers;
    }

    public ZipMetadata(@NotNull List<Digest> digests, @NotNull List<SignerBlock> signers) {
        SignerBlock it;
        Collection<SignerBlockProto> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(digests, "digests");
        Intrinsics.checkNotNullParameter(signers, "signers");
        Iterable iterable = digests;
        ZipSignatureBlockProto.Builder builder = ZipSignatureBlockProto.newBuilder();
        ZipMetadataProto.Builder builder2 = ZipMetadataProto.newBuilder().setSignatureSchemeVersion(1);
        List<SignerBlock> list = signers;
        List<Digest> list2 = digests;
        ZipMetadata zipMetadata = this;
        boolean $i$f$map = false;
        void var5_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Digest digest = (Digest)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((SignerBlockProto)((Object)((Digest)((Object)it)).getProtobufRepresentation()));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = signers;
        builder = builder.addAllDigests((Iterable<? extends DigestProto>)collection);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SignerBlock)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getProtobufRepresentation());
        }
        collection = (List)destination$iv$iv;
        ZipMetadataProto zipMetadataProto = builder2.setContent(builder.addAllSigners((Iterable<? extends SignerBlockProto>)collection).build()).build();
        Intrinsics.checkNotNullExpressionValue(zipMetadataProto, "build(...)");
        zipMetadata(list2, list, zipMetadataProto);
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final byte[] toByteArray() {
        ByteBuffer $this$toByteArray_u24lambda_u242 = ByteBuffer.allocate(this.size);
        boolean bl = false;
        $this$toByteArray_u24lambda_u242.order(ByteOrder.LITTLE_ENDIAN);
        long blockSizeFieldValue = (long)this.size - 8L;
        $this$toByteArray_u24lambda_u242.putLong(blockSizeFieldValue);
        $this$toByteArray_u24lambda_u242.put(this.protobufRepresentation.toByteArray());
        $this$toByteArray_u24lambda_u242.putLong(blockSizeFieldValue);
        $this$toByteArray_u24lambda_u242.putLong(2334950737559900224L);
        $this$toByteArray_u24lambda_u242.putLong(3617552046287187010L);
        byte[] byArray = $this$toByteArray_u24lambda_u242.array();
        Intrinsics.checkNotNullExpressionValue(byArray, "with(...)");
        return byArray;
    }

    public /* synthetic */ ZipMetadata(List digests, List signers, ZipMetadataProto protobufRepresentation, DefaultConstructorMarker $constructor_marker) {
        this(digests, signers, protobufRepresentation);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/zip/signer/metadata/ZipMetadata$Companion;", "", "()V", "SIGNATURE_BLOCK_MAGIC_HI", "", "SIGNATURE_BLOCK_MAGIC_LO", "signatureBlockFooterSize", "", "signatureBlockHeaderSize", "signatureBlockMetadataSize", "findInZip", "Lorg/jetbrains/zip/signer/metadata/ZipMetadata;", "zipArchive", "Lorg/jetbrains/zip/signer/datasource/DataSource;", "zipSectionsInformation", "Lorg/jetbrains/zip/signer/zip/ZipSectionsInformation;", "lib"})
    @SourceDebugExtension(value={"SMAP\nZipMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipMetadata.kt\norg/jetbrains/zip/signer/metadata/ZipMetadata$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1549#2:99\n1620#2,3:100\n1549#2:103\n1620#2,3:104\n*S KotlinDebug\n*F\n+ 1 ZipMetadata.kt\norg/jetbrains/zip/signer/metadata/ZipMetadata$Companion\n*L\n59#1:99\n59#1:100,3\n60#1:103\n60#1:104,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ZipMetadata findInZip(@NotNull DataSource zipArchive, @NotNull ZipSectionsInformation zipSectionsInformation) {
            SignerBlockProto it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2;
            Intrinsics.checkNotNullParameter(zipArchive, "zipArchive");
            Intrinsics.checkNotNullParameter(zipSectionsInformation, "zipSectionsInformation");
            long centralDirStartOffset = zipSectionsInformation.getCentralDirectoryOffset();
            if (centralDirStartOffset < 32L) {
                return null;
            }
            ByteBuffer $this$findInZip_u24lambda_u240 = byteBuffer2 = zipArchive.getByteBuffer(centralDirStartOffset - (long)24, 24);
            boolean bl = false;
            $this$findInZip_u24lambda_u240.order(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer footer = byteBuffer2;
            if (footer.getLong(8) != 2334950737559900224L || footer.getLong(16) != 3617552046287187010L) {
                return null;
            }
            long signatureBlockSizeInFooter = footer.getLong(0);
            if (signatureBlockSizeInFooter < (long)footer.capacity() || signatureBlockSizeInFooter > 0x7FFFFFF7L) {
                return null;
            }
            int totalSize = (int)(signatureBlockSizeInFooter + (long)8);
            long signingBlockOffset = centralDirStartOffset - (long)totalSize;
            if (signingBlockOffset < 0L) {
                return null;
            }
            ByteBuffer $this$findInZip_u24lambda_u241 = byteBuffer = zipArchive.getByteBuffer(signingBlockOffset, 8);
            boolean bl2 = false;
            $this$findInZip_u24lambda_u241.order(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer signatureBlockHeader = byteBuffer;
            long signatureBlockSizeInHeader = signatureBlockHeader.getLong(0);
            if (signatureBlockSizeInHeader != signatureBlockSizeInFooter) {
                return null;
            }
            ZipMetadataProto protobufContent = ZipMetadataProto.parseFrom(zipArchive.getByteBuffer(signingBlockOffset + (long)8, totalSize - 32));
            if (!(protobufContent.getSignatureSchemeVersion() == 1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            List<DigestProto> list = protobufContent.getContent().getDigestsList();
            Intrinsics.checkNotNullExpressionValue(list, "getDigestsList(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                DigestProto digestProto = (DigestProto)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull(it);
                collection.add(new Digest((DigestProto)((Object)it)));
            }
            List list2 = (List)destination$iv$iv;
            List<SignerBlockProto> list3 = protobufContent.getContent().getSignersList();
            Intrinsics.checkNotNullExpressionValue(list3, "getSignersList(...)");
            $this$map$iv = list3;
            collection = list2;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (SignerBlockProto)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNull(it);
                collection2.add(new SignerBlock(it));
            }
            Intrinsics.checkNotNull(protobufContent);
            DefaultConstructorMarker defaultConstructorMarker = null;
            ZipMetadataProto zipMetadataProto = protobufContent;
            List list4 = (List)destination$iv$iv;
            Collection collection3 = collection;
            return new ZipMetadata((List)collection3, list4, zipMetadataProto, defaultConstructorMarker);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

