/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.datasource;

import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.datasource.DataSource;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0003H\u0016J \u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\nH\u0016J\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0005\u001a\u00020\nH\u0016J\u0018\u0010\u0011\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/zip/signer/datasource/ByteBufferDataSource;", "Lorg/jetbrains/zip/signer/datasource/DataSource;", "buffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "size", "", "checkChunkValid", "", "offset", "", "copyTo", "dest", "feed", "writableByteChannel", "Ljava/nio/channels/WritableByteChannel;", "getByteBuffer", "slice", "lib"})
public final class ByteBufferDataSource
implements DataSource {
    @NotNull
    private final ByteBuffer buffer;
    private final int size;

    public ByteBufferDataSource(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        this.buffer = buffer;
        this.size = this.buffer.remaining();
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    @NotNull
    public ByteBuffer getByteBuffer(long offset, int size) {
        this.checkChunkValid(offset, size);
        int chunkPosition = (int)offset;
        int chunkLimit = chunkPosition + size;
        this.buffer.position(0);
        this.buffer.limit(chunkLimit);
        this.buffer.position(chunkPosition);
        ByteBuffer byteBuffer = this.buffer.slice();
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "slice(...)");
        return byteBuffer;
    }

    @Override
    public void copyTo(long offset, int size, @NotNull ByteBuffer dest) {
        Intrinsics.checkNotNullParameter(dest, "dest");
        dest.put(this.getByteBuffer(offset, size));
    }

    @Override
    public void feed(@NotNull WritableByteChannel writableByteChannel, long offset, long size) {
        Intrinsics.checkNotNullParameter(writableByteChannel, "writableByteChannel");
        if (size < 0L || size > size) {
            throw new IndexOutOfBoundsException("size: " + size + ", source size: " + size);
        }
        writableByteChannel.write(this.getByteBuffer(offset, (int)size));
    }

    @Override
    @NotNull
    public ByteBufferDataSource slice(long offset, long size) {
        if (offset == 0L && size == size) {
            return this;
        }
        if (size < 0L || size > size) {
            throw new IndexOutOfBoundsException("size: " + size + ", source size: " + size);
        }
        return new ByteBufferDataSource(this.getByteBuffer(offset, (int)size));
    }

    private final void checkChunkValid(long offset, long size) {
        long endOffset = offset + size;
        if (offset < 0L) {
            throw new IndexOutOfBoundsException("offset: " + offset);
        }
        if (size < 0L) {
            throw new IndexOutOfBoundsException("size: " + size);
        }
        if (offset > (long)this.size) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") > source size (" + size + ")");
        }
        if (endOffset < offset) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") + size (" + size + ") overflow");
        }
        if (endOffset > (long)this.size) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") + size (" + size + ") > source size (" + size + ")");
        }
    }
}

