/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm;

import java.net.URI;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.commonmark.CommonMarkFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.CheckedListItemGeneratingProvider;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMMarkerProcessor;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.flavours.gfm.StrikeThroughParser;
import org.intellij.markdown.flavours.gfm.TablesGeneratingProvider;
import org.intellij.markdown.flavours.gfm.lexer._GFMLexer;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.SimpleInlineTagProvider;
import org.intellij.markdown.html.TrimmingInlineHolderProvider;
import org.intellij.markdown.html.entities.EntityConverter;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.markdown.parser.LinkMap;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserManager;
import org.intellij.markdown.parser.sequentialparsers.impl.AutolinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.BacktickParser;
import org.intellij.markdown.parser.sequentialparsers.impl.EmphStrongParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ImageParser;
import org.intellij.markdown.parser.sequentialparsers.impl.InlineLinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ReferenceLinkParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/intellij/markdown/flavours/gfm/GFMFlavourDescriptor;", "Lorg/intellij/markdown/flavours/commonmark/CommonMarkFlavourDescriptor;", "()V", "markerProcessorFactory", "Lorg/intellij/markdown/flavours/gfm/GFMMarkerProcessor$Factory;", "getMarkerProcessorFactory", "()Lorg/intellij/markdown/flavours/gfm/GFMMarkerProcessor$Factory;", "sequentialParserManager", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "getSequentialParserManager", "()Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "createHtmlGeneratingProviders", "", "Lorg/intellij/markdown/IElementType;", "Lorg/intellij/markdown/html/GeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "createInlinesLexer", "Lorg/intellij/markdown/lexer/MarkdownLexer;", "intellij-markdown"})
public class GFMFlavourDescriptor
extends CommonMarkFlavourDescriptor {
    @NotNull
    private final GFMMarkerProcessor.Factory markerProcessorFactory = GFMMarkerProcessor.Factory.INSTANCE;
    @NotNull
    private final SequentialParserManager sequentialParserManager = new SequentialParserManager(){

        @NotNull
        public List<SequentialParser> getParserSequence() {
            return CollectionsKt.listOf((Object[])new SequentialParser[]{new AutolinkParser(CollectionsKt.listOf((Object[])new IElementType[]{MarkdownTokenTypes.AUTOLINK, GFMTokenTypes.GFM_AUTOLINK})), new BacktickParser(), new ImageParser(), new InlineLinkParser(), new ReferenceLinkParser(), new StrikeThroughParser(), new EmphStrongParser()});
        }
    };

    @Override
    @NotNull
    public GFMMarkerProcessor.Factory getMarkerProcessorFactory() {
        return this.markerProcessorFactory;
    }

    @Override
    @NotNull
    public MarkdownLexer createInlinesLexer() {
        return new MarkdownLexer(new _GFMLexer(null));
    }

    @Override
    @NotNull
    public SequentialParserManager getSequentialParserManager() {
        return this.sequentialParserManager;
    }

    @Override
    @NotNull
    public Map<IElementType, GeneratingProvider> createHtmlGeneratingProviders(@NotNull LinkMap linkMap, @Nullable URI baseURI) {
        Intrinsics.checkParameterIsNotNull((Object)linkMap, (String)"linkMap");
        return MapsKt.plus(super.createHtmlGeneratingProviders(linkMap, baseURI), (Map)MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)GFMElementTypes.STRIKETHROUGH, (Object)new SimpleInlineTagProvider("span", 2, -2){

            public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, this.getTagName(), new CharSequence[]{"class=\"user-del\""}, false, 8, null);
            }
        }), TuplesKt.to((Object)GFMElementTypes.TABLE, (Object)new TablesGeneratingProvider()), TuplesKt.to((Object)GFMTokenTypes.CELL, (Object)new TrimmingInlineHolderProvider()), TuplesKt.to((Object)GFMTokenTypes.GFM_AUTOLINK, (Object)new GeneratingProvider(){

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                CharSequence linkText = ASTUtilKt.getTextInNode(node, text);
                if (ASTUtilKt.getParentOfType(node, MarkdownElementTypes.LINK_LABEL, MarkdownElementTypes.LINK_TEXT) != null) {
                    visitor.consumeHtml(linkText);
                    return;
                }
                CharSequence linkDestination = this.hasSchema(linkText) ? linkText : (CharSequence)("http://" + linkText);
                String link = EntityConverter.INSTANCE.replaceEntities(linkText, true, false);
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "a", new CharSequence[]{"href=\"" + LinkMap.Builder.normalizeDestination(linkDestination, false) + '\"'}, false, 8, null);
                visitor.consumeHtml(link);
                visitor.consumeTagClose("a");
            }

            private final boolean hasSchema(CharSequence linkText) {
                int index = StringsKt.indexOf$default((CharSequence)linkText, (char)'/', (int)0, (boolean)false, (int)6, null);
                if (index == -1) {
                    return false;
                }
                return index != 0 && index + 1 < linkText.length() && linkText.charAt(index - 1) == ':' && linkText.charAt(index + 1) == '/';
            }
        }), TuplesKt.to((Object)MarkdownElementTypes.LIST_ITEM, (Object)new CheckedListItemGeneratingProvider())}));
    }
}

