/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.vis;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.base.values.FontFace;
import jetbrains.datalore.base.values.FontFamily;
import jetbrains.datalore.vis.TextStyle;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B)\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0004J\u0006\u0010\u000e\u001a\u00020\u0004J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ljetbrains/datalore/vis/StyleSheet;", "", "textStyles", "", "", "Ljetbrains/datalore/vis/TextStyle;", "defaultFamily", "defaultSize", "", "(Ljava/util/Map;Ljava/lang/String;D)V", "getClasses", "", "getTextStyle", "className", "toCSS", "id", "Companion", "vis-svg-portable"})
public final class StyleSheet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, TextStyle> textStyles;
    @NotNull
    private final String defaultFamily;
    private final double defaultSize;
    @NotNull
    private static final FontFace UNDEFINED_FONT_FACE = FontFace.Companion.getBOLD_ITALIC();
    @NotNull
    private static final Color UNDEFINED_FONT_COLOR = new Color(150, 0, 255, 0, 8, null);
    @NotNull
    private static final String CSS_REGEX = "\\.([\\w\\-]+)\\s+\\{([^\\{\\}]*)\\}";

    public StyleSheet(@NotNull Map<String, TextStyle> textStyles, @NotNull String defaultFamily, double defaultSize) {
        Intrinsics.checkNotNullParameter(textStyles, (String)"textStyles");
        Intrinsics.checkNotNullParameter((Object)defaultFamily, (String)"defaultFamily");
        this.textStyles = textStyles;
        this.defaultFamily = defaultFamily;
        this.defaultSize = defaultSize;
    }

    @NotNull
    public final List<String> getClasses() {
        return CollectionsKt.toList((Iterable)this.textStyles.keySet());
    }

    @NotNull
    public final TextStyle getTextStyle(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        TextStyle textStyle = this.textStyles.get(className);
        if (textStyle == null) {
            textStyle = new TextStyle(FontFamily.Companion.forName(this.defaultFamily), UNDEFINED_FONT_FACE, this.defaultSize, UNDEFINED_FONT_COLOR);
        }
        return textStyle;
    }

    @NotNull
    public final String toCSS(@NotNull String className, @Nullable String id) {
        String string;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder css;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)className, (String)"className");
                stringBuilder2 = css = new StringBuilder();
                stringBuilder = new StringBuilder().append("\n            |");
                string = id;
                if (string == null) break block2;
                String string2 = string;
                StringBuilder stringBuilder3 = stringBuilder;
                StringBuilder stringBuilder4 = stringBuilder2;
                boolean bl = false;
                String string3 = '#' + id + ' ';
                stringBuilder2 = stringBuilder4;
                stringBuilder = stringBuilder3;
                String string4 = string3;
                string = string4;
                if (string4 != null) break block3;
            }
            string = "";
        }
        stringBuilder2.append(StringsKt.trimMargin$default((String)stringBuilder.append(string).append('.').append(className).append(" {\n            |").append(StyleSheet.Companion.toCSS(this.getTextStyle(className))).append("\n            |}\n            |").toString(), null, (int)1, null));
        String string5 = css.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"css.toString()");
        return string5;
    }

    @NotNull
    public final String toCSS() {
        StringBuilder css = new StringBuilder();
        Iterable $this$forEach$iv = this.getClasses();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String className = (String)element$iv;
            boolean bl = false;
            css.append(this.toCSS(className, null));
        }
        String string = css.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"css.toString()");
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\n\u0010\u0013\u001a\u00020\u0004*\u00020\nJ\f\u0010\u0013\u001a\u00020\u0004*\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/vis/StyleSheet$Companion;", "", "()V", "CSS_REGEX", "", "UNDEFINED_FONT_COLOR", "Ljetbrains/datalore/base/values/Color;", "getUNDEFINED_FONT_COLOR", "()Ljetbrains/datalore/base/values/Color;", "UNDEFINED_FONT_FACE", "Ljetbrains/datalore/base/values/FontFace;", "getUNDEFINED_FONT_FACE", "()Ljetbrains/datalore/base/values/FontFace;", "fromCSS", "Ljetbrains/datalore/vis/StyleSheet;", "css", "defaultFamily", "defaultSize", "", "toCSS", "Ljetbrains/datalore/vis/TextStyle;", "vis-svg-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FontFace getUNDEFINED_FONT_FACE() {
            return UNDEFINED_FONT_FACE;
        }

        @NotNull
        public final Color getUNDEFINED_FONT_COLOR() {
            return UNDEFINED_FONT_COLOR;
        }

        @NotNull
        public final String toCSS(@NotNull FontFace $this$toCSS) {
            Intrinsics.checkNotNullParameter((Object)$this$toCSS, (String)"<this>");
            return "font-weight: " + ($this$toCSS.getBold() ? "bold" : "normal") + ";\n   font-style: " + ($this$toCSS.getItalic() ? "italic" : "normal") + ';';
        }

        private final String toCSS(TextStyle $this$toCSS) {
            return StringsKt.trimMargin$default((String)("\n                |   fill: " + $this$toCSS.getColor().toHexColor() + ";\n                |   font-family: " + $this$toCSS.getFamily() + ";\n                |   font-size: " + $this$toCSS.getSize() + "px;\n                |   " + this.toCSS($this$toCSS.getFace()) + "   \n                "), null, (int)1, null);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final StyleSheet fromCSS(@NotNull String css, @NotNull String defaultFamily, double defaultSize) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)css, (String)"css");
            Intrinsics.checkNotNullParameter((Object)defaultFamily, (String)"defaultFamily");
            Map classes = new LinkedHashMap();
            Sequence sequence = Regex.findAll$default((Regex)new Regex(StyleSheet.CSS_REGEX), (CharSequence)css, (int)0, (int)2, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                double d;
                FontFace fontFace;
                FontFamily fontFamily;
                Map map;
                String className;
                block4: {
                    block3: {
                        void p0;
                        MatchResult matched = (MatchResult)element$iv;
                        boolean bl = false;
                        MatchResult.Destructured destructured = matched.getDestructured();
                        className = (String)destructured.getMatch().getGroupValues().get(1);
                        String styleProperties = (String)destructured.getMatch().getGroupValues().get(2);
                        String fontFamily2 = defaultFamily;
                        String fontWeight = jetbrains.datalore.vis.StyleSheet$Companion.fromCSS$parseProperty(styleProperties, "font-weight");
                        String fontStyle = jetbrains.datalore.vis.StyleSheet$Companion.fromCSS$parseProperty(styleProperties, "font-style");
                        Object object = jetbrains.datalore.vis.StyleSheet$Companion.fromCSS$parseProperty(styleProperties, "font-size");
                        double fontSize = object != null && (object = StringsKt.removeSuffix((String)object, (CharSequence)"px")) != null && (object = StringsKt.toDoubleOrNull((String)object)) != null ? (Double)object : defaultSize;
                        String color = jetbrains.datalore.vis.StyleSheet$Companion.fromCSS$parseProperty(styleProperties, "fill");
                        map = classes;
                        fontFamily = FontFamily.Companion.forName(fontFamily2);
                        fontFace = new FontFace(Intrinsics.areEqual((Object)fontWeight, (Object)"bold"), Intrinsics.areEqual((Object)fontStyle, (Object)"italic"));
                        d = fontSize;
                        string = color;
                        if (string == null) break block3;
                        String string2 = string;
                        Color.Companion companion = Color.Companion;
                        String string3 = string2;
                        double d2 = d;
                        FontFace fontFace2 = fontFace;
                        FontFamily fontFamily3 = fontFamily;
                        boolean bl2 = false;
                        Color color2 = companion.parseHex((String)p0);
                        fontFamily = fontFamily3;
                        fontFace = fontFace2;
                        d = d2;
                        Color color3 = color2;
                        string = color3;
                        if (color3 != null) break block4;
                    }
                    string = Color.Companion.getBLACK();
                }
                String string4 = string;
                double d3 = d;
                FontFace fontFace3 = fontFace;
                FontFamily fontFamily4 = fontFamily;
                TextStyle textStyle = new TextStyle(fontFamily4, fontFace3, d3, (Color)string4);
                map.put(className, textStyle);
            }
            return new StyleSheet(classes, defaultFamily, defaultSize);
        }

        private static final String fromCSS$parseProperty(String styleProperties, String propertyName) {
            Regex regex = new Regex(propertyName + ":(.+);");
            Object object = Regex.find$default((Regex)regex, (CharSequence)styleProperties, (int)0, (int)2, null);
            return object != null && (object = object.getGroupValues()) != null && (object = (String)object.get(1)) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

