/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.util.sizing;

import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.util.sizing.SizingMode;
import org.jetbrains.letsPlot.core.util.sizing.SizingPolicyKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0011J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\u00020\u00002\u000e\u0010\u001c\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001dR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/core/util/sizing/SizingPolicy;", "", "widthMode", "Lorg/jetbrains/letsPlot/core/util/sizing/SizingMode;", "heightMode", "width", "", "height", "(Lorg/jetbrains/letsPlot/core/util/sizing/SizingMode;Lorg/jetbrains/letsPlot/core/util/sizing/SizingMode;Ljava/lang/Double;Ljava/lang/Double;)V", "getHeight", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getHeightMode", "()Lorg/jetbrains/letsPlot/core/util/sizing/SizingMode;", "getWidth", "getWidthMode", "getFixedSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "isFixedSize", "", "normalize", "v", "resize", "figureSizeDefault", "containerSize", "toString", "", "withUpdate", "options", "", "Companion", "plot-stem"})
public final class SizingPolicy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SizingMode widthMode;
    @NotNull
    private final SizingMode heightMode;
    @Nullable
    private final Double width;
    @Nullable
    private final Double height;
    @NotNull
    private static final SizingMode NOTEBOOK_WIDTH_MODE = SizingMode.MIN;
    @NotNull
    private static final SizingMode NOTEBOOK_HEIGHT_MODE = SizingMode.SCALED;

    public SizingPolicy(@NotNull SizingMode widthMode, @NotNull SizingMode heightMode, @Nullable Double width, @Nullable Double height) {
        Intrinsics.checkNotNullParameter((Object)((Object)widthMode), (String)"widthMode");
        Intrinsics.checkNotNullParameter((Object)((Object)heightMode), (String)"heightMode");
        this.widthMode = widthMode;
        this.heightMode = heightMode;
        this.width = width;
        this.height = height;
    }

    public /* synthetic */ SizingPolicy(SizingMode sizingMode2, SizingMode sizingMode3, Double d, Double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d = null;
        }
        if ((n & 8) != 0) {
            d2 = null;
        }
        this(sizingMode2, sizingMode3, d, d2);
    }

    @NotNull
    public final SizingMode getWidthMode() {
        return this.widthMode;
    }

    @NotNull
    public final SizingMode getHeightMode() {
        return this.heightMode;
    }

    @Nullable
    public final Double getWidth() {
        return this.width;
    }

    @Nullable
    public final Double getHeight() {
        return this.height;
    }

    private final double normalize(double v) {
        return Math.max(1.0, v);
    }

    public final boolean isFixedSize() {
        return this.widthMode == SizingMode.FIXED && this.heightMode == SizingMode.FIXED && this.width != null && this.height != null;
    }

    @NotNull
    public final DoubleVector getFixedSize() {
        if (!this.isFixedSize()) {
            boolean bl = false;
            String string = "Not a fixed size policy: " + this;
            throw new IllegalStateException(string.toString());
        }
        Double d = this.width;
        Intrinsics.checkNotNull((Object)d);
        double d2 = this.normalize(d);
        Double d3 = this.height;
        Intrinsics.checkNotNull((Object)d3);
        return new DoubleVector(d2, this.normalize(d3));
    }

    @NotNull
    public final DoubleVector resize(@NotNull DoubleVector figureSizeDefault2, @Nullable DoubleVector containerSize) {
        DoubleVector doubleVector;
        Double d;
        Double d2;
        double policyHeight;
        Intrinsics.checkNotNullParameter((Object)figureSizeDefault2, (String)"figureSizeDefault");
        DoubleVector doubleVector2 = containerSize;
        if (doubleVector2 == null) {
            doubleVector2 = figureSizeDefault2;
        }
        DoubleVector containerSize2 = doubleVector2;
        Double d3 = this.width;
        double policyWidth = d3 != null ? d3.doubleValue() : containerSize2.getX();
        Double d4 = this.height;
        double d5 = policyHeight = d4 != null ? d4.doubleValue() : containerSize2.getY();
        if (this.widthMode == SizingMode.SCALED && this.heightMode == SizingMode.SCALED) {
            return new DoubleRectangle(DoubleVector.Companion.getZERO(), new DoubleVector(policyWidth, policyHeight)).shrinkToAspectRatio(figureSizeDefault2).getDimension();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.widthMode.ordinal()]) {
            case 1: {
                Double d6 = this.width;
                d2 = d6 != null ? d6.doubleValue() : figureSizeDefault2.getX();
                break;
            }
            case 2: {
                d2 = policyWidth;
                break;
            }
            case 3: {
                d2 = Math.min(figureSizeDefault2.getX(), policyWidth);
                break;
            }
            case 4: {
                d2 = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Double widthFixed = d2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.heightMode.ordinal()]) {
            case 1: {
                Double d7 = this.height;
                d = d7 != null ? d7.doubleValue() : figureSizeDefault2.getY();
                break;
            }
            case 2: {
                d = policyHeight;
                break;
            }
            case 3: {
                d = Math.min(figureSizeDefault2.getY(), policyHeight);
                break;
            }
            case 4: {
                d = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Double heightFixed = d;
        if (widthFixed != null && heightFixed != null) {
            doubleVector = new DoubleVector(widthFixed.doubleValue(), heightFixed.doubleValue());
        } else if (widthFixed != null) {
            double height = widthFixed / this.normalize(figureSizeDefault2.getX()) * figureSizeDefault2.getY();
            doubleVector = new DoubleVector(widthFixed.doubleValue(), height);
        } else if (heightFixed != null) {
            double width = heightFixed / this.normalize(figureSizeDefault2.getY()) * figureSizeDefault2.getX();
            doubleVector = new DoubleVector(width, heightFixed.doubleValue());
        } else {
            throw new IllegalArgumentException("Unable to determine size with sizing policy: " + this);
        }
        return doubleVector;
    }

    @NotNull
    public final SizingPolicy withUpdate(@NotNull Map<?, ?> options) {
        SizingMode sizingMode2;
        SizingMode widthMode;
        Intrinsics.checkNotNullParameter(options, (String)"options");
        SizingMode sizingMode3 = SizingPolicy.Companion.sizingMode(options, "width_mode");
        if (sizingMode3 == null) {
            sizingMode3 = widthMode = this.widthMode;
        }
        if ((sizingMode2 = SizingPolicy.Companion.sizingMode(options, "height_mode")) == null) {
            sizingMode2 = this.heightMode;
        }
        SizingMode heightMode = sizingMode2;
        Object obj = options.get("width");
        Number number = obj instanceof Number ? (Number)((Number)obj) : (Number)null;
        Double width = number != null ? Double.valueOf(number.doubleValue()) : this.width;
        Object obj2 = options.get("height");
        Number number2 = obj2 instanceof Number ? (Number)((Number)obj2) : (Number)null;
        Double height = number2 != null ? Double.valueOf(number2.doubleValue()) : this.height;
        return new SizingPolicy(widthMode, heightMode, width, height);
    }

    @NotNull
    public String toString() {
        return "SizingPolicy(widthMode=" + (Object)((Object)this.widthMode) + ", heightMode=" + (Object)((Object)this.heightMode) + ", width=" + this.width + ", height=" + this.height + ')';
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fJ\u0006\u0010\u0012\u001a\u00020\u0007J\u0006\u0010\u0013\u001a\u00020\u0007J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/core/util/sizing/SizingPolicy$Companion;", "", "()V", "NOTEBOOK_HEIGHT_MODE", "Lorg/jetbrains/letsPlot/core/util/sizing/SizingMode;", "NOTEBOOK_WIDTH_MODE", "create", "Lorg/jetbrains/letsPlot/core/util/sizing/SizingPolicy;", "options", "", "dataloreReportCell", "width", "", "fitContainerSize", "preserveAspectRatio", "", "fixed", "height", "keepFigureDefaultSize", "notebookCell", "sizingMode", "option", "", "plot-stem"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SizingPolicy notebookCell() {
            return new SizingPolicy(NOTEBOOK_WIDTH_MODE, NOTEBOOK_HEIGHT_MODE, null, null);
        }

        @NotNull
        public final SizingPolicy dataloreReportCell(double width) {
            SizingMode sizingMode2 = SizingMode.FIXED;
            SizingMode sizingMode3 = SizingMode.SCALED;
            return new SizingPolicy(sizingMode2, sizingMode3, width, null);
        }

        @NotNull
        public final SizingPolicy fixed(double width, double height) {
            return new SizingPolicy(SizingMode.FIXED, SizingMode.FIXED, Math.max(0.0, width), Math.max(0.0, height));
        }

        @NotNull
        public final SizingPolicy keepFigureDefaultSize() {
            return new SizingPolicy(SizingMode.FIXED, SizingMode.FIXED, null, null);
        }

        @NotNull
        public final SizingPolicy fitContainerSize(boolean preserveAspectRatio) {
            SizingMode mode = preserveAspectRatio ? SizingMode.SCALED : SizingMode.FIT;
            return new SizingPolicy(mode, mode, null, null);
        }

        @NotNull
        public final SizingPolicy create(@NotNull Map<?, ?> options) {
            SizingMode sizingMode2;
            SizingMode sizingMode3;
            SizingMode heightMode;
            SizingMode sizingMode4;
            SizingMode widthMode;
            Intrinsics.checkNotNullParameter(options, (String)"options");
            Object obj = options.get("width");
            Number number = obj instanceof Number ? (Number)((Number)obj) : (Number)null;
            Double width = number != null ? Double.valueOf(number.doubleValue()) : null;
            Object obj2 = options.get("height");
            Number number2 = obj2 instanceof Number ? (Number)((Number)obj2) : (Number)null;
            Double height = number2 != null ? Double.valueOf(number2.doubleValue()) : null;
            SizingMode sizingMode5 = this.sizingMode(options, "width_mode");
            if (sizingMode5 == null) {
                sizingMode5 = widthMode = width != null ? SizingMode.FIXED : null;
            }
            if ((sizingMode4 = this.sizingMode(options, "height_mode")) == null) {
                sizingMode4 = heightMode = height != null ? SizingMode.FIXED : null;
            }
            if ((sizingMode3 = widthMode) == null) {
                sizingMode3 = NOTEBOOK_WIDTH_MODE;
            }
            if ((sizingMode2 = heightMode) == null) {
                sizingMode2 = NOTEBOOK_HEIGHT_MODE;
            }
            return new SizingPolicy(sizingMode3, sizingMode2, width, height);
        }

        private final SizingMode sizingMode(Map<?, ?> options, String option) {
            SizingMode sizingMode2;
            Object obj = options.get(option);
            if (obj != null) {
                Object value = obj;
                boolean bl = false;
                sizingMode2 = SizingMode.Companion.byNameIgnoreCase((String)value);
                if (sizingMode2 == null) {
                    Companion it = Companion;
                    boolean bl2 = false;
                    SizingPolicyKt.access$getLOG$p().info((Function0)new Function0<String>(option, value){
                        final /* synthetic */ String $option;
                        final /* synthetic */ Object $value;
                        {
                            this.$option = $option;
                            this.$value = $value;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Option " + this.$option + ": unexpected value '" + this.$value + '\'';
                        }
                    });
                    sizingMode2 = null;
                }
            } else {
                sizingMode2 = null;
            }
            return sizingMode2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SizingMode.values().length];
            try {
                nArray[SizingMode.FIXED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SizingMode.FIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SizingMode.MIN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SizingMode.SCALED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

