/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.front;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.spec.FigKind;
import org.jetbrains.letsPlot.core.spec.config.PlotConfig;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00040\bJB\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00040\bH\u0002JB\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00040\bH\u0002J8\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u00052\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00040\bH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/spec/front/SpecOverrideUtil;", "", "()V", "applySpecOverride", "", "", "plotSpec", "specOverrideList", "", "applySpecOverrideToCompositePlot", "applySpecOverrideToSinglePlot", "specOverrideToApply", "specId", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nSpecOverrideUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecOverrideUtil.kt\norg/jetbrains/letsPlot/core/spec/front/SpecOverrideUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n288#2,2:88\n288#2,2:90\n1549#2:92\n1620#2,3:93\n*S KotlinDebug\n*F\n+ 1 SpecOverrideUtil.kt\norg/jetbrains/letsPlot/core/spec/front/SpecOverrideUtil\n*L\n39#1:88,2\n45#1:90,2\n74#1:92\n74#1:93,3\n*E\n"})
public final class SpecOverrideUtil {
    @NotNull
    public static final SpecOverrideUtil INSTANCE = new SpecOverrideUtil();

    private SpecOverrideUtil() {
    }

    @NotNull
    public final Map<String, Object> applySpecOverride(@NotNull Map<String, ? extends Object> plotSpec, @NotNull List<? extends Map<String, ? extends Object>> specOverrideList) {
        Map<String, Object> map2;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter(specOverrideList, (String)"specOverrideList");
        if (specOverrideList.isEmpty()) {
            return plotSpec;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[PlotConfig.Companion.figSpecKind(plotSpec).ordinal()]) {
            case 1: {
                map2 = this.applySpecOverrideToSinglePlot(plotSpec, specOverrideList);
                break;
            }
            case 2: {
                map2 = this.applySpecOverrideToCompositePlot(plotSpec, specOverrideList);
                break;
            }
            case 3: {
                throw new IllegalStateException("Unsupported: GGBunch");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return map2;
    }

    private final Map<String, Object> specOverrideToApply(String specId, List<? extends Map<String, ? extends Object>> specOverrideList) {
        Map map2;
        block9: {
            Map forSpecId;
            block8: {
                Map forAll;
                Object v1;
                block7: {
                    Object v0;
                    block6: {
                        Iterable $this$firstOrNull$iv = specOverrideList;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Map it = (Map)element$iv;
                            boolean bl = false;
                            Object targetId = it.get("target_id");
                            if (!Intrinsics.areEqual(targetId, (Object)specId)) continue;
                            v0 = element$iv;
                            break block6;
                        }
                        v0 = null;
                    }
                    forSpecId = v0;
                    Iterable $this$firstOrNull$iv = specOverrideList;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Map it = (Map)element$iv;
                        boolean bl = false;
                        if (!(!it.containsKey("target_id"))) continue;
                        v1 = element$iv;
                        break block7;
                    }
                    v1 = null;
                }
                if ((map2 = (forAll = (Map)v1)) == null) break block8;
                Map map3 = forSpecId;
                if (map3 == null) {
                    map3 = MapsKt.emptyMap();
                }
                if ((map2 = MapsKt.plus((Map)map2, (Map)map3)) != null) break block9;
            }
            map2 = forSpecId;
        }
        return map2;
    }

    private final Map<String, Object> applySpecOverrideToSinglePlot(Map<String, ? extends Object> plotSpec, List<? extends Map<String, ? extends Object>> specOverrideList) {
        Map map2;
        block5: {
            block4: {
                Object object = plotSpec.get("spec_id");
                String string = object instanceof String ? (String)object : null;
                if (string == null) {
                    throw new IllegalStateException("spec_id missing from plot specifications. Possible cause: specifications were not processed by the backend preprocessor.");
                }
                String specId = string;
                Map specOverrideToApply = this.specOverrideToApply(specId, specOverrideList);
                map2 = specOverrideToApply;
                if (map2 == null) break block4;
                Map it = map2;
                boolean bl = false;
                Map map3 = MapsKt.plus(plotSpec, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"spec_override", it)));
                map2 = map3;
                if (map3 != null) break block5;
            }
            map2 = plotSpec;
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> applySpecOverrideToCompositePlot(Map<String, ? extends Object> plotSpec, List<? extends Map<String, ? extends Object>> specOverrideList) {
        void $this$mapTo$iv$iv;
        List specList;
        Object object = plotSpec.get("figures");
        List list = specList = object instanceof List ? (List)object : null;
        if (specList == null) {
            return plotSpec;
        }
        HashMap<String, Object> plotSpecCopy = new HashMap<String, Object>(plotSpec);
        Map map2 = plotSpecCopy;
        String string = "figures";
        Iterable $this$map$iv = specList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it instanceof Map ? INSTANCE.applySpecOverride((Map)it, specOverrideList) : it);
        }
        List list2 = (List)destination$iv$iv;
        map2.put(string, list2);
        return plotSpecCopy;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FigKind.values().length];
            try {
                nArray[FigKind.PLOT_SPEC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FigKind.SUBPLOTS_SPEC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FigKind.GG_BUNCH_SPEC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

