/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.plot.base.theme.ExponentFormat;
import org.jetbrains.letsPlot.core.plot.base.theme.FontFamilyRegistry;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.base.theme.TitlePosition;
import org.jetbrains.letsPlot.core.plot.builder.defaultTheme.ThemeUtil;
import org.jetbrains.letsPlot.core.plot.builder.defaultTheme.values.ThemeOption;
import org.jetbrains.letsPlot.core.spec.config.LegendThemeConfig;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0001\fB#\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/ThemeConfig;", "", "themeSettings", "", "", "fontFamilyRegistry", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FontFamilyRegistry;", "(Ljava/util/Map;Lorg/jetbrains/letsPlot/core/plot/base/theme/FontFamilyRegistry;)V", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "getTheme", "()Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "Companion", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nThemeConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThemeConfig.kt\norg/jetbrains/letsPlot/core/spec/config/ThemeConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,206:1\n1#2:207\n453#3:208\n403#3:209\n1238#4,4:210\n*S KotlinDebug\n*F\n+ 1 ThemeConfig.kt\norg/jetbrains/letsPlot/core/spec/config/ThemeConfig\n*L\n36#1:208\n36#1:209\n36#1:210,4\n*E\n"})
public final class ThemeConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Theme theme;

    /*
     * WARNING - void declaration
     */
    public ThemeConfig(@NotNull Map<String, ? extends Object> themeSettings, @NotNull FontFamilyRegistry fontFamilyRegistry) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(themeSettings, (String)"themeSettings");
        Intrinsics.checkNotNullParameter((Object)fontFamilyRegistry, (String)"fontFamilyRegistry");
        Map<String, ? extends Object> map2 = themeSettings;
        Object object = map2.get("name");
        if (object == null) {
            boolean bl = false;
            object = "minimal2";
        }
        String themeName = object.toString();
        Map<String, ? extends Object> $this$mapValues$iv = themeSettings;
        boolean $i$f$mapValues = false;
        Map<String, ? extends Object> map3 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map5 = map4;
            boolean bl2 = false;
            String key = (String)entry2.getKey();
            Object value = entry2.getValue();
            Object value2 = ThemeConfig.Companion.convertElementBlank(value);
            value2 = ThemeConfig.Companion.convertMargins(key, value2);
            value2 = ThemeConfig.Companion.convertInset(key, value2);
            value2 = ThemeConfig.Companion.convertExponentFormat(key, value2);
            value2 = ThemeConfig.Companion.convertTitlePosition(key, value2);
            Object object2 = LegendThemeConfig.INSTANCE.convertValue(key, value2);
            map5.put(k, object2);
        }
        Map userOptions = destination$iv$iv;
        this.theme = (Theme)ThemeUtil.INSTANCE.buildTheme(themeName, userOptions, fontFamilyRegistry);
    }

    public /* synthetic */ ThemeConfig(Map map2, FontFamilyRegistry fontFamilyRegistry, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(map2, fontFamilyRegistry);
    }

    @NotNull
    public final Theme getTheme() {
        return this.theme;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0002J\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0001H\u0002J\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0001H\u0002J\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0001H\u0002J\u0018\u0010\n\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0001H\u0002J\u001a\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/ThemeConfig$Companion;", "", "()V", "convertElementBlank", "value", "convertExponentFormat", "key", "", "convertInset", "convertMargins", "convertTitlePosition", "toThickness", "", "", "obj", "plot-stem"})
    @SourceDebugExtension(value={"SMAP\nThemeConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThemeConfig.kt\norg/jetbrains/letsPlot/core/spec/config/ThemeConfig$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,206:1\n1#2:207\n1726#3,3:208\n1549#3:211\n1620#3,3:212\n1549#3:215\n1620#3,3:216\n1238#3,4:228\n1238#3,4:241\n494#4,7:219\n453#4:226\n403#4:227\n494#4,7:232\n453#4:239\n403#4:240\n*S KotlinDebug\n*F\n+ 1 ThemeConfig.kt\norg/jetbrains/letsPlot/core/spec/config/ThemeConfig$Companion\n*L\n90#1:208,3\n93#1:211\n93#1:212,3\n51#1:215\n51#1:216,3\n149#1:228,4\n176#1:241,4\n148#1:219,7\n149#1:226\n149#1:227\n175#1:232,7\n176#1:239\n176#1:240\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Object convertExponentFormat(String key, Object value) {
            if (Intrinsics.areEqual((Object)key, (Object)"exponent_format")) {
                ExponentFormat.NotationType notationType;
                Object object = value;
                if (object instanceof String) {
                    notationType = org.jetbrains.letsPlot.core.spec.config.ThemeConfig$Companion.convertExponentFormat$toFormat((String)value);
                } else if (object instanceof List) {
                    Object it = ((List)value).get(0);
                    boolean bl = false;
                    ExponentFormat.NotationType format = org.jetbrains.letsPlot.core.spec.config.ThemeConfig$Companion.convertExponentFormat$toFormat(String.valueOf(it));
                    Object e = ((List)value).get(1);
                    Number number = e instanceof Number ? (Number)((Number)e) : (Number)null;
                    Integer minExponent = number != null ? Integer.valueOf(number.intValue()) : null;
                    Object e2 = ((List)value).get(2);
                    Number number2 = e2 instanceof Number ? (Number)((Number)e2) : (Number)null;
                    Integer maxExponent = number2 != null ? Integer.valueOf(number2.intValue()) : null;
                    notationType = new ExponentFormat(format, minExponent, maxExponent);
                } else {
                    throw new IllegalArgumentException("Illegal value: '" + value + "'.\nexponent_format expected value is a string: e|pow|pow_full or tuple (format, min_exp, max_exp).");
                }
                return notationType;
            }
            return value;
        }

        private final Object convertElementBlank(Object value) {
            if (value instanceof String && Intrinsics.areEqual((Object)value, (Object)"blank")) {
                return ThemeOption.INSTANCE.getELEMENT_BLANK();
            }
            if (value instanceof Map && Intrinsics.areEqual(((Map)value).get("name"), (Object)"blank")) {
                return ThemeOption.INSTANCE.getELEMENT_BLANK();
            }
            return value;
        }

        /*
         * WARNING - void declaration
         */
        private final List<Double> toThickness(Object obj) {
            List list;
            Object object = obj;
            if (object instanceof Number) {
                list = CollectionsKt.listOf((Object)((Number)obj).doubleValue());
            } else if (object instanceof List) {
                void $this$mapTo$iv$iv;
                Object object2;
                boolean bl;
                block15: {
                    Iterable $this$all$iv = (Iterable)obj;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        object2 = $this$all$iv.iterator();
                        while (object2.hasNext()) {
                            Object element$iv;
                            Object it = element$iv = object2.next();
                            boolean bl2 = false;
                            if (it == null || it instanceof Number) continue;
                            bl = false;
                            break block15;
                        }
                        bl = true;
                    }
                }
                if (!bl) {
                    boolean $i$a$-require-ThemeConfig$Companion$toThickness$thickness$32 = false;
                    String $i$a$-require-ThemeConfig$Companion$toThickness$thickness$32 = "The option requires a list of numbers, but was: " + obj + '.';
                    throw new IllegalArgumentException($i$a$-require-ThemeConfig$Companion$toThickness$thickness$32.toString());
                }
                Iterable $this$map$iv = (Iterable)obj;
                boolean $i$f$map = false;
                object2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator bl2 = $this$mapTo$iv$iv.iterator();
                while (bl2.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object t = item$iv$iv = bl2.next();
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    Number number = it instanceof Number ? (Number)((Number)it) : (Number)null;
                    collection.add(number != null ? Double.valueOf(number.doubleValue()) : null);
                }
                list = (List)destination$iv$iv;
            } else {
                throw new IllegalStateException(("The option should be specified using number or list of numbers, but was: " + obj + '.').toString());
            }
            List thickness = list;
            Double top = null;
            Double right = null;
            Double bottom = null;
            Double left = null;
            switch (thickness.size()) {
                case 1: {
                    Double value;
                    top = value = (Double)CollectionsKt.single((List)thickness);
                    right = value;
                    left = value;
                    bottom = value;
                    break;
                }
                case 2: {
                    Double v = (Double)thickness.get(0);
                    Double h = (Double)thickness.get(1);
                    top = v;
                    bottom = v;
                    right = h;
                    left = h;
                    break;
                }
                case 3: {
                    top = (Double)thickness.get(0);
                    right = (Double)thickness.get(1);
                    left = (Double)thickness.get(1);
                    bottom = (Double)thickness.get(2);
                    break;
                }
                case 4: {
                    top = (Double)thickness.get(0);
                    right = (Double)thickness.get(1);
                    bottom = (Double)thickness.get(2);
                    left = (Double)thickness.get(3);
                    break;
                }
                default: {
                    throw new IllegalStateException(("The option accept a number or a list of one, two, three or four numbers, but was: " + obj + '.').toString());
                }
            }
            Object[] objectArray = new Double[]{top, right, bottom, left};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        private final Object convertMargins(String key, Object value) {
            Object object;
            Object[] objectArray = new String[]{"plot_margin", "legend_margin"};
            if (SetsKt.setOf((Object[])objectArray).contains(key)) {
                object = org.jetbrains.letsPlot.core.spec.config.ThemeConfig$Companion.convertMargins$toMarginSpec(value);
            } else if (value instanceof Map && ((Map)value).containsKey("margin")) {
                Map<String, Object> margins = org.jetbrains.letsPlot.core.spec.config.ThemeConfig$Companion.convertMargins$toMarginSpec(((Map)value).get("margin"));
                object = MapsKt.plus((Map)MapsKt.minus((Map)((Map)value), (Object)"margin"), margins);
            } else {
                object = value;
            }
            return object;
        }

        private final Object convertInset(String key, Object value) {
            Object object;
            if (Intrinsics.areEqual((Object)key, (Object)"panel_inset") || Intrinsics.areEqual((Object)key, (Object)"plot_inset")) {
                object = org.jetbrains.letsPlot.core.spec.config.ThemeConfig$Companion.convertInset$toInsetSpec(value);
            } else if (value instanceof Map && ((Map)value).containsKey("inset")) {
                Map<String, Object> inset = org.jetbrains.letsPlot.core.spec.config.ThemeConfig$Companion.convertInset$toInsetSpec(((Map)value).get("inset"));
                object = MapsKt.plus((Map)MapsKt.minus((Map)((Map)value), (Object)"inset"), inset);
            } else {
                object = value;
            }
            return object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final Object convertTitlePosition(String key, Object value) {
            Object object;
            String string = key;
            if (Intrinsics.areEqual((Object)string, (Object)"plot_title_position") ? true : Intrinsics.areEqual((Object)string, (Object)"plot_caption_position")) {
                Object object2 = value;
                if (Intrinsics.areEqual((Object)object2, (Object)"panel")) {
                    object = TitlePosition.PANEL;
                    return object;
                } else {
                    if (!Intrinsics.areEqual((Object)object2, (Object)"plot")) throw new IllegalArgumentException("Illegal value: '" + value + "', " + key + ". Expected values are: 'panel' or 'plot'.");
                    object = TitlePosition.PLOT;
                }
                return object;
            } else {
                object = value;
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private static final ExponentFormat.NotationType convertExponentFormat$toFormat(String value) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)EntriesMappings.entries$0;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ExponentFormat.NotationType notationType = (ExponentFormat.NotationType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                collection.add(TuplesKt.to((Object)string, (Object)it));
            }
            Map notationTypes = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            ExponentFormat.NotationType notationType = (ExponentFormat.NotationType)notationTypes.get(value);
            if (notationType == null) {
                throw new IllegalArgumentException("Illegal value: '" + value + "'.\nexponent_format expected value is a string: " + CollectionsKt.joinToString$default((Iterable)notationTypes.keySet(), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + '.');
            }
            return notationType;
        }

        /*
         * WARNING - void declaration
         */
        private static final Map<String, Object> convertMargins$toMarginSpec(Object value) {
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Map $this$filterValues$iv;
            List<Double> list = Companion.toThickness(value);
            Double top = list.get(0);
            Double right = list.get(1);
            Double bottom = list.get(2);
            Double left = list.get(3);
            Object object = new Pair[]{TuplesKt.to((Object)"margin_t", (Object)top), TuplesKt.to((Object)"margin_r", (Object)right), TuplesKt.to((Object)"margin_b", (Object)bottom), TuplesKt.to((Object)"margin_l", (Object)left)};
            object = MapsKt.mapOf((Pair[])object);
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                Double it = (Double)entry$iv.getValue();
                boolean bl = false;
                if (!(it != null)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterValues$iv = result$iv;
            boolean $i$f$mapValues = false;
            result$iv = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                Double v = (Double)entry2.getValue();
                Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.Any");
                Object object2 = v;
                map3.put(k, object2);
            }
            return destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private static final Map<String, Object> convertInset$toInsetSpec(Object value) {
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Map $this$filterValues$iv;
            List<Double> list = Companion.toThickness(value);
            Double top = list.get(0);
            Double right = list.get(1);
            Double bottom = list.get(2);
            Double left = list.get(3);
            Object object = new Pair[]{TuplesKt.to((Object)"inset_t", (Object)top), TuplesKt.to((Object)"inset_r", (Object)right), TuplesKt.to((Object)"inset_b", (Object)bottom), TuplesKt.to((Object)"inset_l", (Object)left)};
            object = MapsKt.mapOf((Pair[])object);
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                Double it = (Double)entry$iv.getValue();
                boolean bl = false;
                if (!(it != null)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterValues$iv = result$iv;
            boolean $i$f$mapValues = false;
            result$iv = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                Double v = (Double)entry2.getValue();
                Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.Any");
                Object object2 = v;
                map3.put(k, object2);
            }
            return destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class EntriesMappings {
            public static final /* synthetic */ EnumEntries<ExponentFormat.NotationType> entries$0;

            static {
                entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])ExponentFormat.NotationType.values()));
            }
        }
    }
}

