/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.string.StringFormat;
import org.jetbrains.letsPlot.commons.intern.datetime.TimeZone;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.commons.values.Colors;
import org.jetbrains.letsPlot.core.commons.data.DataType;
import org.jetbrains.letsPlot.core.commons.time.interval.NiceTimeInterval;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.scale.BreaksGenerator;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.DateTimeBreaksGen;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.TimeBreaksGen;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.Transforms;
import org.jetbrains.letsPlot.core.plot.builder.scale.AxisPosition;
import org.jetbrains.letsPlot.core.plot.builder.scale.DefaultMapperProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.DefaultMapperProviderUtil;
import org.jetbrains.letsPlot.core.plot.builder.scale.DefaultNaValue;
import org.jetbrains.letsPlot.core.plot.builder.scale.MapperProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.ScaleProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.ScaleProviderBuilder;
import org.jetbrains.letsPlot.core.plot.builder.scale.mapper.ShapeMapper;
import org.jetbrains.letsPlot.core.plot.builder.scale.provider.AlphaMapperProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.provider.ColorBrewerMapperProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.provider.ColorGradient2MapperProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.provider.ColorGradientMapperProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.provider.ColorGradientnMapperProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.provider.ColorHueMapperProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.provider.ColormapMapperProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.provider.GreyscaleLightnessMapperProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.provider.IdentityDiscreteMapperProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.provider.IdentityMapperProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.provider.LinewidthMapperProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.provider.SizeAreaMapperProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.provider.SizeMapperProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.provider.StrokeMapperProvider;
import org.jetbrains.letsPlot.core.spec.Option;
import org.jetbrains.letsPlot.core.spec.config.GuideConfig;
import org.jetbrains.letsPlot.core.spec.config.OptionsAccessor;
import org.jetbrains.letsPlot.core.spec.config.ScaleConfig;
import org.jetbrains.letsPlot.core.spec.conversion.AesOptionConversion;
import org.jetbrains.letsPlot.core.spec.conversion.TypedContinuousIdentityMappers;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\"BA\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0002J\u0014\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0002J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\u001eR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/ScaleConfig;", "T", "Lorg/jetbrains/letsPlot/core/spec/config/OptionsAccessor;", "aes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "options", "", "", "", "aopConversion", "Lorg/jetbrains/letsPlot/core/spec/conversion/AesOptionConversion;", "dataType", "Lorg/jetbrains/letsPlot/core/commons/data/DataType;", "tz", "Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;", "(Lorg/jetbrains/letsPlot/core/plot/base/Aes;Ljava/util/Map;Lorg/jetbrains/letsPlot/core/spec/conversion/AesOptionConversion;Lorg/jetbrains/letsPlot/core/commons/data/DataType;Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;)V", "getAes", "()Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "applyCommons", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/ScaleProviderBuilder;", "b", "axisPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;", "axis", "createMapperProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/MapperProvider;", "createScaleProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/ScaleProvider;", "createScaleProviderBuilder", "enforceDiscreteDomain", "", "getGuideOptions", "Lorg/jetbrains/letsPlot/core/spec/config/GuideConfig;", "hasGuideOptions", "Companion", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nScaleConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScaleConfig.kt\norg/jetbrains/letsPlot/core/spec/config/ScaleConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,358:1\n1549#2:359\n1620#2,3:360\n1603#2,9:364\n1855#2:373\n1856#2:375\n1612#2:376\n1#3:363\n1#3:374\n*S KotlinDebug\n*F\n+ 1 ScaleConfig.kt\norg/jetbrains/letsPlot/core/spec/config/ScaleConfig\n*L\n154#1:359\n154#1:360,3\n272#1:364,9\n272#1:373\n272#1:375\n272#1:376\n272#1:374\n*E\n"})
public final class ScaleConfig<T>
extends OptionsAccessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Aes<T> aes;
    @NotNull
    private final AesOptionConversion aopConversion;
    @NotNull
    private final DataType dataType;
    @Nullable
    private final TimeZone tz;

    public ScaleConfig(@NotNull Aes<T> aes, @NotNull Map<String, ? extends Object> options, @NotNull AesOptionConversion aopConversion, @NotNull DataType dataType, @Nullable TimeZone tz) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)aopConversion, (String)"aopConversion");
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        super(options, null, 2, null);
        this.aes = aes;
        this.aopConversion = aopConversion;
        this.dataType = dataType;
        this.tz = tz;
    }

    @NotNull
    public final Aes<T> getAes() {
        return this.aes;
    }

    private final boolean enforceDiscreteDomain() {
        return OptionsAccessor.getBoolean$default(this, "discrete", false, 2, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final MapperProvider<T> createMapperProvider() {
        MapperProvider mapperProvider;
        block37: {
            String scaleMapperKind;
            Object naValue;
            block43: {
                block40: {
                    block38: {
                        block39: {
                            boolean bl;
                            block44: {
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                block41: {
                                    block42: {
                                        block45: {
                                            String string;
                                            String string2;
                                            Object object;
                                            mapperProvider = DefaultMapperProvider.INSTANCE.get(this.aes);
                                            if (this.has("na_value")) {
                                                T t = this.getValue(this.aes, "na_value", this.aopConversion);
                                                object = t;
                                                Intrinsics.checkNotNull(t);
                                            } else {
                                                object = naValue = DefaultNaValue.INSTANCE.get(this.aes);
                                            }
                                            if (this.has("values")) {
                                                List<?> outputValues = this.getList("values");
                                                List<T> mapperOutputValues = this.aopConversion.applyToList(this.aes, outputValues);
                                                mapperProvider = DefaultMapperProviderUtil.INSTANCE.createWithDiscreteOutput(mapperOutputValues, naValue);
                                            }
                                            if (Intrinsics.areEqual(this.aes, (Object)Aes.Companion.getSHAPE())) {
                                                Object solid = this.get("solid");
                                                if (solid instanceof Boolean && Intrinsics.areEqual((Object)solid, (Object)false)) {
                                                    mapperProvider = DefaultMapperProviderUtil.INSTANCE.createWithDiscreteOutput(ShapeMapper.INSTANCE.hollowShapes(), (Object)ShapeMapper.INSTANCE.getNA_VALUE());
                                                }
                                            } else if ((Intrinsics.areEqual(this.aes, (Object)Aes.Companion.getALPHA()) || Intrinsics.areEqual(this.aes, (Object)Aes.Companion.getSEGMENT_ALPHA())) && this.has("range")) {
                                                DoubleSpan doubleSpan = this.getRange$plot_stem("range");
                                                Intrinsics.checkNotNull((Object)naValue, (String)"null cannot be cast to non-null type kotlin.Double");
                                                mapperProvider = (MapperProvider)new AlphaMapperProvider(doubleSpan, ((Double)naValue).doubleValue());
                                            } else if ((Intrinsics.areEqual(this.aes, (Object)Aes.Companion.getSIZE()) || Intrinsics.areEqual(this.aes, (Object)Aes.Companion.getSIZE_START()) || Intrinsics.areEqual(this.aes, (Object)Aes.Companion.getSIZE_END()) || Intrinsics.areEqual(this.aes, (Object)Aes.Companion.getPOINT_SIZE()) || Intrinsics.areEqual(this.aes, (Object)Aes.Companion.getPOINT_STROKE()) || Intrinsics.areEqual(this.aes, (Object)Aes.Companion.getSEGMENT_SIZE())) && this.has("range")) {
                                                DoubleSpan doubleSpan = this.getRange$plot_stem("range");
                                                Intrinsics.checkNotNull((Object)naValue, (String)"null cannot be cast to non-null type kotlin.Double");
                                                mapperProvider = (MapperProvider)new SizeMapperProvider(doubleSpan, ((Double)naValue).doubleValue());
                                            } else if (Intrinsics.areEqual(this.aes, (Object)Aes.Companion.getLINEWIDTH()) && this.has("range")) {
                                                DoubleSpan doubleSpan = this.getRange$plot_stem("range");
                                                Intrinsics.checkNotNull((Object)naValue, (String)"null cannot be cast to non-null type kotlin.Double");
                                                mapperProvider = (MapperProvider)new LinewidthMapperProvider(doubleSpan, ((Double)naValue).doubleValue());
                                            } else if ((Intrinsics.areEqual(this.aes, (Object)Aes.Companion.getSTROKE()) || Intrinsics.areEqual(this.aes, (Object)Aes.Companion.getSTROKE_START()) || Intrinsics.areEqual(this.aes, (Object)Aes.Companion.getSTROKE_END())) && this.has("range")) {
                                                DoubleSpan doubleSpan = this.getRange$plot_stem("range");
                                                Intrinsics.checkNotNull((Object)naValue, (String)"null cannot be cast to non-null type kotlin.Double");
                                                mapperProvider = (MapperProvider)new StrokeMapperProvider(doubleSpan, ((Double)naValue).doubleValue());
                                            }
                                            if ((string2 = this.getString("scale_mapper_kind")) == null) {
                                                string2 = !this.has("values") && this.enforceDiscreteDomain() && Aes.Companion.isColor(this.aes) ? "color_brewer" : null;
                                            }
                                            String string3 = string = (scaleMapperKind = string2);
                                            if (string3 == null) break block37;
                                            switch (string3.hashCode()) {
                                                case 1928028555: {
                                                    if (!string.equals("color_brewer")) {
                                                        throw new IllegalArgumentException("Aes '" + this.aes.getName() + "' - unexpected scale mapper kind: '" + scaleMapperKind + '\'');
                                                    }
                                                    break block38;
                                                }
                                                case 1289304635: {
                                                    if (!string.equals("color_grey")) {
                                                        throw new IllegalArgumentException("Aes '" + this.aes.getName() + "' - unexpected scale mapper kind: '" + scaleMapperKind + '\'');
                                                    }
                                                    break block39;
                                                }
                                                case 1289180533: {
                                                    if (!string.equals("color_cmap")) {
                                                        throw new IllegalArgumentException("Aes '" + this.aes.getName() + "' - unexpected scale mapper kind: '" + scaleMapperKind + '\'');
                                                    }
                                                    break block40;
                                                }
                                                case 1058109794: {
                                                    if (!string.equals("color_gradientn")) {
                                                        throw new IllegalArgumentException("Aes '" + this.aes.getName() + "' - unexpected scale mapper kind: '" + scaleMapperKind + '\'');
                                                    }
                                                    break block41;
                                                }
                                                case -135761730: {
                                                    if (string.equals("identity")) break;
                                                    throw new IllegalArgumentException("Aes '" + this.aes.getName() + "' - unexpected scale mapper kind: '" + scaleMapperKind + '\'');
                                                }
                                                case 1058109734: {
                                                    if (!string.equals("color_gradient2")) {
                                                        throw new IllegalArgumentException("Aes '" + this.aes.getName() + "' - unexpected scale mapper kind: '" + scaleMapperKind + '\'');
                                                    }
                                                    break block42;
                                                }
                                                case 496206347: {
                                                    if (!string.equals("size_area")) {
                                                        throw new IllegalArgumentException("Aes '" + this.aes.getName() + "' - unexpected scale mapper kind: '" + scaleMapperKind + '\'');
                                                    }
                                                    break block43;
                                                }
                                                case 1981254172: {
                                                    if (!string.equals("color_hue")) {
                                                        throw new IllegalArgumentException("Aes '" + this.aes.getName() + "' - unexpected scale mapper kind: '" + scaleMapperKind + '\'');
                                                    }
                                                    break block44;
                                                }
                                                case 1696700556: {
                                                    if (!string.equals("color_gradient")) {
                                                        throw new IllegalArgumentException("Aes '" + this.aes.getName() + "' - unexpected scale mapper kind: '" + scaleMapperKind + '\'');
                                                    }
                                                    break block45;
                                                }
                                            }
                                            mapperProvider = Companion.createIdentityMapperProvider(this.aes, naValue, this.aopConversion);
                                            break block37;
                                        }
                                        Color color = this.getColor("low", this.aopConversion);
                                        Color color2 = this.getColor("high", this.aopConversion);
                                        Intrinsics.checkNotNull((Object)naValue, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.commons.values.Color");
                                        mapperProvider = (MapperProvider)new ColorGradientMapperProvider(color, color2, (Color)naValue);
                                        break block37;
                                    }
                                    Color color = this.getColor("low", this.aopConversion);
                                    Color color3 = this.getColor("mid", this.aopConversion);
                                    Color color4 = this.getColor("high", this.aopConversion);
                                    Double d = this.getDouble("midpoint");
                                    Intrinsics.checkNotNull((Object)naValue, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.commons.values.Color");
                                    mapperProvider = (MapperProvider)new ColorGradient2MapperProvider(color, color3, color4, d, (Color)naValue);
                                    break block37;
                                }
                                Iterable iterable = this.getStringList("colors");
                                Colors colors = Colors.INSTANCE;
                                boolean $i$f$map = false;
                                void var8_8 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                    void p0;
                                    String string = (String)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl2 = false;
                                    collection.add(colors.parseColor((String)p0));
                                }
                                List list = (List)destination$iv$iv;
                                Intrinsics.checkNotNull((Object)naValue, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.commons.values.Color");
                                Color color = (Color)naValue;
                                List list2 = list;
                                mapperProvider = (MapperProvider)new ColorGradientnMapperProvider(list2, color);
                                break block37;
                            }
                            DoubleSpan doubleSpan = this.getRangeOrNull("h");
                            if (doubleSpan == null) {
                                doubleSpan = ColorHueMapperProvider.Companion.getDEF_HUE_RANGE();
                            }
                            Double d = this.getDouble("c");
                            double d2 = d != null ? d : 100.0;
                            Double d3 = this.getDouble("l");
                            double d4 = d3 != null ? d3 : 65.0;
                            Double d5 = this.getDouble("h_start");
                            double d6 = d5 != null ? d5 : 0.0;
                            Double d7 = this.getDouble("direction");
                            if (d7 != null) {
                                void it;
                                double $this$mapTo$iv$iv = ((Number)d7).doubleValue();
                                double d8 = d6;
                                double d9 = d4;
                                double d10 = d2;
                                DoubleSpan doubleSpan2 = doubleSpan;
                                boolean bl3 = false;
                                boolean bl4 = it < 0.0;
                                doubleSpan = doubleSpan2;
                                d2 = d10;
                                d4 = d9;
                                d6 = d8;
                                bl = bl4;
                            } else {
                                bl = false;
                            }
                            Intrinsics.checkNotNull((Object)naValue, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.commons.values.Color");
                            Color color = (Color)naValue;
                            boolean bl5 = bl;
                            double d11 = d6;
                            double d12 = d4;
                            double d13 = d2;
                            DoubleSpan doubleSpan3 = doubleSpan;
                            mapperProvider = (MapperProvider)new ColorHueMapperProvider(doubleSpan3, d13, d12, d11, bl5, color);
                            break block37;
                        }
                        Double d = this.getDouble("start");
                        double d14 = d != null ? d : 0.2;
                        Double d15 = this.getDouble("end");
                        double d16 = d15 != null ? d15 : 0.8;
                        Intrinsics.checkNotNull((Object)naValue, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.commons.values.Color");
                        mapperProvider = (MapperProvider)new GreyscaleLightnessMapperProvider(d14, d16, (Color)naValue);
                        break block37;
                    }
                    String string = this.getString("type");
                    Object object = this.get("palette");
                    Double d = this.getDouble("direction");
                    Intrinsics.checkNotNull((Object)naValue, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.commons.values.Color");
                    mapperProvider = (MapperProvider)new ColorBrewerMapperProvider(string, object, d, (Color)naValue);
                    break block37;
                }
                String string = this.getString("option");
                Double d = this.getDouble("alpha");
                Double d17 = this.getDouble("begin");
                Double d18 = this.getDouble("end");
                Double d19 = this.getDouble("direction");
                Intrinsics.checkNotNull((Object)naValue, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.commons.values.Color");
                mapperProvider = (MapperProvider)new ColormapMapperProvider(string, d, d17, d18, d19, (Color)naValue);
                break block37;
            }
            Double d = this.getDouble("max_size");
            Intrinsics.checkNotNull((Object)naValue, (String)"null cannot be cast to non-null type kotlin.Double");
            mapperProvider = (MapperProvider)new SizeAreaMapperProvider(d, ((Double)naValue).doubleValue());
            break block37;
            throw new IllegalArgumentException("Aes '" + this.aes.getName() + "' - unexpected scale mapper kind: '" + scaleMapperKind + '\'');
        }
        MapperProvider mapperProvider2 = mapperProvider;
        Intrinsics.checkNotNull((Object)mapperProvider2, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.builder.scale.MapperProvider<T of org.jetbrains.letsPlot.core.spec.config.ScaleConfig>");
        return mapperProvider2;
    }

    @NotNull
    public final ScaleProvider createScaleProvider() {
        return this.createScaleProviderBuilder().build();
    }

    @NotNull
    public final ScaleProviderBuilder<T> createScaleProviderBuilder() {
        ScaleProviderBuilder b;
        block26: {
            ContinuousTransform continuousTransform;
            boolean discreteDomain;
            block27: {
                block25: {
                    Function1 function1;
                    discreteDomain = this.enforceDiscreteDomain();
                    boolean reverse = OptionsAccessor.getBoolean$default(this, "reverse", false, 2, null);
                    b = new ScaleProviderBuilder(this.aes);
                    b.discreteDomain(discreteDomain);
                    b.discreteDomainReverse(reverse);
                    if (!OptionsAccessor.getBoolean$default(this, "datetime", false, 2, null)) break block25;
                    String string = this.getString("format");
                    if (string != null) {
                        String pattern2 = string;
                        boolean bl = false;
                        StringFormat stringFormat = StringFormat.Companion.forOneArg$default((StringFormat.Companion)StringFormat.Companion, (String)pattern2, (StringFormat.FormatType)StringFormat.FormatType.DATETIME_FORMAT, null, null, (TimeZone)this.tz, (int)12, null);
                        function1 = (Function1)new Function1<Object, String>(stringFormat){
                            final /* synthetic */ StringFormat $stringFormat;
                            {
                                this.$stringFormat = $stringFormat;
                                super(1);
                            }

                            @NotNull
                            public final String invoke(@NotNull Object value) {
                                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                                return this.$stringFormat.format(value);
                            }
                        };
                    } else {
                        function1 = null;
                    }
                    Function1 dateTimeFormatter2 = function1;
                    b.breaksGenerator((BreaksGenerator)new DateTimeBreaksGen(dateTimeFormatter2, NiceTimeInterval.Companion.minIntervalOf(this.dataType), NiceTimeInterval.Companion.maxIntervalOf(this.dataType), this.tz));
                    break block26;
                }
                if (!OptionsAccessor.getBoolean$default(this, "time", false, 2, null)) break block27;
                b.breaksGenerator((BreaksGenerator)new TimeBreaksGen(null, 1, null));
                break block26;
            }
            if (discreteDomain || !this.has("trans")) break block26;
            String transformName = this.getStringSafe("trans");
            String string = transformName.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            switch (string) {
                case "identity": {
                    continuousTransform = Transforms.INSTANCE.getIDENTITY();
                    break;
                }
                case "log10": {
                    continuousTransform = Transforms.INSTANCE.getLOG10();
                    break;
                }
                case "log2": {
                    continuousTransform = Transforms.INSTANCE.getLOG2();
                    break;
                }
                case "symlog": {
                    continuousTransform = Transforms.INSTANCE.getSYMLOG();
                    break;
                }
                case "reverse": {
                    continuousTransform = Transforms.INSTANCE.getREVERSE();
                    break;
                }
                case "sqrt": {
                    continuousTransform = Transforms.INSTANCE.getSQRT();
                    break;
                }
                default: {
                    Object[] objectArray = new String[]{"identity", "log10", "log2", "symlog", "reverse", "sqrt"};
                    throw new IllegalArgumentException("Unknown transform name: '" + transformName + "'. Supported: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), null, null, null, (int)0, null, (Function1)createScaleProviderBuilder.transform.1.INSTANCE, (int)31, null) + '.');
                }
            }
            ContinuousTransform transform2 = continuousTransform;
            b.continuousTransform(transform2);
        }
        Object[] objectArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getY()};
        if (CollectionsKt.listOf((Object[])objectArray).contains(this.aes) && this.has("position")) {
            b.setAxisPosition(this.axisPosition(this.aes));
        }
        return this.applyCommons(b);
    }

    /*
     * WARNING - void declaration
     */
    private final ScaleProviderBuilder<T> applyCommons(ScaleProviderBuilder<T> b) {
        if (this.has("name")) {
            String string = this.getString("name");
            Intrinsics.checkNotNull((Object)string);
            b.name(string);
        }
        if (this.has("breaks")) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = this.getList("breaks");
            ScaleProviderBuilder<T> scaleProviderBuilder = b;
            boolean $i$f$mapNotNull = false;
            void var4_5 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Object it = element$iv$iv;
                boolean bl2 = false;
                if (it == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            scaleProviderBuilder.breaks((List)destination$iv$iv);
        }
        if (this.has("labels")) {
            b.labels(this.getStringList("labels"));
        } else {
            b.labelFormat(this.getString("format"));
        }
        if (this.has("lablim")) {
            Integer n = this.getInteger("lablim");
            Intrinsics.checkNotNull((Object)n);
            b.labelLengthLimit(n.intValue());
        }
        if (this.has("expand")) {
            List<Double> expandList = this.getDoubleList("expand");
            Double d = (Double)CollectionsKt.getOrNull(expandList, (int)0);
            if (d != null) {
                double it = ((Number)d).doubleValue();
                boolean bl = false;
                b.multiplicativeExpand(it);
            }
            Double d2 = (Double)CollectionsKt.getOrNull(expandList, (int)1);
            if (d2 != null) {
                double it = ((Number)d2).doubleValue();
                boolean bl = false;
                b.additiveExpand(it);
            }
        }
        if (this.has("limits")) {
            b.limits(this.getList("limits"));
        }
        return b;
    }

    public final boolean hasGuideOptions() {
        return this.has("guide");
    }

    @NotNull
    public final GuideConfig getGuideOptions() {
        Object object = this.get("guide");
        Intrinsics.checkNotNull((Object)object);
        return GuideConfig.Companion.create(object);
    }

    private final AxisPosition axisPosition(Aes<?> axis) {
        AxisPosition axisPosition;
        String s = this.getStringSafe("position");
        String string = ((Object)StringsKt.trim((CharSequence)s)).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        switch (string) {
            case "left": {
                axisPosition = AxisPosition.LEFT;
                break;
            }
            case "right": {
                axisPosition = AxisPosition.RIGHT;
                break;
            }
            case "top": {
                axisPosition = AxisPosition.TOP;
                break;
            }
            case "bottom": {
                axisPosition = AxisPosition.BOTTOM;
                break;
            }
            case "both": {
                if (Intrinsics.areEqual(axis, (Object)Aes.Companion.getX())) {
                    axisPosition = AxisPosition.TB;
                    break;
                }
                axisPosition = AxisPosition.LR;
                break;
            }
            default: {
                throw new IllegalArgumentException("'position' - unexpected value: '" + s + "'. Valid values: left|right|top|bottom|both.");
            }
        }
        return axisPosition;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006J5\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u0004\b\u0001\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\u00042\u0006\u0010\f\u001a\u0002H\n2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/ScaleConfig$Companion;", "", "()V", "aesOrFail", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "options", "", "", "createIdentityMapperProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/MapperProvider;", "T", "aes", "naValue", "aopConversion", "Lorg/jetbrains/letsPlot/core/spec/conversion/AesOptionConversion;", "(Lorg/jetbrains/letsPlot/core/plot/base/Aes;Ljava/lang/Object;Lorg/jetbrains/letsPlot/core/spec/conversion/AesOptionConversion;)Lorg/jetbrains/letsPlot/core/plot/builder/scale/MapperProvider;", "plot-stem"})
    @SourceDebugExtension(value={"SMAP\nScaleConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScaleConfig.kt\norg/jetbrains/letsPlot/core/spec/config/ScaleConfig$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,358:1\n1#2:359\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Aes<?> aesOrFail(@NotNull Map<String, ? extends Object> options) {
            Intrinsics.checkNotNullParameter(options, (String)"options");
            OptionsAccessor accessor = new OptionsAccessor(options, null, 2, null);
            if (!accessor.has("aesthetic")) {
                boolean bl = false;
                String string = "Required parameter 'aesthetic' is missing";
                throw new IllegalArgumentException(string.toString());
            }
            return Option.Mapping.INSTANCE.toAes(accessor.getStringSafe("aesthetic"));
        }

        @NotNull
        public final <T> MapperProvider<T> createIdentityMapperProvider(@NotNull Aes<T> aes, T naValue, @NotNull AesOptionConversion aopConversion) {
            Intrinsics.checkNotNullParameter(aes, (String)"aes");
            Intrinsics.checkNotNullParameter((Object)aopConversion, (String)"aopConversion");
            IdentityDiscreteMapperProvider discreteMapperProvider = new IdentityDiscreteMapperProvider(aopConversion.getConverter(aes));
            if (TypedContinuousIdentityMappers.INSTANCE.contain(aes)) {
                ScaleMapper<T> continuousMapper = TypedContinuousIdentityMappers.INSTANCE.get(aes);
                return (MapperProvider)new IdentityMapperProvider(discreteMapperProvider, ScaleMapper.Companion.wrap(continuousMapper, naValue));
            }
            return (MapperProvider)discreteMapperProvider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

