/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.datetime.TimeZone;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.commons.data.DataType;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.GeomMeta;
import org.jetbrains.letsPlot.core.plot.base.Stat;
import org.jetbrains.letsPlot.core.plot.base.data.DataFrameUtil;
import org.jetbrains.letsPlot.core.plot.base.util.YOrientationBaseUtil;
import org.jetbrains.letsPlot.core.plot.base.util.YOrientationBaseUtilKt;
import org.jetbrains.letsPlot.core.plot.builder.MarginSide;
import org.jetbrains.letsPlot.core.plot.builder.VarBinding;
import org.jetbrains.letsPlot.core.plot.builder.annotation.AnnotationSpecification;
import org.jetbrains.letsPlot.core.plot.builder.assemble.CustomLegendOptions;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PosProvider;
import org.jetbrains.letsPlot.core.plot.builder.data.OrderOptionUtil;
import org.jetbrains.letsPlot.core.plot.builder.sampling.Sampling;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.TooltipSpecification;
import org.jetbrains.letsPlot.core.spec.GeomProto;
import org.jetbrains.letsPlot.core.spec.Option;
import org.jetbrains.letsPlot.core.spec.PosProto;
import org.jetbrains.letsPlot.core.spec.StatKind;
import org.jetbrains.letsPlot.core.spec.StatProto;
import org.jetbrains.letsPlot.core.spec.config.AnnotationConfig;
import org.jetbrains.letsPlot.core.spec.config.ConfigUtil;
import org.jetbrains.letsPlot.core.spec.config.DataConfigUtil;
import org.jetbrains.letsPlot.core.spec.config.DataMetaUtil;
import org.jetbrains.letsPlot.core.spec.config.LayerConfig;
import org.jetbrains.letsPlot.core.spec.config.LayerConfigUtil;
import org.jetbrains.letsPlot.core.spec.config.OptionsAccessor;
import org.jetbrains.letsPlot.core.spec.config.SamplingConfig;
import org.jetbrains.letsPlot.core.spec.config.TooltipConfig;
import org.jetbrains.letsPlot.core.spec.conversion.AesOptionConversion;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u0080\u00012\u00020\u0001:\u0002\u0080\u0001B}\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J\u001c\u0010l\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0018\u00010mJ.\u0010n\u001a\b\u0012\u0004\u0012\u00020&0%2\f\u0010o\u001a\b\u0012\u0004\u0012\u00020&0%2\u0010\u00108\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030%0\u000bH\u0002J\u0014\u0010p\u001a\u0004\u0018\u00010q2\n\u0010o\u001a\u0006\u0012\u0002\b\u00030%J\u0006\u0010r\u001a\u00020\u0012J\u000e\u0010s\u001a\u00020\u00122\u0006\u0010t\u001a\u00020\u0004J\"\u0010u\u001a\u0004\u0018\u00010\u00042\u0006\u0010v\u001a\u00020\u00072\u000e\u0010w\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003H\u0002JL\u0010x\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\u0012\u0010y\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\u0012\u0010z\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u000e\u0010{\u001a\u00020\u00122\u0006\u0010t\u001a\u00020\u0004J\u0010\u0010|\u001a\u00020}2\b\u0010~\u001a\u0004\u0018\u00010\u0007J\b\u0010\u007f\u001a\u00020}H\u0002R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0019\u001a\u0018\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R \u0010*\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00078F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010.\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030%\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0013\u00101\u001a\u0004\u0018\u0001028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u001d\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00100R\u0018\u00108\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030%0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u00109\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0017\u0010<\u001a\b\u0012\u0004\u0012\u00020&0%\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010(R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0011\u0010@\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0011\u0010B\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010AR\u0011\u0010C\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010AR\u0011\u0010D\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010AR\u0013\u0010E\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010;R\u0011\u0010G\u001a\u00020H\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010JR\u0011\u0010K\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010MR*\u0010N\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010PR\u001e\u0010Q\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010,R\u0011\u0010S\u001a\u00020T\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010VR\u001b\u0010W\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030%0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010PR\u0017\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00180\u000b8F\u00a2\u0006\u0006\u001a\u0004\bZ\u0010PR\u0011\u0010[\u001a\u00020\\\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010^R\u0011\u0010_\u001a\u00020`\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u0010bR\u0011\u0010c\u001a\u00020d\u00a2\u0006\b\n\u0000\u001a\u0004\be\u0010fR\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\bg\u0010hR\u0017\u0010i\u001a\b\u0012\u0004\u0012\u00020j0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\bk\u0010P\u00a8\u0006\u0081\u0001"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/LayerConfig;", "Lorg/jetbrains/letsPlot/core/spec/config/OptionsAccessor;", "layerOptions", "", "", "", "plotData", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "plotMappings", "plotDataMeta", "plotOrderOptions", "", "Lorg/jetbrains/letsPlot/core/plot/builder/data/OrderOptionUtil$OrderOption;", "geomProto", "Lorg/jetbrains/letsPlot/core/spec/GeomProto;", "aopConversion", "Lorg/jetbrains/letsPlot/core/spec/conversion/AesOptionConversion;", "clientSide", "", "isMapPlot", "tz", "Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;", "(Ljava/util/Map;Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;Ljava/util/Map;Ljava/util/Map;Ljava/util/List;Lorg/jetbrains/letsPlot/core/spec/GeomProto;Lorg/jetbrains/letsPlot/core/spec/conversion/AesOptionConversion;ZZLorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;)V", "_samplings", "Lorg/jetbrains/letsPlot/core/plot/builder/sampling/Sampling;", "aggregateOperation", "Lkotlin/Function1;", "", "getAggregateOperation$plot_stem", "()Lkotlin/jvm/functions/Function1;", "annotations", "Lorg/jetbrains/letsPlot/core/plot/builder/annotation/AnnotationSpecification;", "getAnnotations", "()Lorg/jetbrains/letsPlot/core/plot/builder/annotation/AnnotationSpecification;", "getAopConversion", "()Lorg/jetbrains/letsPlot/core/spec/conversion/AesOptionConversion;", "colorByAes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/commons/values/Color;", "getColorByAes", "()Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "<set-?>", "combinedData", "getCombinedData", "()Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "combinedDataValid", "constantsMap", "getConstantsMap", "()Ljava/util/Map;", "customLegendOptions", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/CustomLegendOptions;", "getCustomLegendOptions", "()Lorg/jetbrains/letsPlot/core/plot/builder/assemble/CustomLegendOptions;", "dtypesByVarName", "Lorg/jetbrains/letsPlot/core/commons/data/DataType;", "getDtypesByVarName", "explicitConstantAes", "explicitGroupingVarName", "getExplicitGroupingVarName", "()Ljava/lang/String;", "fillByAes", "getFillByAes", "getGeomProto", "()Lorg/jetbrains/letsPlot/core/spec/GeomProto;", "isLegendDisabled", "()Z", "isLiveMap", "isMarginal", "isYOrientation", "labelFormat", "getLabelFormat", "marginalSide", "Lorg/jetbrains/letsPlot/core/plot/builder/MarginSide;", "getMarginalSide", "()Lorg/jetbrains/letsPlot/core/plot/builder/MarginSide;", "marginalSize", "getMarginalSize", "()D", "orderOptions", "getOrderOptions", "()Ljava/util/List;", "ownData", "getOwnData$plot_stem", "posProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PosProvider;", "getPosProvider", "()Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PosProvider;", "renderedAes", "getRenderedAes", "samplings", "getSamplings", "stat", "Lorg/jetbrains/letsPlot/core/plot/base/Stat;", "getStat", "()Lorg/jetbrains/letsPlot/core/plot/base/Stat;", "statKind", "Lorg/jetbrains/letsPlot/core/spec/StatKind;", "getStatKind", "()Lorg/jetbrains/letsPlot/core/spec/StatKind;", "tooltips", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipSpecification;", "getTooltips", "()Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipSpecification;", "getTz", "()Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;", "varBindings", "Lorg/jetbrains/letsPlot/core/plot/builder/VarBinding;", "getVarBindings", "getMapJoin", "Lkotlin/Pair;", "getPaintAes", "aes", "getVariableForAes", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "hasExplicitGrouping", "hasVarBinding", "varName", "initGroupingVarName", "data", "mappingOptions", "initYOrientation", "layerMappings", "combinedDiscreteMappings", "isExplicitGrouping", "replaceOwnData", "", "dataFrame", "setOrientationY", "Companion", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nLayerConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayerConfig.kt\norg/jetbrains/letsPlot/core/spec/config/LayerConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,615:1\n766#2:616\n857#2,2:617\n1549#2:619\n1620#2,3:620\n1238#2,4:625\n1179#2,2:636\n1253#2,2:638\n1256#2:641\n766#2:642\n857#2,2:643\n766#2:645\n857#2,2:646\n1747#2,3:648\n1549#2:651\n1620#2,3:652\n1747#2,3:655\n453#3:623\n403#3:624\n478#3,7:629\n1#4:640\n*S KotlinDebug\n*F\n+ 1 LayerConfig.kt\norg/jetbrains/letsPlot/core/spec/config/LayerConfig\n*L\n80#1:616\n80#1:617,2\n81#1:619\n81#1:620,3\n187#1:625,4\n237#1:636,2\n237#1:638,2\n237#1:641\n268#1:642\n268#1:643,2\n278#1:645\n278#1:646,2\n338#1:648,3\n342#1:651\n342#1:652,3\n344#1:655,3\n187#1:623\n187#1:624\n207#1:629,7\n*E\n"})
public final class LayerConfig
extends OptionsAccessor {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final GeomProto geomProto;
    @NotNull
    private final AesOptionConversion aopConversion;
    private final boolean clientSide;
    @Nullable
    private final TimeZone tz;
    @NotNull
    private final Map<String, DataType> dtypesByVarName;
    @NotNull
    private final StatKind statKind;
    @NotNull
    private final Stat stat;
    @Nullable
    private final String labelFormat;
    @NotNull
    private final PosProvider posProvider;
    private final boolean isLiveMap;
    @NotNull
    private final List<Aes<?>> explicitConstantAes;
    @NotNull
    private final Aes<Color> colorByAes;
    @NotNull
    private final Aes<Color> fillByAes;
    @NotNull
    private final List<Aes<?>> renderedAes;
    @NotNull
    private final List<Sampling> _samplings;
    private final boolean isYOrientation;
    private final boolean isMarginal;
    @NotNull
    private final MarginSide marginalSide;
    private final double marginalSize;
    @NotNull
    private final Function1<List<Double>, Double> aggregateOperation;
    @NotNull
    private List<OrderOptionUtil.OrderOption> orderOptions;
    @Nullable
    private final String explicitGroupingVarName;
    @NotNull
    private final List<VarBinding> varBindings;
    @NotNull
    private final Map<Aes<?>, Object> constantsMap;
    @NotNull
    private final TooltipSpecification tooltips;
    @NotNull
    private final AnnotationSpecification annotations;
    @NotNull
    private DataFrame ownData;
    private boolean combinedDataValid;
    @NotNull
    private DataFrame combinedData;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LayerConfig(@NotNull Map<String, ? extends Object> layerOptions, @NotNull DataFrame plotData, @NotNull Map<String, String> plotMappings, @NotNull Map<?, ?> plotDataMeta, @NotNull List<OrderOptionUtil.OrderOption> plotOrderOptions, @NotNull GeomProto geomProto, @NotNull AesOptionConversion aopConversion, boolean clientSide, boolean isMapPlot, @Nullable TimeZone tz) {
        AnnotationSpecification annotationSpecification;
        TooltipSpecification tooltipSpecification;
        List list;
        VarBinding it;
        Iterable $this$filter$iv;
        Map map2;
        Iterable $this$associate$iv;
        Set set;
        Object object;
        void $this$mapValuesTo$iv$iv;
        MarginSide marginSide;
        Object object2;
        Object destination$iv$iv;
        Object object3;
        block29: {
            block26: {
                String side;
                block27: {
                    block28: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv2;
                        Intrinsics.checkNotNullParameter(layerOptions, (String)"layerOptions");
                        Intrinsics.checkNotNullParameter((Object)plotData, (String)"plotData");
                        Intrinsics.checkNotNullParameter((Object)plotMappings, (String)"plotMappings");
                        Intrinsics.checkNotNullParameter(plotDataMeta, (String)"plotDataMeta");
                        Intrinsics.checkNotNullParameter(plotOrderOptions, (String)"plotOrderOptions");
                        Intrinsics.checkNotNullParameter((Object)geomProto, (String)"geomProto");
                        Intrinsics.checkNotNullParameter((Object)aopConversion, (String)"aopConversion");
                        super(layerOptions, LayerConfig.Companion.initLayerDefaultOptions(layerOptions, geomProto));
                        this.geomProto = geomProto;
                        this.aopConversion = aopConversion;
                        this.clientSide = clientSide;
                        this.tz = tz;
                        this.statKind = StatKind.Companion.safeValueOf(this.getStringSafe("stat"));
                        this.stat = StatProto.INSTANCE.createStat$plot_stem(this.statKind, this);
                        this.labelFormat = this.getString("label_format");
                        this.posProvider = PosProto.INSTANCE.createPosProvider(LayerConfigUtil.INSTANCE.positionAdjustmentOptions(this, this.geomProto));
                        this.isLiveMap = this.geomProto.getGeomKind() == GeomKind.LIVE_MAP;
                        Iterable<String> iterable = Option.Mapping.INSTANCE.getREAL_AES_OPTION_NAMES();
                        object3 = this;
                        boolean $i$f$filter22 = false;
                        void var13_15 = $this$filter$iv2;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            String p0 = (String)element$iv$iv;
                            boolean bl = false;
                            if (!this.hasOwn(p0)) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        $this$filter$iv2 = (List)destination$iv$iv2;
                        Option.Mapping $i$f$filter22 = Option.Mapping.INSTANCE;
                        boolean $i$f$map = false;
                        destination$iv$iv2 = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void p0;
                            String bl = (String)item$iv$iv;
                            object2 = destination$iv$iv;
                            boolean bl2 = false;
                            object2.add($i$f$filter22.toAes((String)p0));
                        }
                        ((LayerConfig)object3).explicitConstantAes = (List)destination$iv$iv;
                        this.colorByAes = this.getPaintAes((Aes<Color>)Aes.Companion.getCOLOR(), this.explicitConstantAes);
                        this.fillByAes = this.getPaintAes((Aes<Color>)Aes.Companion.getFILL(), this.explicitConstantAes);
                        this.renderedAes = GeomMeta.INSTANCE.renders(this.geomProto.getGeomKind(), this.colorByAes, this.fillByAes);
                        this._samplings = this.clientSide ? CollectionsKt.emptyList() : LayerConfig.Companion.initSampling(this, this.geomProto.getGeomKind(), this.geomProto.preferredSampling());
                        this.isMarginal = this.getBoolean("marginal", false);
                        if (!this.isMarginal) break block26;
                        String string = this.getStringSafe("margin_side").toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                        side = string;
                        switch (side.hashCode()) {
                            case 114: {
                                if (side.equals("r")) break;
                                throw new IllegalArgumentException("margin_side expected l|r|t|b but was '" + side + '\'');
                            }
                            case 98: {
                                if (!side.equals("b")) {
                                    throw new IllegalArgumentException("margin_side expected l|r|t|b but was '" + side + '\'');
                                }
                                break block27;
                            }
                            case 116: {
                                if (!side.equals("t")) {
                                    throw new IllegalArgumentException("margin_side expected l|r|t|b but was '" + side + '\'');
                                }
                                break block28;
                            }
                            case 108: {
                                if (!side.equals("l")) throw new IllegalArgumentException("margin_side expected l|r|t|b but was '" + side + '\'');
                                marginSide = MarginSide.LEFT;
                                break block29;
                            }
                        }
                        marginSide = MarginSide.RIGHT;
                        break block29;
                    }
                    marginSide = MarginSide.TOP;
                    break block29;
                }
                marginSide = MarginSide.BOTTOM;
                break block29;
                throw new IllegalArgumentException("margin_side expected l|r|t|b but was '" + side + '\'');
            }
            marginSide = MarginSide.LEFT;
        }
        this.marginalSide = marginSide;
        this.marginalSize = this.getDoubleDef("margin_size", 0.1);
        this.aggregateOperation = Intrinsics.areEqual((Object)this.getString("position"), (Object)"stack") ? (Function1)new Function1<List<? extends Double>, Double>((Object)SeriesUtil.INSTANCE){

            @NotNull
            public final Double invoke(@NotNull List<Double> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return ((SeriesUtil)this.receiver).sum(p0);
            }
        } : (Function1)aggregateOperation.2.INSTANCE;
        this.combinedDataValid = true;
        this.ownData = ConfigUtil.INSTANCE.createDataFrame$plot_stem(this.get("data"));
        Map plotMappings2 = this.getBoolean("inherit_aes", true) ? plotMappings : MapsKt.emptyMap();
        Map<String, Object> $this$mapValues$iv = this.getMap("mapping");
        boolean $i$f$mapValues = false;
        destination$iv$iv = $this$mapValues$iv;
        Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv22 = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv22) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv3;
            boolean bl6 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object2 = it$iv$iv.getKey();
            object3 = map3;
            boolean bl3 = false;
            Object variable = entry2.getValue();
            Intrinsics.checkNotNull(variable, (String)"null cannot be cast to non-null type kotlin.String");
            object = (String)variable;
            object3.put(object2, object);
        }
        Map layerMappings = destination$iv$iv3;
        Map<String, String> combinedDiscreteMappings = DataConfigUtil.INSTANCE.combinedDiscreteMapping(plotMappings2, layerMappings, DataMetaUtil.INSTANCE.getAsDiscreteAesSet(plotDataMeta), DataMetaUtil.INSTANCE.getAsDiscreteAesSet(this.getMap("data_meta")));
        this.isYOrientation = this.initYOrientation(plotData, plotMappings2, layerMappings, combinedDiscreteMappings);
        Set it2 = CollectionsKt.toSet((Iterable)this.renderedAes);
        boolean bl = false;
        boolean $this$associateByTo$iv$iv$iv22 = this.clientSide;
        if ($this$associateByTo$iv$iv$iv22) {
            set = it2;
        } else {
            if ($this$associateByTo$iv$iv$iv22) throw new NoWhenBranchMatchedException();
            set = SetsKt.plus((Set)it2, (Iterable)this.stat.consumes());
        }
        Set consumedAesSet = YOrientationBaseUtilKt.afterOrientation((Set)set, (boolean)this.isYOrientation);
        Map $this$filterKeys$iv = MapsKt.plus((Map)plotMappings2, (Map)layerMappings);
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            boolean bl4;
            String aesName = (String)entry$iv.getKey();
            boolean bl5 = false;
            if (Intrinsics.areEqual((Object)aesName, (Object)"group")) {
                bl4 = true;
            } else {
                Aes<?> aes = Option.Mapping.INSTANCE.toAes(aesName);
                bl4 = consumedAesSet.contains(aes);
            }
            if (!bl4) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map consumedAesMappings = result$iv;
        Pair<Map<Aes<?>, DataFrame.Variable>, DataFrame> pair = DataConfigUtil.INSTANCE.layerMappingsAndCombinedData(layerOptions, this.geomProto.getGeomKind(), this.stat, plotData, this.ownData, combinedDiscreteMappings, consumedAesMappings, this.explicitConstantAes, this.isYOrientation, this.clientSide, isMapPlot);
        Map aesMappings = (Map)pair.component1();
        DataFrame rawCombinedData = (DataFrame)pair.component2();
        Map baseDTypes = MapsKt.plus(DataMetaUtil.INSTANCE.getDTypesByVarName(plotDataMeta), DataMetaUtil.INSTANCE.getDTypesByVarName(this.getMap("data_meta")));
        if (this.clientSide) {
            void $this$associateTo$iv$iv;
            $this$associate$iv = combinedDiscreteMappings.entrySet();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable bl6 = $this$associate$iv;
            Map destination$iv$iv4 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map4 = destination$iv$iv4;
                Map.Entry entry = (Map.Entry)element$iv$iv;
                boolean bl7 = false;
                String aes = (String)entry.getKey();
                String varName = (String)entry.getValue();
                String string = DataMetaUtil.INSTANCE.asDiscreteName$plot_stem(aes, varName);
                Object object4 = baseDTypes.get(varName);
                if (object4 == null) {
                    String string2 = string;
                    boolean bl8 = false;
                    object4 = DataType.UNKNOWN;
                    string = string2;
                }
                entry = TuplesKt.to((Object)string, object4);
                map4.put(entry.getFirst(), entry.getSecond());
            }
            map2 = destination$iv$iv4;
        } else {
            map2 = MapsKt.emptyMap();
        }
        Map discreteVarsDTypes = map2;
        this.dtypesByVarName = MapsKt.plus((Map)baseDTypes, (Map)discreteVarsDTypes);
        this.constantsMap = LayerConfigUtil.INSTANCE.initConstants(this, SetsKt.minus((Set)consumedAesSet, (Iterable)aesMappings.keySet()), this.aopConversion);
        this.explicitGroupingVarName = this.initGroupingVarName(rawCombinedData, consumedAesMappings);
        this.varBindings = LayerConfigUtil.INSTANCE.createBindings(rawCombinedData, aesMappings, consumedAesSet, this.clientSide);
        Object object5 = this;
        if (this.has("tooltips")) {
            void $this$filterTo$iv$iv;
            $this$associate$iv = this.varBindings;
            object = this.getSafe("tooltips");
            object2 = Companion;
            object3 = object5;
            boolean $i$f$filter = false;
            void capacity$iv = $this$filter$iv;
            Collection destination$iv$iv5 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (VarBinding)element$iv$iv;
                boolean bl9 = false;
                if (!this.renderedAes.contains(it.getAes())) continue;
                destination$iv$iv5.add(element$iv$iv);
            }
            list = (List)destination$iv$iv5;
            object5 = object3;
            tooltipSpecification = ((Companion)object2).initTooltipsSpec(object, list, this.constantsMap, this.explicitGroupingVarName);
        } else {
            tooltipSpecification = TooltipSpecification.Companion.defaultTooltip();
        }
        ((LayerConfig)object5).tooltips = tooltipSpecification;
        Object object6 = this;
        if (this.has("labels")) {
            $this$filter$iv = this.varBindings;
            object = this.getSafe("labels");
            object2 = Companion;
            object3 = object6;
            boolean $i$f$filter = false;
            Iterable $this$filterTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv6 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (VarBinding)element$iv$iv;
                boolean bl10 = false;
                if (!this.renderedAes.contains(it.getAes())) continue;
                destination$iv$iv6.add(element$iv$iv);
            }
            list = (List)destination$iv$iv6;
            object6 = object3;
            annotationSpecification = ((Companion)object2).initAnnotationSpec(object, list, this.constantsMap, this.explicitGroupingVarName);
        } else {
            annotationSpecification = AnnotationSpecification.Companion.getNONE();
        }
        ((LayerConfig)object6).annotations = annotationSpecification;
        this.orderOptions = LayerConfig.Companion.initOrderOptions(plotOrderOptions, layerOptions, this.varBindings, consumedAesMappings, this.clientSide);
        this.combinedData = DataConfigUtil.INSTANCE.combinedDataWithDataMeta(rawCombinedData, this.varBindings, plotDataMeta, this.getMap("data_meta"), combinedDiscreteMappings.keySet(), this.orderOptions, this.aggregateOperation, this.clientSide);
    }

    @NotNull
    public final GeomProto getGeomProto() {
        return this.geomProto;
    }

    @NotNull
    public final AesOptionConversion getAopConversion() {
        return this.aopConversion;
    }

    @Nullable
    public final TimeZone getTz() {
        return this.tz;
    }

    @NotNull
    public final Map<String, DataType> getDtypesByVarName() {
        return this.dtypesByVarName;
    }

    @NotNull
    public final StatKind getStatKind() {
        return this.statKind;
    }

    @NotNull
    public final Stat getStat() {
        return this.stat;
    }

    @Nullable
    public final String getLabelFormat() {
        return this.labelFormat;
    }

    @NotNull
    public final PosProvider getPosProvider() {
        return this.posProvider;
    }

    public final boolean isLiveMap() {
        return this.isLiveMap;
    }

    @NotNull
    public final Aes<Color> getColorByAes() {
        return this.colorByAes;
    }

    @NotNull
    public final Aes<Color> getFillByAes() {
        return this.fillByAes;
    }

    @NotNull
    public final List<Aes<?>> getRenderedAes() {
        return this.renderedAes;
    }

    public final boolean isLegendDisabled() {
        return this.hasOwn("show_legend") ? !this.getBoolean("show_legend", true) : false;
    }

    @Nullable
    public final CustomLegendOptions getCustomLegendOptions() {
        Map map2;
        Object object = this.get("manual_key");
        if (object == null) {
            return null;
        }
        Object option = object;
        Object object2 = option;
        if (object2 instanceof Map) {
            map2 = (Map)option;
        } else if (object2 instanceof String) {
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"label", (Object)option));
        } else {
            throw new IllegalArgumentException("manual_key expected a string or option map, but was '" + option + '\'');
        }
        Map p0 = map2;
        boolean bl = false;
        OptionsAccessor legendOptions = new OptionsAccessor(p0, null, 2, null);
        String string = legendOptions.getString("label");
        if (string == null) {
            return null;
        }
        String label = string;
        Map<Aes<?>, Object> aesValues = LayerConfigUtil.INSTANCE.initConstants(legendOptions, CollectionsKt.toSet((Iterable)Aes.Companion.values()), this.aopConversion);
        String name = legendOptions.getString("group");
        boolean bl2 = false;
        String groupName = name == null || Intrinsics.areEqual((Object)name, (Object)"manual") ? "" : name;
        return new CustomLegendOptions(label, groupName, legendOptions.getInteger("index"), aesValues);
    }

    @NotNull
    public final List<Sampling> getSamplings() {
        if (!(!this.clientSide)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this._samplings;
    }

    public final boolean isYOrientation() {
        return this.isYOrientation;
    }

    public final boolean isMarginal() {
        return this.isMarginal;
    }

    @NotNull
    public final MarginSide getMarginalSide() {
        return this.marginalSide;
    }

    public final double getMarginalSize() {
        return this.marginalSize;
    }

    @NotNull
    public final Function1<List<Double>, Double> getAggregateOperation$plot_stem() {
        return this.aggregateOperation;
    }

    @NotNull
    public final List<OrderOptionUtil.OrderOption> getOrderOptions() {
        return this.orderOptions;
    }

    @Nullable
    public final String getExplicitGroupingVarName() {
        return this.explicitGroupingVarName;
    }

    @NotNull
    public final List<VarBinding> getVarBindings() {
        return this.varBindings;
    }

    @NotNull
    public final Map<Aes<?>, Object> getConstantsMap() {
        return this.constantsMap;
    }

    @NotNull
    public final TooltipSpecification getTooltips() {
        return this.tooltips;
    }

    @NotNull
    public final AnnotationSpecification getAnnotations() {
        return this.annotations;
    }

    @NotNull
    public final DataFrame getOwnData$plot_stem() {
        return this.ownData;
    }

    @NotNull
    public final DataFrame getCombinedData() {
        if (!this.combinedDataValid) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.combinedData;
    }

    private final boolean initYOrientation(DataFrame plotData, Map<String, String> plotMappings, Map<String, String> layerMappings, Map<String, String> combinedDiscreteMappings) {
        boolean isYOriented;
        boolean bl;
        Object object;
        String string;
        if (this.hasOwn("orientation") && (string = this.getString("orientation")) != null) {
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            object = string2;
            if (object != null) {
                boolean bl2;
                Object it = object;
                boolean bl3 = false;
                Object object2 = it;
                if (Intrinsics.areEqual((Object)object2, (Object)"y")) {
                    bl2 = true;
                } else if (Intrinsics.areEqual((Object)object2, (Object)"x")) {
                    bl2 = false;
                } else {
                    throw new IllegalArgumentException("orientation expected x|y but was " + (String)it);
                }
                return bl2;
            }
        }
        if (this.clientSide) {
            return false;
        }
        object = new StatKind[]{StatKind.COUNT, StatKind.SUMMARY, StatKind.BOXPLOT, StatKind.BOXPLOT_OUTLIER, StatKind.YDOTPLOT, StatKind.YDENSITY};
        if (CollectionsKt.listOf((Object[])object).contains((Object)this.statKind)) {
            bl = !LayerConfig.initYOrientation$isAesDiscrete(plotData, this, plotMappings, layerMappings, combinedDiscreteMappings, Aes.Companion.getX()) && LayerConfig.initYOrientation$isAesDiscrete(plotData, this, plotMappings, layerMappings, combinedDiscreteMappings, Aes.Companion.getY());
        } else {
            object = new GeomKind[]{GeomKind.BAR, GeomKind.VIOLIN, GeomKind.SINA, GeomKind.LOLLIPOP, GeomKind.Y_DOT_PLOT};
            if (CollectionsKt.listOf((Object[])object).contains(this.geomProto.getGeomKind())) {
                bl = !LayerConfig.initYOrientation$isAesDiscrete(plotData, this, plotMappings, layerMappings, combinedDiscreteMappings, Aes.Companion.getX()) && LayerConfig.initYOrientation$isAesDiscrete(plotData, this, plotMappings, layerMappings, combinedDiscreteMappings, Aes.Companion.getY());
            } else if (this.geomProto.getGeomKind() == GeomKind.BOX_PLOT) {
                object = new Aes[]{Aes.Companion.getYMIN(), Aes.Companion.getLOWER(), Aes.Companion.getMIDDLE(), Aes.Companion.getUPPER(), Aes.Companion.getYMAX()};
                bl = LayerConfig.initYOrientation$isYOrientedByAes(plotMappings, layerMappings, this, SetsKt.setOf((Object[])object));
            } else {
                object = new GeomKind[]{GeomKind.CROSS_BAR, GeomKind.ERROR_BAR, GeomKind.LINE_RANGE, GeomKind.POINT_RANGE, GeomKind.RIBBON};
                if (CollectionsKt.listOf((Object[])object).contains(this.geomProto.getGeomKind())) {
                    object = new Aes[]{Aes.Companion.getYMIN(), Aes.Companion.getYMAX()};
                    bl = LayerConfig.initYOrientation$isYOrientedByAes(plotMappings, layerMappings, this, SetsKt.setOf((Object[])object));
                } else {
                    bl = isYOriented = false;
                }
            }
        }
        if (isYOriented) {
            this.setOrientationY();
        }
        return isYOriented;
    }

    private final String initGroupingVarName(DataFrame data2, Map<?, ?> mappingOptions) {
        DataFrame.Variable groupVar;
        String fieldName;
        Object groupBy2 = mappingOptions.get("group");
        String string = fieldName = groupBy2 instanceof String ? (String)groupBy2 : null;
        if (fieldName == null && this.has("map") && (groupVar = (DataFrame.Variable)DataFrameUtil.INSTANCE.variables(data2).get("group")) != null) {
            fieldName = groupVar.getName();
        }
        return fieldName;
    }

    public final boolean hasVarBinding(@NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        for (VarBinding binding : this.varBindings) {
            if (!Intrinsics.areEqual((Object)binding.getVariable().getName(), (Object)varName)) continue;
            return true;
        }
        return false;
    }

    public final void replaceOwnData(@Nullable DataFrame dataFrame) {
        if (!(!this.clientSide)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(dataFrame != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.update("data", DataFrameUtil.INSTANCE.toMap(dataFrame));
        this.ownData = dataFrame;
        this.combinedDataValid = false;
    }

    private final void setOrientationY() {
        if (!(!this.clientSide)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.update("orientation", "y");
    }

    public final boolean hasExplicitGrouping() {
        return this.explicitGroupingVarName != null;
    }

    public final boolean isExplicitGrouping(@NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        return this.explicitGroupingVarName != null && Intrinsics.areEqual((Object)this.explicitGroupingVarName, (Object)varName);
    }

    @Nullable
    public final DataFrame.Variable getVariableForAes(@NotNull Aes<?> aes) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(aes, (String)"aes");
            Iterable iterable = this.varBindings;
            for (Object t : iterable) {
                VarBinding it = (VarBinding)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getAes(), aes)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        VarBinding varBinding = v0;
        return varBinding != null ? varBinding.getVariable() : null;
    }

    @Nullable
    public final Pair<List<?>, List<?>> getMapJoin() {
        if (!this.hasOwn("map_join")) {
            return null;
        }
        List<?> mapJoin = this.getList("map_join");
        if (!(mapJoin.size() == 2)) {
            boolean $i$a$-require-LayerConfig$getMapJoin$42 = false;
            String $i$a$-require-LayerConfig$getMapJoin$42 = "map_join require 2 parameters";
            throw new IllegalArgumentException($i$a$-require-LayerConfig$getMapJoin$42.toString());
        }
        Object dataVar = mapJoin.get(0);
        Object mapVar = mapJoin.get(1);
        if (!(dataVar != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(mapVar != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(dataVar instanceof List)) {
            boolean $i$a$-require-LayerConfig$getMapJoin$52 = false;
            String $i$a$-require-LayerConfig$getMapJoin$52 = "Wrong map_join parameter type: should be a list of strings, but was " + Reflection.getOrCreateKotlinClass(dataVar.getClass()).getSimpleName();
            throw new IllegalArgumentException($i$a$-require-LayerConfig$getMapJoin$52.toString());
        }
        if (!(mapVar instanceof List)) {
            boolean bl = false;
            String string = "Wrong map_join parameter type: should be a list of string, but was " + Reflection.getOrCreateKotlinClass(mapVar.getClass()).getSimpleName();
            throw new IllegalArgumentException(string.toString());
        }
        return new Pair(dataVar, mapVar);
    }

    private final Aes<Color> getPaintAes(Aes<Color> aes, List<? extends Aes<?>> explicitConstantAes) {
        Object object;
        Aes<Color> aes2 = aes;
        if (explicitConstantAes.contains(aes2)) {
            object = aes;
        } else {
            Aes<?> colorBy;
            Aes<?> aes3;
            Aes<Color> aes4 = aes;
            String optionName = Intrinsics.areEqual(aes4, (Object)Aes.Companion.getCOLOR()) ? "color_by" : (Intrinsics.areEqual(aes4, (Object)Aes.Companion.getFILL()) ? "fill_by" : aes.getName());
            String string = this.getString(optionName);
            if (string != null) {
                String aesName = string;
                boolean bl = false;
                Aes<?> aesByName = Option.Mapping.INSTANCE.toAes(aesName);
                if (!Aes.Companion.isColor(aesByName)) {
                    boolean bl2 = false;
                    String string2 = '\'' + optionName + "' should be an aesthetic related to color";
                    throw new IllegalArgumentException(string2.toString());
                }
                Intrinsics.checkNotNull(aesByName, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.Aes<org.jetbrains.letsPlot.commons.values.Color>");
                aes3 = aesByName;
            } else {
                aes3 = null;
            }
            Aes<?> aes5 = colorBy = aes3;
            object = aes5 == null ? aes : (explicitConstantAes.contains(aes5) ? aes : colorBy);
        }
        return object;
    }

    private static final boolean initYOrientation$isAesDiscrete(DataFrame $plotData, LayerConfig this$0, Map<String, String> $plotMappings, Map<String, String> $layerMappings, Map<String, String> $combinedDiscreteMappings, Aes<?> aes) {
        return DataConfigUtil.INSTANCE.isAesDiscrete(aes, $plotData, this$0.ownData, $plotMappings, $layerMappings, $combinedDiscreteMappings);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean initYOrientation$isYOrientedByAes(Map<String, String> $plotMappings, Map<String, String> $layerMappings, LayerConfig this$0, Set<? extends Aes<?>> verticalAesthetics) {
        boolean hasHorizontalAesthetics;
        block9: {
            boolean bl;
            void $this$mapTo$iv$iv;
            boolean hasVerticalAesthetics;
            Object element$iv2;
            Map combinedMappings;
            block8: {
                boolean bl2;
                combinedMappings = MapsKt.plus($plotMappings, $layerMappings);
                Iterable $this$any$iv = verticalAesthetics;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        Aes aes = (Aes)element$iv2;
                        boolean bl3 = false;
                        if (!(combinedMappings.containsKey(Option.Mapping.INSTANCE.toOption(aes)) || this$0.explicitConstantAes.contains(aes))) continue;
                        bl2 = true;
                        break block8;
                    }
                    bl2 = hasVerticalAesthetics = false;
                }
            }
            if (hasVerticalAesthetics) {
                return false;
            }
            Iterable $this$map$iv = verticalAesthetics;
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Aes aes = (Aes)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(YOrientationBaseUtil.INSTANCE.flipAes((Aes)it));
            }
            List horizontalAesthetics = (List)destination$iv$iv;
            Iterable $this$any$iv = horizontalAesthetics;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv3 : $this$any$iv) {
                    Aes aes = (Aes)element$iv3;
                    boolean bl5 = false;
                    if (!(combinedMappings.containsKey(Option.Mapping.INSTANCE.toOption(aes)) || this$0.explicitConstantAes.contains(aes))) continue;
                    bl = true;
                    break block9;
                }
                bl = hasHorizontalAesthetics = false;
            }
        }
        return hasHorizontalAesthetics;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0016\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J,\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\n2\u000e\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002JZ\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00072\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J@\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0016\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a8\u0006\""}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/LayerConfig$Companion;", "", "()V", "initAnnotationSpec", "Lorg/jetbrains/letsPlot/core/plot/builder/annotation/AnnotationSpecification;", "annotationOptions", "varBindings", "", "Lorg/jetbrains/letsPlot/core/plot/builder/VarBinding;", "constantsMap", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "explicitGroupingVarName", "", "initLayerDefaultOptions", "layerOptions", "geomProto", "Lorg/jetbrains/letsPlot/core/spec/GeomProto;", "initOrderOptions", "Lorg/jetbrains/letsPlot/core/plot/builder/data/OrderOptionUtil$OrderOption;", "plotOrderOptions", "combinedMappingOptions", "clientSide", "", "initSampling", "Lorg/jetbrains/letsPlot/core/plot/builder/sampling/Sampling;", "opts", "Lorg/jetbrains/letsPlot/core/spec/config/OptionsAccessor;", "geomKind", "Lorg/jetbrains/letsPlot/core/plot/base/GeomKind;", "defaultSampling", "initTooltipsSpec", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipSpecification;", "tooltipOptions", "plot-stem"})
    @SourceDebugExtension(value={"SMAP\nLayerConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayerConfig.kt\norg/jetbrains/letsPlot/core/spec/config/LayerConfig$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Grouping.kt\nkotlin/collections/GroupingKt__GroupingKt\n*L\n1#1,615:1\n1549#2:616\n1620#2,3:617\n766#2:620\n857#2,2:621\n1536#2:623\n211#3:624\n53#3:625\n80#3,4:626\n213#3:630\n85#3:631\n214#3:632\n*S KotlinDebug\n*F\n+ 1 LayerConfig.kt\norg/jetbrains/letsPlot/core/spec/config/LayerConfig$Companion\n*L\n588#1:616\n588#1:617,3\n591#1:620\n591#1:621,2\n604#1:623\n605#1:624\n605#1:625\n605#1:626,4\n605#1:630\n605#1:631\n605#1:632\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        private final Map<String, Object> initLayerDefaultOptions(Map<?, ?> layerOptions, GeomProto geomProto) {
            if (!(layerOptions.containsKey("geom") || layerOptions.containsKey("stat"))) {
                boolean $i$a$-require-LayerConfig$Companion$initLayerDefaultOptions$22 = false;
                String $i$a$-require-LayerConfig$Companion$initLayerDefaultOptions$22 = "Either 'geom' or 'stat' must be specified.";
                throw new IllegalArgumentException($i$a$-require-LayerConfig$Companion$initLayerDefaultOptions$22.toString());
            }
            HashMap<String, Object> defaults = new HashMap<String, Object>();
            defaults.putAll(geomProto.defaultOptions());
            String statName = (String)layerOptions.get("stat");
            if (statName == null) {
                Object v = defaults.get("stat");
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                statName = (String)v;
            }
            return MapsKt.plus((Map)defaults, StatProto.INSTANCE.defaultOptions$plot_stem(statName, geomProto.getGeomKind()));
        }

        private final List<Sampling> initSampling(OptionsAccessor opts, GeomKind geomKind, Sampling defaultSampling) {
            return opts.has("sampling") ? SamplingConfig.INSTANCE.create(opts.getSafe("sampling"), geomKind) : CollectionsKt.listOf((Object)defaultSampling);
        }

        private final TooltipSpecification initTooltipsSpec(Object tooltipOptions, List<VarBinding> varBindings, Map<Aes<?>, ? extends Object> constantsMap, String explicitGroupingVarName) {
            TooltipSpecification tooltipSpecification;
            Object object = tooltipOptions;
            if (object instanceof Map) {
                Intrinsics.checkNotNull((Object)tooltipOptions, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                tooltipSpecification = new TooltipConfig((Map<String, ? extends Object>)((Map)tooltipOptions), constantsMap, explicitGroupingVarName, varBindings).createTooltips();
            } else if (Intrinsics.areEqual((Object)object, (Object)"none")) {
                tooltipSpecification = TooltipSpecification.Companion.withoutTooltip();
            } else {
                throw new IllegalStateException("Incorrect tooltips specification".toString());
            }
            return tooltipSpecification;
        }

        private final AnnotationSpecification initAnnotationSpec(Object annotationOptions, List<VarBinding> varBindings, Map<Aes<?>, ? extends Object> constantsMap, String explicitGroupingVarName) {
            AnnotationSpecification annotationSpecification;
            Object object = annotationOptions;
            if (object instanceof Map) {
                Intrinsics.checkNotNull((Object)annotationOptions, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                annotationSpecification = new AnnotationConfig((Map<String, ? extends Object>)((Map)annotationOptions), varBindings, constantsMap, explicitGroupingVarName).createAnnotations();
            } else if (Intrinsics.areEqual((Object)object, (Object)"none")) {
                annotationSpecification = AnnotationSpecification.Companion.getNONE();
            } else {
                throw new IllegalStateException("Incorrect annotation specification".toString());
            }
            return annotationSpecification;
        }

        /*
         * WARNING - void declaration
         */
        private final List<OrderOptionUtil.OrderOption> initOrderOptions(List<OrderOptionUtil.OrderOption> plotOrderOptions, Map<String, ? extends Object> layerOptions, List<VarBinding> varBindings, Map<String, String> combinedMappingOptions, boolean clientSide) {
            List list;
            List orderOptions;
            void $this$filterTo$iv$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = varBindings;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VarBinding varBinding = (VarBinding)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getVariable().getName());
            }
            List mappedVariables = (List)destination$iv$iv;
            Iterable $this$filter$iv = plotOrderOptions;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                OrderOptionUtil.OrderOption orderOption = (OrderOptionUtil.OrderOption)element$iv$iv;
                boolean bl = false;
                if (!mappedVariables.contains(orderOption.getVariableName())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List plotOrderOptions2 = (List)destination$iv$iv2;
            List<OrderOptionUtil.OrderOption> ownOrderOptions = DataMetaUtil.INSTANCE.getOrderOptions(layerOptions, combinedMappingOptions, clientSide);
            List it = orderOptions = CollectionsKt.plus((Collection)plotOrderOptions2, (Iterable)ownOrderOptions);
            boolean bl = false;
            if (clientSide) {
                void destination$iv$iv$iv;
                void $this$aggregateTo$iv$iv$iv;
                void $this$reduce$iv;
                Iterable $this$groupingBy$iv = it;
                boolean $i$f$groupingBy = false;
                $this$groupingBy$iv = (Grouping)new Grouping<OrderOptionUtil.OrderOption, String>($this$groupingBy$iv){
                    final /* synthetic */ Iterable $this_groupingBy;
                    {
                        this.$this_groupingBy = $receiver;
                    }

                    @NotNull
                    public Iterator<OrderOptionUtil.OrderOption> sourceIterator() {
                        return this.$this_groupingBy.iterator();
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public Object keyOf(Object element) {
                        OrderOptionUtil.OrderOption p0 = (OrderOptionUtil.OrderOption)element;
                        boolean bl = false;
                        return p0.getVariableName();
                    }
                };
                boolean $i$f$reduce = false;
                void $this$aggregate$iv$iv = $this$reduce$iv;
                boolean $i$f$aggregate = false;
                void var17_26 = $this$aggregate$iv$iv;
                Map map2 = new LinkedHashMap();
                boolean $i$f$aggregateTo = false;
                Iterator iterator = $this$aggregateTo$iv$iv$iv.sourceIterator();
                while (iterator.hasNext()) {
                    OrderOptionUtil.OrderOption orderOption;
                    void e$iv;
                    void first$iv;
                    Object e$iv$iv$iv = iterator.next();
                    Object key$iv$iv$iv = $this$aggregateTo$iv$iv$iv.keyOf(e$iv$iv$iv);
                    Object accumulator$iv$iv$iv = destination$iv$iv$iv.get(key$iv$iv$iv);
                    boolean bl2 = accumulator$iv$iv$iv == null && !destination$iv$iv$iv.containsKey(key$iv$iv$iv);
                    Object e = e$iv$iv$iv;
                    Object v = accumulator$iv$iv$iv;
                    Object object = key$iv$iv$iv;
                    Object object2 = key$iv$iv$iv;
                    void var29_38 = destination$iv$iv$iv;
                    boolean bl3 = false;
                    if (first$iv != false) {
                        orderOption = e$iv;
                    } else {
                        void element;
                        void combined;
                        void key$iv;
                        void acc$iv;
                        OrderOptionUtil.OrderOption orderOption2 = (OrderOptionUtil.OrderOption)e$iv;
                        OrderOptionUtil.OrderOption orderOption3 = (OrderOptionUtil.OrderOption)acc$iv;
                        String cfr_ignored_0 = (String)key$iv;
                        boolean bl4 = false;
                        orderOption = OrderOptionUtil.OrderOption.Companion.mergeWith((OrderOptionUtil.OrderOption)combined, (OrderOptionUtil.OrderOption)element);
                    }
                    void var34_43 = orderOption;
                    var29_38.put(object2, var34_43);
                }
                list = CollectionsKt.toList((Iterable)destination$iv$iv$iv.values());
            } else {
                list = it;
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

