/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.spatial.GeoBoundingBoxCalculator;
import org.jetbrains.letsPlot.commons.intern.spatial.GeoBoundingBoxCalculatorKt;
import org.jetbrains.letsPlot.commons.intern.spatial.GeoJson;
import org.jetbrains.letsPlot.commons.intern.spatial.GeographicKt;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.spatial.SimpleFeature;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.LineString;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiLineString;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiPoint;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiPolygon;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Polygon;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.RectKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.spec.config.CoordinatesCollector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0006\b \u0018\u0000 -2\u00020\u0001:\u0005+,-./B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u001f\u001a\u00020\u0003J2\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u001d\u0010!\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0004\u0012\u00020#0\"\u00a2\u0006\u0002\b$H\u0000\u00a2\u0006\u0002\b%J0\u0010&\u001a\b\u0012\u0004\u0012\u0002H'0\u0017\"\u0004\b\u0000\u0010'2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0\u00172\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000f0*H\u0002R&\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000b0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0017X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R:\u0010\u001a\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u001b\"\u000e\b\u0001\u0010\u001c*\b\u0012\u0004\u0012\u00020\u00010\u0017*\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H\u001c0\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00060"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/CoordinatesCollector;", "", "dataFrame", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "geometries", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "mappings", "", "", "(Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;Ljava/util/Map;)V", "coordinates", "", "getCoordinates", "()Ljava/util/Map;", "dupCounter", "", "geoJsonConsumer", "Lorg/jetbrains/letsPlot/commons/intern/spatial/SimpleFeature$Consumer;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "getGeoJsonConsumer", "()Lorg/jetbrains/letsPlot/commons/intern/spatial/SimpleFeature$Consumer;", "getMappings", "supportedFeatures", "", "getSupportedFeatures", "()Ljava/util/List;", "rowCount", "K", "V", "getRowCount", "(Ljava/util/Map;)I", "buildDataFrame", "defaultConsumer", "config", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "defaultConsumer$plot_stem", "duplicate", "T", "values", "frequencies", "", "BboxCoordinatesCollector", "BoundaryCoordinatesCollector", "Companion", "PathCoordinatesCollector", "PointCoordinatesCollector", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nGeoConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeoConfig.kt\norg/jetbrains/letsPlot/core/spec/config/CoordinatesCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,398:1\n1208#2,2:399\n1238#2,4:401\n1559#2:405\n1590#2,3:406\n1593#2:410\n1855#2,2:411\n1855#2,2:413\n1#3:409\n*S KotlinDebug\n*F\n+ 1 GeoConfig.kt\norg/jetbrains/letsPlot/core/spec/config/CoordinatesCollector\n*L\n271#1:399,2\n271#1:401,4\n277#1:405\n277#1:406,3\n277#1:410\n292#1:411,2\n293#1:413,2\n*E\n"})
public abstract class CoordinatesCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataFrame dataFrame;
    @NotNull
    private final DataFrame.Variable geometries;
    @NotNull
    private final Map<String, String> mappings;
    @NotNull
    private final List<Integer> dupCounter;
    @NotNull
    private final Map<String, List<Object>> coordinates;
    @NotNull
    private static final Map<String, String> POINT_COLUMNS;
    @NotNull
    private static final Map<String, String> RECT_MAPPINGS;

    /*
     * WARNING - void declaration
     */
    public CoordinatesCollector(@NotNull DataFrame dataFrame, @NotNull DataFrame.Variable geometries, @NotNull Map<String, String> mappings) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter((Object)geometries, (String)"geometries");
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        this.dataFrame = dataFrame;
        this.geometries = geometries;
        this.mappings = mappings;
        this.dupCounter = new ArrayList();
        Iterable iterable = this.mappings.values();
        CoordinatesCollector coordinatesCollector = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var7_8 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            String string = (String)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            String it = (String)element$iv$iv;
            void var16_16 = it;
            boolean bl2 = false;
            List list = new ArrayList();
            map2.put(var16_16, list);
        }
        coordinatesCollector.coordinates = destination$iv$iv;
    }

    @NotNull
    public final Map<String, String> getMappings() {
        return this.mappings;
    }

    @NotNull
    protected final Map<String, List<Object>> getCoordinates() {
        return this.coordinates;
    }

    @NotNull
    protected abstract SimpleFeature.Consumer<LonLat> getGeoJsonConsumer();

    @NotNull
    protected abstract List<String> getSupportedFeatures();

    /*
     * WARNING - void declaration
     */
    private final <T> List<T> duplicate(List<? extends T> values, Collection<Integer> frequencies) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = frequencies;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void n;
            int n2;
            if ((n2 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n3 = ((Number)item$iv$iv).intValue();
            int n4 = n2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ArrayList<T> arrayList = new ArrayList<T>((int)n);
            int n5 = 0;
            while (n5 < n) {
                void i;
                int n6;
                int n7 = n6 = n5++;
                ArrayList<T> arrayList2 = arrayList;
                boolean bl2 = false;
                arrayList2.add(values.get((int)i));
            }
            collection.add((List)arrayList);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final DataFrame buildDataFrame() {
        for (Object geoJson : this.dataFrame.get(this.geometries)) {
            int oldRowCount = this.getRowCount(this.coordinates);
            Intrinsics.checkNotNull(geoJson, (String)"null cannot be cast to non-null type kotlin.String");
            GeoJson.INSTANCE.parse((String)geoJson, (SimpleFeature.GeometryConsumer)this.getGeoJsonConsumer());
            ((Collection)this.dupCounter).add(this.getRowCount(this.coordinates) - oldRowCount);
        }
        if (this.getRowCount(this.coordinates) == 0) {
            throw new IllegalStateException(("Geometries are empty or no matching types. Expected: " + this.getSupportedFeatures()).toString());
        }
        DataFrame.Builder builder = new DataFrame.Builder();
        Iterable $this$forEach$iv = this.dataFrame.variables();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataFrame.Variable variable = (DataFrame.Variable)element$iv;
            boolean bl = false;
            builder.put(variable, this.duplicate(this.dataFrame.get(variable), (Collection<Integer>)this.dupCounter));
        }
        $this$forEach$iv = this.coordinates.entrySet();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            String name = (String)entry.getKey();
            List values = (List)entry.getValue();
            builder.put(new DataFrame.Variable(name, null, null, 6, null), values);
        }
        builder.put(new DataFrame.Variable("__geo_id__", null, null, 6, null), this.duplicate(CollectionsKt.toList((Iterable)((Iterable)RangesKt.until((int)0, (int)this.dataFrame.rowCount()))), (Collection<Integer>)this.dupCounter));
        builder.remove(this.geometries);
        return builder.build();
    }

    @NotNull
    public final SimpleFeature.Consumer<LonLat> defaultConsumer$plot_stem(@NotNull Function1<? super SimpleFeature.Consumer<LonLat>, Unit> config2) {
        Intrinsics.checkNotNullParameter(config2, (String)"config");
        SimpleFeature.Consumer consumer = new SimpleFeature.Consumer((Function1)defaultConsumer.1.INSTANCE, (Function1)defaultConsumer.2.INSTANCE, (Function1)defaultConsumer.3.INSTANCE, (Function1)defaultConsumer.4.INSTANCE, (Function1)defaultConsumer.5.INSTANCE, (Function1)defaultConsumer.6.INSTANCE);
        config2.invoke((Object)consumer);
        return consumer;
    }

    private final <K, V extends List<? extends Object>> int getRowCount(Map<K, ? extends V> $this$rowCount) {
        List list = (List)CollectionsKt.firstOrNull((Iterable)$this$rowCount.values());
        return list != null ? list.size() : 0;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Aes.Companion.getX().getName(), (Object)"lon"), TuplesKt.to((Object)Aes.Companion.getY().getName(), (Object)"lat")};
        POINT_COLUMNS = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)Aes.Companion.getXMIN().getName(), (Object)"lonmin"), TuplesKt.to((Object)Aes.Companion.getYMIN().getName(), (Object)"latmin"), TuplesKt.to((Object)Aes.Companion.getXMAX().getName(), (Object)"lonmax"), TuplesKt.to((Object)Aes.Companion.getYMAX().getName(), (Object)"latmax")};
        RECT_MAPPINGS = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/CoordinatesCollector$BboxCoordinatesCollector;", "Lorg/jetbrains/letsPlot/core/spec/config/CoordinatesCollector;", "dataFrame", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "geometries", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "(Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;)V", "geoJsonConsumer", "Lorg/jetbrains/letsPlot/commons/intern/spatial/SimpleFeature$Consumer;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "getGeoJsonConsumer", "()Lorg/jetbrains/letsPlot/commons/intern/spatial/SimpleFeature$Consumer;", "supportedFeatures", "", "", "getSupportedFeatures", "()Ljava/util/List;", "plot-stem"})
    public static final class BboxCoordinatesCollector
    extends CoordinatesCollector {
        @NotNull
        private final List<String> supportedFeatures;
        @NotNull
        private final SimpleFeature.Consumer<LonLat> geoJsonConsumer;

        public BboxCoordinatesCollector(@NotNull DataFrame dataFrame, @NotNull DataFrame.Variable geometries) {
            Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
            Intrinsics.checkNotNullParameter((Object)geometries, (String)"geometries");
            super(dataFrame, geometries, Companion.getRECT_MAPPINGS());
            this.supportedFeatures = CollectionsKt.listOf((Object)"MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon");
            this.geoJsonConsumer = this.defaultConsumer$plot_stem((Function1<? super SimpleFeature.Consumer<LonLat>, Unit>)((Function1)new Function1<SimpleFeature.Consumer<LonLat>, Unit>(this){
                final /* synthetic */ BboxCoordinatesCollector this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull SimpleFeature.Consumer<LonLat> $this$defaultConsumer) {
                    Intrinsics.checkNotNullParameter($this$defaultConsumer, (String)"$this$defaultConsumer");
                    $this$defaultConsumer.setOnMultiPoint((Function1)new Function1<MultiPoint<LonLat>, Unit>(this.this$0){
                        final /* synthetic */ BboxCoordinatesCollector this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull MultiPoint<LonLat> it) {
                            block0: {
                                Intrinsics.checkNotNullParameter(it, (String)"it");
                                Rect rect = it.getBbox();
                                if (rect == null) break block0;
                                Rect rect2 = rect;
                                BboxCoordinatesCollector bboxCoordinatesCollector = this.this$0;
                                Rect p0 = rect2;
                                boolean bl = false;
                                geoJsonConsumer.1.access$invoke$insert$3(bboxCoordinatesCollector, p0);
                            }
                        }
                    });
                    $this$defaultConsumer.setOnLineString((Function1)new Function1<LineString<LonLat>, Unit>(this.this$0){
                        final /* synthetic */ BboxCoordinatesCollector this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull LineString<LonLat> it) {
                            block0: {
                                Intrinsics.checkNotNullParameter(it, (String)"it");
                                Rect rect = it.getBbox();
                                if (rect == null) break block0;
                                Rect rect2 = rect;
                                BboxCoordinatesCollector bboxCoordinatesCollector = this.this$0;
                                Rect p0 = rect2;
                                boolean bl = false;
                                geoJsonConsumer.1.access$invoke$insert$3(bboxCoordinatesCollector, p0);
                            }
                        }
                    });
                    $this$defaultConsumer.setOnMultiLineString((Function1)new Function1<MultiLineString<LonLat>, Unit>(this.this$0){
                        final /* synthetic */ BboxCoordinatesCollector this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull MultiLineString<LonLat> it) {
                            block0: {
                                Intrinsics.checkNotNullParameter(it, (String)"it");
                                Rect rect = it.getBbox();
                                if (rect == null) break block0;
                                Rect rect2 = rect;
                                BboxCoordinatesCollector bboxCoordinatesCollector = this.this$0;
                                Rect p0 = rect2;
                                boolean bl = false;
                                geoJsonConsumer.1.access$invoke$insert$3(bboxCoordinatesCollector, p0);
                            }
                        }
                    });
                    $this$defaultConsumer.setOnPolygon((Function1)new Function1<Polygon<LonLat>, Unit>(this.this$0){
                        final /* synthetic */ BboxCoordinatesCollector this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Polygon<LonLat> it) {
                            block0: {
                                Intrinsics.checkNotNullParameter(it, (String)"it");
                                Rect rect = it.getBbox();
                                if (rect == null) break block0;
                                Rect rect2 = rect;
                                BboxCoordinatesCollector bboxCoordinatesCollector = this.this$0;
                                Rect p0 = rect2;
                                boolean bl = false;
                                geoJsonConsumer.1.access$invoke$insert$3(bboxCoordinatesCollector, p0);
                            }
                        }
                    });
                    $this$defaultConsumer.setOnMultiPolygon((Function1)new Function1<MultiPolygon<LonLat>, Unit>(this.this$0){
                        final /* synthetic */ BboxCoordinatesCollector this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull MultiPolygon<LonLat> it) {
                            void $this$mapNotNullTo$iv$iv;
                            void $this$mapNotNull$iv;
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            Iterable iterable = (Iterable)it;
                            BboxCoordinatesCollector bboxCoordinatesCollector = this.this$0;
                            boolean $i$f$mapNotNull = false;
                            void var4_5 = $this$mapNotNull$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$mapNotNullTo = false;
                            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            boolean $i$f$forEach = false;
                            Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                            while (iterator.hasNext()) {
                                Rect it$iv$iv;
                                T element$iv$iv$iv;
                                T element$iv$iv = element$iv$iv$iv = iterator.next();
                                boolean bl = false;
                                Polygon p0 = (Polygon)element$iv$iv;
                                boolean bl2 = false;
                                if (p0.getBbox() == null) continue;
                                boolean bl3 = false;
                                destination$iv$iv.add(it$iv$iv);
                            }
                            geoJsonConsumer.1.access$invoke$insert(bboxCoordinatesCollector, (List)destination$iv$iv);
                        }
                    });
                }

                private static final void invoke$insert(BboxCoordinatesCollector this$0, List<Rect<LonLat>> bboxes) {
                    List<Rect<LonLat>> list = bboxes;
                    GeoBoundingBoxCalculator geoBoundingBoxCalculator = GeographicKt.getBBOX_CALCULATOR();
                    List<Rect<LonLat>> p0 = list;
                    boolean bl = false;
                    Rect p02 = GeoBoundingBoxCalculatorKt.union((GeoBoundingBoxCalculator)geoBoundingBoxCalculator, p0);
                    boolean bl2 = false;
                    p02 = GeographicKt.convertToGeoRectangle((Rect)p02);
                    boolean bl3 = false;
                    Iterable $this$forEach$iv = p02.splitByAntiMeridian();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Rect r = (Rect)element$iv;
                        boolean bl4 = false;
                        CoordinatesCollector.Companion.append$plot_stem(this$0.getCoordinates(), (Rect<LonLat>)r);
                    }
                }

                private static final void invoke$insert$3(BboxCoordinatesCollector this$0, Rect<LonLat> bbox) {
                    geoJsonConsumer.1.invoke$insert(this$0, CollectionsKt.listOf(bbox));
                }

                public static final /* synthetic */ void access$invoke$insert$3(BboxCoordinatesCollector this$0, Rect bbox) {
                    geoJsonConsumer.1.invoke$insert$3(this$0, (Rect<LonLat>)bbox);
                }

                public static final /* synthetic */ void access$invoke$insert(BboxCoordinatesCollector this$0, List bboxes) {
                    geoJsonConsumer.1.invoke$insert(this$0, bboxes);
                }
            }));
        }

        @Override
        @NotNull
        protected List<String> getSupportedFeatures() {
            return this.supportedFeatures;
        }

        @Override
        @NotNull
        protected SimpleFeature.Consumer<LonLat> getGeoJsonConsumer() {
            return this.geoJsonConsumer;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/CoordinatesCollector$BoundaryCoordinatesCollector;", "Lorg/jetbrains/letsPlot/core/spec/config/CoordinatesCollector;", "dataFrame", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "geometries", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "(Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;)V", "geoJsonConsumer", "Lorg/jetbrains/letsPlot/commons/intern/spatial/SimpleFeature$Consumer;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "getGeoJsonConsumer", "()Lorg/jetbrains/letsPlot/commons/intern/spatial/SimpleFeature$Consumer;", "supportedFeatures", "", "", "getSupportedFeatures", "()Ljava/util/List;", "plot-stem"})
    public static final class BoundaryCoordinatesCollector
    extends CoordinatesCollector {
        @NotNull
        private final List<String> supportedFeatures;
        @NotNull
        private final SimpleFeature.Consumer<LonLat> geoJsonConsumer;

        public BoundaryCoordinatesCollector(@NotNull DataFrame dataFrame, @NotNull DataFrame.Variable geometries) {
            Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
            Intrinsics.checkNotNullParameter((Object)geometries, (String)"geometries");
            super(dataFrame, geometries, Companion.getPOINT_COLUMNS());
            this.supportedFeatures = CollectionsKt.listOf((Object)"Polygon, MultiPolygon");
            this.geoJsonConsumer = this.defaultConsumer$plot_stem((Function1<? super SimpleFeature.Consumer<LonLat>, Unit>)((Function1)new Function1<SimpleFeature.Consumer<LonLat>, Unit>(this){
                final /* synthetic */ BoundaryCoordinatesCollector this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull SimpleFeature.Consumer<LonLat> $this$defaultConsumer) {
                    Intrinsics.checkNotNullParameter($this$defaultConsumer, (String)"$this$defaultConsumer");
                    $this$defaultConsumer.setOnPolygon((Function1)new Function1<Polygon<LonLat>, Unit>(this.this$0){
                        final /* synthetic */ BoundaryCoordinatesCollector this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull Polygon<LonLat> it) {
                            void $this$forEach$iv;
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            Sequence sequence = SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)it)));
                            BoundaryCoordinatesCollector boundaryCoordinatesCollector = this.this$0;
                            boolean $i$f$forEach = false;
                            for (E element$iv : $this$forEach$iv) {
                                Vec p = (Vec)element$iv;
                                boolean bl = false;
                                CoordinatesCollector.Companion.append$plot_stem(boundaryCoordinatesCollector.getCoordinates(), (Vec<LonLat>)p);
                            }
                        }
                    });
                    $this$defaultConsumer.setOnMultiPolygon((Function1)new Function1<MultiPolygon<LonLat>, Unit>(this.this$0){
                        final /* synthetic */ BoundaryCoordinatesCollector this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull MultiPolygon<LonLat> it) {
                            void $this$forEach$iv;
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            Sequence sequence = SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)it))), (Function1)geoJsonConsumer.1.INSTANCE));
                            BoundaryCoordinatesCollector boundaryCoordinatesCollector = this.this$0;
                            boolean $i$f$forEach = false;
                            for (E element$iv : $this$forEach$iv) {
                                Vec p = (Vec)element$iv;
                                boolean bl = false;
                                CoordinatesCollector.Companion.append$plot_stem(boundaryCoordinatesCollector.getCoordinates(), (Vec<LonLat>)p);
                            }
                        }
                    });
                }
            }));
        }

        @Override
        @NotNull
        protected List<String> getSupportedFeatures() {
            return this.supportedFeatures;
        }

        @Override
        @NotNull
        protected SimpleFeature.Consumer<LonLat> getGeoJsonConsumer() {
            return this.geoJsonConsumer;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\n\u001a\u00020\u000b*\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\f0\u00042\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J1\u0010\n\u001a\u00020\u000b*\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\f0\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0002\b\u0013J1\u0010\n\u001a\u00020\u000b*\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\f0\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015H\u0000\u00a2\u0006\u0002\b\u0013R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/CoordinatesCollector$Companion;", "", "()V", "POINT_COLUMNS", "", "", "getPOINT_COLUMNS", "()Ljava/util/Map;", "RECT_MAPPINGS", "getRECT_MAPPINGS", "append", "", "", "key", "value", "", "rect", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "append$plot_stem", "p", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "plot-stem"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getPOINT_COLUMNS() {
            return POINT_COLUMNS;
        }

        @NotNull
        public final Map<String, String> getRECT_MAPPINGS() {
            return RECT_MAPPINGS;
        }

        public final void append$plot_stem(@NotNull Map<String, ? extends List<Object>> $this$append, @NotNull Vec<LonLat> p) {
            Intrinsics.checkNotNullParameter($this$append, (String)"<this>");
            Intrinsics.checkNotNullParameter(p, (String)"p");
            this.append($this$append, "lon", p.getX());
            this.append($this$append, "lat", p.getY());
        }

        public final void append$plot_stem(@NotNull Map<String, ? extends List<Object>> $this$append, @NotNull Rect<LonLat> rect) {
            Intrinsics.checkNotNullParameter($this$append, (String)"<this>");
            Intrinsics.checkNotNullParameter(rect, (String)"rect");
            this.append($this$append, "lonmin", RectKt.getLeft(rect));
            this.append($this$append, "lonmax", RectKt.getRight(rect));
            this.append($this$append, "latmin", RectKt.getTop(rect));
            this.append($this$append, "latmax", RectKt.getBottom(rect));
        }

        private final void append(Map<String, ? extends List<Object>> $this$append, String key, double value) {
            List<Object> list = $this$append.get(key);
            if (list == null) {
                throw new IllegalStateException((key + " is not found").toString());
            }
            list.add(value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/CoordinatesCollector$PathCoordinatesCollector;", "Lorg/jetbrains/letsPlot/core/spec/config/CoordinatesCollector;", "dataFrame", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "geometries", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "(Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;)V", "geoJsonConsumer", "Lorg/jetbrains/letsPlot/commons/intern/spatial/SimpleFeature$Consumer;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "getGeoJsonConsumer", "()Lorg/jetbrains/letsPlot/commons/intern/spatial/SimpleFeature$Consumer;", "supportedFeatures", "", "", "getSupportedFeatures", "()Ljava/util/List;", "plot-stem"})
    public static final class PathCoordinatesCollector
    extends CoordinatesCollector {
        @NotNull
        private final List<String> supportedFeatures;
        @NotNull
        private final SimpleFeature.Consumer<LonLat> geoJsonConsumer;

        public PathCoordinatesCollector(@NotNull DataFrame dataFrame, @NotNull DataFrame.Variable geometries) {
            Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
            Intrinsics.checkNotNullParameter((Object)geometries, (String)"geometries");
            super(dataFrame, geometries, Companion.getPOINT_COLUMNS());
            this.supportedFeatures = CollectionsKt.listOf((Object)"LineString, MultiLineString");
            this.geoJsonConsumer = this.defaultConsumer$plot_stem((Function1<? super SimpleFeature.Consumer<LonLat>, Unit>)((Function1)new Function1<SimpleFeature.Consumer<LonLat>, Unit>(this){
                final /* synthetic */ PathCoordinatesCollector this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull SimpleFeature.Consumer<LonLat> $this$defaultConsumer) {
                    Intrinsics.checkNotNullParameter($this$defaultConsumer, (String)"$this$defaultConsumer");
                    $this$defaultConsumer.setOnLineString((Function1)new Function1<LineString<LonLat>, Unit>(this.this$0){
                        final /* synthetic */ PathCoordinatesCollector this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull LineString<LonLat> it) {
                            void $this$forEach$iv;
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            Iterable iterable = (Iterable)it;
                            PathCoordinatesCollector pathCoordinatesCollector = this.this$0;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                Vec p = (Vec)element$iv;
                                boolean bl = false;
                                CoordinatesCollector.Companion.append$plot_stem(pathCoordinatesCollector.getCoordinates(), (Vec<LonLat>)p);
                            }
                        }
                    });
                    $this$defaultConsumer.setOnMultiLineString((Function1)new Function1<MultiLineString<LonLat>, Unit>(this.this$0){
                        final /* synthetic */ PathCoordinatesCollector this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull MultiLineString<LonLat> it) {
                            void $this$forEach$iv;
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            Sequence sequence = SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)it)));
                            PathCoordinatesCollector pathCoordinatesCollector = this.this$0;
                            boolean $i$f$forEach = false;
                            for (E element$iv : $this$forEach$iv) {
                                Vec p = (Vec)element$iv;
                                boolean bl = false;
                                CoordinatesCollector.Companion.append$plot_stem(pathCoordinatesCollector.getCoordinates(), (Vec<LonLat>)p);
                            }
                        }
                    });
                }
            }));
        }

        @Override
        @NotNull
        protected List<String> getSupportedFeatures() {
            return this.supportedFeatures;
        }

        @Override
        @NotNull
        protected SimpleFeature.Consumer<LonLat> getGeoJsonConsumer() {
            return this.geoJsonConsumer;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/CoordinatesCollector$PointCoordinatesCollector;", "Lorg/jetbrains/letsPlot/core/spec/config/CoordinatesCollector;", "dataFrame", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "geometries", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "(Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;)V", "geoJsonConsumer", "Lorg/jetbrains/letsPlot/commons/intern/spatial/SimpleFeature$Consumer;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "getGeoJsonConsumer", "()Lorg/jetbrains/letsPlot/commons/intern/spatial/SimpleFeature$Consumer;", "supportedFeatures", "", "", "getSupportedFeatures", "()Ljava/util/List;", "plot-stem"})
    public static final class PointCoordinatesCollector
    extends CoordinatesCollector {
        @NotNull
        private final List<String> supportedFeatures;
        @NotNull
        private final SimpleFeature.Consumer<LonLat> geoJsonConsumer;

        public PointCoordinatesCollector(@NotNull DataFrame dataFrame, @NotNull DataFrame.Variable geometries) {
            Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
            Intrinsics.checkNotNullParameter((Object)geometries, (String)"geometries");
            super(dataFrame, geometries, Companion.getPOINT_COLUMNS());
            this.supportedFeatures = CollectionsKt.listOf((Object)"Point, MultiPoint");
            this.geoJsonConsumer = this.defaultConsumer$plot_stem((Function1<? super SimpleFeature.Consumer<LonLat>, Unit>)((Function1)new Function1<SimpleFeature.Consumer<LonLat>, Unit>(this){
                final /* synthetic */ PointCoordinatesCollector this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull SimpleFeature.Consumer<LonLat> $this$defaultConsumer) {
                    Intrinsics.checkNotNullParameter($this$defaultConsumer, (String)"$this$defaultConsumer");
                    $this$defaultConsumer.setOnPoint((Function1)new Function1<Vec<LonLat>, Unit>(this.this$0){
                        final /* synthetic */ PointCoordinatesCollector this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Vec<LonLat> p) {
                            Intrinsics.checkNotNullParameter(p, (String)"p");
                            CoordinatesCollector.Companion.append$plot_stem(this.this$0.getCoordinates(), p);
                        }
                    });
                    $this$defaultConsumer.setOnMultiPoint((Function1)new Function1<MultiPoint<LonLat>, Unit>(this.this$0){
                        final /* synthetic */ PointCoordinatesCollector this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull MultiPoint<LonLat> it) {
                            void $this$forEach$iv;
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            Iterable iterable = (Iterable)it;
                            PointCoordinatesCollector pointCoordinatesCollector = this.this$0;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                Vec p = (Vec)element$iv;
                                boolean bl = false;
                                CoordinatesCollector.Companion.append$plot_stem(pointCoordinatesCollector.getCoordinates(), (Vec<LonLat>)p);
                            }
                        }
                    });
                }
            }));
        }

        @Override
        @NotNull
        protected List<String> getSupportedFeatures() {
            return this.supportedFeatures;
        }

        @Override
        @NotNull
        protected SimpleFeature.Consumer<LonLat> getGeoJsonConsumer() {
            return this.geoJsonConsumer;
        }
    }
}

