/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.config;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.Transform;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.spec.config.ConfigUtil;
import org.jetbrains.letsPlot.core.spec.config.CoordProto;
import org.jetbrains.letsPlot.core.spec.config.OptionsAccessor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001J(\u0010\u0006\u001a\u00020\u00072\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0001H\u0002J8\u0010\u000e\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\u0016\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000f2\u0006\u0010\u0013\u001a\u00020\tH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/CoordConfig;", "", "()V", "allowsDomainExpand", "", "coordOpts", "createCoordProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "transformX", "Lorg/jetbrains/letsPlot/core/plot/base/Transform;", "transformY", "defaultCoordProvider", "getCoordName", "", "transformRange", "Lkotlin/Pair;", "", "r", "", "t", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nCoordConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoordConfig.kt\norg/jetbrains/letsPlot/core/spec/config/CoordConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public final class CoordConfig {
    @NotNull
    public static final CoordConfig INSTANCE = new CoordConfig();

    private CoordConfig() {
    }

    public final boolean allowsDomainExpand(@Nullable Object coordOpts) {
        if (coordOpts == null) {
            return true;
        }
        return !Intrinsics.areEqual((Object)this.getCoordName(coordOpts), (Object)"polar");
    }

    @NotNull
    public final CoordProvider createCoordProvider(@Nullable Object coordOpts, @NotNull Transform transformX, @NotNull Transform transformY, @NotNull CoordProvider defaultCoordProvider) {
        Intrinsics.checkNotNullParameter((Object)transformX, (String)"transformX");
        Intrinsics.checkNotNullParameter((Object)transformY, (String)"transformY");
        Intrinsics.checkNotNullParameter((Object)defaultCoordProvider, (String)"defaultCoordProvider");
        if (coordOpts == null) {
            return defaultCoordProvider;
        }
        Map options = coordOpts instanceof Map ? (Map)coordOpts : MapsKt.emptyMap();
        OptionsAccessor accessor = OptionsAccessor.Companion.over(options);
        Pair<Number, Number> it = accessor.getNumQPairDef("xlim", (Pair<? extends Number, ? extends Number>)TuplesKt.to(null, null));
        boolean bl = false;
        Pair<Double, Double> xLim = INSTANCE.transformRange(it, transformX);
        Pair<Number, Number> it2 = accessor.getNumQPairDef("ylim", (Pair<? extends Number, ? extends Number>)TuplesKt.to(null, null));
        boolean bl2 = false;
        Pair<Double, Double> yLim = INSTANCE.transformRange(it2, transformY);
        String coordName = this.getCoordName(coordOpts);
        return Intrinsics.areEqual((Object)coordName, (Object)"flip") ? defaultCoordProvider.with(xLim, yLim, true) : CoordProto.INSTANCE.createCoordProvider(coordName, xLim, yLim, accessor);
    }

    private final String getCoordName(Object coordOpts) {
        String coordName = coordOpts instanceof Map ? ConfigUtil.INSTANCE.featureName((Map)coordOpts) : coordOpts.toString();
        return coordName;
    }

    private final Pair<Double, Double> transformRange(Pair<? extends Number, ? extends Number> r, Transform t) {
        Pair pair;
        if (t instanceof ContinuousTransform) {
            Pair pair2;
            Double second;
            Double d;
            Double d2;
            Number number = (Number)r.getFirst();
            if (number != null) {
                Number it = number;
                boolean bl = false;
                d2 = t.isInDomain((Object)it) ? Double.valueOf(it.doubleValue()) : null;
            } else {
                d2 = null;
            }
            Double first = d2;
            Number number2 = (Number)r.getSecond();
            if (number2 != null) {
                Number it = number2;
                boolean bl = false;
                d = t.isInDomain((Object)it) ? Double.valueOf(it.doubleValue()) : null;
            } else {
                d = second = null;
            }
            if (first != null && second != null) {
                double it = first;
                double d3 = second;
                Double d4 = Math.min(it, d3);
                it = first;
                d3 = second;
                Pair pair3 = new Pair((Object)d4, (Object)Math.max(it, d3));
                pair2 = pair3;
            } else {
                pair2 = new Pair((Object)first, (Object)second);
            }
            Pair pair4 = pair2;
            Double lower = (Double)pair4.component1();
            Double upper = (Double)pair4.component2();
            pair = new Pair((Object)((ContinuousTransform)t).apply(lower), (Object)((ContinuousTransform)t).apply(upper));
        } else {
            Number number = (Number)r.getFirst();
            Number number3 = (Number)r.getSecond();
            pair = new Pair((Object)(number != null ? Double.valueOf(number.doubleValue()) : null), (Object)(number3 != null ? Double.valueOf(number3.doubleValue()) : null));
        }
        return pair;
    }
}

