/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.back.transform.bistro.qq;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.CollectionsExKt;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.data.DataFrameUtil;
import org.jetbrains.letsPlot.core.plot.base.stat.QQStat;
import org.jetbrains.letsPlot.core.plot.base.stat.QQStatUtil;
import org.jetbrains.letsPlot.core.spec.back.transform.bistro.qq.QQPlotOptionsBuilder;
import org.jetbrains.letsPlot.core.spec.back.transform.bistro.util.DataFrameExKt;
import org.jetbrains.letsPlot.core.spec.back.transform.bistro.util.DataUtil;
import org.jetbrains.letsPlot.core.spec.conversion.LineTypeOptionConverter;
import org.jetbrains.letsPlot.core.spec.conversion.ShapeOptionConverter;
import org.jetbrains.letsPlot.core.spec.plotson.LayerOptions;
import org.jetbrains.letsPlot.core.spec.plotson.Mapping;
import org.jetbrains.letsPlot.core.spec.plotson.Options;
import org.jetbrains.letsPlot.core.spec.plotson.PlotOptions;
import org.jetbrains.letsPlot.core.spec.plotson.PlotOptionsKt;
import org.jetbrains.letsPlot.core.spec.plotson.ScaleOptions;
import org.jetbrains.letsPlot.core.spec.plotson.ScaleOptionsKt;
import org.jetbrains.letsPlot.core.spec.plotson.ThemeOptions;
import org.jetbrains.letsPlot.core.spec.plotson.ThemeOptionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 82\u00020\u0001:\u000289B\u00eb\u0001\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u0012\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0001\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\u001d\u001a\u00020\u001eJ0\u0010\u001f\u001a\u00020 2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0002J'\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020(2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020%0\nH\u0002J8\u0010+\u001a\u00020 2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010'\u001a\u00020(H\u0002J@\u0010,\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030-\u0012\u0004\u0012\u00020\u00050\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0002JR\u0010.\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n0\u00032\u001a\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n0\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0002JJ\u0010/\u001a\b\u0012\u0004\u0012\u0002000\n\"\u0004\b\u0000\u00101\"\u000e\b\u0001\u00102*\b\u0012\u0004\u0012\u0002H203*\b\u0012\u0004\u0012\u0002H1042\u001a\u00105\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H107\u0012\u0006\u0012\u0004\u0018\u0001H206H\u0002R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\"\u0010\u001c\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/letsPlot/core/spec/back/transform/bistro/qq/QQPlotOptionsBuilder;", "", "data", "", "sample", "", "x", "y", "distribution", "distributionParameters", "", "", "quantiles", "group", "showLegend", "", "marginal", "color", "fill", "alpha", "size", "shape", "lineColor", "lineSize", "lineType", "(Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Double;Ljava/lang/Object;)V", "Ljava/lang/Double;", "Ljava/lang/Boolean;", "statData", "build", "Lorg/jetbrains/letsPlot/core/spec/plotson/PlotOptions;", "getMappings", "Lorg/jetbrains/letsPlot/core/spec/plotson/Mapping;", "getMarginGeom", "Lorg/jetbrains/letsPlot/core/plot/base/GeomKind;", "geom", "getMarginalLayer", "Lorg/jetbrains/letsPlot/core/spec/plotson/LayerOptions;", "geomKind", "side", "Lorg/jetbrains/letsPlot/core/spec/back/transform/bistro/qq/QQPlotOptionsBuilder$MarginSide;", "(Lorg/jetbrains/letsPlot/core/plot/base/GeomKind;Lorg/jetbrains/letsPlot/core/spec/back/transform/bistro/qq/QQPlotOptionsBuilder$MarginSide;Ljava/lang/Double;)Lorg/jetbrains/letsPlot/core/spec/plotson/LayerOptions;", "getMarginalLayers", "getMarginalMappings", "getScaleNames", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "getStatData", "sortedIndices", "", "T", "R", "", "", "selector", "Lkotlin/Function1;", "Lkotlin/collections/IndexedValue;", "Companion", "MarginSide", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nQQPlotOptionsBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QQPlotOptionsBuilder.kt\norg/jetbrains/letsPlot/core/spec/back/transform/bistro/qq/QQPlotOptionsBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,275:1\n1#2:276\n1549#3:277\n1620#3,2:278\n1549#3:280\n1620#3,3:281\n1622#3:284\n1549#3:288\n1620#3,3:289\n1549#3:292\n1620#3,3:293\n1549#3:297\n1620#3,3:298\n125#4:285\n152#4,2:286\n154#4:296\n*S KotlinDebug\n*F\n+ 1 QQPlotOptionsBuilder.kt\norg/jetbrains/letsPlot/core/spec/back/transform/bistro/qq/QQPlotOptionsBuilder\n*L\n150#1:277\n150#1:278,2\n156#1:280\n156#1:281,3\n150#1:284\n207#1:288\n207#1:289,3\n212#1:292\n212#1:293,3\n241#1:297\n241#1:298,3\n198#1:285\n198#1:286,2\n198#1:296\n*E\n"})
public final class QQPlotOptionsBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String sample;
    @Nullable
    private final String x;
    @Nullable
    private final String y;
    @Nullable
    private final String distribution;
    @Nullable
    private final List<Double> distributionParameters;
    @Nullable
    private final List<Double> quantiles;
    @Nullable
    private final String group;
    @Nullable
    private final Boolean showLegend;
    @NotNull
    private final String marginal;
    @Nullable
    private final String color;
    @Nullable
    private final String fill;
    @Nullable
    private final Double alpha;
    @Nullable
    private final Double size;
    @Nullable
    private final Object shape;
    @Nullable
    private final String lineColor;
    @Nullable
    private final Double lineSize;
    @Nullable
    private final Object lineType;
    @NotNull
    private final Map<String, List<Object>> statData;
    @NotNull
    public static final String DEF_DISTRIBUTION = "norm";
    public static final double DEF_POINT_ALPHA = 0.5;
    public static final double DEF_POINT_SIZE = 3.0;
    @NotNull
    private static final String DEF_LINE_COLOR = Color.Companion.getRED().toHexColor();
    public static final double DEF_LINE_SIZE = 0.75;
    @NotNull
    public static final String DEF_MARGINAL = "dens:tr";
    public static final double DEF_MARGINAL_ALPHA = 0.25;
    @NotNull
    private static final Options.PropSpec<String> DISTRIBUTION = new Options.PropSpec("distribution");
    @NotNull
    private static final Options.PropSpec<List<Double>> DISTRIBUTION_PARAMETERS = new Options.PropSpec("dparams");
    @NotNull
    private static final Options.PropSpec<List<Double>> QUANTILES = new Options.PropSpec("quantiles");
    @NotNull
    private static final DataFrame.Variable THEORETICAL_VAR = new DataFrame.Variable("..theoretical_bistro..", null, null, 6, null);

    public QQPlotOptionsBuilder(@NotNull Map<?, ?> data2, @Nullable String sample, @Nullable String x, @Nullable String y, @Nullable String distribution, @Nullable List<Double> distributionParameters, @Nullable List<Double> quantiles, @Nullable String group, @Nullable Boolean showLegend, @NotNull String marginal, @Nullable String color, @Nullable String fill2, @Nullable Double alpha, @Nullable Double size, @Nullable Object shape, @Nullable String lineColor, @Nullable Double lineSize, @Nullable Object lineType) {
        Intrinsics.checkNotNullParameter(data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)marginal, (String)"marginal");
        this.sample = sample;
        this.x = x;
        this.y = y;
        this.distribution = distribution;
        this.distributionParameters = distributionParameters;
        this.quantiles = quantiles;
        this.group = group;
        this.showLegend = showLegend;
        this.marginal = marginal;
        this.color = color;
        this.fill = fill2;
        this.alpha = alpha;
        this.size = size;
        this.shape = shape;
        this.lineColor = lineColor;
        this.lineSize = lineSize;
        this.lineType = lineType;
        this.statData = this.getStatData(DataUtil.INSTANCE.standardiseData(data2), this.distribution, this.distributionParameters);
    }

    public /* synthetic */ QQPlotOptionsBuilder(Map map2, String string, String string2, String string3, String string4, List list, List list2, String string5, Boolean bl, String string6, String string7, String string8, Double d, Double d2, Object object, String string9, Double d3, Object object2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            string4 = DEF_DISTRIBUTION;
        }
        if ((n & 0x20) != 0) {
            list = null;
        }
        if ((n & 0x40) != 0) {
            list2 = null;
        }
        if ((n & 0x80) != 0) {
            string5 = null;
        }
        if ((n & 0x100) != 0) {
            bl = null;
        }
        if ((n & 0x200) != 0) {
            string6 = DEF_MARGINAL;
        }
        if ((n & 0x400) != 0) {
            string7 = null;
        }
        if ((n & 0x800) != 0) {
            string8 = null;
        }
        if ((n & 0x1000) != 0) {
            d = 0.5;
        }
        if ((n & 0x2000) != 0) {
            d2 = 3.0;
        }
        if ((n & 0x4000) != 0) {
            object = null;
        }
        if ((n & 0x8000) != 0) {
            string9 = null;
        }
        if ((n & 0x10000) != 0) {
            d3 = 0.75;
        }
        if ((n & 0x20000) != 0) {
            object2 = null;
        }
        this(map2, string, string2, string3, string4, list, list2, string5, bl, string6, string7, string8, d, d2, object, string9, d3, object2);
    }

    @NotNull
    public final PlotOptions build() {
        Mapping mapping = this.getMappings(this.sample, this.x, this.y, this.group);
        Map<Aes<?>, String> scaleNames = this.getScaleNames(this.sample, this.x, this.y, this.distribution);
        return PlotOptionsKt.plot((Function1<? super PlotOptions, Unit>)((Function1)new Function1<PlotOptions, Unit>(this, mapping, scaleNames){
            final /* synthetic */ QQPlotOptionsBuilder this$0;
            final /* synthetic */ Mapping $mapping;
            final /* synthetic */ Map<Aes<?>, String> $scaleNames;
            {
                this.this$0 = $receiver;
                this.$mapping = $mapping;
                this.$scaleNames = $scaleNames;
                super(1);
            }

            public final void invoke(@NotNull PlotOptions $this$plot) {
                LayerOptions it;
                Intrinsics.checkNotNullParameter((Object)$this$plot, (String)"$this$plot");
                Object[] objectArray = new LayerOptions[2];
                LayerOptions layerOptions = new LayerOptions(null, 1, null);
                QQPlotOptionsBuilder qQPlotOptionsBuilder = this.this$0;
                Mapping mapping = this.$mapping;
                LayerOptions layerOptions2 = layerOptions;
                int n = 0;
                Object[] objectArray2 = objectArray;
                PlotOptions plotOptions = $this$plot;
                boolean bl = false;
                it.setGeom(QQPlotOptionsBuilder.access$getSample$p(qQPlotOptionsBuilder) != null ? GeomKind.Q_Q : GeomKind.Q_Q_2);
                it.getProp().set(QQPlotOptionsBuilder.access$getDISTRIBUTION$cp(), QQPlotOptionsBuilder.access$getDistribution$p(qQPlotOptionsBuilder));
                it.getProp().set(QQPlotOptionsBuilder.access$getDISTRIBUTION_PARAMETERS$cp(), QQPlotOptionsBuilder.access$getDistributionParameters$p(qQPlotOptionsBuilder));
                it.getProp().set(QQPlotOptionsBuilder.access$getQUANTILES$cp(), QQPlotOptionsBuilder.access$getQuantiles$p(qQPlotOptionsBuilder));
                it.setData(QQPlotOptionsBuilder.access$getStatData$p(qQPlotOptionsBuilder));
                it.setMapping(mapping);
                it.setShowLegend(QQPlotOptionsBuilder.access$getShowLegend$p(qQPlotOptionsBuilder));
                it.setColor(QQPlotOptionsBuilder.access$getColor$p(qQPlotOptionsBuilder));
                it.setFill(QQPlotOptionsBuilder.access$getFill$p(qQPlotOptionsBuilder));
                it.setAlpha(QQPlotOptionsBuilder.access$getAlpha$p(qQPlotOptionsBuilder));
                it.setSize(QQPlotOptionsBuilder.access$getSize$p(qQPlotOptionsBuilder));
                it.setShape(new ShapeOptionConverter().apply(QQPlotOptionsBuilder.access$getShape$p(qQPlotOptionsBuilder)));
                Unit unit = Unit.INSTANCE;
                objectArray2[n] = layerOptions;
                layerOptions = new LayerOptions(null, 1, null);
                qQPlotOptionsBuilder = this.this$0;
                mapping = this.$mapping;
                it = layerOptions;
                n = 1;
                objectArray2 = objectArray;
                boolean bl2 = false;
                it.setGeom(QQPlotOptionsBuilder.access$getSample$p(qQPlotOptionsBuilder) != null ? GeomKind.Q_Q_LINE : GeomKind.Q_Q_2_LINE);
                it.getProp().set(QQPlotOptionsBuilder.access$getDISTRIBUTION$cp(), QQPlotOptionsBuilder.access$getDistribution$p(qQPlotOptionsBuilder));
                it.getProp().set(QQPlotOptionsBuilder.access$getDISTRIBUTION_PARAMETERS$cp(), QQPlotOptionsBuilder.access$getDistributionParameters$p(qQPlotOptionsBuilder));
                it.getProp().set(QQPlotOptionsBuilder.access$getQUANTILES$cp(), QQPlotOptionsBuilder.access$getQuantiles$p(qQPlotOptionsBuilder));
                it.setData(QQPlotOptionsBuilder.access$getStatData$p(qQPlotOptionsBuilder));
                it.setMapping(mapping);
                it.setShowLegend(QQPlotOptionsBuilder.access$getShowLegend$p(qQPlotOptionsBuilder));
                String string = QQPlotOptionsBuilder.access$getLineColor$p(qQPlotOptionsBuilder);
                if (string == null) {
                    string = QQPlotOptionsBuilder.access$getGroup$p(qQPlotOptionsBuilder) == null ? QQPlotOptionsBuilder.Companion.getDEF_LINE_COLOR() : null;
                }
                it.setColor(string);
                it.setSize(QQPlotOptionsBuilder.access$getLineSize$p(qQPlotOptionsBuilder));
                it.setLinetype(new LineTypeOptionConverter().apply(QQPlotOptionsBuilder.access$getLineType$p(qQPlotOptionsBuilder)));
                unit = Unit.INSTANCE;
                objectArray2[n] = layerOptions;
                plotOptions.setLayerOptions(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)QQPlotOptionsBuilder.access$getMarginalLayers(this.this$0)));
                objectArray = new ScaleOptions[]{ScaleOptionsKt.scale((Function1<? super ScaleOptions, Unit>)((Function1)new Function1<ScaleOptions, Unit>(this.$scaleNames){
                    final /* synthetic */ Map<Aes<?>, String> $scaleNames;
                    {
                        this.$scaleNames = $scaleNames;
                        super(1);
                    }

                    public final void invoke(@NotNull ScaleOptions $this$scale) {
                        Intrinsics.checkNotNullParameter((Object)$this$scale, (String)"$this$scale");
                        $this$scale.setAes(Aes.Companion.getX());
                        $this$scale.setName(this.$scaleNames.get(Aes.Companion.getX()));
                    }
                })), ScaleOptionsKt.scale((Function1<? super ScaleOptions, Unit>)((Function1)new Function1<ScaleOptions, Unit>(this.$scaleNames){
                    final /* synthetic */ Map<Aes<?>, String> $scaleNames;
                    {
                        this.$scaleNames = $scaleNames;
                        super(1);
                    }

                    public final void invoke(@NotNull ScaleOptions $this$scale) {
                        Intrinsics.checkNotNullParameter((Object)$this$scale, (String)"$this$scale");
                        $this$scale.setAes(Aes.Companion.getY());
                        $this$scale.setName(this.$scaleNames.get(Aes.Companion.getY()));
                    }
                })), ScaleOptionsKt.scale((Function1<? super ScaleOptions, Unit>)((Function1)build.5.INSTANCE)), ScaleOptionsKt.scale((Function1<? super ScaleOptions, Unit>)((Function1)build.6.INSTANCE))};
                $this$plot.setScaleOptions(CollectionsKt.listOf((Object[])objectArray));
                $this$plot.setThemeOptions(ThemeOptionsKt.theme((Function1<? super ThemeOptions, Unit>)((Function1)build.7.INSTANCE)));
            }
        }));
    }

    private final Mapping getMappings(String sample, String x, String y, String group) {
        Mapping mapping;
        Mapping mapping2;
        Pair[] pairArray;
        if (sample != null) {
            if (!(x == null)) {
                boolean $i$a$-require-QQPlotOptionsBuilder$getMappings$mapping$52 = false;
                String $i$a$-require-QQPlotOptionsBuilder$getMappings$mapping$52 = "Parameter x shouldn't be specified when parameter sample is.";
                throw new IllegalArgumentException($i$a$-require-QQPlotOptionsBuilder$getMappings$mapping$52.toString());
            }
            if (!(y == null)) {
                boolean $i$a$-require-QQPlotOptionsBuilder$getMappings$mapping$62 = false;
                String $i$a$-require-QQPlotOptionsBuilder$getMappings$mapping$62 = "Parameter y shouldn't be specified when parameter sample is.";
                throw new IllegalArgumentException($i$a$-require-QQPlotOptionsBuilder$getMappings$mapping$62.toString());
            }
            pairArray = new Pair[]{TuplesKt.to((Object)Aes.Companion.getSAMPLE(), (Object)sample)};
            Mapping mapping3 = new Mapping(pairArray);
            mapping2 = mapping3;
        } else {
            if (!(x != null)) {
                boolean $i$a$-require-QQPlotOptionsBuilder$getMappings$mapping$72 = false;
                String $i$a$-require-QQPlotOptionsBuilder$getMappings$mapping$72 = "Parameter x should be specified when parameter sample isn't.";
                throw new IllegalArgumentException($i$a$-require-QQPlotOptionsBuilder$getMappings$mapping$72.toString());
            }
            if (!(y != null)) {
                boolean bl = false;
                String string = "Parameter y should be specified when parameter sample isn't.";
                throw new IllegalArgumentException(string.toString());
            }
            pairArray = new Pair[]{TuplesKt.to((Object)Aes.Companion.getX(), (Object)x), TuplesKt.to((Object)Aes.Companion.getY(), (Object)y)};
            mapping2 = mapping = new Mapping(pairArray);
        }
        if (group != null) {
            mapping = mapping.plus(TuplesKt.to((Object)Aes.Companion.getCOLOR(), (Object)group));
            mapping = mapping.plus(TuplesKt.to((Object)Aes.Companion.getFILL(), (Object)group));
        }
        return mapping;
    }

    private final Map<Aes<?>, String> getScaleNames(String sample, String x, String y, String distribution) {
        String string = distribution;
        if (string == null) {
            string = DEF_DISTRIBUTION;
        }
        String distributionName = string;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Aes.Companion.getX(), (Object)(sample != null ? '\"' + distributionName + "\" distribution quantiles" : x + " quantiles")), TuplesKt.to((Object)Aes.Companion.getY(), (Object)(sample != null ? sample + " quantiles" : y + " quantiles"))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - void declaration
     */
    private final List<LayerOptions> getMarginalLayers() {
        void $this$mapTo$iv$iv;
        if (Intrinsics.areEqual((Object)this.marginal, (Object)"none")) {
            return CollectionsKt.emptyList();
        }
        String[] stringArray = new String[]{","};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)this.marginal, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void layerDescription;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{":"};
            List params = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)((CharSequence)layerDescription))).toString(), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            if (!(params.size() >= 2)) {
                boolean $i$a$-require-QQPlotOptionsBuilder$getMarginalLayers$1$22 = false;
                String $i$a$-require-QQPlotOptionsBuilder$getMarginalLayers$1$22 = "Invalid format of the marginal parameter";
                throw new IllegalArgumentException($i$a$-require-QQPlotOptionsBuilder$getMarginalLayers$1$22.toString());
            }
            GeomKind geomKind = this.getMarginGeom(((Object)StringsKt.trim((CharSequence)((String)params.get(0)))).toString());
            Set<MarginSide> sides = MarginSide.Companion.parseSides(((Object)StringsKt.trim((CharSequence)((String)params.get(1)))).toString());
            String string2 = (String)CollectionsKt.getOrNull((List)params, (int)2);
            Double size = string2 != null && (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) != null ? Double.valueOf(Double.parseDouble(string2)) : null;
            Iterable $this$map$iv2 = sides;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void side;
                MarginSide marginSide = (MarginSide)((Object)item$iv$iv2);
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(this.getMarginalLayer(geomKind, (MarginSide)side, size));
            }
            collection.add((List)destination$iv$iv2);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    private final GeomKind getMarginGeom(String geom) {
        GeomKind geomKind;
        switch (geom) {
            case "density": 
            case "dens": {
                geomKind = GeomKind.DENSITY;
                break;
            }
            case "histogram": 
            case "hist": {
                geomKind = GeomKind.HISTOGRAM;
                break;
            }
            case "boxplot": 
            case "box": {
                geomKind = GeomKind.BOX_PLOT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown geom " + geom);
            }
        }
        return geomKind;
    }

    private final LayerOptions getMarginalLayer(GeomKind geomKind, MarginSide side, Double size) {
        LayerOptions layerOptions;
        Mapping mapping = this.getMarginalMappings(this.sample, this.x, this.y, this.group, side);
        String orientation = geomKind == GeomKind.BOX_PLOT ^ MarginSide.Companion.isVerticallyOriented(side) ? "y" : "x";
        LayerOptions it = layerOptions = new LayerOptions(null, 1, null);
        boolean bl = false;
        it.setGeom(geomKind);
        it.setData(this.statData);
        it.setMapping(mapping);
        it.setOrientation(orientation);
        it.setMarginal(true);
        it.setMarginSide(side.getValue());
        it.setMarginSize(size);
        it.setColor(this.color);
        it.setFill(this.fill);
        Double d = this.alpha;
        if (d == null) {
            d = 0.25;
        }
        it.setAlpha(d);
        return layerOptions;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, List<Object>> getStatData(Map<String, ? extends List<? extends Object>> data2, String distribution, List<Double> distributionParameters) {
        void $this$mapTo$iv$iv;
        if (this.sample == null) {
            return data2;
        }
        DataFrame originalDf = DataFrameUtil.INSTANCE.fromMap(data2);
        DataFrame.Variable sampleVar = DataFrameUtil.INSTANCE.findVariableOrFail(originalDf, this.sample);
        Map<Object, DataFrame> $this$map$iv = DataFrameExKt.groupBy(originalDf, this.group);
        boolean $i$f$map = false;
        Map<Object, DataFrame> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Collection collection;
            void $this$mapTo$iv$iv3;
            DataFrame groupDf;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            DataFrame df = groupDf = (DataFrame)entry.getValue();
            boolean bl2 = false;
            List<Integer> indices2 = CollectionsExKt.indicesOf((Iterable)df.getNumeric(sampleVar), (Function1)getStatData.statDf.1.1.indices.1.INSTANCE);
            DataFrame filteredDf = df.slice((Iterable)indices2);
            boolean bl3 = false;
            indices2 = this.sortedIndices(CollectionsKt.filterNotNull((Iterable)filteredDf.getNumeric(sampleVar)), (Function1)getStatData.statDf.1.2.indices.1.INSTANCE);
            DataFrame sortedDf = filteredDf.slice((Iterable)indices2);
            boolean bl4 = false;
            List statSample = sortedDf.getNumeric(sampleVar);
            Iterable $this$map$iv3 = (Iterable)new IntRange(1, statSample.size());
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv3;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator2 = $this$mapTo$iv$iv3.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv2;
                int n = item$iv$iv2 = ((IntIterator)iterator2).nextInt();
                collection = destination$iv$iv2;
                boolean bl5 = false;
                collection.add(((double)it - 0.5) / (double)statSample.size());
            }
            List t = (List)destination$iv$iv2;
            String string = distribution;
            if (string == null) {
                string = DEF_DISTRIBUTION;
            }
            QQStat.Distribution distribution2 = QQStat.Distribution.Companion.safeValueOf(string);
            List list = distributionParameters;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Function1 quantileFunction = QQStatUtil.INSTANCE.getQuantileFunction(distribution2, list);
            Iterable $i$f$map22 = t;
            DataFrame.Variable variable = THEORETICAL_VAR;
            collection = sortedDf;
            boolean $i$f$map3 = false;
            destination$iv$iv2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
                destination$iv$iv3.add(quantileFunction.invoke(item$iv$iv3));
            }
            List list2 = (List)destination$iv$iv3;
            collection2.add(DataFrameExKt.setColumn((DataFrame)collection, variable, list2));
        }
        List dataframes = (List)destination$iv$iv;
        boolean bl = false;
        DataFrame statDf2 = DataFrameUtil.concat$default((DataFrameUtil)DataFrameUtil.INSTANCE, (List)dataframes, (boolean)false, (int)2, null);
        return DataFrameUtil.INSTANCE.toMap(statDf2);
    }

    private final Mapping getMarginalMappings(String sample, String x, String y, String group, MarginSide side) {
        Mapping mapping;
        Mapping mapping2;
        Pair[] pairArray;
        if (MarginSide.Companion.isVerticallyOriented(side)) {
            pairArray = new Pair[1];
            Aes aes = Aes.Companion.getY();
            String string = sample;
            if (string == null) {
                String string2 = y;
                string = string2;
                Intrinsics.checkNotNull((Object)string2);
            }
            pairArray[0] = TuplesKt.to((Object)aes, (Object)string);
            Mapping mapping3 = new Mapping(pairArray);
            mapping2 = mapping3;
        } else {
            String string;
            pairArray = new Pair[1];
            Aes aes = Aes.Companion.getX();
            if (sample != null) {
                string = THEORETICAL_VAR.getName();
            } else {
                String string3 = x;
                string = string3;
                Intrinsics.checkNotNull((Object)string3);
            }
            pairArray[0] = TuplesKt.to((Object)aes, (Object)string);
            mapping2 = mapping = new Mapping(pairArray);
        }
        if (group != null) {
            mapping = mapping.plus(TuplesKt.to((Object)Aes.Companion.getCOLOR(), (Object)group));
            mapping = mapping.plus(TuplesKt.to((Object)Aes.Companion.getFILL(), (Object)group));
        }
        return mapping;
    }

    /*
     * WARNING - void declaration
     */
    private final <T, R extends Comparable<? super R>> List<Integer> sortedIndices(Iterable<? extends T> $this$sortedIndices, Function1<? super IndexedValue<? extends T>, ? extends R> selector) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)CollectionsKt.withIndex($this$sortedIndices), (Comparator)new Comparator(selector){
            final /* synthetic */ Function1 $selector;
            {
                this.$selector = $selector;
            }

            public final int compare(T a, T b) {
                Function1 function1 = this.$selector;
                return ComparisonsKt.compareValues((Comparable)((Comparable)function1.invoke(a)), (Comparable)((Comparable)function1.invoke(b)));
            }
        });
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            IndexedValue indexedValue = (IndexedValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getIndex());
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ List access$getMarginalLayers(QQPlotOptionsBuilder $this) {
        return $this.getMarginalLayers();
    }

    public static final /* synthetic */ String access$getSample$p(QQPlotOptionsBuilder $this) {
        return $this.sample;
    }

    public static final /* synthetic */ Options.PropSpec access$getDISTRIBUTION$cp() {
        return DISTRIBUTION;
    }

    public static final /* synthetic */ String access$getDistribution$p(QQPlotOptionsBuilder $this) {
        return $this.distribution;
    }

    public static final /* synthetic */ Options.PropSpec access$getDISTRIBUTION_PARAMETERS$cp() {
        return DISTRIBUTION_PARAMETERS;
    }

    public static final /* synthetic */ List access$getDistributionParameters$p(QQPlotOptionsBuilder $this) {
        return $this.distributionParameters;
    }

    public static final /* synthetic */ Options.PropSpec access$getQUANTILES$cp() {
        return QUANTILES;
    }

    public static final /* synthetic */ List access$getQuantiles$p(QQPlotOptionsBuilder $this) {
        return $this.quantiles;
    }

    public static final /* synthetic */ Map access$getStatData$p(QQPlotOptionsBuilder $this) {
        return $this.statData;
    }

    public static final /* synthetic */ Boolean access$getShowLegend$p(QQPlotOptionsBuilder $this) {
        return $this.showLegend;
    }

    public static final /* synthetic */ String access$getColor$p(QQPlotOptionsBuilder $this) {
        return $this.color;
    }

    public static final /* synthetic */ String access$getFill$p(QQPlotOptionsBuilder $this) {
        return $this.fill;
    }

    public static final /* synthetic */ Double access$getAlpha$p(QQPlotOptionsBuilder $this) {
        return $this.alpha;
    }

    public static final /* synthetic */ Double access$getSize$p(QQPlotOptionsBuilder $this) {
        return $this.size;
    }

    public static final /* synthetic */ Object access$getShape$p(QQPlotOptionsBuilder $this) {
        return $this.shape;
    }

    public static final /* synthetic */ String access$getLineColor$p(QQPlotOptionsBuilder $this) {
        return $this.lineColor;
    }

    public static final /* synthetic */ String access$getGroup$p(QQPlotOptionsBuilder $this) {
        return $this.group;
    }

    public static final /* synthetic */ Double access$getLineSize$p(QQPlotOptionsBuilder $this) {
        return $this.lineSize;
    }

    public static final /* synthetic */ Object access$getLineType$p(QQPlotOptionsBuilder $this) {
        return $this.lineType;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/core/spec/back/transform/bistro/qq/QQPlotOptionsBuilder$Companion;", "", "()V", "DEF_DISTRIBUTION", "", "DEF_LINE_COLOR", "getDEF_LINE_COLOR", "()Ljava/lang/String;", "DEF_LINE_SIZE", "", "DEF_MARGINAL", "DEF_MARGINAL_ALPHA", "DEF_POINT_ALPHA", "DEF_POINT_SIZE", "DISTRIBUTION", "Lorg/jetbrains/letsPlot/core/spec/plotson/Options$PropSpec;", "DISTRIBUTION_PARAMETERS", "", "QUANTILES", "THEORETICAL_VAR", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "getTHEORETICAL_VAR", "()Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "plot-stem"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDEF_LINE_COLOR() {
            return DEF_LINE_COLOR;
        }

        @NotNull
        public final DataFrame.Variable getTHEORETICAL_VAR() {
            return THEORETICAL_VAR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/spec/back/transform/bistro/qq/QQPlotOptionsBuilder$MarginSide;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "LEFT", "RIGHT", "TOP", "BOTTOM", "Companion", "plot-stem"})
    public static final class MarginSide
    extends Enum<MarginSide> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String value;
        public static final /* enum */ MarginSide LEFT;
        public static final /* enum */ MarginSide RIGHT;
        public static final /* enum */ MarginSide TOP;
        public static final /* enum */ MarginSide BOTTOM;
        private static final /* synthetic */ MarginSide[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private MarginSide(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public static MarginSide[] values() {
            return (MarginSide[])$VALUES.clone();
        }

        public static MarginSide valueOf(String value) {
            return Enum.valueOf(MarginSide.class, value);
        }

        @NotNull
        public static EnumEntries<MarginSide> getEntries() {
            return $ENTRIES;
        }

        static {
            LEFT = new MarginSide("l");
            RIGHT = new MarginSide("r");
            TOP = new MarginSide("t");
            BOTTOM = new MarginSide("b");
            $VALUES = marginSideArray = new MarginSide[]{MarginSide.LEFT, MarginSide.RIGHT, MarginSide.TOP, MarginSide.BOTTOM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/core/spec/back/transform/bistro/qq/QQPlotOptionsBuilder$MarginSide$Companion;", "", "()V", "isVerticallyOriented", "", "side", "Lorg/jetbrains/letsPlot/core/spec/back/transform/bistro/qq/QQPlotOptionsBuilder$MarginSide;", "parseSides", "", "sides", "", "plot-stem"})
        @SourceDebugExtension(value={"SMAP\nQQPlotOptionsBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QQPlotOptionsBuilder.kt\norg/jetbrains/letsPlot/core/spec/back/transform/bistro/qq/QQPlotOptionsBuilder$MarginSide$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,275:1\n766#2:276\n857#2,2:277\n*S KotlinDebug\n*F\n+ 1 QQPlotOptionsBuilder.kt\norg/jetbrains/letsPlot/core/spec/back/transform/bistro/qq/QQPlotOptionsBuilder$MarginSide$Companion\n*L\n251#1:276\n251#1:277,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Set<MarginSide> parseSides(@NotNull String sides) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)sides, (String)"sides");
                Iterable $this$filter$iv = (Iterable)MarginSide.getEntries();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    MarginSide it = (MarginSide)((Object)element$iv$iv);
                    boolean bl = false;
                    if (!StringsKt.contains$default((CharSequence)sides, (CharSequence)it.getValue(), (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            }

            public final boolean isVerticallyOriented(@NotNull MarginSide side) {
                Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
                MarginSide[] marginSideArray = new MarginSide[]{LEFT, RIGHT};
                return CollectionsKt.listOf((Object[])marginSideArray).contains((Object)side);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

