/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.back.transform.bistro.corr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.data.DataFrameUtil;
import org.jetbrains.letsPlot.core.spec.back.transform.bistro.corr.CorrVar;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J`\u0010\u0003\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00070\u00042\u001a\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\u00042$\u0010\n\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t\u0012\u0004\u0012\u00020\u00070\u000bJN\u0010\f\u001a\u00020\u00072\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\t2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\t2$\u0010\n\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t\u0012\u0004\u0012\u00020\u00070\u000bH\u0002J:\u0010\u000f\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00070\u00042\u001a\u0010\u0010\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\u0004J>\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\u00042\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\tJt\u0010\u0016\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t0\u00052\u001e\u0010\u0017\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00070\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b\u00a8\u0006 "}, d2={"Lorg/jetbrains/letsPlot/core/spec/back/transform/bistro/corr/CorrUtil;", "", "()V", "computeCorrelations", "", "Lkotlin/Pair;", "", "", "data", "", "corrFun", "Lkotlin/Function2;", "correlation", "xs", "ys", "correlationsFromCoefficients", "coeff", "correlationsToDataframe", "cm", "Lorg/jetbrains/letsPlot/core/spec/back/transform/bistro/corr/CorrUtil$CorrMatrix;", "xSeries", "ySeries", "matrixXYSeries", "correlations", "variablesInOrder", "type", "nullDiag", "", "threshold", "dropDiagNA", "dropOtherNA", "CorrMatrix", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nCorrUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CorrUtil.kt\norg/jetbrains/letsPlot/core/spec/back/transform/bistro/corr/CorrUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,173:1\n766#2:174\n857#2,2:175\n1238#2,4:179\n1864#2,3:184\n468#3:177\n414#3:178\n215#4:183\n216#4:187\n*S KotlinDebug\n*F\n+ 1 CorrUtil.kt\norg/jetbrains/letsPlot/core/spec/back/transform/bistro/corr/CorrUtil\n*L\n19#1:174\n19#1:175,2\n36#1:179,4\n50#1:184,3\n36#1:177\n36#1:178\n49#1:183\n49#1:187\n*E\n"})
public final class CorrUtil {
    @NotNull
    public static final CorrUtil INSTANCE = new CorrUtil();

    private CorrUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Pair<String, String>, Double> computeCorrelations(@NotNull Map<String, ? extends List<? extends Object>> data2, @NotNull Function2<? super List<Double>, ? super List<Double>, Double> corrFun) {
        void $this$mapKeysTo$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(data2, (String)"data");
        Intrinsics.checkNotNullParameter(corrFun, (String)"corrFun");
        DataFrame df = DataFrameUtil.INSTANCE.fromMap(data2);
        Iterable $this$filter$iv = df.variables();
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DataFrame.Variable it = (DataFrame.Variable)element$iv$iv;
            boolean bl = false;
            if (!df.isNumeric(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List numerics = (List)destination$iv$iv;
        LinkedHashMap correlations2 = new LinkedHashMap();
        for (DataFrame.Variable variable : numerics) {
            ((Map)correlations2).put(TuplesKt.to((Object)variable, (Object)variable), 1.0);
        }
        Iterator $i$f$filter22 = numerics.iterator();
        int variable = 0;
        while ($i$f$filter22.hasNext()) {
            int i = variable++;
            DataFrame.Variable vx = (DataFrame.Variable)$i$f$filter22.next();
            List xs = df.getNumeric(vx);
            for (int j = 0; j < i; ++j) {
                DataFrame.Variable vy = (DataFrame.Variable)numerics.get(j);
                List ys = df.getNumeric(vy);
                ((Map)correlations2).put(TuplesKt.to((Object)vx, (Object)vy), this.correlation(xs, ys, corrFun));
            }
        }
        Map $this$mapKeys$iv = correlations2;
        boolean $i$f$mapKeys = false;
        Map i = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Pair pair = new Pair((Object)((DataFrame.Variable)((Pair)it.getKey()).getFirst()).getLabel(), (Object)((DataFrame.Variable)((Pair)it.getKey()).getSecond()).getLabel());
            Map map3 = map2;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map3.put(pair, entry);
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Pair<String, String>, Double> correlationsFromCoefficients(@NotNull Map<String, ? extends List<? extends Object>> coeff) {
        Intrinsics.checkNotNullParameter(coeff, (String)"coeff");
        LinkedHashMap correlations2 = new LinkedHashMap();
        Map<String, ? extends List<? extends Object>> $this$forEach$iv = coeff;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends List<? extends Object>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends List<? extends Object>> element$iv;
            Map.Entry<String, ? extends List<? extends Object>> entry = element$iv = iterator.next();
            boolean bl = false;
            String vx = entry.getKey();
            List<? extends Object> vxCoeffs = entry.getValue();
            Iterable $this$forEachIndexed$iv = coeff.keySet();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void vy;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int vyIndex = n;
                boolean bl2 = false;
                Map map2 = correlations2;
                Pair pair = TuplesKt.to((Object)vx, (Object)vy);
                Object object = vxCoeffs.get(vyIndex);
                Double d = object instanceof Double ? (Double)object : null;
                Double d2 = d != null ? d : Double.NaN;
                map2.put(pair, d2);
            }
        }
        return correlations2;
    }

    private final double correlation(List<Double> xs, List<Double> ys, Function2<? super List<Double>, ? super List<Double>, Double> corrFun) {
        List filtered = SeriesUtil.INSTANCE.filterFinite(xs, ys);
        List xs2 = (List)filtered.get(0);
        List ys2 = (List)filtered.get(1);
        return ((Number)corrFun.invoke((Object)xs2, (Object)ys2)).doubleValue();
    }

    @NotNull
    public final Pair<List<String>, List<String>> matrixXYSeries(@NotNull Map<Pair<String, String>, Double> correlations2, @NotNull List<String> variablesInOrder, @NotNull String type, boolean nullDiag, double threshold, boolean dropDiagNA, boolean dropOtherNA) {
        Intrinsics.checkNotNullParameter(correlations2, (String)"correlations");
        Intrinsics.checkNotNullParameter(variablesInOrder, (String)"variablesInOrder");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ArrayList<String> xs = new ArrayList<String>();
        ArrayList<String> ys = new ArrayList<String>();
        CorrMatrix cm = new CorrMatrix(correlations2, nullDiag, threshold);
        Iterator<String> iterator = variablesInOrder.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int ix = n++;
            String x = iterator.next();
            String string = type;
            List<String> iterY = Intrinsics.areEqual((Object)string, (Object)"upper") ? variablesInOrder.subList(ix, variablesInOrder.size()) : (Intrinsics.areEqual((Object)string, (Object)"lower") ? variablesInOrder.subList(0, ix + 1) : variablesInOrder);
            for (String y : iterY) {
                Double v = cm.value(x, y);
                if (v == null && (dropDiagNA && Intrinsics.areEqual((Object)x, (Object)y) || dropOtherNA && !Intrinsics.areEqual((Object)x, (Object)y))) continue;
                xs.add(x);
                ys.add(y);
            }
        }
        return new Pair(xs, ys);
    }

    @NotNull
    public final Map<String, List<Object>> correlationsToDataframe(@NotNull CorrMatrix cm, @NotNull List<String> xSeries, @NotNull List<String> ySeries) {
        Intrinsics.checkNotNullParameter((Object)cm, (String)"cm");
        Intrinsics.checkNotNullParameter(xSeries, (String)"xSeries");
        Intrinsics.checkNotNullParameter(ySeries, (String)"ySeries");
        ArrayList<String> corrX = new ArrayList<String>();
        ArrayList<String> corrY = new ArrayList<String>();
        ArrayList<Double> corr = new ArrayList<Double>();
        ArrayList<Double> corrAbs = new ArrayList<Double>();
        for (Pair pair : CollectionsKt.zip((Iterable)xSeries, (Iterable)ySeries)) {
            String x = (String)pair.component1();
            String y = (String)pair.component2();
            Double d = cm.value(x, y);
            if (d == null) {
                continue;
            }
            double v = d;
            corrX.add(x);
            corrY.add(y);
            corr.add(v);
            corrAbs.add(Math.abs(v));
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)CorrVar.INSTANCE.getX(), corrX), TuplesKt.to((Object)CorrVar.INSTANCE.getY(), corrY), TuplesKt.to((Object)CorrVar.INSTANCE.getCORR(), corr), TuplesKt.to((Object)CorrVar.INSTANCE.getCORR_ABS(), corrAbs)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ(\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0012R&\u0010\u0002\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/core/spec/back/transform/bistro/corr/CorrUtil$CorrMatrix;", "", "correlations", "", "Lkotlin/Pair;", "", "", "nullDiag", "", "threshold", "(Ljava/util/Map;ZD)V", "toKey", "pair", "s0", "s1", "value", "x", "y", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Double;", "plot-stem"})
    @SourceDebugExtension(value={"SMAP\nCorrUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CorrUtil.kt\norg/jetbrains/letsPlot/core/spec/back/transform/bistro/corr/CorrUtil$CorrMatrix\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n468#2:174\n414#2:175\n1238#3,4:176\n*S KotlinDebug\n*F\n+ 1 CorrUtil.kt\norg/jetbrains/letsPlot/core/spec/back/transform/bistro/corr/CorrUtil$CorrMatrix\n*L\n148#1:174\n148#1:175\n148#1:176,4\n*E\n"})
    public static final class CorrMatrix {
        private final boolean nullDiag;
        private final double threshold;
        @NotNull
        private final Map<Pair<String, String>, Double> correlations;

        /*
         * WARNING - void declaration
         */
        public CorrMatrix(@NotNull Map<Pair<String, String>, Double> correlations2, boolean nullDiag, double threshold) {
            void $this$mapKeysTo$iv$iv;
            void $this$mapKeys$iv;
            Intrinsics.checkNotNullParameter(correlations2, (String)"correlations");
            this.nullDiag = nullDiag;
            this.threshold = threshold;
            Map<Pair<String, String>, Double> map2 = correlations2;
            CorrMatrix corrMatrix = this;
            boolean $i$f$mapKeys = false;
            void var7_7 = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Pair<String, String> pair = this.toKey((Pair<String, String>)((Pair)it.getKey()));
                Map map4 = map3;
                boolean bl2 = false;
                Object v = it$iv$iv.getValue();
                map4.put(pair, v);
            }
            corrMatrix.correlations = destination$iv$iv;
        }

        private final Pair<String, String> toKey(String s0, String s1) {
            return s0.compareTo(s1) < 0 ? TuplesKt.to((Object)s0, (Object)s1) : TuplesKt.to((Object)s1, (Object)s0);
        }

        private final Pair<String, String> toKey(Pair<String, String> pair) {
            return this.toKey((String)pair.getFirst(), (String)pair.getSecond());
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Double value(@NotNull String x, @NotNull String y) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            if (Intrinsics.areEqual((Object)x, (Object)y) && this.nullDiag) {
                object = null;
            } else {
                void var3_3;
                Double v = this.correlations.get(this.toKey(x, y));
                object = v == null ? null : (Math.abs(v) < this.threshold ? null : var3_3);
            }
            return object;
        }
    }
}

