/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.back;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.logging.Logger;
import org.jetbrains.letsPlot.commons.logging.PortableLogging;
import org.jetbrains.letsPlot.core.spec.FailureHandler;
import org.jetbrains.letsPlot.core.spec.FigKind;
import org.jetbrains.letsPlot.core.spec.OptionsSelectorKt;
import org.jetbrains.letsPlot.core.spec.back.PlotConfigBackend;
import org.jetbrains.letsPlot.core.spec.back.SpecGGBunchTransformBackendUtil;
import org.jetbrains.letsPlot.core.spec.back.SpecIdGeneration;
import org.jetbrains.letsPlot.core.spec.back.transform.PlotConfigBackendTransforms;
import org.jetbrains.letsPlot.core.spec.config.PlotConfig;
import org.jetbrains.letsPlot.core.spec.vegalite.VegaConfig;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0005\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007\u0012\u0004\u0012\u00020\t0\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0000\u00a2\u0006\u0002\b\u000bJ7\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00072\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002J(\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00072\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0002J(\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00072\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0017H\u0002J(\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0002J4\u0010\u0019\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007\u0012\u0004\u0012\u00020\t0\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0002J\u001c\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/core/spec/back/SpecTransformBackendUtil;", "", "()V", "LOG", "Lorg/jetbrains/letsPlot/commons/logging/Logger;", "getTransformedSpecsAndPlotConfig", "Lkotlin/Pair;", "", "", "Lorg/jetbrains/letsPlot/core/spec/back/PlotConfigBackend;", "plotSpecRaw", "getTransformedSpecsAndPlotConfig$plot_stem", "processTransform", "simulateFailure", "", "processTransform$plot_stem", "processTransformFigureList", "", "figureListRaw", "processTransformInBunch", "bunchSpecRaw", "processTransformInSubPlots", "compositeFigureSpecRaw", "", "processTransformIntern", "processTransformIntern2", "throwTestingException", "", "plotSpec", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nSpecTransformBackendUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecTransformBackendUtil.kt\norg/jetbrains/letsPlot/core/spec/back/SpecTransformBackendUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n1549#2:201\n1620#2,3:202\n*S KotlinDebug\n*F\n+ 1 SpecTransformBackendUtil.kt\norg/jetbrains/letsPlot/core/spec/back/SpecTransformBackendUtil\n*L\n91#1:201\n91#1:202,3\n*E\n"})
public final class SpecTransformBackendUtil {
    @NotNull
    public static final SpecTransformBackendUtil INSTANCE = new SpecTransformBackendUtil();
    @NotNull
    private static final Logger LOG = PortableLogging.INSTANCE.logger(Reflection.getOrCreateKotlinClass(SpecTransformBackendUtil.class));

    private SpecTransformBackendUtil() {
    }

    @NotNull
    public final Map<String, Object> processTransform$plot_stem(@NotNull Map<String, Object> plotSpecRaw, boolean simulateFailure) {
        Map<String, Object> map2;
        Intrinsics.checkNotNullParameter(plotSpecRaw, (String)"plotSpecRaw");
        List<?> vegaLiteConverterSummary = null;
        try {
            Map<String, Object> map3;
            Map<String, Object> map4;
            if (simulateFailure) {
                boolean isInternal;
                Object object = MapsKt.getValue(plotSpecRaw, (Object)"message");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String message = (String)object;
                Object object2 = MapsKt.getValue(plotSpecRaw, (Object)"is_internal");
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Boolean");
                boolean bl = isInternal = ((Boolean)object2).booleanValue();
                if (bl) {
                    throw new IllegalStateException(message);
                }
                if (!bl) {
                    throw new IllegalArgumentException(message);
                }
                throw new NoWhenBranchMatchedException();
            }
            if (VegaConfig.INSTANCE.isVegaLiteSpec(plotSpecRaw)) {
                Map vegaSpec = TypeIntrinsics.asMutableMap(plotSpecRaw);
                Map<String, Object> letsPlotSpec = VegaConfig.INSTANCE.toLetsPlotSpec(vegaSpec);
                Object[] objectArray = new Object[]{"computation_messages"};
                vegaLiteConverterSummary = OptionsSelectorKt.getList(letsPlotSpec, objectArray);
                map4 = letsPlotSpec;
            } else {
                map4 = plotSpecRaw;
            }
            Map<String, Object> spec = map4;
            switch (WhenMappings.$EnumSwitchMapping$0[PlotConfig.Companion.figSpecKind(spec).ordinal()]) {
                case 1: {
                    map3 = this.processTransformIntern(spec);
                    break;
                }
                case 2: {
                    map3 = this.processTransformInSubPlots(spec);
                    break;
                }
                case 3: {
                    Map<String, Object> bunchSpecOld = this.processTransformInBunch(spec);
                    map3 = SpecGGBunchTransformBackendUtil.INSTANCE.ggbunchFromGGBunch(bunchSpecOld);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            map2 = map3;
        }
        catch (RuntimeException e) {
            FailureHandler.FailureInfo failureInfo = FailureHandler.INSTANCE.failureInfo(e);
            if (failureInfo.isInternalError()) {
                LOG.error((Throwable)e, (Function0)new Function0<String>(failureInfo){
                    final /* synthetic */ FailureHandler.FailureInfo $failureInfo;
                    {
                        this.$failureInfo = $failureInfo;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return this.$failureInfo.getMessage();
                    }
                });
            }
            String message = vegaLiteConverterSummary == null ? failureInfo.getMessage() : failureInfo.getMessage() + "\n\nVega-Lite converter messages:\n" + CollectionsKt.joinToString$default((Iterable)vegaLiteConverterSummary, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            map2 = (Map<String, Object>)new HashMap<String, Object>(PlotConfig.Companion.failure(message));
        }
        return map2;
    }

    public static /* synthetic */ Map processTransform$plot_stem$default(SpecTransformBackendUtil specTransformBackendUtil, Map map2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return specTransformBackendUtil.processTransform$plot_stem(map2, bl);
    }

    private final Map<String, Object> processTransformInSubPlots(Map<String, ? extends Object> compositeFigureSpecRaw) {
        HashMap<String, ? extends Object> hashMap;
        HashMap<String, ? extends Object> $this$processTransformInSubPlots_u24lambda_u240 = hashMap = new HashMap<String, Object>(compositeFigureSpecRaw);
        boolean bl = false;
        Object object = $this$processTransformInSubPlots_u24lambda_u240.get("figures");
        List list = object instanceof List ? (List)object : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List figures = list;
        ((Map)$this$processTransformInSubPlots_u24lambda_u240).put("figures", INSTANCE.processTransformFigureList(figures));
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Object> processTransformFigureList(List<?> figureListRaw) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = figureListRaw;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> map2;
            void figRaw;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (figRaw == null || Intrinsics.areEqual((Object)figRaw, (Object)"blank")) {
                map2 = "blank";
            } else {
                if (!(figRaw instanceof Map)) {
                    throw new IllegalArgumentException("Subplots: a figure spec (a Map) expected but was: " + Reflection.getOrCreateKotlinClass(figRaw.getClass()).getSimpleName());
                }
                HashMap figCopy = new HashMap((Map)figRaw);
                switch (WhenMappings.$EnumSwitchMapping$0[PlotConfig.Companion.figSpecKind(figCopy).ordinal()]) {
                    case 1: {
                        map2 = INSTANCE.processTransformIntern(figCopy);
                        break;
                    }
                    case 2: {
                        map2 = INSTANCE.processTransformInSubPlots(figCopy);
                        break;
                    }
                    case 3: {
                        throw new IllegalStateException("GGBunch is not expected among subplots.");
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            collection.add(map2);
        }
        return (List)destination$iv$iv;
    }

    private final Map<String, Object> processTransformInBunch(Map<String, Object> bunchSpecRaw) {
        if (!bunchSpecRaw.containsKey("items")) {
            bunchSpecRaw.put("items", CollectionsKt.emptyList());
            return bunchSpecRaw;
        }
        Object object = bunchSpecRaw.get("items");
        Intrinsics.checkNotNull((Object)object);
        Object itemsRaw = object;
        if (!(itemsRaw instanceof List)) {
            throw new IllegalArgumentException("GGBunch: list of features expected but was: " + Reflection.getOrCreateKotlinClass(itemsRaw.getClass()).getSimpleName());
        }
        ArrayList items = new ArrayList();
        for (Object rawItem : (List)itemsRaw) {
            Object featureSpecRaw;
            if (!(rawItem instanceof Map)) {
                StringBuilder stringBuilder = new StringBuilder().append("GGBunch item: Map of attributes expected but was: ");
                Object e = rawItem;
                Intrinsics.checkNotNull(e);
                throw new IllegalArgumentException(stringBuilder.append(Reflection.getOrCreateKotlinClass(e.getClass()).getSimpleName()).toString());
            }
            HashMap item = new HashMap((Map)rawItem);
            if (!item.containsKey("feature_spec")) {
                throw new IllegalArgumentException("GGBunch item: absent required attribute: feature_spec");
            }
            Intrinsics.checkNotNull(item.get("feature_spec"));
            if (!(featureSpecRaw instanceof Map)) {
                throw new IllegalArgumentException("GGBunch item 'feature_spec' : Map of attributes expected but was: " + Reflection.getOrCreateKotlinClass(featureSpecRaw.getClass()).getSimpleName());
            }
            HashMap featureSpec = new HashMap((Map)featureSpecRaw);
            FigKind kind = PlotConfig.Companion.figSpecKind(featureSpec);
            if (kind != FigKind.PLOT_SPEC) {
                throw new IllegalArgumentException((Object)((Object)FigKind.PLOT_SPEC) + " expected but was: " + (Object)((Object)kind));
            }
            Map<String, Object> plotSpec = this.processTransformIntern(featureSpec);
            ((Map)item).put("feature_spec", plotSpec);
            items.add(item);
        }
        bunchSpecRaw.put("items", items);
        return bunchSpecRaw;
    }

    private final Map<String, Object> processTransformIntern(Map<String, Object> plotSpecRaw) {
        Map plotSpec = (Map)this.processTransformIntern2(plotSpecRaw).component1();
        return plotSpec;
    }

    @NotNull
    public final Pair<Map<String, Object>, PlotConfigBackend> getTransformedSpecsAndPlotConfig$plot_stem(@NotNull Map<String, Object> plotSpecRaw) {
        Intrinsics.checkNotNullParameter(plotSpecRaw, (String)"plotSpecRaw");
        return this.processTransformIntern2(plotSpecRaw);
    }

    private final Pair<Map<String, Object>, PlotConfigBackend> processTransformIntern2(Map<String, Object> plotSpecRaw) {
        Map<String, Object> plotSpec = PlotConfigBackendTransforms.INSTANCE.migrationTransform().apply(plotSpecRaw);
        plotSpec = PlotConfigBackendTransforms.INSTANCE.bistroTransform().apply(plotSpec);
        plotSpec = PlotConfigBackendTransforms.INSTANCE.entryTransform().apply(plotSpec);
        if (SpecIdGeneration.INSTANCE.getEnabled()) {
            plotSpec.put("spec_id", SpecIdGeneration.INSTANCE.nextId());
        }
        PlotConfigBackend plotConfig = new PlotConfigBackend((Map<String, ? extends Object>)plotSpec, null);
        plotConfig.updatePlotSpec$plot_stem();
        return new Pair(plotSpec, (Object)plotConfig);
    }

    private final void throwTestingException(Map<String, ? extends Object> plotSpec) {
        if (plotSpec.containsKey("ggtitle")) {
            Object object = plotSpec.get("ggtitle");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            Object v = ((Map)object).get("text");
            Intrinsics.checkNotNull(v);
            Object title = v;
            if (Intrinsics.areEqual((Object)"Throw testing exception", title)) {
                throw new IllegalArgumentException("User configuration error");
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FigKind.values().length];
            try {
                nArray[FigKind.PLOT_SPEC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FigKind.SUBPLOTS_SPEC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FigKind.GG_BUNCH_SPEC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

