/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.string.StringFormat;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.datetime.TimeZone;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Geom;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.geom.AreaGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.AreaRidgesGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.BandGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.BoxplotGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.CrossBarGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.CurveGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.DensityGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.DimensionUnit;
import org.jetbrains.letsPlot.core.plot.base.geom.DotplotGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.ErrorBarGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.HexGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.ImageGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.LabelGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.LabelRepelGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.LollipopGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.PathGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.PieGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.PointGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.PointRangeGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.SegmentGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.SinaGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.SpokeGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.StepGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.TextGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.TextRepelGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.TileGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.ViolinGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.YDotplotGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.repel.LabelForceLayout;
import org.jetbrains.letsPlot.core.plot.base.geom.util.LabelOptions;
import org.jetbrains.letsPlot.core.plot.base.stat.DotplotStat;
import org.jetbrains.letsPlot.core.plot.base.theme.ExponentFormat;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotAssembler;
import org.jetbrains.letsPlot.core.plot.builder.assemble.geom.GeomProvider;
import org.jetbrains.letsPlot.core.spec.Option;
import org.jetbrains.letsPlot.core.spec.config.ArrowSpecConfig;
import org.jetbrains.letsPlot.core.spec.config.LayerConfig;
import org.jetbrains.letsPlot.core.spec.config.OptionsAccessor;
import org.jetbrains.letsPlot.core.spec.conversion.AesOptionConversion;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J*\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J0\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001eH\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001eH\u0002R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/letsPlot/core/spec/GeomProviderFactory;", "", "()V", "PROVIDER", "Ljava/util/HashMap;", "Lorg/jetbrains/letsPlot/core/plot/base/GeomKind;", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/geom/GeomProvider;", "Lkotlin/collections/HashMap;", "applyLabelOptions", "", "layerConfig", "Lorg/jetbrains/letsPlot/core/spec/config/LayerConfig;", "factory", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/LabelOptions;", "applyRepelOptions", "geom", "Lorg/jetbrains/letsPlot/core/plot/base/geom/TextRepelGeom;", "applyTextOptions", "Lorg/jetbrains/letsPlot/core/plot/base/geom/TextGeom;", "expFormat", "Lorg/jetbrains/letsPlot/core/plot/base/theme/ExponentFormat;", "tz", "Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;", "createGeomProvider", "geomKind", "aopConversion", "Lorg/jetbrains/letsPlot/core/spec/conversion/AesOptionConversion;", "dimensionUnit", "Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "option", "", "directionValue", "Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/LabelForceLayout$Direction;", "value", "isVertical", "", "ctx", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/geom/GeomProvider$Context;", "geomName", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nGeomProviderFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeomProviderFactory.kt\norg/jetbrains/letsPlot/core/spec/GeomProviderFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,561:1\n1#2:562\n1747#3,3:563\n1747#3,3:566\n*S KotlinDebug\n*F\n+ 1 GeomProviderFactory.kt\norg/jetbrains/letsPlot/core/spec/GeomProviderFactory\n*L\n527#1:563,3\n528#1:566,3\n*E\n"})
public final class GeomProviderFactory {
    @NotNull
    public static final GeomProviderFactory INSTANCE = new GeomProviderFactory();
    @NotNull
    private static final HashMap<GeomKind, GeomProvider> PROVIDER = new HashMap();

    private GeomProviderFactory() {
    }

    @NotNull
    public final GeomProvider createGeomProvider(@NotNull GeomKind geomKind, @NotNull LayerConfig layerConfig, @NotNull AesOptionConversion aopConversion, @NotNull ExponentFormat expFormat, @Nullable TimeZone tz) {
        GeomProvider geomProvider;
        Intrinsics.checkNotNullParameter((Object)geomKind, (String)"geomKind");
        Intrinsics.checkNotNullParameter((Object)layerConfig, (String)"layerConfig");
        Intrinsics.checkNotNullParameter((Object)aopConversion, (String)"aopConversion");
        Intrinsics.checkNotNullParameter((Object)expFormat, (String)"expFormat");
        switch (WhenMappings.$EnumSwitchMapping$0[geomKind.ordinal()]) {
            case 1: {
                geomProvider = GeomProvider.Companion.area((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ LayerConfig $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        AreaGeom geom = new AreaGeom();
                        if (this.$layerConfig.hasOwn("flat")) {
                            geom.setFlat(OptionsAccessor.getBoolean$default(this.$layerConfig, "flat", false, 2, null));
                        }
                        return (Geom)geom;
                    }
                });
                break;
            }
            case 2: {
                geomProvider = GeomProvider.Companion.density((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ LayerConfig $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        DensityGeom geom = new DensityGeom();
                        if (this.$layerConfig.hasOwn("quantiles")) {
                            geom.setQuantiles(this.$layerConfig.getBoundedDoubleList("quantiles", 0.0, 1.0));
                        }
                        if (this.$layerConfig.hasOwn("quantile_lines")) {
                            geom.setQuantileLines(this.$layerConfig.getBoolean("quantile_lines", false));
                        }
                        return (Geom)geom;
                    }
                });
                break;
            }
            case 3: {
                geomProvider = GeomProvider.Companion.dotplot((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ LayerConfig $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        DotplotGeom geom;
                        block20: {
                            DotplotGeom.Stackdir stackdir;
                            void it2;
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            geom = new DotplotGeom();
                            if (this.$layerConfig.hasOwn("dotsize")) {
                                Double d = this.$layerConfig.getDouble("dotsize");
                                Intrinsics.checkNotNull((Object)d);
                                geom.setDotSize(d.doubleValue());
                            }
                            if (this.$layerConfig.hasOwn("stackratio")) {
                                Double d = this.$layerConfig.getDouble("stackratio");
                                Intrinsics.checkNotNull((Object)d);
                                geom.setStackRatio(d.doubleValue());
                            }
                            if (this.$layerConfig.hasOwn("stackgroups")) {
                                geom.setStackGroups(OptionsAccessor.getBoolean$default(this.$layerConfig, "stackgroups", false, 2, null));
                            }
                            if (!this.$layerConfig.hasOwn("stackdir")) break block20;
                            String string = this.$layerConfig.getString("stackdir");
                            Intrinsics.checkNotNull((Object)string);
                            String string2 = string;
                            DotplotGeom dotplotGeom = geom;
                            boolean bl = false;
                            String string3 = it2.toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                            switch (string3) {
                                case "up": {
                                    stackdir = DotplotGeom.Stackdir.UP;
                                    break;
                                }
                                case "down": {
                                    stackdir = DotplotGeom.Stackdir.DOWN;
                                    break;
                                }
                                case "center": {
                                    stackdir = DotplotGeom.Stackdir.CENTER;
                                    break;
                                }
                                case "centerwhole": {
                                    stackdir = DotplotGeom.Stackdir.CENTERWHOLE;
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unsupported stackdir: '" + (String)it2 + "'. Use one of: up, down, center, centerwhole.");
                                }
                            }
                            dotplotGeom.setStackDir(stackdir);
                        }
                        if (this.$layerConfig.hasOwn("method")) {
                            String string = this.$layerConfig.getString("method");
                            Intrinsics.checkNotNull((Object)string);
                            geom.setMethod(DotplotStat.Method.Companion.safeValueOf(string));
                        }
                        return (Geom)geom;
                    }
                });
                break;
            }
            case 4: {
                geomProvider = GeomProvider.Companion.tile((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ LayerConfig $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        TileGeom tileGeom = new TileGeom();
                        LayerConfig layerConfig = this.$layerConfig;
                        TileGeom $this$invoke_u24lambda_u240 = tileGeom;
                        boolean bl = false;
                        DimensionUnit dimensionUnit = GeomProviderFactory.access$dimensionUnit(GeomProviderFactory.INSTANCE, layerConfig, "width_unit");
                        if (dimensionUnit == null) {
                            dimensionUnit = TileGeom.Companion.getDEF_WIDTH_UNIT();
                        }
                        $this$invoke_u24lambda_u240.setWidthUnit(dimensionUnit);
                        DimensionUnit dimensionUnit2 = GeomProviderFactory.access$dimensionUnit(GeomProviderFactory.INSTANCE, layerConfig, "height_unit");
                        if (dimensionUnit2 == null) {
                            dimensionUnit2 = TileGeom.Companion.getDEF_HEIGHT_UNIT();
                        }
                        $this$invoke_u24lambda_u240.setHeightUnit(dimensionUnit2);
                        return (Geom)tileGeom;
                    }
                });
                break;
            }
            case 5: {
                geomProvider = GeomProvider.Companion.hex((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ LayerConfig $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        HexGeom hexGeom = new HexGeom();
                        LayerConfig layerConfig = this.$layerConfig;
                        HexGeom $this$invoke_u24lambda_u240 = hexGeom;
                        boolean bl = false;
                        DimensionUnit dimensionUnit = GeomProviderFactory.access$dimensionUnit(GeomProviderFactory.INSTANCE, layerConfig, "width_unit");
                        if (dimensionUnit == null) {
                            dimensionUnit = HexGeom.Companion.getDEF_WIDTH_UNIT();
                        }
                        $this$invoke_u24lambda_u240.setWidthUnit(dimensionUnit);
                        DimensionUnit dimensionUnit2 = GeomProviderFactory.access$dimensionUnit(GeomProviderFactory.INSTANCE, layerConfig, "height_unit");
                        if (dimensionUnit2 == null) {
                            dimensionUnit2 = HexGeom.Companion.getDEF_HEIGHT_UNIT();
                        }
                        $this$invoke_u24lambda_u240.setHeightUnit(dimensionUnit2);
                        return (Geom)hexGeom;
                    }
                });
                break;
            }
            case 6: {
                geomProvider = GeomProvider.Companion.errorBar((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ LayerConfig $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ErrorBarGeom errorBarGeom = new ErrorBarGeom();
                        LayerConfig layerConfig = this.$layerConfig;
                        ErrorBarGeom $this$invoke_u24lambda_u240 = errorBarGeom;
                        boolean bl = false;
                        if (layerConfig.hasOwn("width_unit")) {
                            DimensionUnit dimensionUnit = GeomProviderFactory.access$dimensionUnit(GeomProviderFactory.INSTANCE, layerConfig, "width_unit");
                            Intrinsics.checkNotNull((Object)dimensionUnit);
                            $this$invoke_u24lambda_u240.setWidthUnit(dimensionUnit);
                        }
                        return (Geom)errorBarGeom;
                    }
                });
                break;
            }
            case 7: {
                geomProvider = GeomProvider.Companion.crossBar((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig, geomKind){
                    final /* synthetic */ LayerConfig $layerConfig;
                    final /* synthetic */ GeomKind $geomKind;
                    {
                        this.$layerConfig = $layerConfig;
                        this.$geomKind = $geomKind;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context ctx2) {
                        boolean midlineIsMapped;
                        boolean isVertical;
                        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
                        CrossBarGeom geom = new CrossBarGeom();
                        if (this.$layerConfig.hasOwn("fatten")) {
                            Double d = this.$layerConfig.getDouble("fatten");
                            Intrinsics.checkNotNull((Object)d);
                            geom.setFattenMidline(d.doubleValue());
                        }
                        Aes midlineAes = (isVertical = GeomProviderFactory.access$isVertical(GeomProviderFactory.INSTANCE, ctx2, this.$geomKind.name())) ? Aes.Companion.getY() : Aes.Companion.getX();
                        boolean bl = midlineIsMapped = ctx2.hasBinding(midlineAes) || ctx2.hasConstant(midlineAes);
                        if (!midlineIsMapped) {
                            geom.setFattenMidline(0.0);
                        }
                        if (this.$layerConfig.hasOwn("width_unit")) {
                            DimensionUnit dimensionUnit = GeomProviderFactory.access$dimensionUnit(GeomProviderFactory.INSTANCE, this.$layerConfig, "width_unit");
                            Intrinsics.checkNotNull((Object)dimensionUnit);
                            geom.setWidthUnit(dimensionUnit);
                        }
                        return (Geom)geom;
                    }
                });
                break;
            }
            case 8: {
                geomProvider = GeomProvider.Companion.pointRange((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ LayerConfig $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        PointRangeGeom geom = new PointRangeGeom();
                        if (this.$layerConfig.hasOwn("fatten")) {
                            Double d = this.$layerConfig.getDouble("fatten");
                            Intrinsics.checkNotNull((Object)d);
                            geom.setFattenMidPoint(d.doubleValue());
                        }
                        return (Geom)geom;
                    }
                });
                break;
            }
            case 9: {
                geomProvider = GeomProvider.Companion.band((Function1)new Function1<GeomProvider.Context, Geom>(geomKind){
                    final /* synthetic */ GeomKind $geomKind;
                    {
                        this.$geomKind = $geomKind;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context ctx2) {
                        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
                        return (Geom)new BandGeom(GeomProviderFactory.access$isVertical(GeomProviderFactory.INSTANCE, ctx2, this.$geomKind.name()));
                    }
                });
                break;
            }
            case 10: {
                geomProvider = GeomProvider.Companion.boxplot((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ LayerConfig $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        BoxplotGeom geom = new BoxplotGeom();
                        if (this.$layerConfig.hasOwn("fatten")) {
                            Double d = this.$layerConfig.getDouble("fatten");
                            Intrinsics.checkNotNull((Object)d);
                            geom.setFattenMidline(d.doubleValue());
                        }
                        if (this.$layerConfig.hasOwn("whisker_width")) {
                            Double d = this.$layerConfig.getDouble("whisker_width");
                            Intrinsics.checkNotNull((Object)d);
                            geom.setWhiskerWidth(d.doubleValue());
                        }
                        if (this.$layerConfig.hasOwn("width_unit")) {
                            DimensionUnit dimensionUnit = GeomProviderFactory.access$dimensionUnit(GeomProviderFactory.INSTANCE, this.$layerConfig, "width_unit");
                            Intrinsics.checkNotNull((Object)dimensionUnit);
                            geom.setWidthUnit(dimensionUnit);
                        }
                        return (Geom)geom;
                    }
                });
                break;
            }
            case 11: {
                geomProvider = GeomProvider.Companion.arearidges((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ LayerConfig $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        AreaRidgesGeom geom = new AreaRidgesGeom();
                        if (this.$layerConfig.hasOwn("scale")) {
                            geom.setScale(this.$layerConfig.getDoubleDef("scale", 1.0));
                        }
                        if (this.$layerConfig.hasOwn("min_height")) {
                            geom.setMinHeight(this.$layerConfig.getDoubleDef("min_height", 0.0));
                        }
                        if (this.$layerConfig.hasOwn("quantiles")) {
                            geom.setQuantiles(this.$layerConfig.getBoundedDoubleList("quantiles", 0.0, 1.0));
                        }
                        if (this.$layerConfig.hasOwn("quantile_lines")) {
                            geom.setQuantileLines(this.$layerConfig.getBoolean("quantile_lines", false));
                        }
                        return (Geom)geom;
                    }
                });
                break;
            }
            case 12: {
                geomProvider = GeomProvider.Companion.violin((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ LayerConfig $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ViolinGeom geom = new ViolinGeom();
                        if (this.$layerConfig.hasOwn("quantiles")) {
                            geom.setQuantiles(this.$layerConfig.getBoundedDoubleList("quantiles", 0.0, 1.0));
                        }
                        if (this.$layerConfig.hasOwn("quantile_lines")) {
                            geom.setQuantileLines(this.$layerConfig.getBoolean("quantile_lines", false));
                        }
                        if (this.$layerConfig.hasOwn("show_half")) {
                            Double d = this.$layerConfig.getDouble("show_half");
                            Intrinsics.checkNotNull((Object)d);
                            geom.setShowHalf(d.doubleValue());
                        }
                        return (Geom)geom;
                    }
                });
                break;
            }
            case 13: {
                geomProvider = GeomProvider.Companion.sina((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ LayerConfig $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        SinaGeom geom = new SinaGeom();
                        if (this.$layerConfig.hasOwn("seed")) {
                            Long l = this.$layerConfig.getLong("seed");
                            Intrinsics.checkNotNull((Object)l);
                            geom.setSeed(l);
                        }
                        if (this.$layerConfig.hasOwn("quantiles")) {
                            geom.setQuantiles(this.$layerConfig.getBoundedDoubleList("quantiles", 0.0, 1.0));
                        }
                        if (this.$layerConfig.hasOwn("show_half")) {
                            Double d = this.$layerConfig.getDouble("show_half");
                            Intrinsics.checkNotNull((Object)d);
                            geom.setShowHalf(d.doubleValue());
                        }
                        return (Geom)geom;
                    }
                });
                break;
            }
            case 14: {
                geomProvider = GeomProvider.Companion.ydotplot((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ LayerConfig $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        YDotplotGeom geom;
                        block20: {
                            YDotplotGeom.YStackdir yStackdir;
                            void it2;
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            geom = new YDotplotGeom();
                            if (this.$layerConfig.hasOwn("dotsize")) {
                                Double d = this.$layerConfig.getDouble("dotsize");
                                Intrinsics.checkNotNull((Object)d);
                                geom.setDotSize(d.doubleValue());
                            }
                            if (this.$layerConfig.hasOwn("stackratio")) {
                                Double d = this.$layerConfig.getDouble("stackratio");
                                Intrinsics.checkNotNull((Object)d);
                                geom.setStackRatio(d.doubleValue());
                            }
                            if (this.$layerConfig.hasOwn("stackgroups")) {
                                geom.setStackGroups(OptionsAccessor.getBoolean$default(this.$layerConfig, "stackgroups", false, 2, null));
                            }
                            if (!this.$layerConfig.hasOwn("stackdir")) break block20;
                            String string = this.$layerConfig.getString("stackdir");
                            Intrinsics.checkNotNull((Object)string);
                            String string2 = string;
                            YDotplotGeom yDotplotGeom = geom;
                            boolean bl = false;
                            String string3 = it2.toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                            switch (string3) {
                                case "left": {
                                    yStackdir = YDotplotGeom.YStackdir.LEFT;
                                    break;
                                }
                                case "right": {
                                    yStackdir = YDotplotGeom.YStackdir.RIGHT;
                                    break;
                                }
                                case "center": {
                                    yStackdir = YDotplotGeom.YStackdir.CENTER;
                                    break;
                                }
                                case "centerwhole": {
                                    yStackdir = YDotplotGeom.YStackdir.CENTERWHOLE;
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unsupported stackdir: '" + (String)it2 + "'. Use one of: left, right, center, centerwhole.");
                                }
                            }
                            yDotplotGeom.setYStackDir(yStackdir);
                        }
                        if (this.$layerConfig.hasOwn("method")) {
                            String string = this.$layerConfig.getString("method");
                            Intrinsics.checkNotNull((Object)string);
                            geom.setMethod(DotplotStat.Method.Companion.safeValueOf(string));
                        }
                        return (Geom)geom;
                    }
                });
                break;
            }
            case 15: {
                geomProvider = GeomProvider.Companion.step((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ LayerConfig $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        StepGeom geom = new StepGeom();
                        if (this.$layerConfig.hasOwn("direction")) {
                            String string = this.$layerConfig.getString("direction");
                            Intrinsics.checkNotNull((Object)string);
                            geom.setDirection(string);
                        }
                        if (this.$layerConfig.hasOwn("pad")) {
                            geom.setPadded(this.$layerConfig.getBoolean("pad", false));
                        }
                        return (Geom)geom;
                    }
                });
                break;
            }
            case 16: {
                geomProvider = GeomProvider.Companion.segment((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ LayerConfig $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        SegmentGeom geom;
                        block4: {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            geom = new SegmentGeom();
                            if (this.$layerConfig.has("arrow")) {
                                Object object = this.$layerConfig.get("arrow");
                                Intrinsics.checkNotNull((Object)object);
                                ArrowSpecConfig arrowConfig = ArrowSpecConfig.Companion.create(object);
                                geom.setArrowSpec(arrowConfig.createArrowSpec());
                            }
                            if (this.$layerConfig.has("animation")) {
                                geom.setAnimation(this.$layerConfig.get("animation"));
                            }
                            if (this.$layerConfig.has("flat")) {
                                geom.setFlat(OptionsAccessor.getBoolean$default(this.$layerConfig, "flat", false, 2, null));
                            }
                            if (this.$layerConfig.has("geodesic")) {
                                geom.setGeodesic(OptionsAccessor.getBoolean$default(this.$layerConfig, "geodesic", false, 2, null));
                            }
                            Double d = this.$layerConfig.getDouble("spacer");
                            if (d == null) break block4;
                            double it2 = ((Number)d).doubleValue();
                            boolean bl = false;
                            geom.setSpacer(it2);
                        }
                        return (Geom)geom;
                    }
                });
                break;
            }
            case 17: {
                return GeomProvider.Companion.curve((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ LayerConfig $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        CurveGeom geom;
                        block4: {
                            double it2;
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            geom = new CurveGeom();
                            Double d = this.$layerConfig.getDouble("curvature");
                            if (d != null) {
                                it2 = ((Number)d).doubleValue();
                                boolean bl = false;
                                geom.setCurvature(it2);
                            }
                            Double d2 = this.$layerConfig.getDouble("angle");
                            if (d2 != null) {
                                it2 = ((Number)d2).doubleValue();
                                boolean bl = false;
                                geom.setAngle(it2);
                            }
                            Integer n = this.$layerConfig.getInteger("ncp");
                            if (n != null) {
                                int it3 = ((Number)n).intValue();
                                boolean bl = false;
                                geom.setNcp(it3);
                            }
                            if (this.$layerConfig.has("arrow")) {
                                Object object = this.$layerConfig.get("arrow");
                                Intrinsics.checkNotNull((Object)object);
                                ArrowSpecConfig arrowConfig = ArrowSpecConfig.Companion.create(object);
                                geom.setArrowSpec(arrowConfig.createArrowSpec());
                            }
                            Double d3 = this.$layerConfig.getDouble("spacer");
                            if (d3 == null) break block4;
                            double it4 = ((Number)d3).doubleValue();
                            boolean bl = false;
                            geom.setSpacer(it4);
                        }
                        return (Geom)geom;
                    }
                });
            }
            case 18: {
                geomProvider = GeomProvider.Companion.path((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ LayerConfig $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        PathGeom geom = new PathGeom();
                        if (this.$layerConfig.has("animation")) {
                            geom.setAnimation(this.$layerConfig.get("animation"));
                        }
                        if (this.$layerConfig.has("flat")) {
                            geom.setFlat(OptionsAccessor.getBoolean$default(this.$layerConfig, "flat", false, 2, null));
                        }
                        if (this.$layerConfig.has("geodesic")) {
                            geom.setGeodesic(OptionsAccessor.getBoolean$default(this.$layerConfig, "geodesic", false, 2, null));
                        }
                        return (Geom)geom;
                    }
                });
                break;
            }
            case 19: {
                geomProvider = GeomProvider.Companion.point((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ LayerConfig $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        String string;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        PointGeom geom = new PointGeom();
                        if (this.$layerConfig.has("animation")) {
                            geom.setAnimation(this.$layerConfig.get("animation"));
                        }
                        String string2 = this.$layerConfig.getString("size_unit");
                        if (string2 != null) {
                            String string3 = string2.toLowerCase(Locale.ROOT);
                            string = string3;
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                        } else {
                            string = null;
                        }
                        geom.setSizeUnit(string);
                        return (Geom)geom;
                    }
                });
                break;
            }
            case 20: {
                geomProvider = GeomProvider.Companion.text((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig, expFormat, tz){
                    final /* synthetic */ LayerConfig $layerConfig;
                    final /* synthetic */ ExponentFormat $expFormat;
                    final /* synthetic */ TimeZone $tz;
                    {
                        this.$layerConfig = $layerConfig;
                        this.$expFormat = $expFormat;
                        this.$tz = $tz;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        TextGeom geom = new TextGeom();
                        GeomProviderFactory.access$applyTextOptions(GeomProviderFactory.INSTANCE, this.$layerConfig, geom, this.$expFormat, this.$tz);
                        return (Geom)geom;
                    }
                });
                break;
            }
            case 21: {
                geomProvider = GeomProvider.Companion.label((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig, expFormat, tz){
                    final /* synthetic */ LayerConfig $layerConfig;
                    final /* synthetic */ ExponentFormat $expFormat;
                    final /* synthetic */ TimeZone $tz;
                    {
                        this.$layerConfig = $layerConfig;
                        this.$expFormat = $expFormat;
                        this.$tz = $tz;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        LabelGeom geom = new LabelGeom();
                        GeomProviderFactory.access$applyTextOptions(GeomProviderFactory.INSTANCE, this.$layerConfig, (TextGeom)geom, this.$expFormat, this.$tz);
                        GeomProviderFactory.access$applyLabelOptions(GeomProviderFactory.INSTANCE, this.$layerConfig, geom.getLabelOptions());
                        return (Geom)geom;
                    }
                });
                break;
            }
            case 22: {
                geomProvider = GeomProvider.Companion.textRepel((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig, expFormat, tz){
                    final /* synthetic */ LayerConfig $layerConfig;
                    final /* synthetic */ ExponentFormat $expFormat;
                    final /* synthetic */ TimeZone $tz;
                    {
                        this.$layerConfig = $layerConfig;
                        this.$expFormat = $expFormat;
                        this.$tz = $tz;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        TextRepelGeom geom = new TextRepelGeom();
                        GeomProviderFactory.access$applyTextOptions(GeomProviderFactory.INSTANCE, this.$layerConfig, (TextGeom)geom, this.$expFormat, this.$tz);
                        GeomProviderFactory.access$applyRepelOptions(GeomProviderFactory.INSTANCE, this.$layerConfig, geom);
                        return (Geom)geom;
                    }
                });
                break;
            }
            case 23: {
                geomProvider = GeomProvider.Companion.labelRepel((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig, expFormat, tz){
                    final /* synthetic */ LayerConfig $layerConfig;
                    final /* synthetic */ ExponentFormat $expFormat;
                    final /* synthetic */ TimeZone $tz;
                    {
                        this.$layerConfig = $layerConfig;
                        this.$expFormat = $expFormat;
                        this.$tz = $tz;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        LabelRepelGeom geom = new LabelRepelGeom();
                        GeomProviderFactory.access$applyTextOptions(GeomProviderFactory.INSTANCE, this.$layerConfig, (TextGeom)geom, this.$expFormat, this.$tz);
                        GeomProviderFactory.access$applyLabelOptions(GeomProviderFactory.INSTANCE, this.$layerConfig, geom.getLabelOptions());
                        GeomProviderFactory.access$applyRepelOptions(GeomProviderFactory.INSTANCE, this.$layerConfig, (TextRepelGeom)geom);
                        return (Geom)geom;
                    }
                });
                break;
            }
            case 24: {
                geomProvider = GeomProvider.Companion.image((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ LayerConfig $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (!this.$layerConfig.hasOwn("href")) {
                            boolean $i$a$-require-GeomProviderFactory$createGeomProvider$24$32 = false;
                            String $i$a$-require-GeomProviderFactory$createGeomProvider$24$32 = "Image reference URL (href) is not specified.";
                            throw new IllegalArgumentException($i$a$-require-GeomProviderFactory$createGeomProvider$24$32.toString());
                        }
                        Object[] $i$a$-require-GeomProviderFactory$createGeomProvider$24$32 = new String[]{Option.Geom.Image.INSTANCE.getXMIN(), Option.Geom.Image.INSTANCE.getXMAX(), Option.Geom.Image.INSTANCE.getYMIN(), Option.Geom.Image.INSTANCE.getYMAX()};
                        for (String s : CollectionsKt.listOf((Object[])$i$a$-require-GeomProviderFactory$createGeomProvider$24$32)) {
                            if (this.$layerConfig.hasOwn(s)) continue;
                            boolean bl = false;
                            String string = '\'' + s + "' is not specified.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        String string = this.$layerConfig.getString("href");
                        Intrinsics.checkNotNull((Object)string);
                        return (Geom)new ImageGeom(string, DoubleRectangle.Companion.span(new DoubleVector(this.$layerConfig.getDoubleSafe(Option.Geom.Image.INSTANCE.getXMIN()), this.$layerConfig.getDoubleSafe(Option.Geom.Image.INSTANCE.getYMIN())), new DoubleVector(this.$layerConfig.getDoubleSafe(Option.Geom.Image.INSTANCE.getXMAX()), this.$layerConfig.getDoubleSafe(Option.Geom.Image.INSTANCE.getYMAX()))));
                    }
                });
                break;
            }
            case 25: {
                geomProvider = GeomProvider.Companion.pie((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig, aopConversion){
                    final /* synthetic */ LayerConfig $layerConfig;
                    final /* synthetic */ AesOptionConversion $aopConversion;
                    {
                        this.$layerConfig = $layerConfig;
                        this.$aopConversion = $aopConversion;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        String string;
                        PieGeom geom;
                        block18: {
                            PieGeom.StrokeSide strokeSide;
                            double it2;
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            geom = new PieGeom();
                            Double d = this.$layerConfig.getDouble("hole");
                            if (d != null) {
                                it2 = ((Number)d).doubleValue();
                                boolean bl = false;
                                geom.setHoleSize(it2);
                            }
                            Double d2 = this.$layerConfig.getDouble("spacer_width");
                            if (d2 != null) {
                                it2 = ((Number)d2).doubleValue();
                                boolean bl = false;
                                geom.setSpacerWidth(it2);
                            }
                            Color color = this.$layerConfig.getColor("spacer_color", this.$aopConversion);
                            if (color != null) {
                                Color it3 = color;
                                boolean bl = false;
                                geom.setSpacerColor(it3);
                            }
                            String string2 = this.$layerConfig.getString("stroke_side");
                            if (string2 == null) break block18;
                            String it4 = string2;
                            boolean bl = false;
                            String string3 = it4.toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                            switch (string3) {
                                case "outer": {
                                    strokeSide = PieGeom.StrokeSide.OUTER;
                                    break;
                                }
                                case "inner": {
                                    strokeSide = PieGeom.StrokeSide.INNER;
                                    break;
                                }
                                case "both": {
                                    strokeSide = PieGeom.StrokeSide.BOTH;
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unsupported value for stroke_side parameter: '" + it4 + "'. Use one of: outer, inner, both.");
                                }
                            }
                            geom.setStrokeSide(strokeSide);
                        }
                        String string4 = this.$layerConfig.getString("size_unit");
                        if (string4 != null) {
                            String string5 = string4.toLowerCase(Locale.ROOT);
                            string = string5;
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                        } else {
                            string = null;
                        }
                        geom.setSizeUnit(string);
                        geom.setStart(this.$layerConfig.getDouble("start"));
                        Integer n = this.$layerConfig.getInteger("direction");
                        geom.setClockwise((n != null ? n : 1) == 1);
                        return (Geom)geom;
                    }
                });
                break;
            }
            case 26: {
                geomProvider = GeomProvider.Companion.lollipop((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ LayerConfig $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        String string;
                        block23: {
                            block21: {
                                LollipopGeom.Direction direction;
                                String directionValue;
                                String string2;
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                String string3 = this.$layerConfig.getString("dir");
                                if (string3 != null) {
                                    String string4 = string3.toLowerCase(Locale.ROOT);
                                    string2 = string4;
                                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                                } else {
                                    string2 = null;
                                }
                                if ((string = (directionValue = string2)) == null) break block21;
                                String it2 = string;
                                boolean bl = false;
                                switch (it2) {
                                    case "v": {
                                        direction = LollipopGeom.Direction.ORTHOGONAL_TO_AXIS;
                                        break;
                                    }
                                    case "h": {
                                        direction = LollipopGeom.Direction.ALONG_AXIS;
                                        break;
                                    }
                                    case "s": {
                                        direction = LollipopGeom.Direction.SLOPE;
                                        break;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Unsupported value for dir parameter: '" + it2 + "'. Use one of: v, h, s.");
                                    }
                                }
                                string = direction;
                                if (direction != null) break block23;
                            }
                            string = LollipopGeom.Direction.ORTHOGONAL_TO_AXIS;
                        }
                        String direction = string;
                        Double d = this.$layerConfig.getDouble("slope");
                        double slope = d != null ? d : 0.0;
                        LollipopGeom lollipopGeom = new LollipopGeom();
                        LayerConfig layerConfig = this.$layerConfig;
                        LollipopGeom $this$invoke_u24lambda_u241 = lollipopGeom;
                        boolean bl = false;
                        $this$invoke_u24lambda_u241.setDirection((LollipopGeom.Direction)direction);
                        $this$invoke_u24lambda_u241.setSlope(slope);
                        if (layerConfig.hasOwn("intercept")) {
                            Double d2 = layerConfig.getDouble("intercept");
                            Intrinsics.checkNotNull((Object)d2);
                            $this$invoke_u24lambda_u241.setIntercept(d2.doubleValue());
                        }
                        if (layerConfig.hasOwn("fatten")) {
                            Double d3 = layerConfig.getDouble("fatten");
                            Intrinsics.checkNotNull((Object)d3);
                            $this$invoke_u24lambda_u241.setFatten(d3.doubleValue());
                        }
                        return (Geom)lollipopGeom;
                    }
                });
                break;
            }
            case 27: {
                geomProvider = GeomProvider.Companion.spoke((Function1)new Function1<GeomProvider.Context, Geom>(layerConfig){
                    final /* synthetic */ LayerConfig $layerConfig;
                    {
                        this.$layerConfig = $layerConfig;
                        super(1);
                    }

                    @NotNull
                    public final Geom invoke(@NotNull GeomProvider.Context it) {
                        SpokeGeom geom;
                        block16: {
                            SpokeGeom.Pivot pivot;
                            Object it2;
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            geom = new SpokeGeom();
                            Object object = this.$layerConfig.get("arrow");
                            if (object != null) {
                                it2 = object;
                                boolean bl = false;
                                ArrowSpecConfig arrowConfig = ArrowSpecConfig.Companion.create(it2);
                                geom.setArrowSpec(arrowConfig.createArrowSpec());
                            }
                            String string = this.$layerConfig.getString("pivot");
                            if (string == null) break block16;
                            it2 = string;
                            boolean bl = false;
                            String string2 = ((String)it2).toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                            switch (string2) {
                                case "tail": {
                                    pivot = SpokeGeom.Pivot.TAIL;
                                    break;
                                }
                                case "middle": 
                                case "mid": {
                                    pivot = SpokeGeom.Pivot.MIDDLE;
                                    break;
                                }
                                case "tip": {
                                    pivot = SpokeGeom.Pivot.TIP;
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unsupported value for pivot parameter: '" + (String)it2 + "'. Use one of: tail, middle, mid, tip.");
                                }
                            }
                            geom.setPivot(pivot);
                        }
                        return (Geom)geom;
                    }
                });
                break;
            }
            default: {
                if (!PROVIDER.containsKey(geomKind)) {
                    boolean bl = false;
                    String string = "Provider doesn't support geom kind: '" + geomKind + '\'';
                    throw new IllegalArgumentException(string.toString());
                }
                geomProvider = (GeomProvider)MapsKt.getValue((Map)PROVIDER, (Object)geomKind);
            }
        }
        return geomProvider;
    }

    private final void applyTextOptions(LayerConfig layerConfig, TextGeom geom, ExponentFormat expFormat, TimeZone tz) {
        String it;
        String string = layerConfig.getString("label_format");
        if (string != null) {
            it = string;
            boolean bl = false;
            geom.setFormatter((Function1)new Function1<Object, String>((Object)StringFormat.Companion.forOneArg$default((StringFormat.Companion)StringFormat.Companion, (String)it, null, null, (StringFormat.ExponentFormat)PlotAssembler.Companion.extractExponentFormat(expFormat), (TimeZone)tz, (int)6, null)){

                @NotNull
                public final String invoke(@NotNull Object p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((StringFormat)this.receiver).format(p0);
                }
            });
        }
        String string2 = layerConfig.getString("na_text");
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            geom.setNaValue(it);
        }
        String string3 = layerConfig.getString("size_unit");
        if (string3 != null) {
            it = string3;
            boolean bl = false;
            String string4 = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            geom.setSizeUnit(string4);
        }
        boolean it2 = OptionsAccessor.getBoolean$default(layerConfig, "check_overlap", false, 2, null);
        boolean bl = false;
        geom.setCheckOverlap(it2);
    }

    private final void applyLabelOptions(LayerConfig layerConfig, LabelOptions factory) {
        double it;
        Double d = layerConfig.getDouble("label_padding");
        if (d != null) {
            it = ((Number)d).doubleValue();
            boolean bl = false;
            factory.setPaddingFactor(it);
        }
        Double d2 = layerConfig.getDouble("label_r");
        if (d2 != null) {
            it = ((Number)d2).doubleValue();
            boolean bl = false;
            factory.setRadiusFactor(it);
        }
        Double d3 = layerConfig.getDouble("label_size");
        if (d3 != null) {
            it = ((Number)d3).doubleValue();
            boolean bl = false;
            factory.setBorderWidth(it);
        }
        if (layerConfig.hasOwn("alpha_stroke")) {
            factory.setAlphaStroke(OptionsAccessor.getBoolean$default(layerConfig, "alpha_stroke", false, 2, null));
        }
    }

    private final void applyRepelOptions(LayerConfig layerConfig, TextRepelGeom geom) {
        Long l = layerConfig.getLong("seed");
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            geom.setSeed(Long.valueOf(it));
        }
        Integer n = layerConfig.getInteger("max_iter");
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            geom.setMaxIter(Integer.valueOf(it));
        }
        Double d = layerConfig.getDouble("max_time");
        if (d != null) {
            double it = ((Number)d).doubleValue();
            boolean bl = false;
            geom.setMaxTime(Double.valueOf(it * 1000.0));
        }
        String string = layerConfig.getString("direction");
        if (string != null) {
            String it = string;
            boolean bl = false;
            geom.setDirection(INSTANCE.directionValue(it));
        }
        Double d2 = layerConfig.getDouble("point_padding");
        if (d2 != null) {
            double it = ((Number)d2).doubleValue();
            boolean bl = false;
            geom.setPointPadding(Double.valueOf(it));
        }
        Double d3 = layerConfig.getDouble("box_padding");
        if (d3 != null) {
            double it = ((Number)d3).doubleValue();
            boolean bl = false;
            geom.setBoxPadding(Double.valueOf(it));
        }
        Integer n2 = layerConfig.getInteger("max_overlaps");
        if (n2 != null) {
            int it = ((Number)n2).intValue();
            boolean bl = false;
            geom.setMaxOverlaps(Integer.valueOf(it));
        }
        Double d4 = layerConfig.getDouble("min_segment_length");
        if (d4 != null) {
            double it = ((Number)d4).doubleValue();
            boolean bl = false;
            geom.setMinSegmentLength(Double.valueOf(it));
        }
        if (layerConfig.has("arrow")) {
            Object object = layerConfig.get("arrow");
            Intrinsics.checkNotNull((Object)object);
            ArrowSpecConfig arrowConfig = ArrowSpecConfig.Companion.create(object);
            geom.setArrowSpec(arrowConfig.createArrowSpec());
        }
    }

    private final boolean isVertical(GeomProvider.Context ctx2, String geomName) {
        boolean isHorizontal;
        boolean isVertical;
        block8: {
            boolean bl;
            boolean bl2;
            block7: {
                Object[] objectArray = new Aes[]{Aes.Companion.getYMIN(), Aes.Companion.getYMAX()};
                Iterable $this$any$iv = SetsKt.setOf((Object[])objectArray);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Aes aes = (Aes)element$iv;
                        boolean bl3 = false;
                        if (!(ctx2.hasBinding(aes) || ctx2.hasConstant(aes))) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            isVertical = bl2;
            Object[] $i$f$any = new Aes[]{Aes.Companion.getXMIN(), Aes.Companion.getXMAX()};
            Iterable $this$any$iv = SetsKt.setOf((Object[])$i$f$any);
            boolean $i$f$any2 = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Aes aes = (Aes)element$iv;
                    boolean bl4 = false;
                    if (!(ctx2.hasBinding(aes) || ctx2.hasConstant(aes))) continue;
                    bl = true;
                    break block8;
                }
                bl = isHorizontal = false;
            }
        }
        if (!(!isVertical || !isHorizontal)) {
            boolean bl = false;
            String string = "Either ymin, ymax or xmin, xmax must be specified for the " + geomName + '.';
            throw new IllegalArgumentException(string.toString());
        }
        return isVertical;
    }

    private final DimensionUnit dimensionUnit(LayerConfig layerConfig, String option) {
        DimensionUnit dimensionUnit;
        block18: {
            block16: {
                String string = layerConfig.getString(option);
                if (string == null) break block16;
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                string = string2;
                if (string2 == null) break block16;
                String it = string;
                boolean bl = false;
                switch (it) {
                    case "res": {
                        dimensionUnit = DimensionUnit.RESOLUTION;
                        break;
                    }
                    case "identity": {
                        dimensionUnit = DimensionUnit.IDENTITY;
                        break;
                    }
                    case "size": {
                        dimensionUnit = DimensionUnit.SIZE;
                        break;
                    }
                    case "px": {
                        dimensionUnit = DimensionUnit.PIXEL;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported value for " + option + " parameter: '" + it + "'. Use one of: res, identity, size, px.");
                    }
                }
                break block18;
            }
            dimensionUnit = null;
        }
        return dimensionUnit;
    }

    private final LabelForceLayout.Direction directionValue(String value) {
        LabelForceLayout.Direction direction;
        String string = value.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        switch (string) {
            case "x": {
                direction = LabelForceLayout.Direction.X;
                break;
            }
            case "y": {
                direction = LabelForceLayout.Direction.Y;
                break;
            }
            case "both": {
                direction = LabelForceLayout.Direction.BOTH;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported value for direction parameter: '" + value + "'. Use one of: x, y, both.");
            }
        }
        return direction;
    }

    public static final /* synthetic */ DimensionUnit access$dimensionUnit(GeomProviderFactory $this, LayerConfig layerConfig, String option) {
        return $this.dimensionUnit(layerConfig, option);
    }

    public static final /* synthetic */ boolean access$isVertical(GeomProviderFactory $this, GeomProvider.Context ctx2, String geomName) {
        return $this.isVertical(ctx2, geomName);
    }

    public static final /* synthetic */ void access$applyTextOptions(GeomProviderFactory $this, LayerConfig layerConfig, TextGeom geom, ExponentFormat expFormat, TimeZone tz) {
        $this.applyTextOptions(layerConfig, geom, expFormat, tz);
    }

    public static final /* synthetic */ void access$applyLabelOptions(GeomProviderFactory $this, LayerConfig layerConfig, LabelOptions factory) {
        $this.applyLabelOptions(layerConfig, factory);
    }

    public static final /* synthetic */ void access$applyRepelOptions(GeomProviderFactory $this, LayerConfig layerConfig, TextRepelGeom geom) {
        $this.applyRepelOptions(layerConfig, geom);
    }

    static {
        ((Map)PROVIDER).put(GeomKind.BLANK, GeomProvider.Companion.blank());
        ((Map)PROVIDER).put(GeomKind.LINE, GeomProvider.Companion.line());
        ((Map)PROVIDER).put(GeomKind.SMOOTH, GeomProvider.Companion.smooth());
        ((Map)PROVIDER).put(GeomKind.BAR, GeomProvider.Companion.bar());
        ((Map)PROVIDER).put(GeomKind.HISTOGRAM, GeomProvider.Companion.histogram());
        ((Map)PROVIDER).put(GeomKind.RIBBON, GeomProvider.Companion.ribbon());
        ((Map)PROVIDER).put(GeomKind.LINE_RANGE, GeomProvider.Companion.lineRange());
        ((Map)PROVIDER).put(GeomKind.BIN_2D, GeomProvider.Companion.bin2d());
        ((Map)PROVIDER).put(GeomKind.CONTOUR, GeomProvider.Companion.contour());
        ((Map)PROVIDER).put(GeomKind.CONTOURF, GeomProvider.Companion.contourf());
        ((Map)PROVIDER).put(GeomKind.POLYGON, GeomProvider.Companion.polygon());
        ((Map)PROVIDER).put(GeomKind.MAP, GeomProvider.Companion.map());
        ((Map)PROVIDER).put(GeomKind.AB_LINE, GeomProvider.Companion.abline());
        ((Map)PROVIDER).put(GeomKind.H_LINE, GeomProvider.Companion.hline());
        ((Map)PROVIDER).put(GeomKind.V_LINE, GeomProvider.Companion.vline());
        ((Map)PROVIDER).put(GeomKind.DENSITY2D, GeomProvider.Companion.density2d());
        ((Map)PROVIDER).put(GeomKind.DENSITY2DF, GeomProvider.Companion.density2df());
        ((Map)PROVIDER).put(GeomKind.JITTER, GeomProvider.Companion.jitter());
        ((Map)PROVIDER).put(GeomKind.Q_Q, GeomProvider.Companion.qq());
        ((Map)PROVIDER).put(GeomKind.Q_Q_2, GeomProvider.Companion.qq2());
        ((Map)PROVIDER).put(GeomKind.Q_Q_LINE, GeomProvider.Companion.qqline());
        ((Map)PROVIDER).put(GeomKind.Q_Q_2_LINE, GeomProvider.Companion.qq2line());
        ((Map)PROVIDER).put(GeomKind.FREQPOLY, GeomProvider.Companion.freqpoly());
        ((Map)PROVIDER).put(GeomKind.RECT, GeomProvider.Companion.rect());
        ((Map)PROVIDER).put(GeomKind.RASTER, GeomProvider.Companion.raster());
        ((Map)PROVIDER).put(GeomKind.LIVE_MAP, GeomProvider.Companion.livemap());
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GeomKind.values().length];
            try {
                nArray[GeomKind.AREA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.DENSITY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.DOT_PLOT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.TILE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.HEX.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.ERROR_BAR.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.CROSS_BAR.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.POINT_RANGE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.BAND.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.BOX_PLOT.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.AREA_RIDGES.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.VIOLIN.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.SINA.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.Y_DOT_PLOT.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.STEP.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.SEGMENT.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.CURVE.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.PATH.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.POINT.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.TEXT.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.LABEL.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.TEXT_REPEL.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.LABEL_REPEL.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.IMAGE.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.PIE.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.LOLLIPOP.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.SPOKE.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

