/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.livemap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.geometry.Rectangle;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.commons.values.SomeFig;
import org.jetbrains.letsPlot.core.commons.enums.EnumInfo;
import org.jetbrains.letsPlot.core.commons.enums.EnumInfoFactory;
import org.jetbrains.letsPlot.core.commons.enums.EnumInfoImpl;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.geom.LiveMapProvider;
import org.jetbrains.letsPlot.core.plot.base.livemap.LivemapConstants;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetLocator;
import org.jetbrains.letsPlot.core.plot.builder.GeomLayer;
import org.jetbrains.letsPlot.core.plot.builder.LayerRendererUtil;
import org.jetbrains.letsPlot.core.plot.livemap.ConfigUtil;
import org.jetbrains.letsPlot.core.plot.livemap.CursorServiceConfig;
import org.jetbrains.letsPlot.core.plot.livemap.LayerConverter;
import org.jetbrains.letsPlot.core.plot.livemap.LiveMapProviderUtil;
import org.jetbrains.letsPlot.core.plot.livemap.LiveMapProviderUtil$MyLiveMapProvider$createLiveMap$lambda$2$;
import org.jetbrains.letsPlot.core.spec.OptionsSelectorKt;
import org.jetbrains.letsPlot.gis.tileprotocol.TileService;
import org.jetbrains.letsPlot.livemap.LiveMap;
import org.jetbrains.letsPlot.livemap.api.BuilderKt;
import org.jetbrains.letsPlot.livemap.api.LiveMapBuilder;
import org.jetbrains.letsPlot.livemap.api.LiveMapGeocodingServiceBuilder;
import org.jetbrains.letsPlot.livemap.api.LiveMapTileServiceBuilder;
import org.jetbrains.letsPlot.livemap.api.Services;
import org.jetbrains.letsPlot.livemap.chart.HoverObject;
import org.jetbrains.letsPlot.livemap.config.DevParams;
import org.jetbrains.letsPlot.livemap.config.LiveMapCanvasFigure;
import org.jetbrains.letsPlot.livemap.core.Projections;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapTileSystemProvider;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.Tilesets;
import org.jetbrains.letsPlot.livemap.ui.CursorService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J6\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00040\u00042\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010\u0018\u001a\u00020\u0019\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/livemap/LiveMapProviderUtil;", "", "()V", "createTargetLocators", "", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator;", "plotLayers", "Lorg/jetbrains/letsPlot/core/plot/builder/LayerRendererUtil$LayerRendererData;", "liveMap", "Lorg/jetbrains/letsPlot/livemap/LiveMap;", "createTileSystemProvider", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/BasemapTileSystemProvider;", "options", "", "debugTiles", "", "quant", "", "injectLiveMapProvider", "", "tiles", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "spec", "", "cursorServiceConfig", "Lorg/jetbrains/letsPlot/core/plot/livemap/CursorServiceConfig;", "MyLiveMapProvider", "plot-livemap"})
@SourceDebugExtension(value={"SMAP\nLiveMapProviderUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveMapProviderUtil.kt\norg/jetbrains/letsPlot/core/plot/livemap/LiveMapProviderUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,265:1\n1855#2:266\n1747#2,3:267\n1774#2,4:270\n1549#2:275\n1620#2,3:276\n1856#2:279\n1#3:274\n151#4,6:280\n163#4,6:286\n1064#4,2:292\n970#4:294\n1041#4,3:295\n*S KotlinDebug\n*F\n+ 1 LiveMapProviderUtil.kt\norg/jetbrains/letsPlot/core/plot/livemap/LiveMapProviderUtil\n*L\n64#1:266\n65#1:267,3\n66#1:270,4\n79#1:275\n79#1:276,3\n64#1:279\n164#1:280,6\n165#1:286,6\n176#1:292,2\n180#1:294\n180#1:295,3\n*E\n"})
public final class LiveMapProviderUtil {
    @NotNull
    public static final LiveMapProviderUtil INSTANCE = new LiveMapProviderUtil();

    private LiveMapProviderUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public final void injectLiveMapProvider(@NotNull List<? extends List<? extends GeomLayer>> tiles, @NotNull Map<String, ? extends Object> spec, @NotNull CursorServiceConfig cursorServiceConfig) {
        Intrinsics.checkNotNullParameter(tiles, (String)"tiles");
        Intrinsics.checkNotNullParameter(spec, (String)"spec");
        Intrinsics.checkNotNullParameter((Object)cursorServiceConfig, (String)"cursorServiceConfig");
        Iterable $this$forEach$iv = tiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            int n;
            boolean bl;
            List layers;
            block12: {
                layers = (List)element$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = layers;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        GeomLayer p0 = (GeomLayer)element$iv2;
                        boolean bl3 = false;
                        if (!p0.isLiveMap()) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            Iterable $this$count$iv = layers;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                Object element$iv2;
                int count$iv = 0;
                element$iv2 = $this$count$iv.iterator();
                while (element$iv2.hasNext()) {
                    Object element$iv3 = element$iv2.next();
                    GeomLayer p0 = (GeomLayer)element$iv3;
                    boolean bl4 = false;
                    if (!p0.isLiveMap() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            if (!(n == 1)) {
                boolean $i$a$-require-LiveMapProviderUtil$injectLiveMapProvider$1$52 = false;
                String $i$a$-require-LiveMapProviderUtil$injectLiveMapProvider$1$52 = "Only one LiveMap layer is allowed per plot.";
                throw new IllegalArgumentException($i$a$-require-LiveMapProviderUtil$injectLiveMapProvider$1$52.toString());
            }
            if (!((GeomLayer)CollectionsKt.first((List)layers)).isLiveMap()) {
                boolean $i$a$-require-LiveMapProviderUtil$injectLiveMapProvider$1$62 = false;
                String $i$a$-require-LiveMapProviderUtil$injectLiveMapProvider$1$62 = "LiveMap layer should be the first layer in a plot.";
                throw new IllegalArgumentException($i$a$-require-LiveMapProviderUtil$injectLiveMapProvider$1$62.toString());
            }
            Object $i$a$-require-LiveMapProviderUtil$injectLiveMapProvider$1$62 = new Object[]{"layers"};
            List layerSpecs = OptionsSelectorKt.getMaps(spec, (Object[])$i$a$-require-LiveMapProviderUtil$injectLiveMapProvider$1$62);
            if (!(!(($i$a$-require-LiveMapProviderUtil$injectLiveMapProvider$1$62 = (Collection)layerSpecs) == null || $i$a$-require-LiveMapProviderUtil$injectLiveMapProvider$1$62.isEmpty()))) {
                boolean $i$a$-check-LiveMapProviderUtil$injectLiveMapProvider$1$72 = false;
                String $i$a$-check-LiveMapProviderUtil$injectLiveMapProvider$1$72 = "Layer specs not found in the plot spec: " + spec;
                throw new IllegalStateException($i$a$-check-LiveMapProviderUtil$injectLiveMapProvider$1$72.toString());
            }
            Map liveMapOptions = (Map)CollectionsKt.first((List)layerSpecs);
            if (!Intrinsics.areEqual(liveMapOptions.get("geom"), (Object)"livemap")) {
                boolean bl5 = false;
                String string = "LiveMap layer spec not found in the plot spec: " + spec;
                throw new IllegalStateException(string.toString());
            }
            Iterable $i$a$-check-LiveMapProviderUtil$injectLiveMapProvider$1$72 = layers;
            LayerRendererUtil layerRendererUtil = LayerRendererUtil.INSTANCE;
            GeomLayer geomLayer = (GeomLayer)CollectionsKt.first((List)layers);
            boolean $i$f$map = false;
            void p0 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p02;
                GeomLayer geomLayer2 = (GeomLayer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                collection.add(layerRendererUtil.createLayerRendererData((GeomLayer)p02));
            }
            CursorService cursorService = cursorServiceConfig.getCursorService();
            Map map = liveMapOptions;
            List list = (List)destination$iv$iv;
            geomLayer.setLiveMapProvider((LiveMapProvider)new MyLiveMapProvider(list, map, cursorService));
        }
    }

    private final BasemapTileSystemProvider createTileSystemProvider(Map<?, ?> options, boolean debugTiles, int quant) {
        BasemapTileSystemProvider basemapTileSystemProvider;
        if (debugTiles) {
            return Tilesets.chessboard$default((Tilesets)Tilesets.INSTANCE, null, null, (int)3, null);
        }
        Object obj = options.get("kind");
        if (Intrinsics.areEqual(obj, (Object)"chessboard")) {
            basemapTileSystemProvider = Tilesets.chessboard$default((Tilesets)Tilesets.INSTANCE, null, null, (int)3, null);
        } else if (Intrinsics.areEqual(obj, (Object)"solid")) {
            Object[] objectArray = new Object[]{"fill_color"};
            String string = OptionsSelectorKt.getString(options, (Object[])objectArray);
            Intrinsics.checkNotNull((Object)string);
            basemapTileSystemProvider = Tilesets.INSTANCE.solid(Color.Companion.parseHex(string));
        } else if (Intrinsics.areEqual(obj, (Object)"raster_zxy")) {
            Object object = new Object[]{"url"};
            String string = OptionsSelectorKt.getString(options, (Object[])object);
            Intrinsics.checkNotNull((Object)string);
            String p0 = string;
            boolean bl = false;
            object = LiveMapProviderUtil.createTileSystemProvider$splitSubdomains(p0);
            Tilesets tilesets = Tilesets.INSTANCE;
            Object p02 = object;
            boolean bl2 = false;
            basemapTileSystemProvider = tilesets.raster((List)p02);
        } else if (Intrinsics.areEqual(obj, (Object)"vector_lets_plot")) {
            Tilesets tilesets = Tilesets.INSTANCE;
            TileService tileService = BuilderKt.liveMapVectorTiles((Function1)((Function1)new Function1<LiveMapTileServiceBuilder, Unit>(options){
                final /* synthetic */ Map<?, ?> $options;
                {
                    this.$options = $options;
                    super(1);
                }

                public final void invoke(@NotNull LiveMapTileServiceBuilder $this$liveMapVectorTiles) {
                    block1: {
                        String it;
                        Intrinsics.checkNotNullParameter((Object)$this$liveMapVectorTiles, (String)"$this$liveMapVectorTiles");
                        Object[] objectArray = new Object[]{"url"};
                        String string = OptionsSelectorKt.getString(this.$options, (Object[])objectArray);
                        if (string != null) {
                            it = string;
                            boolean bl = false;
                            $this$liveMapVectorTiles.setUrl(it);
                        }
                        objectArray = new Object[]{"theme"};
                        String string2 = OptionsSelectorKt.getString(this.$options, (Object[])objectArray);
                        if (string2 == null) break block1;
                        it = string2;
                        boolean bl = false;
                        String string3 = it.toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
                        $this$liveMapVectorTiles.setTheme(TileService.Theme.valueOf((String)string3));
                    }
                }
            }));
            basemapTileSystemProvider = tilesets.letsPlot(tileService, quant);
        } else {
            throw new IllegalArgumentException("Tile provider is not set.");
        }
        return basemapTileSystemProvider;
    }

    private final List<GeomTargetLocator> createTargetLocators(List<LayerRendererUtil.LayerRendererData> plotLayers, LiveMap liveMap) {
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0002\u0000\u0005\b\n\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002R\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u00060\u0005R\u00020\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"org/jetbrains/letsPlot/core/plot/livemap/LiveMapProviderUtil$createTargetLocators$LiveMapInteractionAdapter", "", "(Lorg/jetbrains/letsPlot/livemap/LiveMap;Ljava/util/List;)V", "adapters", "", "org/jetbrains/letsPlot/core/plot/livemap/LiveMapProviderUtil$createTargetLocators$LiveMapInteractionAdapter.GeomTargetLocatorAdapter", "geomTargetLocators", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator;", "getGeomTargetLocators", "()Ljava/util/List;", "lastCoord", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "lastResult", "", "", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator$LookupResult;", "myLiveMap", "Lorg/jetbrains/letsPlot/livemap/LiveMap;", "search", "layerIndex", "coord", "GeomTargetLocatorAdapter", "plot-livemap"})
        @SourceDebugExtension(value={"SMAP\nLiveMapProviderUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveMapProviderUtil.kt\norg/jetbrains/letsPlot/core/plot/livemap/LiveMapProviderUtil$createTargetLocators$LiveMapInteractionAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,265:1\n1559#2:266\n1590#2,4:267\n1477#2:271\n1502#2,3:272\n1505#2,3:282\n1238#2,4:287\n372#3,7:275\n453#3:285\n403#3:286\n*S KotlinDebug\n*F\n+ 1 LiveMapProviderUtil.kt\norg/jetbrains/letsPlot/core/plot/livemap/LiveMapProviderUtil$createTargetLocators$LiveMapInteractionAdapter\n*L\n202#1:266\n202#1:267,4\n214#1:271\n214#1:272,3\n214#1:282,3\n215#1:287,4\n214#1:275,7\n215#1:285\n215#1:286\n*E\n"})
        public final class LiveMapInteractionAdapter {
            @NotNull
            private LiveMap myLiveMap;
            @NotNull
            private final List<createTargetLocators.LiveMapInteractionAdapter.GeomTargetLocatorAdapter> adapters;
            @Nullable
            private DoubleVector lastCoord;
            @NotNull
            private Map<Integer, ? extends GeomTargetLocator.LookupResult> lastResult;
            @NotNull
            private final List<GeomTargetLocator> geomTargetLocators;

            /*
             * WARNING - void declaration
             */
            public LiveMapInteractionAdapter(@NotNull LiveMap $liveMap, @NotNull List<LayerRendererUtil.LayerRendererData> $plotLayers) {
                void $this$mapIndexedTo$iv$iv;
                void $this$mapIndexed$iv;
                Intrinsics.checkNotNullParameter((Object)$liveMap, (String)"$liveMap");
                Intrinsics.checkNotNullParameter($plotLayers, (String)"$plotLayers");
                this.myLiveMap = $liveMap;
                Iterable iterable = $plotLayers;
                LiveMapInteractionAdapter liveMapInteractionAdapter = this;
                boolean $i$f$mapIndexed = false;
                void var5_6 = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void p1;
                    void p0;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    LayerRendererUtil.LayerRendererData layerRendererData = (LayerRendererUtil.LayerRendererData)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new createTargetLocators.LiveMapInteractionAdapter.GeomTargetLocatorAdapter(this, (int)p0, (LayerRendererUtil.LayerRendererData)p1));
                }
                liveMapInteractionAdapter.adapters = (List)destination$iv$iv;
                this.lastResult = MapsKt.emptyMap();
                this.geomTargetLocators = this.adapters;
            }

            @NotNull
            public final List<GeomTargetLocator> getGeomTargetLocators() {
                return this.geomTargetLocators;
            }

            /*
             * WARNING - void declaration
             */
            private final GeomTargetLocator.LookupResult search(int layerIndex, DoubleVector coord) {
                if (!Intrinsics.areEqual((Object)this.lastCoord, (Object)coord)) {
                    void $this$mapValuesTo$iv$iv;
                    void $this$mapValues$iv;
                    Object key$iv$iv;
                    void $this$groupByTo$iv$iv;
                    Map $this$groupBy$iv;
                    Iterable iterable = this.myLiveMap.hoverObjects();
                    LiveMapInteractionAdapter liveMapInteractionAdapter = this;
                    boolean $i$f$groupBy = false;
                    void var5_6 = $this$groupBy$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    for (T element$iv$iv : $this$groupByTo$iv$iv) {
                        Object object;
                        HoverObject p0 = (HoverObject)element$iv$iv;
                        boolean bl = false;
                        key$iv$iv = p0.getLayerIndex();
                        Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl2 = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        list$iv$iv.add(element$iv$iv);
                    }
                    $this$groupBy$iv = destination$iv$iv;
                    boolean $i$f$mapValues = false;
                    $this$groupByTo$iv$iv = $this$mapValues$iv;
                    destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo = false;
                    Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo = false;
                    for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        void it$iv$iv;
                        key$iv$iv = (Map.Entry)element$iv$iv$iv;
                        Map map = destination$iv$iv;
                        boolean bl = false;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        K k = it$iv$iv.getKey();
                        Map map2 = map;
                        boolean bl3 = false;
                        int layerIndex2 = ((Number)entry.getKey()).intValue();
                        List hoverObjects = (List)entry.getValue();
                        GeomTargetLocator.LookupResult lookupResult = this.adapters.get(layerIndex2).buildLookupResult(coord, hoverObjects);
                        map2.put(k, lookupResult);
                    }
                    liveMapInteractionAdapter.lastResult = destination$iv$iv;
                }
                return this.lastResult.get(layerIndex);
            }

            public static final /* synthetic */ GeomTargetLocator.LookupResult access$search(LiveMapInteractionAdapter $this, int layerIndex, DoubleVector coord) {
                return $this.search(layerIndex, coord);
            }
        }
        return new LiveMapInteractionAdapter(liveMap, plotLayers).getGeomTargetLocators();
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> createTileSystemProvider$splitSubdomains(String url) {
        void $this$mapTo$iv$iv;
        boolean bl;
        String subdomains;
        int closeBracketIndex;
        int openBracketIndex;
        block11: {
            int index$iv;
            block10: {
                int n;
                int n2;
                int n3;
                block9: {
                    CharSequence $this$indexOfFirst$iv = url;
                    boolean $i$f$indexOfFirst = false;
                    n3 = $this$indexOfFirst$iv.length();
                    for (int index$iv2 = 0; index$iv2 < n3; ++index$iv2) {
                        char it = $this$indexOfFirst$iv.charAt(index$iv2);
                        boolean bl2 = false;
                        if (!(it == '[')) continue;
                        n2 = index$iv2;
                        break block9;
                    }
                    n2 = -1;
                }
                openBracketIndex = n2;
                CharSequence $this$indexOfLast$iv = url;
                boolean $i$f$indexOfLast = false;
                n3 = $this$indexOfLast$iv.length() + -1;
                if (0 <= n3) {
                    do {
                        index$iv = n3--;
                        char it = $this$indexOfLast$iv.charAt(index$iv);
                        boolean bl3 = false;
                        if (!(it == ']')) continue;
                        n = index$iv;
                        break block10;
                    } while (0 <= n3);
                }
                n = closeBracketIndex = -1;
            }
            if (openBracketIndex < 0 || closeBracketIndex < 0) {
                return CollectionsKt.listOf((Object)url);
            }
            if (!(openBracketIndex <= closeBracketIndex)) {
                boolean $i$a$-require-LiveMapProviderUtil$createTileSystemProvider$splitSubdomains$32 = false;
                String $i$a$-require-LiveMapProviderUtil$createTileSystemProvider$splitSubdomains$32 = "Error parsing subdomains: wrong brackets order";
                throw new IllegalArgumentException($i$a$-require-LiveMapProviderUtil$createTileSystemProvider$splitSubdomains$32.toString());
            }
            String string = url.substring(openBracketIndex + 1, closeBracketIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            subdomains = string;
            if (!(((CharSequence)subdomains).length() > 0)) {
                boolean $i$a$-require-LiveMapProviderUtil$createTileSystemProvider$splitSubdomains$52 = false;
                String $i$a$-require-LiveMapProviderUtil$createTileSystemProvider$splitSubdomains$52 = "Empty subdomains list";
                throw new IllegalArgumentException($i$a$-require-LiveMapProviderUtil$createTileSystemProvider$splitSubdomains$52.toString());
            }
            CharSequence $this$all$iv = subdomains;
            boolean $i$f$all = false;
            for (index$iv = 0; index$iv < $this$all$iv.length(); ++index$iv) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(index$iv);
                boolean bl4 = false;
                char c = Character.toLowerCase(it);
                if ('a' <= c ? c < '{' : false) continue;
                bl = false;
                break block11;
            }
            bl = true;
        }
        if (!bl) {
            boolean $i$a$-require-LiveMapProviderUtil$createTileSystemProvider$splitSubdomains$62 = false;
            String $i$a$-require-LiveMapProviderUtil$createTileSystemProvider$splitSubdomains$62 = "subdomain list contains non-letter symbols";
            throw new IllegalArgumentException($i$a$-require-LiveMapProviderUtil$createTileSystemProvider$splitSubdomains$62.toString());
        }
        String string = url.substring(0, openBracketIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String urlStart = string;
        String string2 = url.substring(closeBracketIndex + 1, url.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String urlEnd = string2;
        CharSequence $this$map$iv = subdomains;
        boolean $i$f$map = false;
        CharSequence it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
            void it2;
            char item$iv$iv;
            char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(urlStart + (char)it2 + urlEnd);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ List access$createTargetLocators(LiveMapProviderUtil $this, List plotLayers, LiveMap liveMap) {
        return $this.createTargetLocators(plotLayers, liveMap);
    }

    public static final /* synthetic */ BasemapTileSystemProvider access$createTileSystemProvider(LiveMapProviderUtil $this, Map options, boolean debugTiles, int quant) {
        return $this.createTileSystemProvider(options, debugTiles, quant);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/livemap/LiveMapProviderUtil$MyLiveMapProvider;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/LiveMapProvider;", "letsPlotLayers", "", "Lorg/jetbrains/letsPlot/core/plot/builder/LayerRendererUtil$LayerRendererData;", "myLiveMapOptions", "", "cursor", "Lorg/jetbrains/letsPlot/livemap/ui/CursorService;", "(Ljava/util/List;Ljava/util/Map;Lorg/jetbrains/letsPlot/livemap/ui/CursorService;)V", "createLiveMap", "Lorg/jetbrains/letsPlot/core/plot/base/geom/LiveMapProvider$LiveMapData;", "bounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "plot-livemap"})
    @SourceDebugExtension(value={"SMAP\nLiveMapProviderUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveMapProviderUtil.kt\norg/jetbrains/letsPlot/core/plot/livemap/LiveMapProviderUtil$MyLiveMapProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 OptionsSelector.kt\norg/jetbrains/letsPlot/core/spec/OptionsSelectorKt\n+ 4 EnumInfoFactory.kt\norg/jetbrains/letsPlot/core/commons/enums/EnumInfoFactory\n*L\n1#1,265:1\n1#2:266\n198#3:267\n90#3,2:268\n92#3,9:271\n14#4:270\n*S KotlinDebug\n*F\n+ 1 LiveMapProviderUtil.kt\norg/jetbrains/letsPlot/core/plot/livemap/LiveMapProviderUtil$MyLiveMapProvider\n*L\n103#1:267\n103#1:268,2\n103#1:271,9\n103#1:270\n*E\n"})
    private static final class MyLiveMapProvider
    implements LiveMapProvider {
        @NotNull
        private final List<LayerRendererUtil.LayerRendererData> letsPlotLayers;
        @NotNull
        private final Map<?, ?> myLiveMapOptions;
        @NotNull
        private final CursorService cursor;

        public MyLiveMapProvider(@NotNull List<LayerRendererUtil.LayerRendererData> letsPlotLayers, @NotNull Map<?, ?> myLiveMapOptions, @NotNull CursorService cursor) {
            Intrinsics.checkNotNullParameter(letsPlotLayers, (String)"letsPlotLayers");
            Intrinsics.checkNotNullParameter(myLiveMapOptions, (String)"myLiveMapOptions");
            Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
            this.letsPlotLayers = letsPlotLayers;
            this.myLiveMapOptions = myLiveMapOptions;
            this.cursor = cursor;
            if (!(!((Collection)this.letsPlotLayers).isEmpty())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(((LayerRendererUtil.LayerRendererData)CollectionsKt.first(this.letsPlotLayers)).getGeomKind() == GeomKind.LIVE_MAP)) {
                boolean bl = false;
                String string = "geom_livemap have to be the very first geom after ggplot()";
                throw new IllegalArgumentException(string.toString());
            }
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @NotNull
        public LiveMapProvider.LiveMapData createLiveMap(@NotNull DoubleRectangle bounds) {
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            plotLayers = CollectionsKt.drop((Iterable)this.letsPlotLayers, (int)1);
            $this$createLiveMap_u24lambda_u242 = var4_3 = new LiveMapBuilder();
            $i$a$-apply-LiveMapProviderUtil$MyLiveMapProvider$createLiveMap$liveMapBuilder$1 = false;
            $this$createLiveMap_u24lambda_u242.setSize(bounds.getDimension());
            var7_7 = this.myLiveMapOptions;
            var8_8 = new Object[]{"projection"};
            query$iv = var8_8;
            $i$f$getEnum = false;
            var10_12 = $this$getEnum$iv;
            path$iv$iv = ArraysKt.toList((Object[])query$iv);
            $i$f$getEnum = false;
            v0 = OptionsSelectorKt.getString((Map)$this$getEnum$iv$iv, (List)path$iv$iv);
            if (v0 == null) {
                v1 = null;
            } else {
                name$iv$iv = v0;
                this_$iv$iv$iv = EnumInfoFactory.INSTANCE;
                $i$f$createEnumInfo = false;
                enumInfo$iv$iv = (EnumInfo)new EnumInfoImpl((Enum[])LivemapConstants.Projection.values());
                value$iv$iv = enumInfo$iv$iv.safeValueOf(name$iv$iv);
                if (!(value$iv$iv != null)) {
                    $i$a$-require-OptionsSelectorKt$getEnum$1$iv$iv = false;
                    var17_21 = "Unknown value '" + name$iv$iv + "'. Expected: " + CollectionsKt.joinToString$default((Iterable)enumInfo$iv$iv.getOriginalNames(), (CharSequence)"|", (CharSequence)" [", (CharSequence)"]", (int)0, null, (Function1)MyLiveMapProvider$createLiveMap$lambda$2$$inlined$getEnum$1.INSTANCE, (int)24, null);
                    throw new IllegalArgumentException(var17_21.toString());
                }
                v1 = value$iv$iv;
            }
            if ((v2 = (LivemapConstants.Projection)v1) == null) {
                v2 = LivemapConstants.Projection.EPSG3857;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[v2.ordinal()]) {
                case 1: {
                    v3 = Projections.INSTANCE.mercator();
                    break;
                }
                case 2: {
                    v3 = Projections.INSTANCE.geographic();
                    break;
                }
                case 3: {
                    v3 = Projections.INSTANCE.azimuthalEqualArea();
                    break;
                }
                case 4: {
                    v3 = Projections.INSTANCE.conicEqualArea();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            $this$createLiveMap_u24lambda_u242.setProjection(v3);
            var18_22 /* !! */  = new Object[]{"location"};
            $this$createLiveMap_u24lambda_u242.setMapLocation(ConfigUtil.INSTANCE.createMapLocation(OptionsSelectorKt.read(this.myLiveMapOptions, (Object[])var18_22 /* !! */ )));
            $this$createLiveMap_u24lambda_u242.setMapLocationConsumer((Function1)createLiveMap.liveMapBuilder.1.1.INSTANCE);
            var19_23 = new Object[]{"dev_params"};
            v4 = OptionsSelectorKt.getMap(this.myLiveMapOptions, (Object[])var19_23);
            if (v4 == null) {
                v4 = MapsKt.emptyMap();
            }
            $this$createLiveMap_u24lambda_u242.setDevParams(new DevParams(v4));
            $this$createLiveMap_u24lambda_u242.setCursorService(this.cursor);
            var18_22 /* !! */  = new Object[]{"tiles", "attribution"};
            $this$createLiveMap_u24lambda_u242.setAttribution(OptionsSelectorKt.getString(this.myLiveMapOptions, (Object[])var18_22 /* !! */ ));
            var19_23 = new Object[]{"tiles", "min_zoom"};
            v5 = OptionsSelectorKt.getInt(this.myLiveMapOptions, (Object[])var19_23);
            $this$createLiveMap_u24lambda_u242.setMinZoom(v5 != null ? v5.intValue() : $this$createLiveMap_u24lambda_u242.getMinZoom());
            var19_23 = new Object[]{"tiles", "max_zoom"};
            v6 = OptionsSelectorKt.getInt(this.myLiveMapOptions, (Object[])var19_23);
            $this$createLiveMap_u24lambda_u242.setMaxZoom(v6 != null ? v6.intValue() : $this$createLiveMap_u24lambda_u242.getMaxZoom());
            var18_22 /* !! */  = new Object[]{"zoom"};
            $this$createLiveMap_u24lambda_u242.setZoom(OptionsSelectorKt.getInt(this.myLiveMapOptions, (Object[])var18_22 /* !! */ ));
            var19_23 = new Object[]{"show_coord_pick_tools"};
            v7 = OptionsSelectorKt.getBool(this.myLiveMapOptions, (Object[])var19_23);
            $this$createLiveMap_u24lambda_u242.setShowCoordPickTools(v7 != null ? v7 : false);
            v8 = $this$createLiveMap_u24lambda_u242;
            var19_23 = new Object[]{"geocoding"};
            var18_22 /* !! */  = OptionsSelectorKt.getMap(this.myLiveMapOptions, (Object[])var19_23);
            if (var18_22 /* !! */  == null || (var19_23 = OptionsSelectorKt.getString((Map)var18_22 /* !! */ , (Object[])($this$getEnum$iv = new Object[]{"url"}))) == null) ** GOTO lbl-1000
            $i$f$getEnum = var19_23;
            var20_24 = v8;
            $i$a$-let-LiveMapProviderUtil$MyLiveMapProvider$createLiveMap$liveMapBuilder$1$2 = false;
            v8 = var20_24;
            $this$getEnum$iv = BuilderKt.liveMapGeocoding((Function1)((Function1)new Function1<LiveMapGeocodingServiceBuilder, Unit>((String)it){
                final /* synthetic */ String $it;
                {
                    this.$it = $it;
                    super(1);
                }

                public final void invoke(@NotNull LiveMapGeocodingServiceBuilder $this$liveMapGeocoding) {
                    Intrinsics.checkNotNullParameter((Object)$this$liveMapGeocoding, (String)"$this$liveMapGeocoding");
                    $this$liveMapGeocoding.setUrl(this.$it);
                }
            }));
            if ($this$getEnum$iv != null) {
                v9 = $this$getEnum$iv;
            } else lbl-1000:
            // 2 sources

            {
                v9 = Services.INSTANCE.bogusGeocodingService();
            }
            v8.setGeocodingService(v9);
            var19_23 = new Object[]{"tiles"};
            v10 = OptionsSelectorKt.getMap(this.myLiveMapOptions, (Object[])var19_23);
            if (v10 == null) {
                throw new IllegalStateException("Tiles must be condigured".toString());
            }
            $this$createLiveMap_u24lambda_u242.setTileSystemProvider(LiveMapProviderUtil.access$createTileSystemProvider(LiveMapProviderUtil.INSTANCE, v10, $this$createLiveMap_u24lambda_u242.getDevParams().isSet(DevParams.Companion.getDEBUG_TILES()), $this$createLiveMap_u24lambda_u242.getDevParams().read(DevParams.Companion.getCOMPUTATION_PROJECTION_QUANT())));
            var19_23 = new Object[]{"data_size_zoomin"};
            v11 = OptionsSelectorKt.getInt(this.myLiveMapOptions, (Object[])var19_23);
            var19_23 = new Object[]{"const_size_zoomin"};
            v12 = OptionsSelectorKt.getInt(this.myLiveMapOptions, (Object[])var19_23);
            $this$createLiveMap_u24lambda_u242.setLayers(LayerConverter.INSTANCE.convert(plotLayers, v11 != null ? v11 : 0, v12 != null ? v12 : -1));
            liveMapBuilder = var4_3;
            liveMap = liveMapBuilder.build();
            $this$createLiveMap_u24lambda_u243 = var6_6 = new LiveMapCanvasFigure(liveMap);
            $i$a$-apply-LiveMapProviderUtil$MyLiveMapProvider$createLiveMap$liveMapCanvasFigure$1 = false;
            $this$createLiveMap_u24lambda_u243.setBounds(new Rectangle(MathKt.roundToInt((double)bounds.getOrigin().getX()), MathKt.roundToInt((double)bounds.getOrigin().getY()), MathKt.roundToInt((double)bounds.getDimension().getX()), MathKt.roundToInt((double)bounds.getDimension().getY())));
            liveMapCanvasFigure = var6_6;
            return new LiveMapProvider.LiveMapData((SomeFig)liveMapCanvasFigure, LiveMapProviderUtil.access$createTargetLocators(LiveMapProviderUtil.INSTANCE, plotLayers, liveMap));
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LivemapConstants.Projection.values().length];
                try {
                    nArray[LivemapConstants.Projection.EPSG3857.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LivemapConstants.Projection.EPSG4326.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LivemapConstants.Projection.AZIMUTHAL.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LivemapConstants.Projection.CONIC.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

