/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.livemap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.FunctionsKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.VecKt;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.commons.values.FontFace;
import org.jetbrains.letsPlot.core.canvas.FontStyle;
import org.jetbrains.letsPlot.core.canvas.FontWeight;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Geom;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.CurveGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.DimensionUnit;
import org.jetbrains.letsPlot.core.plot.base.geom.PieGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.PointGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.SegmentGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.SpokeGeom;
import org.jetbrains.letsPlot.core.plot.base.pos.NudgePos;
import org.jetbrains.letsPlot.core.plot.builder.LayerRendererUtil;
import org.jetbrains.letsPlot.core.plot.livemap.DataPointLiveMapAesthetics;
import org.jetbrains.letsPlot.core.plot.livemap.DataPointsConverter;
import org.jetbrains.letsPlot.core.plot.livemap.LayerConverter;
import org.jetbrains.letsPlot.core.plot.livemap.MapLayerKind;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.api.FeatureLayerBuilder;
import org.jetbrains.letsPlot.livemap.api.LineEntityBuilder;
import org.jetbrains.letsPlot.livemap.api.LineLayerBuilder;
import org.jetbrains.letsPlot.livemap.api.LineLayerBuilderKt;
import org.jetbrains.letsPlot.livemap.api.PathEntityBuilder;
import org.jetbrains.letsPlot.livemap.api.PathLayerBuilder;
import org.jetbrains.letsPlot.livemap.api.PathLayerBuilderKt;
import org.jetbrains.letsPlot.livemap.api.PieEntityBuilder;
import org.jetbrains.letsPlot.livemap.api.PieLayerBuilder;
import org.jetbrains.letsPlot.livemap.api.PieLayerBuilderKt;
import org.jetbrains.letsPlot.livemap.api.PointEntityBuilder;
import org.jetbrains.letsPlot.livemap.api.PointLayerBuilder;
import org.jetbrains.letsPlot.livemap.api.PointLayerBuilderKt;
import org.jetbrains.letsPlot.livemap.api.PolygonEntityBuilder;
import org.jetbrains.letsPlot.livemap.api.PolygonLayerBuilder;
import org.jetbrains.letsPlot.livemap.api.PolygonLayerBuilderKt;
import org.jetbrains.letsPlot.livemap.api.TextEntityBuilder;
import org.jetbrains.letsPlot.livemap.api.TextLayerBuilder;
import org.jetbrains.letsPlot.livemap.api.TextLayerBuilderKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J;\u0010\u0003\u001a\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b0\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJY\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J$\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001d2\u0006\u0010\u001f\u001a\u00020\u00152\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0\u001dH\u0002J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/letsPlot/core/plot/livemap/LayerConverter;", "", "()V", "convert", "", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/livemap/api/FeatureLayerBuilder;", "", "Lkotlin/ExtensionFunctionType;", "letsPlotLayers", "Lorg/jetbrains/letsPlot/core/plot/builder/LayerRendererUtil$LayerRendererData;", "aesScalingLimit", "", "constScalingLimit", "createLayerBuilder", "layerIdx", "layerKind", "Lorg/jetbrains/letsPlot/core/plot/livemap/MapLayerKind;", "plotLayerKind", "Lorg/jetbrains/letsPlot/core/plot/base/GeomKind;", "layerPositionAdjustment", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "liveMapDataPoints", "Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointLiveMapAesthetics;", "sizeScalingRange", "Lkotlin/ranges/IntRange;", "alphaScalingEnabled", "", "nudgeClient", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/livemap/Client;", "position", "nudgePoint", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "point", "nudgeScaling", "plot-livemap"})
@SourceDebugExtension(value={"SMAP\nLayerConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayerConverter.kt\norg/jetbrains/letsPlot/core/plot/livemap/LayerConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,273:1\n1559#2:274\n1590#2,3:275\n1747#2,3:278\n1593#2:281\n*S KotlinDebug\n*F\n+ 1 LayerConverter.kt\norg/jetbrains/letsPlot/core/plot/livemap/LayerConverter\n*L\n36#1:274\n36#1:275,3\n60#1:278,3\n36#1:281\n*E\n"})
public final class LayerConverter {
    @NotNull
    public static final LayerConverter INSTANCE = new LayerConverter();

    private LayerConverter() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Function1<FeatureLayerBuilder, Unit>> convert(@NotNull List<LayerRendererUtil.LayerRendererData> letsPlotLayers, int aesScalingLimit, int constScalingLimit) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter(letsPlotLayers, (String)"letsPlotLayers");
        Iterable iterable = letsPlotLayers;
        boolean $i$f$mapIndexed = false;
        void var6_6 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            int n;
            boolean bl;
            List dataPointLiveMapAesthetics;
            MapLayerKind layerKind;
            void layer;
            void index;
            Collection collection;
            block24: {
                Pair pair;
                int n2;
                if ((n2 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                LayerRendererUtil.LayerRendererData layerRendererData = (LayerRendererUtil.LayerRendererData)item$iv$iv;
                int n3 = n2;
                collection = destination$iv$iv;
                boolean bl2 = false;
                DataPointsConverter dataPointsConverter = new DataPointsConverter((int)index, layer.getAesthetics());
                switch (WhenMappings.$EnumSwitchMapping$0[layer.getGeomKind().ordinal()]) {
                    case 1: {
                        Geom geom = layer.getGeom();
                        Intrinsics.checkNotNull((Object)geom, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.geom.PointGeom");
                        pair = TuplesKt.to((Object)((Object)MapLayerKind.POINT), dataPointsConverter.toPoint((PointGeom)geom));
                        break;
                    }
                    case 2: {
                        pair = TuplesKt.to((Object)((Object)MapLayerKind.H_LINE), dataPointsConverter.toHorizontalLine());
                        break;
                    }
                    case 3: {
                        pair = TuplesKt.to((Object)((Object)MapLayerKind.V_LINE), dataPointsConverter.toVerticalLine());
                        break;
                    }
                    case 4: {
                        Geom geom = layer.getGeom();
                        Intrinsics.checkNotNull((Object)geom, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.geom.SegmentGeom");
                        pair = TuplesKt.to((Object)((Object)MapLayerKind.PATH), dataPointsConverter.toSegment((SegmentGeom)geom));
                        break;
                    }
                    case 5: {
                        Geom geom = layer.getGeom();
                        Intrinsics.checkNotNull((Object)geom, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.geom.CurveGeom");
                        pair = TuplesKt.to((Object)((Object)MapLayerKind.PATH), dataPointsConverter.toCurve((CurveGeom)geom));
                        break;
                    }
                    case 6: {
                        pair = TuplesKt.to((Object)((Object)MapLayerKind.POLYGON), dataPointsConverter.toRect());
                        break;
                    }
                    case 7: 
                    case 8: {
                        pair = TuplesKt.to((Object)((Object)MapLayerKind.POLYGON), dataPointsConverter.toTile());
                        break;
                    }
                    case 9: {
                        Geom geom = layer.getGeom();
                        Intrinsics.checkNotNull((Object)geom, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.geom.SpokeGeom");
                        pair = TuplesKt.to((Object)((Object)MapLayerKind.PATH), dataPointsConverter.toSpoke((SpokeGeom)geom));
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        pair = TuplesKt.to((Object)((Object)MapLayerKind.PATH), dataPointsConverter.toPath(layer.getGeom()));
                        break;
                    }
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: {
                        pair = TuplesKt.to((Object)((Object)MapLayerKind.TEXT), dataPointsConverter.toText(layer.getGeom()));
                        break;
                    }
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: {
                        pair = TuplesKt.to((Object)((Object)MapLayerKind.POLYGON), dataPointsConverter.toPolygon());
                        break;
                    }
                    case 21: {
                        Geom geom = layer.getGeom();
                        Intrinsics.checkNotNull((Object)geom, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.geom.PieGeom");
                        pair = TuplesKt.to((Object)((Object)MapLayerKind.PIE), dataPointsConverter.toPie((PieGeom)geom));
                        break;
                    }
                    case 22: {
                        pair = TuplesKt.to((Object)((Object)MapLayerKind.POLYGON), dataPointsConverter.toHex());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Layer '" + layer.getGeomKind().name() + "' is not supported on Live Map.");
                    }
                }
                Pair pair2 = pair;
                layerKind = (MapLayerKind)((Object)pair2.component1());
                dataPointLiveMapAesthetics = (List)pair2.component2();
                Object[] objectArray = new Aes[]{Aes.Companion.getSIZE(), Aes.Companion.getSIZE_START(), Aes.Companion.getSIZE_END(), Aes.Companion.getPOINT_SIZE(), Aes.Companion.getPOINT_STROKE(), Aes.Companion.getSEGMENT_SIZE()};
                Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Aes it = (Aes)element$iv;
                        boolean bl3 = false;
                        if (!layer.getMappedAes().contains(it)) continue;
                        bl = true;
                        break block24;
                    }
                    bl = false;
                }
            }
            boolean bl4 = bl;
            if (bl4) {
                n = aesScalingLimit;
            } else if (!bl4) {
                n = constScalingLimit;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            int positiveScalingLimit = n;
            IntRange sizeScalingRange = positiveScalingLimit == -1 ? new IntRange(-2, Integer.MAX_VALUE) : new IntRange(-2, positiveScalingLimit);
            collection.add(INSTANCE.createLayerBuilder((int)index, layerKind, layer.getGeomKind(), layer.getPos(), dataPointLiveMapAesthetics, sizeScalingRange, sizeScalingRange.getLast() != 0));
        }
        return (List)destination$iv$iv;
    }

    private final Function1<FeatureLayerBuilder, Unit> createLayerBuilder(int layerIdx, MapLayerKind layerKind, GeomKind plotLayerKind, PositionAdjustment layerPositionAdjustment, List<DataPointLiveMapAesthetics> liveMapDataPoints, IntRange sizeScalingRange, boolean alphaScalingEnabled) {
        return (Function1)new Function1<FeatureLayerBuilder, Unit>(layerKind, liveMapDataPoints, sizeScalingRange, alphaScalingEnabled, layerIdx, layerPositionAdjustment, plotLayerKind){
            final /* synthetic */ MapLayerKind $layerKind;
            final /* synthetic */ List<DataPointLiveMapAesthetics> $liveMapDataPoints;
            final /* synthetic */ IntRange $sizeScalingRange;
            final /* synthetic */ boolean $alphaScalingEnabled;
            final /* synthetic */ int $layerIdx;
            final /* synthetic */ PositionAdjustment $layerPositionAdjustment;
            final /* synthetic */ GeomKind $plotLayerKind;
            {
                this.$layerKind = $layerKind;
                this.$liveMapDataPoints = $liveMapDataPoints;
                this.$sizeScalingRange = $sizeScalingRange;
                this.$alphaScalingEnabled = $alphaScalingEnabled;
                this.$layerIdx = $layerIdx;
                this.$layerPositionAdjustment = $layerPositionAdjustment;
                this.$plotLayerKind = $plotLayerKind;
                super(1);
            }

            public final void invoke(@NotNull FeatureLayerBuilder $this$null) {
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                switch (createLayerBuilder.WhenMappings.$EnumSwitchMapping$0[this.$layerKind.ordinal()]) {
                    case 1: {
                        PointLayerBuilderKt.points((FeatureLayerBuilder)$this$null, (Function1)((Function1)new Function1<PointLayerBuilder, Unit>(this.$liveMapDataPoints, this.$sizeScalingRange, this.$alphaScalingEnabled, this.$layerIdx){
                            final /* synthetic */ List<DataPointLiveMapAesthetics> $liveMapDataPoints;
                            final /* synthetic */ IntRange $sizeScalingRange;
                            final /* synthetic */ boolean $alphaScalingEnabled;
                            final /* synthetic */ int $layerIdx;
                            {
                                this.$liveMapDataPoints = $liveMapDataPoints;
                                this.$sizeScalingRange = $sizeScalingRange;
                                this.$alphaScalingEnabled = $alphaScalingEnabled;
                                this.$layerIdx = $layerIdx;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull PointLayerBuilder $this$points) {
                                void $this$forEach$iv;
                                Intrinsics.checkNotNullParameter((Object)$this$points, (String)"$this$points");
                                Iterable iterable = this.$liveMapDataPoints;
                                IntRange intRange = this.$sizeScalingRange;
                                boolean bl = this.$alphaScalingEnabled;
                                int n = this.$layerIdx;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    DataPointLiveMapAesthetics it = (DataPointLiveMapAesthetics)element$iv;
                                    boolean bl2 = false;
                                    PointLayerBuilderKt.point((PointLayerBuilder)$this$points, (Function1)((Function1)new Function1<PointEntityBuilder, Unit>(intRange, bl, n, it){
                                        final /* synthetic */ IntRange $sizeScalingRange;
                                        final /* synthetic */ boolean $alphaScalingEnabled;
                                        final /* synthetic */ int $layerIdx;
                                        final /* synthetic */ DataPointLiveMapAesthetics $it;
                                        {
                                            this.$sizeScalingRange = $sizeScalingRange;
                                            this.$alphaScalingEnabled = $alphaScalingEnabled;
                                            this.$layerIdx = $layerIdx;
                                            this.$it = $it;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull PointEntityBuilder $this$point) {
                                            Intrinsics.checkNotNullParameter((Object)$this$point, (String)"$this$point");
                                            $this$point.setSizeScalingRange((ClosedRange)this.$sizeScalingRange);
                                            $this$point.setAlphaScalingEnabled(this.$alphaScalingEnabled);
                                            $this$point.setLayerIndex(Integer.valueOf(this.$layerIdx));
                                            $this$point.setIndex(Integer.valueOf(this.$it.getIndex()));
                                            $this$point.setPoint(this.$it.getPoint());
                                            $this$point.setLabel(this.$it.getLabel());
                                            $this$point.setAnimation(this.$it.getAnimation());
                                            $this$point.setShape(this.$it.getShape());
                                            $this$point.setAngle(this.$it.getAngle());
                                            $this$point.setRadius(this.$it.getRadius());
                                            $this$point.setFillColor(this.$it.getFillColor());
                                            $this$point.setStrokeColor(this.$it.getStrokeColor());
                                            $this$point.setStrokeWidth(this.$it.getStrokeWidth());
                                        }
                                    }));
                                }
                            }
                        }));
                        break;
                    }
                    case 2: {
                        PolygonLayerBuilderKt.polygons((FeatureLayerBuilder)$this$null, (Function1)((Function1)new Function1<PolygonLayerBuilder, Unit>(this.$liveMapDataPoints, this.$sizeScalingRange, this.$alphaScalingEnabled, this.$layerIdx){
                            final /* synthetic */ List<DataPointLiveMapAesthetics> $liveMapDataPoints;
                            final /* synthetic */ IntRange $sizeScalingRange;
                            final /* synthetic */ boolean $alphaScalingEnabled;
                            final /* synthetic */ int $layerIdx;
                            {
                                this.$liveMapDataPoints = $liveMapDataPoints;
                                this.$sizeScalingRange = $sizeScalingRange;
                                this.$alphaScalingEnabled = $alphaScalingEnabled;
                                this.$layerIdx = $layerIdx;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull PolygonLayerBuilder $this$polygons) {
                                void $this$forEach$iv;
                                Intrinsics.checkNotNullParameter((Object)$this$polygons, (String)"$this$polygons");
                                Iterable iterable = this.$liveMapDataPoints;
                                IntRange intRange = this.$sizeScalingRange;
                                boolean bl = this.$alphaScalingEnabled;
                                int n = this.$layerIdx;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    DataPointLiveMapAesthetics it = (DataPointLiveMapAesthetics)element$iv;
                                    boolean bl2 = false;
                                    PolygonLayerBuilderKt.polygon((PolygonLayerBuilder)$this$polygons, (Function1)((Function1)new Function1<PolygonEntityBuilder, Unit>(intRange, bl, n, it){
                                        final /* synthetic */ IntRange $sizeScalingRange;
                                        final /* synthetic */ boolean $alphaScalingEnabled;
                                        final /* synthetic */ int $layerIdx;
                                        final /* synthetic */ DataPointLiveMapAesthetics $it;
                                        {
                                            this.$sizeScalingRange = $sizeScalingRange;
                                            this.$alphaScalingEnabled = $alphaScalingEnabled;
                                            this.$layerIdx = $layerIdx;
                                            this.$it = $it;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull PolygonEntityBuilder $this$polygon) {
                                            Intrinsics.checkNotNullParameter((Object)$this$polygon, (String)"$this$polygon");
                                            $this$polygon.setSizeScalingRange((ClosedRange)this.$sizeScalingRange);
                                            $this$polygon.setAlphaScalingEnabled(this.$alphaScalingEnabled);
                                            $this$polygon.setLayerIndex(Integer.valueOf(this.$layerIdx));
                                            $this$polygon.setIndex(Integer.valueOf(this.$it.getIndex()));
                                            List<Vec<LonLat>> list = this.$it.getGeometry();
                                            Intrinsics.checkNotNull(list);
                                            $this$polygon.setGeometry(FunctionsKt.createMultiPolygon(list));
                                            $this$polygon.setGeoObject(this.$it.getGeoObject());
                                            $this$polygon.setLineDash(this.$it.getLineDash());
                                            $this$polygon.setLineDashOffset(this.$it.getLineDashOffset());
                                            $this$polygon.setFillColor(this.$it.getFillColor());
                                            $this$polygon.setStrokeColor(this.$it.getStrokeColor());
                                            $this$polygon.setStrokeWidth(AestheticsUtil.INSTANCE.strokeWidth(this.$it.getMyP()));
                                        }
                                    }));
                                }
                            }
                        }));
                        break;
                    }
                    case 3: {
                        PathLayerBuilderKt.paths((FeatureLayerBuilder)$this$null, (Function1)((Function1)new Function1<PathLayerBuilder, Unit>(this.$liveMapDataPoints, this.$sizeScalingRange, this.$alphaScalingEnabled, this.$layerIdx){
                            final /* synthetic */ List<DataPointLiveMapAesthetics> $liveMapDataPoints;
                            final /* synthetic */ IntRange $sizeScalingRange;
                            final /* synthetic */ boolean $alphaScalingEnabled;
                            final /* synthetic */ int $layerIdx;
                            {
                                this.$liveMapDataPoints = $liveMapDataPoints;
                                this.$sizeScalingRange = $sizeScalingRange;
                                this.$alphaScalingEnabled = $alphaScalingEnabled;
                                this.$layerIdx = $layerIdx;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull PathLayerBuilder $this$paths) {
                                void $this$forEach$iv;
                                Intrinsics.checkNotNullParameter((Object)$this$paths, (String)"$this$paths");
                                Iterable iterable = this.$liveMapDataPoints;
                                IntRange intRange = this.$sizeScalingRange;
                                boolean bl = this.$alphaScalingEnabled;
                                int n = this.$layerIdx;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    DataPointLiveMapAesthetics it = (DataPointLiveMapAesthetics)element$iv;
                                    boolean bl2 = false;
                                    if (it.getGeometry() == null) continue;
                                    PathLayerBuilderKt.path((PathLayerBuilder)$this$paths, (Function1)((Function1)new Function1<PathEntityBuilder, Unit>(intRange, bl, n, it){
                                        final /* synthetic */ IntRange $sizeScalingRange;
                                        final /* synthetic */ boolean $alphaScalingEnabled;
                                        final /* synthetic */ int $layerIdx;
                                        final /* synthetic */ DataPointLiveMapAesthetics $it;
                                        {
                                            this.$sizeScalingRange = $sizeScalingRange;
                                            this.$alphaScalingEnabled = $alphaScalingEnabled;
                                            this.$layerIdx = $layerIdx;
                                            this.$it = $it;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull PathEntityBuilder $this$path) {
                                            Intrinsics.checkNotNullParameter((Object)$this$path, (String)"$this$path");
                                            $this$path.setSizeScalingRange((ClosedRange)this.$sizeScalingRange);
                                            $this$path.setAlphaScalingEnabled(this.$alphaScalingEnabled);
                                            $this$path.setLayerIndex(Integer.valueOf(this.$layerIdx));
                                            $this$path.setIndex(Integer.valueOf(this.$it.getIndex()));
                                            List<Vec<LonLat>> list = this.$it.getGeometry();
                                            Intrinsics.checkNotNull(list);
                                            $this$path.setPoints(list);
                                            $this$path.setFlat(this.$it.getFlat());
                                            $this$path.setGeodesic(this.$it.getGeodesic());
                                            $this$path.setLineDash(this.$it.getLineDash());
                                            $this$path.setLineDashOffset(this.$it.getLineDashOffset());
                                            $this$path.setStrokeColor(this.$it.getStrokeColor());
                                            $this$path.setStrokeWidth(AestheticsUtil.INSTANCE.strokeWidth(this.$it.getMyP()));
                                            $this$path.setAnimation(this.$it.getAnimation());
                                            $this$path.setSpeed(this.$it.getSpeed());
                                            $this$path.setFlow(this.$it.getFlow());
                                            $this$path.setArrowSpec(this.$it.getArrowSpec());
                                            $this$path.setCurve(this.$it.isCurve());
                                            $this$path.setSizeStart-hZjkWWM(this.$it.getSizeStart-b9qgYVc());
                                            $this$path.setSizeEnd-hZjkWWM(this.$it.getSizeEnd-b9qgYVc());
                                            $this$path.setStrokeStart-hZjkWWM(this.$it.getStrokeStart-b9qgYVc());
                                            $this$path.setStrokeEnd-hZjkWWM(this.$it.getStrokeEnd-b9qgYVc());
                                            $this$path.setSpacer-hZjkWWM(this.$it.getSpacer-b9qgYVc());
                                        }
                                    }));
                                }
                            }
                        }));
                        break;
                    }
                    case 4: {
                        LineLayerBuilderKt.vLines((FeatureLayerBuilder)$this$null, (Function1)((Function1)new Function1<LineLayerBuilder, Unit>(this.$liveMapDataPoints, this.$sizeScalingRange, this.$alphaScalingEnabled, this.$layerIdx){
                            final /* synthetic */ List<DataPointLiveMapAesthetics> $liveMapDataPoints;
                            final /* synthetic */ IntRange $sizeScalingRange;
                            final /* synthetic */ boolean $alphaScalingEnabled;
                            final /* synthetic */ int $layerIdx;
                            {
                                this.$liveMapDataPoints = $liveMapDataPoints;
                                this.$sizeScalingRange = $sizeScalingRange;
                                this.$alphaScalingEnabled = $alphaScalingEnabled;
                                this.$layerIdx = $layerIdx;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull LineLayerBuilder $this$vLines) {
                                void $this$forEach$iv;
                                Intrinsics.checkNotNullParameter((Object)$this$vLines, (String)"$this$vLines");
                                Iterable iterable = this.$liveMapDataPoints;
                                IntRange intRange = this.$sizeScalingRange;
                                boolean bl = this.$alphaScalingEnabled;
                                int n = this.$layerIdx;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    DataPointLiveMapAesthetics it = (DataPointLiveMapAesthetics)element$iv;
                                    boolean bl2 = false;
                                    LineLayerBuilderKt.line((LineLayerBuilder)$this$vLines, (Function1)((Function1)new Function1<LineEntityBuilder, Unit>(intRange, bl, n, it){
                                        final /* synthetic */ IntRange $sizeScalingRange;
                                        final /* synthetic */ boolean $alphaScalingEnabled;
                                        final /* synthetic */ int $layerIdx;
                                        final /* synthetic */ DataPointLiveMapAesthetics $it;
                                        {
                                            this.$sizeScalingRange = $sizeScalingRange;
                                            this.$alphaScalingEnabled = $alphaScalingEnabled;
                                            this.$layerIdx = $layerIdx;
                                            this.$it = $it;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull LineEntityBuilder $this$line) {
                                            Intrinsics.checkNotNullParameter((Object)$this$line, (String)"$this$line");
                                            $this$line.setSizeScalingRange((ClosedRange)this.$sizeScalingRange);
                                            $this$line.setAlphaScalingEnabled(this.$alphaScalingEnabled);
                                            $this$line.setLayerIndex(Integer.valueOf(this.$layerIdx));
                                            $this$line.setIndex(Integer.valueOf(this.$it.getIndex()));
                                            $this$line.setPoint(this.$it.getPoint());
                                            $this$line.setLineDash(this.$it.getLineDash());
                                            $this$line.setLineDashOffset(this.$it.getLineDashOffset());
                                            $this$line.setStrokeColor(this.$it.getStrokeColor());
                                            $this$line.setStrokeWidth(AestheticsUtil.INSTANCE.strokeWidth(this.$it.getMyP()));
                                        }
                                    }));
                                }
                            }
                        }));
                        break;
                    }
                    case 5: {
                        LineLayerBuilderKt.hLines((FeatureLayerBuilder)$this$null, (Function1)((Function1)new Function1<LineLayerBuilder, Unit>(this.$liveMapDataPoints, this.$sizeScalingRange, this.$alphaScalingEnabled, this.$layerIdx){
                            final /* synthetic */ List<DataPointLiveMapAesthetics> $liveMapDataPoints;
                            final /* synthetic */ IntRange $sizeScalingRange;
                            final /* synthetic */ boolean $alphaScalingEnabled;
                            final /* synthetic */ int $layerIdx;
                            {
                                this.$liveMapDataPoints = $liveMapDataPoints;
                                this.$sizeScalingRange = $sizeScalingRange;
                                this.$alphaScalingEnabled = $alphaScalingEnabled;
                                this.$layerIdx = $layerIdx;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull LineLayerBuilder $this$hLines) {
                                void $this$forEach$iv;
                                Intrinsics.checkNotNullParameter((Object)$this$hLines, (String)"$this$hLines");
                                Iterable iterable = this.$liveMapDataPoints;
                                IntRange intRange = this.$sizeScalingRange;
                                boolean bl = this.$alphaScalingEnabled;
                                int n = this.$layerIdx;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    DataPointLiveMapAesthetics it = (DataPointLiveMapAesthetics)element$iv;
                                    boolean bl2 = false;
                                    LineLayerBuilderKt.line((LineLayerBuilder)$this$hLines, (Function1)((Function1)new Function1<LineEntityBuilder, Unit>(intRange, bl, n, it){
                                        final /* synthetic */ IntRange $sizeScalingRange;
                                        final /* synthetic */ boolean $alphaScalingEnabled;
                                        final /* synthetic */ int $layerIdx;
                                        final /* synthetic */ DataPointLiveMapAesthetics $it;
                                        {
                                            this.$sizeScalingRange = $sizeScalingRange;
                                            this.$alphaScalingEnabled = $alphaScalingEnabled;
                                            this.$layerIdx = $layerIdx;
                                            this.$it = $it;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull LineEntityBuilder $this$line) {
                                            Intrinsics.checkNotNullParameter((Object)$this$line, (String)"$this$line");
                                            $this$line.setSizeScalingRange((ClosedRange)this.$sizeScalingRange);
                                            $this$line.setAlphaScalingEnabled(this.$alphaScalingEnabled);
                                            $this$line.setLayerIndex(Integer.valueOf(this.$layerIdx));
                                            $this$line.setIndex(Integer.valueOf(this.$it.getIndex()));
                                            $this$line.setPoint(this.$it.getPoint());
                                            $this$line.setLineDash(this.$it.getLineDash());
                                            $this$line.setLineDashOffset(this.$it.getLineDashOffset());
                                            $this$line.setStrokeColor(this.$it.getStrokeColor());
                                            $this$line.setStrokeWidth(AestheticsUtil.INSTANCE.strokeWidth(this.$it.getMyP()));
                                        }
                                    }));
                                }
                            }
                        }));
                        break;
                    }
                    case 6: {
                        TextLayerBuilderKt.texts((FeatureLayerBuilder)$this$null, (Function1)((Function1)new Function1<TextLayerBuilder, Unit>(this.$liveMapDataPoints, this.$sizeScalingRange, this.$alphaScalingEnabled, this.$layerPositionAdjustment, this.$plotLayerKind){
                            final /* synthetic */ List<DataPointLiveMapAesthetics> $liveMapDataPoints;
                            final /* synthetic */ IntRange $sizeScalingRange;
                            final /* synthetic */ boolean $alphaScalingEnabled;
                            final /* synthetic */ PositionAdjustment $layerPositionAdjustment;
                            final /* synthetic */ GeomKind $plotLayerKind;
                            {
                                this.$liveMapDataPoints = $liveMapDataPoints;
                                this.$sizeScalingRange = $sizeScalingRange;
                                this.$alphaScalingEnabled = $alphaScalingEnabled;
                                this.$layerPositionAdjustment = $layerPositionAdjustment;
                                this.$plotLayerKind = $plotLayerKind;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull TextLayerBuilder $this$texts) {
                                void $this$forEach$iv;
                                Intrinsics.checkNotNullParameter((Object)$this$texts, (String)"$this$texts");
                                Iterable iterable = this.$liveMapDataPoints;
                                IntRange intRange = this.$sizeScalingRange;
                                boolean bl = this.$alphaScalingEnabled;
                                PositionAdjustment positionAdjustment = this.$layerPositionAdjustment;
                                GeomKind geomKind = this.$plotLayerKind;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    DataPointLiveMapAesthetics it = (DataPointLiveMapAesthetics)element$iv;
                                    boolean bl2 = false;
                                    TextLayerBuilderKt.text((TextLayerBuilder)$this$texts, (Function1)((Function1)new Function1<TextEntityBuilder, Unit>(intRange, bl, it, positionAdjustment, geomKind){
                                        final /* synthetic */ IntRange $sizeScalingRange;
                                        final /* synthetic */ boolean $alphaScalingEnabled;
                                        final /* synthetic */ DataPointLiveMapAesthetics $it;
                                        final /* synthetic */ PositionAdjustment $layerPositionAdjustment;
                                        final /* synthetic */ GeomKind $plotLayerKind;
                                        {
                                            this.$sizeScalingRange = $sizeScalingRange;
                                            this.$alphaScalingEnabled = $alphaScalingEnabled;
                                            this.$it = $it;
                                            this.$layerPositionAdjustment = $layerPositionAdjustment;
                                            this.$plotLayerKind = $plotLayerKind;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull TextEntityBuilder $this$text) {
                                            FontStyle fontStyle;
                                            Color color;
                                            Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
                                            $this$text.setSizeScalingRange((ClosedRange)this.$sizeScalingRange);
                                            $this$text.setAlphaScalingEnabled(this.$alphaScalingEnabled);
                                            $this$text.setIndex(this.$it.getIndex());
                                            $this$text.setPoint(LayerConverter.access$nudgePoint(LayerConverter.INSTANCE, this.$layerPositionAdjustment, this.$it.getPoint()));
                                            $this$text.setFillColor(this.$plotLayerKind == GeomKind.LABEL ? this.$it.getFillColor() : Color.Companion.getTRANSPARENT());
                                            if (this.$plotLayerKind == GeomKind.LABEL && !this.$it.getAlphaStroke()) {
                                                Color color2 = this.$it.getMyP().color();
                                                color = color2;
                                                Intrinsics.checkNotNull((Object)color2);
                                            } else {
                                                color = this.$it.getStrokeColor();
                                            }
                                            $this$text.setStrokeColor(color);
                                            $this$text.setStrokeWidth(0.0);
                                            $this$text.setLabel(this.$it.getLabel());
                                            $this$text.setSize(this.$it.getSize());
                                            $this$text.setFamily(this.$it.getFamily());
                                            $this$text.setHjust(this.$it.getHjust());
                                            $this$text.setVjust(this.$it.getVjust());
                                            $this$text.setAngle(this.$it.getAngle());
                                            $this$text.setDrawBorder(this.$plotLayerKind == GeomKind.LABEL);
                                            $this$text.setLabelPadding(this.$it.getLabelPadding());
                                            $this$text.setLabelRadius(this.$it.getLabelRadius());
                                            $this$text.setLabelSize(this.$it.getLabelSize());
                                            $this$text.setLineheight(this.$it.getLineheight());
                                            $this$text.setNudgeClient(LayerConverter.access$nudgeClient(LayerConverter.INSTANCE, this.$layerPositionAdjustment));
                                            $this$text.setEnableNudgeScaling(LayerConverter.access$nudgeScaling(LayerConverter.INSTANCE, this.$layerPositionAdjustment));
                                            FontFace fontFace = FontFace.Companion.fromString(this.$it.getFontface());
                                            FontStyle fontStyle2 = fontStyle = FontStyle.ITALIC;
                                            TextEntityBuilder textEntityBuilder = $this$text;
                                            boolean bl = false;
                                            boolean bl2 = fontFace.getItalic();
                                            Object object = bl2 ? fontStyle : null;
                                            if (object == null) {
                                                object = FontStyle.NORMAL;
                                            }
                                            textEntityBuilder.setFontStyle(object);
                                            FontStyle it = fontStyle = FontWeight.BOLD;
                                            textEntityBuilder = $this$text;
                                            boolean bl3 = false;
                                            bl2 = fontFace.getBold();
                                            Object object2 = bl2 ? fontStyle : null;
                                            if (object2 == null) {
                                                object2 = FontWeight.NORMAL;
                                            }
                                            textEntityBuilder.setFontWeight((FontWeight)object2);
                                        }
                                    }));
                                }
                            }
                        }));
                        break;
                    }
                    case 7: {
                        PieLayerBuilderKt.pies((FeatureLayerBuilder)$this$null, (Function1)((Function1)new Function1<PieLayerBuilder, Unit>(this.$liveMapDataPoints, this.$sizeScalingRange, this.$alphaScalingEnabled, this.$layerIdx){
                            final /* synthetic */ List<DataPointLiveMapAesthetics> $liveMapDataPoints;
                            final /* synthetic */ IntRange $sizeScalingRange;
                            final /* synthetic */ boolean $alphaScalingEnabled;
                            final /* synthetic */ int $layerIdx;
                            {
                                this.$liveMapDataPoints = $liveMapDataPoints;
                                this.$sizeScalingRange = $sizeScalingRange;
                                this.$alphaScalingEnabled = $alphaScalingEnabled;
                                this.$layerIdx = $layerIdx;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull PieLayerBuilder $this$pies) {
                                void $this$forEach$iv;
                                Intrinsics.checkNotNullParameter((Object)$this$pies, (String)"$this$pies");
                                Iterable iterable = this.$liveMapDataPoints;
                                IntRange intRange = this.$sizeScalingRange;
                                boolean bl = this.$alphaScalingEnabled;
                                int n = this.$layerIdx;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    DataPointLiveMapAesthetics it = (DataPointLiveMapAesthetics)element$iv;
                                    boolean bl2 = false;
                                    PieLayerBuilderKt.pie((PieLayerBuilder)$this$pies, (Function1)((Function1)new Function1<PieEntityBuilder, Unit>(intRange, bl, n, it){
                                        final /* synthetic */ IntRange $sizeScalingRange;
                                        final /* synthetic */ boolean $alphaScalingEnabled;
                                        final /* synthetic */ int $layerIdx;
                                        final /* synthetic */ DataPointLiveMapAesthetics $it;
                                        {
                                            this.$sizeScalingRange = $sizeScalingRange;
                                            this.$alphaScalingEnabled = $alphaScalingEnabled;
                                            this.$layerIdx = $layerIdx;
                                            this.$it = $it;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull PieEntityBuilder $this$pie) {
                                            Intrinsics.checkNotNullParameter((Object)$this$pie, (String)"$this$pie");
                                            $this$pie.setSizeScalingRange((ClosedRange)this.$sizeScalingRange);
                                            $this$pie.setAlphaScalingEnabled(this.$alphaScalingEnabled);
                                            $this$pie.setLayerIndex(Integer.valueOf(this.$layerIdx));
                                            $this$pie.setPoint(this.$it.getPoint());
                                            $this$pie.setRadius(this.$it.getRadius());
                                            $this$pie.setIndices(this.$it.getIndices());
                                            $this$pie.setValues(this.$it.getValueArray());
                                            $this$pie.setFillColors(this.$it.getFillArray());
                                            $this$pie.setExplodes(this.$it.getExplodeArray());
                                            $this$pie.setStrokeColors(this.$it.getColorArray());
                                            $this$pie.setStrokeWidths(this.$it.getStrokeArray());
                                            $this$pie.setStrokeSide(this.$it.getStrokeSide());
                                            $this$pie.setHoleSize(this.$it.getHoleRatio());
                                            $this$pie.setSpacerColor(this.$it.getSpacerColor());
                                            $this$pie.setSpacerWidth(this.$it.getSpacerWidth());
                                            $this$pie.setStartAngle(this.$it.getStartAngle());
                                            $this$pie.setClockwise(this.$it.getClockwise());
                                        }
                                    }));
                                }
                            }
                        }));
                    }
                }
            }
        };
    }

    private final Vec<LonLat> nudgePoint(PositionAdjustment position, Vec<? extends LonLat> point2) {
        if (position instanceof NudgePos && ((NudgePos)position).getUnit() == DimensionUnit.IDENTITY) {
            return VecKt.plus(point2, (Vec)FunctionsKt.toVec((DoubleVector)((NudgePos)position).getAdjustedDimension()));
        }
        return point2;
    }

    private final Vec<Client> nudgeClient(PositionAdjustment position) {
        if (position instanceof NudgePos && (((NudgePos)position).getUnit() == DimensionUnit.SIZE || ((NudgePos)position).getUnit() == DimensionUnit.PIXEL)) {
            return FunctionsKt.toVec((DoubleVector)((NudgePos)position).getAdjustedDimension());
        }
        return new Vec(0.0, 0.0);
    }

    private final boolean nudgeScaling(PositionAdjustment position) {
        return position instanceof NudgePos && ((NudgePos)position).getUnit() == DimensionUnit.SIZE;
    }

    public static final /* synthetic */ Vec access$nudgePoint(LayerConverter $this, PositionAdjustment position, Vec point2) {
        return $this.nudgePoint(position, (Vec<? extends LonLat>)point2);
    }

    public static final /* synthetic */ Vec access$nudgeClient(LayerConverter $this, PositionAdjustment position) {
        return $this.nudgeClient(position);
    }

    public static final /* synthetic */ boolean access$nudgeScaling(LayerConverter $this, PositionAdjustment position) {
        return $this.nudgeScaling(position);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GeomKind.values().length];
            try {
                nArray[GeomKind.POINT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.H_LINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.V_LINE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.SEGMENT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.CURVE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.RECT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.TILE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.BIN_2D.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.SPOKE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.DENSITY2D.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.CONTOUR.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.PATH.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.TEXT.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.LABEL.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.TEXT_REPEL.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.LABEL_REPEL.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.DENSITY2DF.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.CONTOURF.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.POLYGON.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.MAP.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.PIE.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeomKind.HEX.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

