/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.livemap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.VecKt;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.Geom;
import org.jetbrains.letsPlot.core.plot.base.geom.CurveGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.HexGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.LabelGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.PathGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.PieGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.PointGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.SegmentGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.SpokeGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.util.ArrowSpec;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.LabelOptions;
import org.jetbrains.letsPlot.core.plot.base.geom.util.LinesHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.PathData;
import org.jetbrains.letsPlot.core.plot.base.geom.util.PathPoint;
import org.jetbrains.letsPlot.core.plot.builder.scale.DefaultNaValue;
import org.jetbrains.letsPlot.core.plot.livemap.DataPointLiveMapAesthetics;
import org.jetbrains.letsPlot.core.plot.livemap.DataPointsConverter;
import org.jetbrains.letsPlot.core.plot.livemap.MapLayerKind;
import org.jetbrains.letsPlot.livemap.Client;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 *2\u00020\u0001:\u0007*+,-./0B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0019J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u001dJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020 J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020$J\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020&J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u001dJ\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00060\bR\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u00060\fR\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00061"}, d2={"Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter;", "", "layerIndex", "", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "(ILorg/jetbrains/letsPlot/core/plot/base/Aesthetics;)V", "myMultiPathFeatureConverter", "Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$MultiPathFeatureConverter;", "getMyMultiPathFeatureConverter", "()Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$MultiPathFeatureConverter;", "mySinglePathFeatureConverter", "Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$SinglePathFeatureConverter;", "getMySinglePathFeatureConverter", "()Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$SinglePathFeatureConverter;", "pointFeatureConverter", "Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$PointFeatureConverter;", "getPointFeatureConverter", "()Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$PointFeatureConverter;", "pieConverter", "", "Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointLiveMapAesthetics;", "geom", "Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom;", "toCurve", "Lorg/jetbrains/letsPlot/core/plot/base/geom/CurveGeom;", "toHex", "toHorizontalLine", "toPath", "Lorg/jetbrains/letsPlot/core/plot/base/Geom;", "toPie", "toPoint", "Lorg/jetbrains/letsPlot/core/plot/base/geom/PointGeom;", "toPolygon", "toRect", "toSegment", "Lorg/jetbrains/letsPlot/core/plot/base/geom/SegmentGeom;", "toSpoke", "Lorg/jetbrains/letsPlot/core/plot/base/geom/SpokeGeom;", "toText", "toTile", "toVerticalLine", "Companion", "MultiDataPointHelper", "MultiPathFeatureConverter", "PathFeatureConverterBase", "PieOptions", "PointFeatureConverter", "SinglePathFeatureConverter", "plot-livemap"})
@SourceDebugExtension(value={"SMAP\nDataPointsConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataPointsConverter.kt\norg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,425:1\n1549#2:426\n1620#2,3:427\n*S KotlinDebug\n*F\n+ 1 DataPointsConverter.kt\norg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter\n*L\n64#1:426\n64#1:427,3\n*E\n"})
public final class DataPointsConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int layerIndex;
    @NotNull
    private final Aesthetics aesthetics;

    public DataPointsConverter(int layerIndex, @NotNull Aesthetics aesthetics) {
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        this.layerIndex = layerIndex;
        this.aesthetics = aesthetics;
    }

    private final PointFeatureConverter getPointFeatureConverter() {
        return new PointFeatureConverter(this.aesthetics);
    }

    private final SinglePathFeatureConverter getMySinglePathFeatureConverter() {
        return new SinglePathFeatureConverter(this.aesthetics);
    }

    private final MultiPathFeatureConverter getMyMultiPathFeatureConverter() {
        return new MultiPathFeatureConverter(this.aesthetics);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DataPointLiveMapAesthetics> pieConverter(PieGeom geom) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        PieOptions pieOptions = new PieOptions(geom.getSpacerColor(), geom.getSpacerWidth(), geom.getHoleSize(), geom.getStrokeSide(), geom.getStart(), geom.getClockwise());
        Iterable definedDataPoints = GeomUtil.INSTANCE.withDefined(this.aesthetics.dataPoints(), Aes.Companion.getX(), Aes.Companion.getY(), Aes.Companion.getSLICE());
        Iterable iterable = MultiDataPointHelper.Companion.getPoints(definedDataPoints);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DataPointLiveMapAesthetics dataPointLiveMapAesthetics;
            MultiDataPointHelper.MultiDataPoint multiDataPoint = (MultiDataPointHelper.MultiDataPoint)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DataPointLiveMapAesthetics $this$pieConverter_u24lambda_u241_u24lambda_u240 = dataPointLiveMapAesthetics = new DataPointLiveMapAesthetics((MultiDataPointHelper.MultiDataPoint)it, MapLayerKind.PIE);
            boolean bl2 = false;
            Double d = it.getAes().x();
            Intrinsics.checkNotNull((Object)d);
            double d2 = d;
            Double d3 = it.getAes().y();
            Intrinsics.checkNotNull((Object)d3);
            $this$pieConverter_u24lambda_u241_u24lambda_u240.setPoint((Vec<? extends LonLat>)new Vec(d2, d3.doubleValue()));
            $this$pieConverter_u24lambda_u241_u24lambda_u240.setPieOptions(pieOptions);
            collection.add(dataPointLiveMapAesthetics);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<DataPointLiveMapAesthetics> toPoint(@NotNull PointGeom geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        return this.getPointFeatureConverter().point(geom);
    }

    @NotNull
    public final List<DataPointLiveMapAesthetics> toHorizontalLine() {
        return this.getPointFeatureConverter().hLine();
    }

    @NotNull
    public final List<DataPointLiveMapAesthetics> toVerticalLine() {
        return this.getPointFeatureConverter().vLine();
    }

    @NotNull
    public final List<DataPointLiveMapAesthetics> toSegment(@NotNull SegmentGeom geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        return this.getMySinglePathFeatureConverter().segment(geom);
    }

    @NotNull
    public final List<DataPointLiveMapAesthetics> toRect() {
        return this.getMyMultiPathFeatureConverter().rect();
    }

    @NotNull
    public final List<DataPointLiveMapAesthetics> toTile() {
        return this.getMySinglePathFeatureConverter().tile();
    }

    @NotNull
    public final List<DataPointLiveMapAesthetics> toPath(@NotNull Geom geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        return this.getMyMultiPathFeatureConverter().path(geom);
    }

    @NotNull
    public final List<DataPointLiveMapAesthetics> toPolygon() {
        return this.getMyMultiPathFeatureConverter().polygon();
    }

    @NotNull
    public final List<DataPointLiveMapAesthetics> toText(@NotNull Geom geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        return this.getPointFeatureConverter().text(geom);
    }

    @NotNull
    public final List<DataPointLiveMapAesthetics> toPie(@NotNull PieGeom geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        return this.pieConverter(geom);
    }

    @NotNull
    public final List<DataPointLiveMapAesthetics> toCurve(@NotNull CurveGeom geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        return this.getMySinglePathFeatureConverter().curve(geom);
    }

    @NotNull
    public final List<DataPointLiveMapAesthetics> toSpoke(@NotNull SpokeGeom geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        return this.getMySinglePathFeatureConverter().spoke(geom);
    }

    @NotNull
    public final List<DataPointLiveMapAesthetics> toHex() {
        return this.getMySinglePathFeatureConverter().hex();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00050\u0004\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$Companion;", "", "()V", "toVecs", "", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "T", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-livemap"})
    @SourceDebugExtension(value={"SMAP\nDataPointsConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataPointsConverter.kt\norg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,425:1\n1549#2:426\n1620#2,3:427\n*S KotlinDebug\n*F\n+ 1 DataPointsConverter.kt\norg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$Companion\n*L\n36#1:426\n36#1:427,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final <T> List<Vec<T>> toVecs(List<DoubleVector> $this$toVecs) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$toVecs;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DoubleVector doubleVector = (DoubleVector)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(VecKt.explicitVec((double)it.getX(), (double)it.getY()));
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$MultiDataPointHelper;", "", "()V", "Companion", "MultiDataPoint", "MultiDataPointBuilder", "plot-livemap"})
    public static final class MultiDataPointHelper {
        @NotNull
        public static final Companion Companion = new Companion(null);

        private MultiDataPointHelper() {
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$MultiDataPointHelper$Companion;", "", "()V", "getPoints", "", "Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$MultiDataPointHelper$MultiDataPoint;", "dataPoints", "", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "plot-livemap"})
        @SourceDebugExtension(value={"SMAP\nDataPointsConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataPointsConverter.kt\norg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$MultiDataPointHelper$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,425:1\n1855#2,2:426\n1549#2:428\n1620#2,3:429\n372#3,7:432\n*S KotlinDebug\n*F\n+ 1 DataPointsConverter.kt\norg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$MultiDataPointHelper$Companion\n*L\n388#1:426,2\n389#1:428\n389#1:429,3\n385#1:432,7\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<MultiDataPoint> getPoints(@NotNull Iterable<? extends DataPointAesthetics> dataPoints) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(dataPoints, (String)"dataPoints");
                HashMap<Vec<LonLat>, MultiDataPointBuilder> builders = new HashMap<Vec<LonLat>, MultiDataPointBuilder>();
                Iterable<? extends DataPointAesthetics> $this$forEach$iv = dataPoints;
                boolean $i$f$forEach = false;
                Object object = $this$forEach$iv.iterator();
                while (object.hasNext()) {
                    DataPointAesthetics element$iv;
                    DataPointAesthetics p = element$iv = object.next();
                    boolean bl = false;
                    org.jetbrains.letsPlot.core.plot.livemap.DataPointsConverter$MultiDataPointHelper$Companion.getPoints$fetchBuilder(builders, p).add(p);
                }
                Collection collection = builders.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $this$map$iv = collection;
                boolean $i$f$map = false;
                object = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    MultiDataPointBuilder multiDataPointBuilder = (MultiDataPointBuilder)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(p0.build());
                }
                return (List)destination$iv$iv;
            }

            private static final MultiDataPointBuilder getPoints$fetchBuilder(HashMap<Vec<LonLat>, MultiDataPointBuilder> builders, DataPointAesthetics p) {
                Object object;
                Double d = p.x();
                Intrinsics.checkNotNull((Object)d);
                double d2 = d;
                Double d3 = p.y();
                Intrinsics.checkNotNull((Object)d3);
                Vec coord = VecKt.explicitVec((double)d2, (double)d3);
                Map $this$getOrPut$iv = builders;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(coord);
                if (value$iv == null) {
                    boolean bl = false;
                    MultiDataPointBuilder answer$iv = new MultiDataPointBuilder(p);
                    $this$getOrPut$iv.put(coord, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                return (MultiDataPointBuilder)object;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003Js\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\u0006H\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012\u00a8\u0006&"}, d2={"Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$MultiDataPointHelper$MultiDataPoint;", "", "aes", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "indices", "", "", "values", "", "colorArray", "Lorg/jetbrains/letsPlot/commons/values/Color;", "fillArray", "strokeArray", "explodeValues", "(Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getAes", "()Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "getColorArray", "()Ljava/util/List;", "getExplodeValues", "getFillArray", "getIndices", "getStrokeArray", "getValues", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "toString", "", "plot-livemap"})
        public static final class MultiDataPoint {
            @NotNull
            private final DataPointAesthetics aes;
            @NotNull
            private final List<Integer> indices;
            @NotNull
            private final List<Double> values;
            @NotNull
            private final List<Color> colorArray;
            @NotNull
            private final List<Color> fillArray;
            @NotNull
            private final List<Double> strokeArray;
            @NotNull
            private final List<Double> explodeValues;

            public MultiDataPoint(@NotNull DataPointAesthetics aes, @NotNull List<Integer> indices, @NotNull List<Double> values, @NotNull List<Color> colorArray, @NotNull List<Color> fillArray, @NotNull List<Double> strokeArray, @NotNull List<Double> explodeValues) {
                Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
                Intrinsics.checkNotNullParameter(indices, (String)"indices");
                Intrinsics.checkNotNullParameter(values, (String)"values");
                Intrinsics.checkNotNullParameter(colorArray, (String)"colorArray");
                Intrinsics.checkNotNullParameter(fillArray, (String)"fillArray");
                Intrinsics.checkNotNullParameter(strokeArray, (String)"strokeArray");
                Intrinsics.checkNotNullParameter(explodeValues, (String)"explodeValues");
                this.aes = aes;
                this.indices = indices;
                this.values = values;
                this.colorArray = colorArray;
                this.fillArray = fillArray;
                this.strokeArray = strokeArray;
                this.explodeValues = explodeValues;
            }

            @NotNull
            public final DataPointAesthetics getAes() {
                return this.aes;
            }

            @NotNull
            public final List<Integer> getIndices() {
                return this.indices;
            }

            @NotNull
            public final List<Double> getValues() {
                return this.values;
            }

            @NotNull
            public final List<Color> getColorArray() {
                return this.colorArray;
            }

            @NotNull
            public final List<Color> getFillArray() {
                return this.fillArray;
            }

            @NotNull
            public final List<Double> getStrokeArray() {
                return this.strokeArray;
            }

            @NotNull
            public final List<Double> getExplodeValues() {
                return this.explodeValues;
            }

            @NotNull
            public final DataPointAesthetics component1() {
                return this.aes;
            }

            @NotNull
            public final List<Integer> component2() {
                return this.indices;
            }

            @NotNull
            public final List<Double> component3() {
                return this.values;
            }

            @NotNull
            public final List<Color> component4() {
                return this.colorArray;
            }

            @NotNull
            public final List<Color> component5() {
                return this.fillArray;
            }

            @NotNull
            public final List<Double> component6() {
                return this.strokeArray;
            }

            @NotNull
            public final List<Double> component7() {
                return this.explodeValues;
            }

            @NotNull
            public final MultiDataPoint copy(@NotNull DataPointAesthetics aes, @NotNull List<Integer> indices, @NotNull List<Double> values, @NotNull List<Color> colorArray, @NotNull List<Color> fillArray, @NotNull List<Double> strokeArray, @NotNull List<Double> explodeValues) {
                Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
                Intrinsics.checkNotNullParameter(indices, (String)"indices");
                Intrinsics.checkNotNullParameter(values, (String)"values");
                Intrinsics.checkNotNullParameter(colorArray, (String)"colorArray");
                Intrinsics.checkNotNullParameter(fillArray, (String)"fillArray");
                Intrinsics.checkNotNullParameter(strokeArray, (String)"strokeArray");
                Intrinsics.checkNotNullParameter(explodeValues, (String)"explodeValues");
                return new MultiDataPoint(aes, indices, values, colorArray, fillArray, strokeArray, explodeValues);
            }

            public static /* synthetic */ MultiDataPoint copy$default(MultiDataPoint multiDataPoint, DataPointAesthetics dataPointAesthetics, List list, List list2, List list3, List list4, List list5, List list6, int n, Object object) {
                if ((n & 1) != 0) {
                    dataPointAesthetics = multiDataPoint.aes;
                }
                if ((n & 2) != 0) {
                    list = multiDataPoint.indices;
                }
                if ((n & 4) != 0) {
                    list2 = multiDataPoint.values;
                }
                if ((n & 8) != 0) {
                    list3 = multiDataPoint.colorArray;
                }
                if ((n & 0x10) != 0) {
                    list4 = multiDataPoint.fillArray;
                }
                if ((n & 0x20) != 0) {
                    list5 = multiDataPoint.strokeArray;
                }
                if ((n & 0x40) != 0) {
                    list6 = multiDataPoint.explodeValues;
                }
                return multiDataPoint.copy(dataPointAesthetics, list, list2, list3, list4, list5, list6);
            }

            @NotNull
            public String toString() {
                return "MultiDataPoint(aes=" + this.aes + ", indices=" + this.indices + ", values=" + this.values + ", colorArray=" + this.colorArray + ", fillArray=" + this.fillArray + ", strokeArray=" + this.strokeArray + ", explodeValues=" + this.explodeValues + ')';
            }

            public int hashCode() {
                int result = this.aes.hashCode();
                result = result * 31 + ((Object)this.indices).hashCode();
                result = result * 31 + ((Object)this.values).hashCode();
                result = result * 31 + ((Object)this.colorArray).hashCode();
                result = result * 31 + ((Object)this.fillArray).hashCode();
                result = result * 31 + ((Object)this.strokeArray).hashCode();
                result = result * 31 + ((Object)this.explodeValues).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MultiDataPoint)) {
                    return false;
                }
                MultiDataPoint multiDataPoint = (MultiDataPoint)other;
                if (!Intrinsics.areEqual((Object)this.aes, (Object)multiDataPoint.aes)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.indices, multiDataPoint.indices)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.values, multiDataPoint.values)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.colorArray, multiDataPoint.colorArray)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.fillArray, multiDataPoint.fillArray)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.strokeArray, multiDataPoint.strokeArray)) {
                    return false;
                }
                return Intrinsics.areEqual(this.explodeValues, multiDataPoint.explodeValues);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0006j\b\u0012\u0004\u0012\u00020\u0003`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$MultiDataPointHelper$MultiDataPointBuilder;", "", "myAes", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "(Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;)V", "myPoints", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "add", "", "p", "build", "Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$MultiDataPointHelper$MultiDataPoint;", "plot-livemap"})
        @SourceDebugExtension(value={"SMAP\nDataPointsConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataPointsConverter.kt\norg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$MultiDataPointHelper$MultiDataPointBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,425:1\n1549#2:426\n1620#2,3:427\n1549#2:430\n1620#2,3:431\n1549#2:434\n1620#2,3:435\n1549#2:438\n1620#2,3:439\n1549#2:442\n1620#2,3:443\n1549#2:446\n1620#2,3:447\n*S KotlinDebug\n*F\n+ 1 DataPointsConverter.kt\norg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$MultiDataPointHelper$MultiDataPointBuilder\n*L\n405#1:426\n405#1:427,3\n406#1:430\n406#1:431,3\n407#1:434\n407#1:435,3\n408#1:438\n408#1:439,3\n409#1:442\n409#1:443,3\n410#1:446\n410#1:447,3\n*E\n"})
        private static final class MultiDataPointBuilder {
            @NotNull
            private final DataPointAesthetics myAes;
            @NotNull
            private final ArrayList<DataPointAesthetics> myPoints;

            public MultiDataPointBuilder(@NotNull DataPointAesthetics myAes) {
                Intrinsics.checkNotNullParameter((Object)myAes, (String)"myAes");
                this.myAes = myAes;
                this.myPoints = new ArrayList();
            }

            public final void add(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                this.myPoints.add(p);
            }

            @NotNull
            public final MultiDataPoint build() {
                Collection<Double> collection;
                Collection<Double> collection2;
                Collection<Color> collection3;
                Collection<Color> collection4;
                DataPointAesthetics it;
                Collection<Double> collection5;
                DataPointAesthetics p0;
                Collection collection6;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Iterable iterable = this.myPoints;
                DataPointAesthetics dataPointAesthetics = this.myAes;
                boolean $i$f$map = false;
                void var3_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    DataPointAesthetics dataPointAesthetics2 = (DataPointAesthetics)item$iv$iv;
                    collection6 = destination$iv$iv;
                    boolean bl = false;
                    collection6.add(p0.index());
                }
                $this$map$iv = this.myPoints;
                collection6 = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    p0 = (DataPointAesthetics)item$iv$iv;
                    collection5 = destination$iv$iv;
                    boolean bl = false;
                    Double d = it.slice();
                    Intrinsics.checkNotNull((Object)d);
                    collection5.add(d);
                }
                collection5 = (List)destination$iv$iv;
                $this$map$iv = this.myPoints;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (DataPointAesthetics)item$iv$iv;
                    collection4 = destination$iv$iv;
                    boolean bl = false;
                    Color color = it.color();
                    if (color == null) {
                        color = Color.Companion.getTRANSPARENT();
                    }
                    collection4.add(color);
                }
                collection4 = (List)destination$iv$iv;
                $this$map$iv = this.myPoints;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (DataPointAesthetics)item$iv$iv;
                    collection3 = destination$iv$iv;
                    boolean bl = false;
                    Color color = it.fill();
                    if (color == null) {
                        color = (Color)DefaultNaValue.INSTANCE.get(Aes.Companion.getFILL());
                    }
                    collection3.add(color);
                }
                collection3 = (List)destination$iv$iv;
                $this$map$iv = this.myPoints;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (DataPointAesthetics)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl = false;
                    Double d = it.stroke();
                    collection2.add(d != null ? d : 0.0);
                }
                collection2 = (List)destination$iv$iv;
                $this$map$iv = this.myPoints;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (DataPointAesthetics)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Double d = it.explode();
                    collection.add(d != null ? d : 0.0);
                }
                Collection<Double> collection7 = collection = (List)destination$iv$iv;
                Collection<Double> collection8 = collection2;
                Collection<Color> collection9 = collection3;
                Collection<Color> collection10 = collection4;
                Collection<Double> collection11 = collection5;
                Collection collection12 = collection6;
                DataPointAesthetics dataPointAesthetics3 = dataPointAesthetics;
                return new MultiDataPoint(dataPointAesthetics3, (List<Integer>)collection12, (List<Double>)collection11, (List<Color>)collection10, (List<Color>)collection9, (List<Double>)collection8, (List<Double>)collection7);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$MultiPathFeatureConverter;", "Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$PathFeatureConverterBase;", "aes", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "(Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter;Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;)V", "path", "", "Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointLiveMapAesthetics;", "geom", "Lorg/jetbrains/letsPlot/core/plot/base/Geom;", "polygon", "process", "paths", "", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/PathData;", "isClosed", "", "rect", "plot-livemap"})
    @SourceDebugExtension(value={"SMAP\nDataPointsConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataPointsConverter.kt\norg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$MultiPathFeatureConverter\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,425:1\n453#2:426\n403#2:427\n1238#3,4:428\n1549#3:432\n1620#3,3:433\n1603#3,9:436\n1855#3:445\n1856#3:447\n1612#3:448\n1549#3:449\n1620#3,3:450\n1#4:446\n*S KotlinDebug\n*F\n+ 1 DataPointsConverter.kt\norg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$MultiPathFeatureConverter\n*L\n163#1:426\n163#1:427\n163#1:428,4\n175#1:432\n175#1:433,3\n176#1:436,9\n176#1:445\n176#1:447\n176#1:448\n180#1:449\n180#1:450,3\n176#1:446\n*E\n"})
    private final class MultiPathFeatureConverter
    extends PathFeatureConverterBase {
        public MultiPathFeatureConverter(Aesthetics aes) {
            Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
            super(aes);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<DataPointLiveMapAesthetics> path(@NotNull Geom geom) {
            void $this$mapValuesTo$iv$iv;
            Map pathData;
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            if (geom instanceof PathGeom) {
                this.setAnimation(((PathGeom)geom).getAnimation());
                this.setFlat(((PathGeom)geom).getFlat());
                this.setGeodesic(((PathGeom)geom).getGeodesic());
            }
            Map $this$mapValues$iv = pathData = GeomUtil.createPathGroups$default((GeomUtil)GeomUtil.INSTANCE, (Iterable)this.getAesthetics().dataPoints(), (Function1)GeomUtil.INSTANCE.getTO_LOCATION_X_Y(), (boolean)true, (boolean)false, (int)8, null);
            boolean $i$f$mapValues = false;
            Map map = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                PathData pathData2 = (PathData)entry2.getValue();
                List list = LinesHelper.Companion.splitByStyle(pathData2);
                map3.put(k, list);
            }
            Map variadicPathData = destination$iv$iv;
            Map interpolatedPathData = LinesHelper.Companion.interpolatePathData(variadicPathData);
            return this.process(CollectionsKt.flatten((Iterable)interpolatedPathData.values()), false);
        }

        @NotNull
        public final List<DataPointLiveMapAesthetics> polygon() {
            Map paths = GeomUtil.createPathGroups$default((GeomUtil)GeomUtil.INSTANCE, (Iterable)this.getAesthetics().dataPoints(), (Function1)GeomUtil.INSTANCE.getTO_LOCATION_X_Y(), (boolean)true, (boolean)false, (int)8, null);
            return this.process(paths.values(), true);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<DataPointLiveMapAesthetics> rect() {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object object;
            Object object2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getAesthetics().dataPoints();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                void aes;
                object2 = (DataPointAesthetics)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv2 = (Iterable)GeomUtil.INSTANCE.getTO_RECTANGLE().invoke((Object)aes);
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    DoubleVector doubleVector = (DoubleVector)item$iv$iv2;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(new PathPoint((DataPointAesthetics)aes, (DoubleVector)it));
                }
                object.add((List)destination$iv$iv2);
            }
            List rectangles = (List)destination$iv$iv;
            $this$map$iv = rectangles;
            object = this;
            boolean $i$f$mapNotNull = false;
            $this$mapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            object2 = $this$forEach$iv$iv$iv.iterator();
            while (object2.hasNext()) {
                PathData it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object2.next();
                boolean bl = false;
                List it = (List)element$iv$iv;
                boolean bl3 = false;
                if (PathData.Companion.create(it) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return super.process((List)destination$iv$iv, true);
        }

        /*
         * WARNING - void declaration
         */
        private final List<DataPointLiveMapAesthetics> process(Collection<PathData> paths, boolean isClosed) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = paths;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PathData pathData = (PathData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.pathToBuilder(it.getAes(), Companion.toVecs(it.getCoordinates()), isClosed));
            }
            return (List)destination$iv$iv;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0006\n\u0000\b\"\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\u0014\u001a\u0004\u0018\u00010\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u0016J*\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001c2\u0006\u0010\u001f\u001a\u00020\rJ\u0010\u0010 \u001a\u00020!2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001J\u0010\u0010\"\u001a\u00020!2\b\u0010#\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\rJ\u000e\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\rJ\u000e\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\rJ\u000e\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020,R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0013\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006-"}, d2={"Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$PathFeatureConverterBase;", "", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "(Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;)V", "getAesthetics", "()Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "myAnimation", "", "Ljava/lang/Integer;", "myArrowSpec", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec;", "myFlat", "", "myGeodesic", "myIsCurve", "mySpacer", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Scalar;", "Lorg/jetbrains/letsPlot/livemap/Client;", "D", "parsePathAnimation", "animation", "(Ljava/lang/Object;)Ljava/lang/Integer;", "pathToBuilder", "Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointLiveMapAesthetics;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "points", "", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "isClosed", "setAnimation", "", "setArrowSpec", "arrowSpec", "setFlat", "flat", "setGeodesic", "geodesic", "setIsCurve", "isCurve", "setSpacer", "spacer", "", "plot-livemap"})
    private static abstract class PathFeatureConverterBase {
        @NotNull
        private final Aesthetics aesthetics;
        @Nullable
        private ArrowSpec myArrowSpec;
        @Nullable
        private Integer myAnimation;
        private boolean myFlat;
        private boolean myGeodesic;
        private double mySpacer;
        private boolean myIsCurve;

        public PathFeatureConverterBase(@NotNull Aesthetics aesthetics) {
            Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
            this.aesthetics = aesthetics;
            this.mySpacer = Client.Companion.getPx-VvMBhYE((Number)0);
        }

        @NotNull
        public final Aesthetics getAesthetics() {
            return this.aesthetics;
        }

        private final Integer parsePathAnimation(Object animation) {
            block15: {
                Object object = animation;
                if (object == null) {
                    return null;
                }
                if (object instanceof Number) {
                    return ((Number)animation).intValue();
                }
                if (!(object instanceof String)) break block15;
                switch ((String)animation) {
                    case "dash": {
                        return 1;
                    }
                    case "plane": {
                        return 2;
                    }
                    case "circle": {
                        return 3;
                    }
                }
            }
            throw new IllegalArgumentException("Unknown path animation: '" + animation + '\'');
        }

        @NotNull
        public final DataPointLiveMapAesthetics pathToBuilder(@NotNull DataPointAesthetics p, @NotNull List<? extends Vec<? extends LonLat>> points, boolean isClosed) {
            DataPointLiveMapAesthetics dataPointLiveMapAesthetics;
            MapLayerKind mapLayerKind;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter(points, (String)"points");
            boolean bl = isClosed;
            if (bl) {
                mapLayerKind = MapLayerKind.POLYGON;
            } else if (!bl) {
                mapLayerKind = MapLayerKind.PATH;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            DataPointLiveMapAesthetics $this$pathToBuilder_u24lambda_u240 = dataPointLiveMapAesthetics = new DataPointLiveMapAesthetics(p, mapLayerKind);
            boolean bl2 = false;
            $this$pathToBuilder_u24lambda_u240.setGeometry(points);
            $this$pathToBuilder_u24lambda_u240.setFlat(this.myFlat);
            $this$pathToBuilder_u24lambda_u240.setGeodesic(this.myGeodesic);
            $this$pathToBuilder_u24lambda_u240.setSpacer-hZjkWWM(this.mySpacer);
            $this$pathToBuilder_u24lambda_u240.setCurve(this.myIsCurve);
            $this$pathToBuilder_u24lambda_u240.setAnimation(this.myAnimation);
            $this$pathToBuilder_u24lambda_u240.setArrowSpec(this.myArrowSpec);
            return dataPointLiveMapAesthetics;
        }

        public final void setArrowSpec(@Nullable ArrowSpec arrowSpec) {
            this.myArrowSpec = arrowSpec;
        }

        public final void setAnimation(@Nullable Object animation) {
            this.myAnimation = this.parsePathAnimation(animation);
        }

        public final void setFlat(boolean flat) {
            this.myFlat = flat;
        }

        public final void setGeodesic(boolean geodesic) {
            this.myGeodesic = geodesic;
        }

        public final void setSpacer(double spacer) {
            this.mySpacer = Client.Companion.getPx-VvMBhYE((Number)spacer);
        }

        public final void setIsCurve(boolean isCurve) {
            this.myIsCurve = isCurve;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0018\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00c6\u0003J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0015J\t\u0010\u001e\u001a\u00020\u000bH\u00c6\u0003JN\u0010\u001f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001\u00a2\u0006\u0002\u0010 J\u0013\u0010!\u001a\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0015\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$PieOptions;", "", "spacerColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "spacerWidth", "", "holeSize", "strokeSide", "Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$StrokeSide;", "startAngle", "clockwise", "", "(Lorg/jetbrains/letsPlot/commons/values/Color;DDLorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$StrokeSide;Ljava/lang/Double;Z)V", "getClockwise", "()Z", "getHoleSize", "()D", "getSpacerColor", "()Lorg/jetbrains/letsPlot/commons/values/Color;", "getSpacerWidth", "getStartAngle", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getStrokeSide", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$StrokeSide;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Lorg/jetbrains/letsPlot/commons/values/Color;DDLorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$StrokeSide;Ljava/lang/Double;Z)Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$PieOptions;", "equals", "other", "hashCode", "", "toString", "", "plot-livemap"})
    public static final class PieOptions {
        @Nullable
        private final Color spacerColor;
        private final double spacerWidth;
        private final double holeSize;
        @NotNull
        private final PieGeom.StrokeSide strokeSide;
        @Nullable
        private final Double startAngle;
        private final boolean clockwise;

        public PieOptions(@Nullable Color spacerColor, double spacerWidth, double holeSize, @NotNull PieGeom.StrokeSide strokeSide, @Nullable Double startAngle, boolean clockwise) {
            Intrinsics.checkNotNullParameter((Object)strokeSide, (String)"strokeSide");
            this.spacerColor = spacerColor;
            this.spacerWidth = spacerWidth;
            this.holeSize = holeSize;
            this.strokeSide = strokeSide;
            this.startAngle = startAngle;
            this.clockwise = clockwise;
        }

        @Nullable
        public final Color getSpacerColor() {
            return this.spacerColor;
        }

        public final double getSpacerWidth() {
            return this.spacerWidth;
        }

        public final double getHoleSize() {
            return this.holeSize;
        }

        @NotNull
        public final PieGeom.StrokeSide getStrokeSide() {
            return this.strokeSide;
        }

        @Nullable
        public final Double getStartAngle() {
            return this.startAngle;
        }

        public final boolean getClockwise() {
            return this.clockwise;
        }

        @Nullable
        public final Color component1() {
            return this.spacerColor;
        }

        public final double component2() {
            return this.spacerWidth;
        }

        public final double component3() {
            return this.holeSize;
        }

        @NotNull
        public final PieGeom.StrokeSide component4() {
            return this.strokeSide;
        }

        @Nullable
        public final Double component5() {
            return this.startAngle;
        }

        public final boolean component6() {
            return this.clockwise;
        }

        @NotNull
        public final PieOptions copy(@Nullable Color spacerColor, double spacerWidth, double holeSize, @NotNull PieGeom.StrokeSide strokeSide, @Nullable Double startAngle, boolean clockwise) {
            Intrinsics.checkNotNullParameter((Object)strokeSide, (String)"strokeSide");
            return new PieOptions(spacerColor, spacerWidth, holeSize, strokeSide, startAngle, clockwise);
        }

        public static /* synthetic */ PieOptions copy$default(PieOptions pieOptions, Color color, double d, double d2, PieGeom.StrokeSide strokeSide, Double d3, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                color = pieOptions.spacerColor;
            }
            if ((n & 2) != 0) {
                d = pieOptions.spacerWidth;
            }
            if ((n & 4) != 0) {
                d2 = pieOptions.holeSize;
            }
            if ((n & 8) != 0) {
                strokeSide = pieOptions.strokeSide;
            }
            if ((n & 0x10) != 0) {
                d3 = pieOptions.startAngle;
            }
            if ((n & 0x20) != 0) {
                bl = pieOptions.clockwise;
            }
            return pieOptions.copy(color, d, d2, strokeSide, d3, bl);
        }

        @NotNull
        public String toString() {
            return "PieOptions(spacerColor=" + this.spacerColor + ", spacerWidth=" + this.spacerWidth + ", holeSize=" + this.holeSize + ", strokeSide=" + this.strokeSide + ", startAngle=" + this.startAngle + ", clockwise=" + this.clockwise + ')';
        }

        public int hashCode() {
            int result = this.spacerColor == null ? 0 : this.spacerColor.hashCode();
            result = result * 31 + Double.hashCode(this.spacerWidth);
            result = result * 31 + Double.hashCode(this.holeSize);
            result = result * 31 + this.strokeSide.hashCode();
            result = result * 31 + (this.startAngle == null ? 0 : ((Object)this.startAngle).hashCode());
            result = result * 31 + Boolean.hashCode(this.clockwise);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PieOptions)) {
                return false;
            }
            PieOptions pieOptions = (PieOptions)other;
            if (!Intrinsics.areEqual((Object)this.spacerColor, (Object)pieOptions.spacerColor)) {
                return false;
            }
            if (Double.compare(this.spacerWidth, pieOptions.spacerWidth) != 0) {
                return false;
            }
            if (Double.compare(this.holeSize, pieOptions.holeSize) != 0) {
                return false;
            }
            if (this.strokeSide != pieOptions.strokeSide) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.startAngle, (Object)pieOptions.startAngle)) {
                return false;
            }
            return this.clockwise == pieOptions.clockwise;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0019\u0010\r\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J2\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u001a\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0018\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00190\u0017H\u0002J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0011\u001a\u00020\u001cJ\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$PointFeatureConverter;", "", "myAesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "(Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;)V", "myAnimation", "", "Ljava/lang/Integer;", "myLabelOptions", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/LabelOptions;", "hLine", "", "Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointLiveMapAesthetics;", "parsePointAnimation", "animation", "(Ljava/lang/Object;)Ljava/lang/Integer;", "point", "geom", "Lorg/jetbrains/letsPlot/core/plot/base/geom/PointGeom;", "process", "layerKind", "Lorg/jetbrains/letsPlot/core/plot/livemap/MapLayerKind;", "dataPointToGeometry", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "text", "Lorg/jetbrains/letsPlot/core/plot/base/Geom;", "vLine", "plot-livemap"})
    @SourceDebugExtension(value={"SMAP\nDataPointsConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataPointsConverter.kt\norg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$PointFeatureConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,425:1\n1#2:426\n*E\n"})
    private static final class PointFeatureConverter {
        @NotNull
        private final Aesthetics myAesthetics;
        @Nullable
        private Integer myAnimation;
        @Nullable
        private LabelOptions myLabelOptions;

        public PointFeatureConverter(@NotNull Aesthetics myAesthetics) {
            Intrinsics.checkNotNullParameter((Object)myAesthetics, (String)"myAesthetics");
            this.myAesthetics = myAesthetics;
        }

        private final Integer parsePointAnimation(Object animation) {
            Object object = animation;
            if (object == null) {
                return null;
            }
            if (object instanceof Number) {
                return ((Number)animation).intValue();
            }
            if (object instanceof String && Intrinsics.areEqual((Object)((String)animation), (Object)"ripple")) {
                return 1;
            }
            throw new IllegalArgumentException("Unknown point animation: '" + animation + '\'');
        }

        @NotNull
        public final List<DataPointLiveMapAesthetics> point(@NotNull PointGeom geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            this.myAnimation = this.parsePointAnimation(geom.getAnimation());
            return this.process(MapLayerKind.POINT, (Function1<? super DataPointAesthetics, ? extends Vec<? extends LonLat>>)((Function1)point.1.INSTANCE));
        }

        @NotNull
        public final List<DataPointLiveMapAesthetics> hLine() {
            return this.process(MapLayerKind.H_LINE, (Function1<? super DataPointAesthetics, ? extends Vec<? extends LonLat>>)((Function1)hLine.1.INSTANCE));
        }

        @NotNull
        public final List<DataPointLiveMapAesthetics> vLine() {
            return this.process(MapLayerKind.V_LINE, (Function1<? super DataPointAesthetics, ? extends Vec<? extends LonLat>>)((Function1)vLine.1.INSTANCE));
        }

        @NotNull
        public final List<DataPointLiveMapAesthetics> text(@NotNull Geom geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            if (geom instanceof LabelGeom) {
                this.myLabelOptions = ((LabelGeom)geom).getLabelOptions();
            }
            return this.process(MapLayerKind.TEXT, (Function1<? super DataPointAesthetics, ? extends Vec<? extends LonLat>>)((Function1)text.1.INSTANCE));
        }

        private final List<DataPointLiveMapAesthetics> process(MapLayerKind layerKind, Function1<? super DataPointAesthetics, ? extends Vec<? extends LonLat>> dataPointToGeometry) {
            ArrayList<DataPointLiveMapAesthetics> mapObjects = new ArrayList<DataPointLiveMapAesthetics>(this.myAesthetics.dataPointCount());
            for (DataPointAesthetics p : this.myAesthetics.dataPoints()) {
                Vec v;
                DataPointLiveMapAesthetics dataPointLiveMapAesthetics;
                if ((Vec)dataPointToGeometry.invoke((Object)p) == null) continue;
                boolean bl = false;
                DataPointLiveMapAesthetics $this$process_u24lambda_u241_u24lambda_u240 = dataPointLiveMapAesthetics = new DataPointLiveMapAesthetics(p, layerKind);
                boolean bl2 = false;
                $this$process_u24lambda_u241_u24lambda_u240.setPoint((Vec<? extends LonLat>)v);
                $this$process_u24lambda_u241_u24lambda_u240.setAnimation(this.myAnimation);
                $this$process_u24lambda_u241_u24lambda_u240.setLabelOptions(this.myLabelOptions);
                DataPointLiveMapAesthetics p0 = dataPointLiveMapAesthetics;
                boolean bl3 = false;
                mapObjects.add(p0);
            }
            return mapObjects;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J0\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00060\u0016H\u0002J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u001aJ\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u001cJ\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$SinglePathFeatureConverter;", "Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$PathFeatureConverterBase;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "(Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter;Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;)V", "curve", "", "Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointLiveMapAesthetics;", "geom", "Lorg/jetbrains/letsPlot/core/plot/base/geom/CurveGeom;", "getResolution", "", "aes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "hex", "nonZero", "d", "defaultValue", "process", "isClosed", "", "dataPointToGeometry", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "segment", "Lorg/jetbrains/letsPlot/core/plot/base/geom/SegmentGeom;", "spoke", "Lorg/jetbrains/letsPlot/core/plot/base/geom/SpokeGeom;", "tile", "plot-livemap"})
    @SourceDebugExtension(value={"SMAP\nDataPointsConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataPointsConverter.kt\norg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$SinglePathFeatureConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,425:1\n1#2:426\n*E\n"})
    private final class SinglePathFeatureConverter
    extends PathFeatureConverterBase {
        public SinglePathFeatureConverter(Aesthetics aesthetics) {
            Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
            super(aesthetics);
        }

        @NotNull
        public final List<DataPointLiveMapAesthetics> tile() {
            double resX = this.getResolution((Aes<Double>)Aes.Companion.getX());
            double resY = this.getResolution((Aes<Double>)Aes.Companion.getY());
            return this.process(true, (Function1<? super DataPointAesthetics, ? extends List<DoubleVector>>)((Function1)new Function1<DataPointAesthetics, List<? extends DoubleVector>>(this, resX, resY){
                final /* synthetic */ SinglePathFeatureConverter this$0;
                final /* synthetic */ double $resX;
                final /* synthetic */ double $resY;
                {
                    this.this$0 = $receiver;
                    this.$resX = $resX;
                    this.$resY = $resY;
                    super(1);
                }

                @NotNull
                public final List<DoubleVector> invoke(@NotNull DataPointAesthetics p) {
                    List list;
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (SeriesUtil.INSTANCE.allFinite(p.x(), p.y(), p.width(), p.height())) {
                        Double d = p.width();
                        Intrinsics.checkNotNull((Object)d);
                        double w = SinglePathFeatureConverter.access$nonZero(this.this$0, d * this.$resX, 1.0);
                        Double d2 = p.height();
                        Intrinsics.checkNotNull((Object)d2);
                        double h = SinglePathFeatureConverter.access$nonZero(this.this$0, d2 * this.$resY, 1.0);
                        Double d3 = p.x();
                        Intrinsics.checkNotNull((Object)d3);
                        double d4 = d3 - w / (double)2;
                        Double d5 = p.y();
                        Intrinsics.checkNotNull((Object)d5);
                        double d6 = d5 - h / (double)2;
                        Double d7 = p.x();
                        Intrinsics.checkNotNull((Object)d7);
                        double d8 = d7 + w / (double)2;
                        Double d9 = p.y();
                        Intrinsics.checkNotNull((Object)d9);
                        list = GeomUtil.INSTANCE.rectToGeometry(d4, d6, d8, d9 + h / (double)2);
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    return list;
                }
            }));
        }

        @NotNull
        public final List<DataPointLiveMapAesthetics> segment(@NotNull SegmentGeom geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            this.setArrowSpec(geom.getArrowSpec());
            this.setAnimation(geom.getAnimation());
            this.setFlat(geom.getFlat());
            this.setGeodesic(geom.getGeodesic());
            this.setSpacer(geom.getSpacer());
            return this.process(false, (Function1<? super DataPointAesthetics, ? extends List<DoubleVector>>)((Function1)segment.1.INSTANCE));
        }

        @NotNull
        public final List<DataPointLiveMapAesthetics> curve(@NotNull CurveGeom geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            this.setArrowSpec(geom.getArrowSpec());
            this.setSpacer(geom.getSpacer());
            this.setIsCurve(true);
            this.setFlat(true);
            return this.process(false, (Function1<? super DataPointAesthetics, ? extends List<DoubleVector>>)((Function1)new Function1<DataPointAesthetics, List<? extends DoubleVector>>(geom){
                final /* synthetic */ CurveGeom $geom;
                {
                    this.$geom = $geom;
                    super(1);
                }

                @NotNull
                public final List<DoubleVector> invoke(@NotNull DataPointAesthetics it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    DoubleVector doubleVector = GeomUtil.INSTANCE.toLocation(it, Aes.Companion.getX(), Aes.Companion.getY());
                    if (doubleVector == null) {
                        return CollectionsKt.emptyList();
                    }
                    DoubleVector start = doubleVector;
                    DoubleVector doubleVector2 = GeomUtil.INSTANCE.toLocation(it, Aes.Companion.getXEND(), Aes.Companion.getYEND());
                    if (doubleVector2 == null) {
                        return CollectionsKt.emptyList();
                    }
                    DoubleVector end = doubleVector2;
                    GeomHelper.SvgElementHelper elementHelper = new GeomHelper.SvgElementHelper(null, 1, null).noSvg().geometryWithPadding(false);
                    Pair pair = GeomHelper.SvgElementHelper.createCurve$default((GeomHelper.SvgElementHelper)elementHelper, (DoubleVector)start, (DoubleVector)end, (double)this.$geom.getCurvature(), (double)this.$geom.getAngle(), (int)this.$geom.getNcp(), (DataPointAesthetics)it, null, (int)64, null);
                    if (pair == null) {
                        return CollectionsKt.emptyList();
                    }
                    List geometry = (List)pair.component2();
                    return geometry;
                }
            }));
        }

        @NotNull
        public final List<DataPointLiveMapAesthetics> spoke(@NotNull SpokeGeom geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            this.setArrowSpec(geom.getArrowSpec());
            this.setFlat(true);
            return this.process(false, (Function1<? super DataPointAesthetics, ? extends List<DoubleVector>>)((Function1)new Function1<DataPointAesthetics, List<? extends DoubleVector>>(geom){
                final /* synthetic */ SpokeGeom $geom;
                {
                    this.$geom = $geom;
                    super(1);
                }

                @NotNull
                public final List<DoubleVector> invoke(@NotNull DataPointAesthetics it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    DoubleVector doubleVector = GeomUtil.INSTANCE.toLocation(it, Aes.Companion.getX(), Aes.Companion.getY());
                    if (doubleVector == null) {
                        return CollectionsKt.emptyList();
                    }
                    DoubleVector base = doubleVector;
                    Double d = it.finiteOrNull(Aes.Companion.getANGLE());
                    if (d == null) {
                        return CollectionsKt.emptyList();
                    }
                    double angle = d;
                    Double d2 = it.finiteOrNull(Aes.Companion.getRADIUS());
                    if (d2 == null) {
                        return CollectionsKt.emptyList();
                    }
                    double radius = d2;
                    GeomHelper.SvgElementHelper elementHelper = new GeomHelper.SvgElementHelper(null, 1, null).noSvg();
                    Pair pair = GeomHelper.SvgElementHelper.createSpoke$default((GeomHelper.SvgElementHelper)elementHelper, (DoubleVector)base, (double)angle, (double)radius, (double)this.$geom.getPivot().getFactor(), (DataPointAesthetics)it, null, (int)32, null);
                    if (pair == null) {
                        return CollectionsKt.emptyList();
                    }
                    List geometry = (List)pair.component2();
                    return geometry;
                }
            }));
        }

        @NotNull
        public final List<DataPointLiveMapAesthetics> hex() {
            double resX = this.getResolution((Aes<Double>)Aes.Companion.getX());
            double resY = this.getResolution((Aes<Double>)Aes.Companion.getY());
            Function1 transformWidthToUnits2 = (Function1)new Function1<Double, Double>(resX){
                final /* synthetic */ double $resX;
                {
                    this.$resX = $resX;
                    super(1);
                }

                @NotNull
                public final Double invoke(double v) {
                    return 2.0 * this.$resX * v;
                }
            };
            Function1 transformHeightToUnits2 = (Function1)new Function1<Double, Double>(resY){
                final /* synthetic */ double $resY;
                {
                    this.$resY = $resY;
                    super(1);
                }

                @NotNull
                public final Double invoke(double v) {
                    return 2.0 / Math.sqrt(3.0) * this.$resY * v;
                }
            };
            return this.process(true, (Function1<? super DataPointAesthetics, ? extends List<DoubleVector>>)((Function1)new Function1<DataPointAesthetics, List<? extends DoubleVector>>((Function1<? super Double, Double>)transformWidthToUnits2, (Function1<? super Double, Double>)transformHeightToUnits2){
                final /* synthetic */ Function1<Double, Double> $transformWidthToUnits;
                final /* synthetic */ Function1<Double, Double> $transformHeightToUnits;
                {
                    this.$transformWidthToUnits = $transformWidthToUnits;
                    this.$transformHeightToUnits = $transformHeightToUnits;
                    super(1);
                }

                @NotNull
                public final List<DoubleVector> invoke(@NotNull DataPointAesthetics p) {
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    List list = (List)HexGeom.Companion.clientHexByDataPoint(this.$transformWidthToUnits, this.$transformHeightToUnits).invoke((Object)p);
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    return list;
                }
            }));
        }

        private final List<DataPointLiveMapAesthetics> process(boolean isClosed, Function1<? super DataPointAesthetics, ? extends List<DoubleVector>> dataPointToGeometry) {
            ArrayList<DataPointLiveMapAesthetics> mapObjects = new ArrayList<DataPointLiveMapAesthetics>(this.getAesthetics().dataPointCount());
            for (DataPointAesthetics p : this.getAesthetics().dataPoints()) {
                List points = (List)dataPointToGeometry.invoke((Object)p);
                if (points.isEmpty()) continue;
                DataPointLiveMapAesthetics p0 = this.pathToBuilder(p, Companion.toVecs(points), isClosed);
                boolean bl = false;
                mapObjects.add(p0);
            }
            mapObjects.trimToSize();
            return mapObjects;
        }

        private final double nonZero(double d, double defaultValue) {
            return d == 0.0 ? defaultValue : d;
        }

        private final double getResolution(Aes<Double> aes) {
            double resolution = this.getAesthetics().resolution(aes, 0.0);
            return resolution <= 1.0E-50 ? 1.0 : resolution;
        }

        public static final /* synthetic */ double access$nonZero(SinglePathFeatureConverter $this, double d, double defaultValue) {
            return $this.nonZero(d, defaultValue);
        }
    }
}

