/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.livemap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.json.JsonSupport;
import org.jetbrains.letsPlot.commons.intern.spatial.GeoRectangle;
import org.jetbrains.letsPlot.commons.intern.spatial.GeographicKt;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.ScalarKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.VecKt;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.aes.AesInitValue;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.PieGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.util.ArrowSpec;
import org.jetbrains.letsPlot.core.plot.base.geom.util.LabelOptions;
import org.jetbrains.letsPlot.core.plot.base.geom.util.TextUtil;
import org.jetbrains.letsPlot.core.plot.base.render.linetype.LineType;
import org.jetbrains.letsPlot.core.plot.base.render.point.PointShape;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.builder.scale.DefaultNaValue;
import org.jetbrains.letsPlot.core.plot.livemap.DataPointLiveMapAesthetics;
import org.jetbrains.letsPlot.core.plot.livemap.DataPointsConverter;
import org.jetbrains.letsPlot.core.plot.livemap.MapLayerKind;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.api.GeoObject;
import org.jetbrains.letsPlot.livemap.chart.donut.StrokeSide;
import org.jetbrains.letsPlot.livemap.chart.path.ArrowSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u009a\u0001\u001a\u00020 2\u0007\u0010\u009b\u0001\u001a\u00020 H\u0002J\u0011\u0010\u009c\u0001\u001a\u00020\u000e2\u0006\u0010r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0015\u001a\u00020\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0003\u0010\u009d\u0001J\u0011\u0010\u009e\u0001\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010hJ\u0012\u0010\u009f\u0001\u001a\u00020\u00002\t\u0010\u00a0\u0001\u001a\u0004\u0018\u00010^J\u0012\u0010\u00a1\u0001\u001a\u00020\u00002\t\u0010\u00a2\u0001\u001a\u0004\u0018\u00010fJ\u001d\u0010\u00a3\u0001\u001a\b\u0012\u0004\u0012\u00020?0>2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020?0>H\u0002R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0019\u0010\u0017\u001a\n\u0018\u00010\u0018j\u0004\u0018\u0001`\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\fR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020 0\u001f8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\"R\u0011\u0010+\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\f\"\u0004\b0\u00101R\u0011\u00102\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0010R\u0011\u00104\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010(R\u0013\u00106\u001a\u0004\u0018\u0001078F\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u001a\u0010:\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\f\"\u0004\b<\u00101R@\u0010@\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020?0>\u0018\u00010\u001f2\u0014\u0010=\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020?0>\u0018\u00010\u001f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\"\"\u0004\bB\u0010CR\u0011\u0010D\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010\u0010R\u0011\u0010F\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\bG\u0010\u0010R\u0011\u0010H\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\bI\u0010\u0014R\u0017\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00120\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\"R\u001a\u0010L\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010\f\"\u0004\bM\u00101R\u0011\u0010N\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\bO\u0010(R\u0011\u0010P\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\bQ\u0010\u0010R\u0011\u0010R\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\bS\u0010\u0010R\u0011\u0010T\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\bU\u0010\u0010R\u0017\u0010V\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001f8F\u00a2\u0006\u0006\u001a\u0004\bW\u0010\"R\u0011\u0010X\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\bY\u0010\u0010R\u0011\u0010Z\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b[\u0010\u0010R\u0014\u0010\\\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010]\u001a\u0004\u0018\u00010^X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010_\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b`\u0010aR\u0011\u0010b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bc\u0010dR\u0010\u0010e\u001a\u0004\u0018\u00010fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010g\u001a\u0004\u0018\u00010hX\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010i\u001a\b\u0012\u0004\u0012\u00020?0>2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bj\u0010k\"\u0004\bl\u0010mR\u0011\u0010n\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\bo\u0010\u0010R\u0011\u0010p\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\bq\u0010\u0014R\u0011\u0010r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\bs\u0010\u0010R\u001d\u0010t\u001a\b\u0012\u0004\u0012\u00020v0u8F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\bw\u0010\u0010R\u001d\u0010x\u001a\b\u0012\u0004\u0012\u00020v0u8F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\by\u0010\u0010R(\u0010z\u001a\b\u0012\u0004\u0012\u00020v0uX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010~\u001a\u0004\b{\u0010\u0010\"\u0004\b|\u0010}R\u0012\u0010\u007f\u001a\u00020 8F\u00a2\u0006\u0007\u001a\u0005\b\u0080\u0001\u0010-R\u0013\u0010\u0081\u0001\u001a\u00020\u000e8F\u00a2\u0006\u0007\u001a\u0005\b\u0082\u0001\u0010\u0010R\u0013\u0010\u0083\u0001\u001a\u00020\u000e8F\u00a2\u0006\u0007\u001a\u0005\b\u0084\u0001\u0010\u0010R\u0016\u0010\u0085\u0001\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\b\u001a\u0006\b\u0086\u0001\u0010\u0087\u0001R\u0019\u0010\u0088\u0001\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001f\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0089\u0001\u0010\"R\u0013\u0010\u008a\u0001\u001a\u00020 8F\u00a2\u0006\u0007\u001a\u0005\b\u008b\u0001\u0010-R\u001f\u0010\u008c\u0001\u001a\b\u0012\u0004\u0012\u00020v0u8F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0007\u001a\u0005\b\u008d\u0001\u0010\u0010R\u0015\u0010\u008e\u0001\u001a\u00030\u008f\u00018F\u00a2\u0006\b\u001a\u0006\b\u0090\u0001\u0010\u0091\u0001R\u001f\u0010\u0092\u0001\u001a\b\u0012\u0004\u0012\u00020v0u8F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0007\u001a\u0005\b\u0093\u0001\u0010\u0010R\u0013\u0010\u0094\u0001\u001a\u00020\u000e8F\u00a2\u0006\u0007\u001a\u0005\b\u0095\u0001\u0010\u0010R\u0019\u0010\u0096\u0001\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001f\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0097\u0001\u0010\"R\u0013\u0010\u0098\u0001\u001a\u00020\u000e8F\u00a2\u0006\u0007\u001a\u0005\b\u0099\u0001\u0010\u0010\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u00a4\u0001"}, d2={"Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointLiveMapAesthetics;", "", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "layerKind", "Lorg/jetbrains/letsPlot/core/plot/livemap/MapLayerKind;", "(Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;Lorg/jetbrains/letsPlot/core/plot/livemap/MapLayerKind;)V", "Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$MultiDataPointHelper$MultiDataPoint;", "(Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$MultiDataPointHelper$MultiDataPoint;Lorg/jetbrains/letsPlot/core/plot/livemap/MapLayerKind;)V", "alphaStroke", "", "getAlphaStroke", "()Z", "angle", "", "getAngle", "()D", "animation", "", "getAnimation", "()I", "setAnimation", "(I)V", "arrowSpec", "Lorg/jetbrains/letsPlot/livemap/chart/path/ArrowSpec;", "Lorg/jetbrains/letsPlot/core/plot/livemap/LiveMapArrowSpec;", "getArrowSpec", "()Lorg/jetbrains/letsPlot/livemap/chart/path/ArrowSpec;", "clockwise", "getClockwise", "colorArray", "", "Lorg/jetbrains/letsPlot/commons/values/Color;", "getColorArray", "()Ljava/util/List;", "explodeArray", "getExplodeArray", "family", "", "getFamily", "()Ljava/lang/String;", "fillArray", "getFillArray", "fillColor", "getFillColor", "()Lorg/jetbrains/letsPlot/commons/values/Color;", "flat", "getFlat", "setFlat", "(Z)V", "flow", "getFlow", "fontface", "getFontface", "geoObject", "Lorg/jetbrains/letsPlot/livemap/api/GeoObject;", "getGeoObject", "()Lorg/jetbrains/letsPlot/livemap/api/GeoObject;", "geodesic", "getGeodesic", "setGeodesic", "value", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "geometry", "getGeometry", "setGeometry", "(Ljava/util/List;)V", "hjust", "getHjust", "holeRatio", "getHoleRatio", "index", "getIndex", "indices", "getIndices", "isCurve", "setCurve", "label", "getLabel", "labelPadding", "getLabelPadding", "labelRadius", "getLabelRadius", "labelSize", "getLabelSize", "lineDash", "getLineDash", "lineDashOffset", "getLineDashOffset", "lineheight", "getLineheight", "myFillArray", "myLabelOptions", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/LabelOptions;", "myLayerKind", "getMyLayerKind", "()Lorg/jetbrains/letsPlot/core/plot/livemap/MapLayerKind;", "myP", "getMyP", "()Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "myPieOptions", "Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointsConverter$PieOptions;", "myPlotArrowSpec", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec;", "point", "getPoint", "()Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "setPoint", "(Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;)V", "radius", "getRadius", "shape", "getShape", "size", "getSize", "sizeEnd", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Scalar;", "Lorg/jetbrains/letsPlot/livemap/Client;", "getSizeEnd-b9qgYVc", "sizeStart", "getSizeStart-b9qgYVc", "spacer", "getSpacer-b9qgYVc", "setSpacer-hZjkWWM", "(D)V", "D", "spacerColor", "getSpacerColor", "spacerWidth", "getSpacerWidth", "speed", "getSpeed", "startAngle", "getStartAngle", "()Ljava/lang/Double;", "strokeArray", "getStrokeArray", "strokeColor", "getStrokeColor", "strokeEnd", "getStrokeEnd-b9qgYVc", "strokeSide", "Lorg/jetbrains/letsPlot/livemap/chart/donut/StrokeSide;", "getStrokeSide", "()Lorg/jetbrains/letsPlot/livemap/chart/donut/StrokeSide;", "strokeStart", "getStrokeStart-b9qgYVc", "strokeWidth", "getStrokeWidth", "valueArray", "getValueArray", "vjust", "getVjust", "colorWithAlpha", "color", "pointRadius", "(Ljava/lang/Integer;)Lorg/jetbrains/letsPlot/core/plot/livemap/DataPointLiveMapAesthetics;", "setArrowSpec", "setLabelOptions", "labelOptions", "setPieOptions", "pieOptions", "trimLonLat", "plot-livemap"})
@SourceDebugExtension(value={"SMAP\nDataPointLiveMapAesthetics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataPointLiveMapAesthetics.kt\norg/jetbrains/letsPlot/core/plot/livemap/DataPointLiveMapAesthetics\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,281:1\n1549#2:282\n1620#2,3:283\n1549#2:286\n1620#2,3:287\n1549#2:290\n1620#2,3:291\n*S KotlinDebug\n*F\n+ 1 DataPointLiveMapAesthetics.kt\norg/jetbrains/letsPlot/core/plot/livemap/DataPointLiveMapAesthetics\n*L\n73#1:282\n73#1:283,3\n144#1:286\n144#1:287,3\n207#1:290\n207#1:291,3\n*E\n"})
public final class DataPointLiveMapAesthetics {
    @NotNull
    private final DataPointAesthetics myP;
    @NotNull
    private final List<Integer> indices;
    @NotNull
    private final List<Double> valueArray;
    @NotNull
    private List<Color> myFillArray;
    @NotNull
    private final List<Color> colorArray;
    @NotNull
    private final List<Double> strokeArray;
    @NotNull
    private final List<Double> explodeArray;
    @NotNull
    private final MapLayerKind myLayerKind;
    @Nullable
    private List<? extends Vec<? extends LonLat>> geometry;
    @NotNull
    private Vec<? extends LonLat> point;
    private boolean flat;
    private boolean geodesic;
    private int animation;
    private boolean isCurve;
    @Nullable
    private ArrowSpec myPlotArrowSpec;
    private double spacer;
    @Nullable
    private LabelOptions myLabelOptions;
    @Nullable
    private DataPointsConverter.PieOptions myPieOptions;

    public DataPointLiveMapAesthetics(@NotNull DataPointAesthetics p, @NotNull MapLayerKind layerKind) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)((Object)layerKind), (String)"layerKind");
        this.myFillArray = CollectionsKt.emptyList();
        this.point = LonLat.Companion.getZERO_VEC();
        this.spacer = Client.Companion.getPx-VvMBhYE((Number)0);
        this.myLayerKind = layerKind;
        this.myP = p;
        this.indices = CollectionsKt.emptyList();
        this.valueArray = CollectionsKt.emptyList();
        this.colorArray = CollectionsKt.emptyList();
        this.strokeArray = CollectionsKt.emptyList();
        this.explodeArray = CollectionsKt.emptyList();
    }

    public DataPointLiveMapAesthetics(@NotNull DataPointsConverter.MultiDataPointHelper.MultiDataPoint p, @NotNull MapLayerKind layerKind) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)((Object)layerKind), (String)"layerKind");
        this.myFillArray = CollectionsKt.emptyList();
        this.point = LonLat.Companion.getZERO_VEC();
        this.spacer = Client.Companion.getPx-VvMBhYE((Number)0);
        this.myLayerKind = layerKind;
        this.myP = p.getAes();
        this.indices = p.getIndices();
        this.valueArray = p.getValues();
        this.myFillArray = p.getFillArray();
        this.colorArray = p.getColorArray();
        this.strokeArray = p.getStrokeArray();
        this.explodeArray = p.getExplodeValues();
    }

    @NotNull
    public final DataPointAesthetics getMyP() {
        return this.myP;
    }

    @NotNull
    public final List<Integer> getIndices() {
        return this.indices;
    }

    @NotNull
    public final List<Double> getValueArray() {
        return this.valueArray;
    }

    @NotNull
    public final List<Color> getColorArray() {
        return this.colorArray;
    }

    @NotNull
    public final List<Double> getStrokeArray() {
        return this.strokeArray;
    }

    @NotNull
    public final List<Double> getExplodeArray() {
        return this.explodeArray;
    }

    @NotNull
    public final MapLayerKind getMyLayerKind() {
        return this.myLayerKind;
    }

    @Nullable
    public final List<Vec<LonLat>> getGeometry() {
        return this.geometry;
    }

    /*
     * WARNING - void declaration
     */
    public final void setGeometry(@Nullable List<? extends Vec<? extends LonLat>> value) {
        List list;
        DataPointLiveMapAesthetics dataPointLiveMapAesthetics = this;
        List<? extends Vec<? extends LonLat>> list2 = value;
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list2;
            DataPointLiveMapAesthetics dataPointLiveMapAesthetics2 = dataPointLiveMapAesthetics;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                Vec vec = (Vec)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.trimLonLat((Vec<? extends LonLat>)p0));
            }
            list = (List)destination$iv$iv;
            dataPointLiveMapAesthetics = dataPointLiveMapAesthetics2;
        } else {
            list = null;
        }
        dataPointLiveMapAesthetics.geometry = list;
    }

    @NotNull
    public final Vec<LonLat> getPoint() {
        return this.point;
    }

    public final void setPoint(@NotNull Vec<? extends LonLat> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.point = this.trimLonLat(value);
    }

    public final boolean getFlat() {
        return this.flat;
    }

    public final void setFlat(boolean bl) {
        this.flat = bl;
    }

    public final boolean getGeodesic() {
        return this.geodesic;
    }

    public final void setGeodesic(boolean bl) {
        this.geodesic = bl;
    }

    public final int getAnimation() {
        return this.animation;
    }

    public final void setAnimation(int n) {
        this.animation = n;
    }

    public final boolean isCurve() {
        return this.isCurve;
    }

    public final void setCurve(boolean bl) {
        this.isCurve = bl;
    }

    @Nullable
    public final org.jetbrains.letsPlot.livemap.chart.path.ArrowSpec getArrowSpec() {
        org.jetbrains.letsPlot.livemap.chart.path.ArrowSpec arrowSpec;
        ArrowSpec arrowSpec2 = this.myPlotArrowSpec;
        if (arrowSpec2 != null) {
            ArrowSpec.Type type;
            ArrowSpec.End end;
            ArrowSpec it = arrowSpec2;
            boolean bl = false;
            double d = it.getAngle();
            double d2 = Client.Companion.getPx-VvMBhYE((Number)it.getLength());
            switch (WhenMappings.$EnumSwitchMapping$0[it.getEnd().ordinal()]) {
                case 1: {
                    end = ArrowSpec.End.LAST;
                    break;
                }
                case 2: {
                    end = ArrowSpec.End.FIRST;
                    break;
                }
                case 3: {
                    end = ArrowSpec.End.BOTH;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$1[it.getType().ordinal()]) {
                case 1: {
                    type = ArrowSpec.Type.OPEN;
                    break;
                }
                case 2: {
                    type = ArrowSpec.Type.CLOSED;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            arrowSpec = new org.jetbrains.letsPlot.livemap.chart.path.ArrowSpec(d, d2, end, type, null);
        } else {
            arrowSpec = null;
        }
        return arrowSpec;
    }

    public final int getIndex() {
        return this.myP.index();
    }

    public final double getFlow() {
        Double d = this.myP.flow();
        Intrinsics.checkNotNull((Object)d);
        return d;
    }

    public final double getSpeed() {
        Double d = this.myP.speed();
        Intrinsics.checkNotNull((Object)d);
        return d;
    }

    @NotNull
    public final String getFamily() {
        return this.myP.family();
    }

    public final double getAngle() {
        Double d = this.myP.angle();
        Intrinsics.checkNotNull((Object)d);
        return d;
    }

    public final int getShape() {
        PointShape pointShape = this.myP.shape();
        Intrinsics.checkNotNull((Object)pointShape);
        return pointShape.getCode();
    }

    public final double getSize() {
        return AestheticsUtil.INSTANCE.textSize(this.myP);
    }

    @NotNull
    public final Color getFillColor() {
        Color color = this.myP.fill();
        Intrinsics.checkNotNull((Object)color);
        return this.colorWithAlpha(color);
    }

    @NotNull
    public final String getLabel() {
        Object object = this.myP.label();
        if (object == null || (object = object.toString()) == null) {
            object = "n/a";
        }
        return object;
    }

    public final double getLineheight() {
        Double d = this.myP.lineheight();
        Intrinsics.checkNotNull((Object)d);
        return d;
    }

    public final double getHjust() {
        double d;
        switch (WhenMappings.$EnumSwitchMapping$2[TextUtil.INSTANCE.hAnchor(this.myP.hjust()).ordinal()]) {
            case 1: {
                d = 0.0;
                break;
            }
            case 2: {
                d = 1.0;
                break;
            }
            case 3: {
                d = 0.5;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    public final double getVjust() {
        double d;
        switch (WhenMappings.$EnumSwitchMapping$3[TextUtil.INSTANCE.vAnchor(this.myP.vjust()).ordinal()]) {
            case 1: {
                d = 0.0;
                break;
            }
            case 2: {
                d = 1.0;
                break;
            }
            case 3: {
                d = 0.5;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getFontface() {
        void var1_1;
        String fontface = this.myP.fontface();
        return Intrinsics.areEqual((Object)fontface, (Object)AesInitValue.INSTANCE.get(Aes.Companion.getFONTFACE())) ? "" : var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Double> getLineDash() {
        void $this$mapTo$iv$iv;
        LineType lineType = this.myP.lineType();
        if (lineType.isSolid()) {
            return CollectionsKt.emptyList();
        }
        double width = AestheticsUtil.INSTANCE.strokeWidth(this.myP);
        Iterable $this$map$iv = lineType.getDashArray();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((double)(it * width));
        }
        return (List)destination$iv$iv;
    }

    public final double getLineDashOffset() {
        LineType lineType = this.myP.lineType();
        if (lineType.isSolid()) {
            return 0.0;
        }
        double width = AestheticsUtil.INSTANCE.strokeWidth(this.myP);
        return lineType.getDashOffset() * width;
    }

    @Nullable
    public final GeoObject getGeoObject() {
        if (!Intrinsics.areEqual((Object)this.myP.mapId(), (Object)DefaultNaValue.INSTANCE.get(Aes.Companion.getMAP_ID()))) {
            Map geoReference = JsonSupport.INSTANCE.parseJson(this.myP.mapId().toString());
            Object v = geoReference.get("id");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            String id = (String)v;
            Object v2 = geoReference.get("lim");
            List list = v2 instanceof List ? (List)v2 : null;
            if (list == null || (list = DataPointLiveMapAesthetics._get_geoObject_$toGeoRect(list)) == null) {
                throw new IllegalStateException("Limit have to be provided".toString());
            }
            List lim = list;
            Object v3 = geoReference.get("pos");
            List list2 = v3 instanceof List ? (List)v3 : null;
            if (list2 == null || (list2 = DataPointLiveMapAesthetics._get_geoObject_$toGeoRect(list2)) == null) {
                throw new IllegalStateException("Position have to be provided".toString());
            }
            List pos = list2;
            Object v4 = geoReference.get("cen");
            Vec<LonLat> vec = v4 instanceof List ? (Vec<LonLat>)v4 : null;
            if (vec == null || (vec = DataPointLiveMapAesthetics._get_geoObject_$toVec(vec)) == null) {
                throw new IllegalStateException("Centroid have to be provided".toString());
            }
            Vec<LonLat> cen = vec;
            return new GeoObject(id, cen, (GeoRectangle)lim, (GeoRectangle)pos);
        }
        return null;
    }

    @NotNull
    public final Color getStrokeColor() {
        Color color;
        switch (WhenMappings.$EnumSwitchMapping$4[this.myLayerKind.ordinal()]) {
            case 1: 
            case 2: {
                Color color2 = this.myP.color();
                color = color2;
                Intrinsics.checkNotNull((Object)color2);
                break;
            }
            default: {
                Color color3 = this.myP.color();
                Intrinsics.checkNotNull((Object)color3);
                color = this.colorWithAlpha(color3);
            }
        }
        return color;
    }

    private final double pointRadius(double size) {
        return Math.ceil(size / 2.0);
    }

    public final double getRadius() {
        double d;
        switch (WhenMappings.$EnumSwitchMapping$4[this.myLayerKind.ordinal()]) {
            case 3: {
                PointShape pointShape = this.myP.shape();
                Intrinsics.checkNotNull((Object)pointShape);
                d = this.pointRadius(PointShape.DefaultImpls.size$default((PointShape)pointShape, (DataPointAesthetics)this.myP, (double)0.0, (int)2, null));
                break;
            }
            case 2: {
                d = AestheticsUtil.INSTANCE.pieDiameter(this.myP) / 2.0;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        return d;
    }

    public final double getStrokeWidth() {
        double d;
        switch (WhenMappings.$EnumSwitchMapping$4[this.myLayerKind.ordinal()]) {
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                d = AestheticsUtil.INSTANCE.strokeWidth(this.myP);
                break;
            }
            case 3: {
                d = AestheticsUtil.pointStrokeWidth$default((AestheticsUtil)AestheticsUtil.INSTANCE, (DataPointAesthetics)this.myP, null, (int)2, null);
                break;
            }
            case 7: {
                d = 0.0;
                break;
            }
            case 2: {
                Double d2 = this.myP.stroke();
                if (d2 != null) {
                    d = d2;
                    break;
                }
                d = 0.0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Color> getFillArray() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.myFillArray;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Color color = (Color)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.colorWithAlpha((Color)p0));
        }
        return (List)destination$iv$iv;
    }

    public final double getSizeStart-b9qgYVc() {
        return ScalarKt.times-ZDqpIUE((double)Client.Companion.getPx-VvMBhYE((Number)this.pointRadius(AestheticsUtil.INSTANCE.circleDiameter(this.myP, (Function1)sizeStart.1.INSTANCE))), (Number)2.0);
    }

    public final double getSizeEnd-b9qgYVc() {
        return ScalarKt.times-ZDqpIUE((double)Client.Companion.getPx-VvMBhYE((Number)this.pointRadius(AestheticsUtil.INSTANCE.circleDiameter(this.myP, (Function1)sizeEnd.1.INSTANCE))), (Number)2.0);
    }

    public final double getStrokeStart-b9qgYVc() {
        return Client.Companion.getPx-VvMBhYE((Number)AestheticsUtil.INSTANCE.pointStrokeWidth(this.myP, (Function1)strokeStart.1.INSTANCE));
    }

    public final double getStrokeEnd-b9qgYVc() {
        return Client.Companion.getPx-VvMBhYE((Number)AestheticsUtil.INSTANCE.pointStrokeWidth(this.myP, (Function1)strokeEnd.1.INSTANCE));
    }

    public final double getSpacer-b9qgYVc() {
        return this.spacer;
    }

    public final void setSpacer-hZjkWWM(double d) {
        this.spacer = d;
    }

    public final double getLabelPadding() {
        LabelOptions labelOptions = this.myLabelOptions;
        return labelOptions != null ? labelOptions.getPaddingFactor() : 0.0;
    }

    public final double getLabelRadius() {
        LabelOptions labelOptions = this.myLabelOptions;
        return labelOptions != null ? labelOptions.getRadiusFactor() : 0.0;
    }

    public final double getLabelSize() {
        LabelOptions labelOptions = this.myLabelOptions;
        return labelOptions != null ? labelOptions.getBorderWidth() : 0.0;
    }

    public final boolean getAlphaStroke() {
        LabelOptions labelOptions = this.myLabelOptions;
        return labelOptions != null ? labelOptions.getAlphaStroke() : false;
    }

    public final double getHoleRatio() {
        DataPointsConverter.PieOptions pieOptions = this.myPieOptions;
        return pieOptions != null ? pieOptions.getHoleSize() : 0.0;
    }

    @NotNull
    public final Color getSpacerColor() {
        DataPointsConverter.PieOptions pieOptions = this.myPieOptions;
        if (pieOptions == null || (pieOptions = pieOptions.getSpacerColor()) == null) {
            pieOptions = Color.Companion.getWHITE();
        }
        return pieOptions;
    }

    public final double getSpacerWidth() {
        DataPointsConverter.PieOptions pieOptions = this.myPieOptions;
        return pieOptions != null ? pieOptions.getSpacerWidth() : 1.0;
    }

    @NotNull
    public final StrokeSide getStrokeSide() {
        DataPointsConverter.PieOptions pieOptions;
        block8: {
            block7: {
                StrokeSide strokeSide;
                pieOptions = this.myPieOptions;
                if (pieOptions == null || (pieOptions = pieOptions.getStrokeSide()) == null) break block7;
                DataPointsConverter.PieOptions it = pieOptions;
                boolean bl = false;
                switch (WhenMappings.$EnumSwitchMapping$5[it.ordinal()]) {
                    case 1: {
                        strokeSide = StrokeSide.OUTER;
                        break;
                    }
                    case 2: {
                        strokeSide = StrokeSide.INNER;
                        break;
                    }
                    case 3: {
                        strokeSide = StrokeSide.BOTH;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                pieOptions = strokeSide;
                if (strokeSide != null) break block8;
            }
            pieOptions = StrokeSide.OUTER;
        }
        return pieOptions;
    }

    @Nullable
    public final Double getStartAngle() {
        DataPointsConverter.PieOptions pieOptions = this.myPieOptions;
        return pieOptions != null ? pieOptions.getStartAngle() : null;
    }

    public final boolean getClockwise() {
        DataPointsConverter.PieOptions pieOptions = this.myPieOptions;
        return !(pieOptions != null ? !pieOptions.getClockwise() : false);
    }

    private final Color colorWithAlpha(Color color) {
        return color.changeAlpha((int)(AestheticsUtil.INSTANCE.alpha(color, this.myP) * (double)255));
    }

    @NotNull
    public final DataPointLiveMapAesthetics setArrowSpec(@Nullable ArrowSpec arrowSpec) {
        this.myPlotArrowSpec = arrowSpec;
        return this;
    }

    @NotNull
    public final DataPointLiveMapAesthetics setAnimation(@Nullable Integer animation) {
        if (animation != null) {
            this.animation = animation;
        }
        return this;
    }

    @NotNull
    public final DataPointLiveMapAesthetics setLabelOptions(@Nullable LabelOptions labelOptions) {
        this.myLabelOptions = labelOptions;
        return this;
    }

    @NotNull
    public final DataPointLiveMapAesthetics setPieOptions(@Nullable DataPointsConverter.PieOptions pieOptions) {
        this.myPieOptions = pieOptions;
        return this;
    }

    private final Vec<LonLat> trimLonLat(Vec<? extends LonLat> p) {
        return new Vec(GeographicKt.normalizeLon((double)p.getX()), GeographicKt.limitLat((double)p.getY()));
    }

    private static final Vec<LonLat> _get_geoObject_$toVec(List<?> $this$_get_geoObject__u24toVec) {
        Object obj = $this$_get_geoObject__u24toVec.get(0);
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Double");
        double d = (Double)obj;
        Object obj2 = $this$_get_geoObject__u24toVec.get(1);
        Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type kotlin.Double");
        return VecKt.explicitVec((double)d, (double)((Double)obj2));
    }

    private static final GeoRectangle _get_geoObject_$toGeoRect(List<?> $this$_get_geoObject__u24toGeoRect) {
        Object obj = $this$_get_geoObject__u24toGeoRect.get(0);
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Double");
        double d = (Double)obj;
        Object obj2 = $this$_get_geoObject__u24toGeoRect.get(1);
        Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type kotlin.Double");
        double d2 = (Double)obj2;
        Object obj3 = $this$_get_geoObject__u24toGeoRect.get(2);
        Intrinsics.checkNotNull(obj3, (String)"null cannot be cast to non-null type kotlin.Double");
        double d3 = (Double)obj3;
        Object obj4 = $this$_get_geoObject__u24toGeoRect.get(3);
        Intrinsics.checkNotNull(obj4, (String)"null cannot be cast to non-null type kotlin.Double");
        return new GeoRectangle(d, d2, d3, ((Double)obj4).doubleValue());
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;
        public static final /* synthetic */ int[] $EnumSwitchMapping$5;

        static {
            int[] nArray = new int[ArrowSpec.End.values().length];
            try {
                nArray[ArrowSpec.End.LAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArrowSpec.End.FIRST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArrowSpec.End.BOTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ArrowSpec.Type.values().length];
            try {
                nArray[ArrowSpec.Type.OPEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArrowSpec.Type.CLOSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[Text.HorizontalAnchor.values().length];
            try {
                nArray[Text.HorizontalAnchor.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.HorizontalAnchor.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.HorizontalAnchor.MIDDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[Text.VerticalAnchor.values().length];
            try {
                nArray[Text.VerticalAnchor.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.VerticalAnchor.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.VerticalAnchor.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[MapLayerKind.values().length];
            try {
                nArray[MapLayerKind.POLYGON.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapLayerKind.PIE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapLayerKind.POINT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapLayerKind.PATH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapLayerKind.H_LINE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapLayerKind.V_LINE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapLayerKind.TEXT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$4 = nArray;
            nArray = new int[PieGeom.StrokeSide.values().length];
            try {
                nArray[PieGeom.StrokeSide.OUTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PieGeom.StrokeSide.INNER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PieGeom.StrokeSide.BOTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$5 = nArray;
        }
    }
}

