/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.livemap;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.spatial.GeoBoundingBoxCalculator;
import org.jetbrains.letsPlot.commons.intern.spatial.GeoBoundingBoxCalculatorKt;
import org.jetbrains.letsPlot.commons.intern.spatial.GeoRectangle;
import org.jetbrains.letsPlot.commons.intern.spatial.GeographicKt;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.core.plot.livemap.ConfigUtil;
import org.jetbrains.letsPlot.gis.geoprotocol.MapRegion;
import org.jetbrains.letsPlot.livemap.api.MapLocation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002JF\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0014\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0019\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0002J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0001H\u0002JC\u0010#\u001a\u0002H$\"\u0004\b\u0000\u0010$2\u000e\u0010 \u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001a2\u001e\u0010%\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H$0&0\u001aH\u0002\u00a2\u0006\u0002\u0010'J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\"\u0004\b\u0000\u0010$*\b\u0012\u0004\u0012\u0002H$0\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/letsPlot/core/plot/livemap/ConfigUtil;", "", "()V", "REGION_DATA", "", "REGION_TYPE", "REGION_TYPE_COORDINATES", "REGION_TYPE_DATAFRAME", "REGION_TYPE_IDS", "REGION_TYPE_NAME", "calculateBoundingBox", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "xyCoords", "", "", "xCoords", "yCoords", "minXCoords", "minYCoords", "maxXCoords", "maxYCoords", "calculateGeoRectangle", "Lorg/jetbrains/letsPlot/commons/intern/spatial/GeoRectangle;", "lonLatList", "lonLatDataMap", "", "createMapLocation", "Lorg/jetbrains/letsPlot/livemap/api/MapLocation;", "location", "createMapRegion", "Lorg/jetbrains/letsPlot/gis/geoprotocol/MapRegion;", "region", "getWithIdList", "data", "handleRegionObject", "T", "handlerMap", "Lkotlin/Function1;", "(Ljava/util/Map;Ljava/util/Map;)Ljava/lang/Object;", "toDoubleList", "plot-livemap"})
@SourceDebugExtension(value={"SMAP\nConfigUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigUtil.kt\norg/jetbrains/letsPlot/core/plot/livemap/ConfigUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n1726#2,3:167\n1#3:170\n*S KotlinDebug\n*F\n+ 1 ConfigUtil.kt\norg/jetbrains/letsPlot/core/plot/livemap/ConfigUtil\n*L\n27#1:167,3\n*E\n"})
public final class ConfigUtil {
    @NotNull
    public static final ConfigUtil INSTANCE = new ConfigUtil();
    @NotNull
    private static final String REGION_TYPE = "type";
    @NotNull
    private static final String REGION_DATA = "data";
    @NotNull
    private static final String REGION_TYPE_NAME = "region_name";
    @NotNull
    private static final String REGION_TYPE_IDS = "region_ids";
    @NotNull
    private static final String REGION_TYPE_COORDINATES = "coordinates";
    @NotNull
    private static final String REGION_TYPE_DATAFRAME = "data_frame";

    private ConfigUtil() {
    }

    private final <T> List<Double> toDoubleList(List<? extends T> $this$toDoubleList) {
        boolean bl;
        block5: {
            if ($this$toDoubleList.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$all$iv = $this$toDoubleList;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (it instanceof Double) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            Intrinsics.checkNotNull($this$toDoubleList, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Double>");
            return $this$toDoubleList;
        }
        throw new IllegalStateException("Can't cast to collection of numbers".toString());
    }

    private final MapRegion getWithIdList(Object data) {
        Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
        List list = (List)data;
        return MapRegion.Companion.withIdList(list);
    }

    private final GeoRectangle calculateGeoRectangle(List<?> lonLatList) {
        if (!(!(!((Collection)lonLatList).isEmpty()) || lonLatList.size() % 2 == 0)) {
            boolean bl = false;
            String string = "Expected: location = [double lon1, double lat1, double lon2, double lat2, ... , double lonN, double latN]";
            throw new IllegalArgumentException(string.toString());
        }
        return GeographicKt.convertToGeoRectangle(this.calculateBoundingBox(this.toDoubleList(lonLatList)));
    }

    private final GeoRectangle calculateGeoRectangle(Map<?, ?> lonLatDataMap) {
        if (lonLatDataMap.containsKey("lon") && lonLatDataMap.containsKey("lat")) {
            Object obj = lonLatDataMap.get("lon");
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
            List<Double> list = this.toDoubleList((List)obj);
            Object obj2 = lonLatDataMap.get("lat");
            Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
            return GeographicKt.convertToGeoRectangle(this.calculateBoundingBox(list, this.toDoubleList((List)obj2)));
        }
        if (lonLatDataMap.containsKey("lonmin") && lonLatDataMap.containsKey("latmin") && lonLatDataMap.containsKey("lonmax") && lonLatDataMap.containsKey("latmax")) {
            Object obj = lonLatDataMap.get("lonmin");
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
            List<Double> list = this.toDoubleList((List)obj);
            Object obj3 = lonLatDataMap.get("latmin");
            Intrinsics.checkNotNull(obj3, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
            List<Double> list2 = this.toDoubleList((List)obj3);
            Object obj4 = lonLatDataMap.get("lonmax");
            Intrinsics.checkNotNull(obj4, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
            List<Double> list3 = this.toDoubleList((List)obj4);
            Object obj5 = lonLatDataMap.get("latmax");
            Intrinsics.checkNotNull(obj5, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
            return GeographicKt.convertToGeoRectangle(this.calculateBoundingBox(list, list2, list3, this.toDoubleList((List)obj5)));
        }
        throw new IllegalArgumentException("Expected: location = DataFrame with ['lon', 'lat'] or ['lonmin', 'latmin', 'lonmax', 'latmax'] columns");
    }

    private final MapRegion createMapRegion(Object region) {
        MapRegion mapRegion;
        Object object = region;
        if (object == null) {
            mapRegion = null;
        } else if (object instanceof Map) {
            HashMap handlerMap = new HashMap();
            ((Map)handlerMap).put(REGION_TYPE_NAME, createMapRegion.1.INSTANCE);
            ((Map)handlerMap).put(REGION_TYPE_IDS, createMapRegion.2.INSTANCE);
            mapRegion = (MapRegion)this.handleRegionObject((Map)region, handlerMap);
        } else {
            throw new IllegalArgumentException("Expected: parent = [String]");
        }
        return mapRegion;
    }

    @Nullable
    public final MapLocation createMapLocation(@Nullable Object location) {
        MapLocation mapLocation;
        Object object = location;
        if (object == null) {
            mapLocation = null;
        } else if (object instanceof Map) {
            HashMap handlerMap = new HashMap();
            ((Map)handlerMap).put(REGION_TYPE_NAME, createMapLocation.1.INSTANCE);
            ((Map)handlerMap).put(REGION_TYPE_IDS, createMapLocation.2.INSTANCE);
            ((Map)handlerMap).put(REGION_TYPE_COORDINATES, createMapLocation.3.INSTANCE);
            ((Map)handlerMap).put(REGION_TYPE_DATAFRAME, createMapLocation.4.INSTANCE);
            mapLocation = (MapLocation)this.handleRegionObject((Map)location, handlerMap);
        } else {
            throw new IllegalArgumentException("Expected: location = [String|Array|DataFrame]");
        }
        return mapLocation;
    }

    private final <T> T handleRegionObject(Map<?, ?> region, Map<String, ? extends Function1<Object, ? extends T>> handlerMap) {
        Object obj = region.get(REGION_TYPE);
        if (obj == null) {
            throw new IllegalArgumentException("Invalid map region object");
        }
        Object regionType = obj;
        Object obj2 = region.get(REGION_DATA);
        if (obj2 == null) {
            throw new IllegalArgumentException("Invalid map region object");
        }
        Object regionData = obj2;
        for (Map.Entry<String, Function1<Object, T>> entry : handlerMap.entrySet()) {
            String key = entry.getKey();
            Function1<Object, ? extends T> handler = entry.getValue();
            if (!Intrinsics.areEqual(regionType, (Object)key)) continue;
            return (T)handler.invoke(regionData);
        }
        throw new IllegalArgumentException("Invalid map region type: " + regionType);
    }

    private final Rect<LonLat> calculateBoundingBox(List<Double> xyCoords) {
        return GeoBoundingBoxCalculatorKt.pointsBBox((GeoBoundingBoxCalculator)GeographicKt.getBBOX_CALCULATOR(), xyCoords);
    }

    private final Rect<LonLat> calculateBoundingBox(List<Double> xCoords, List<Double> yCoords) {
        if (!(xCoords.size() == yCoords.size())) {
            boolean bl = false;
            String string = "Longitude list count is not equal Latitude list count.";
            throw new IllegalArgumentException(string.toString());
        }
        return GeographicKt.getBBOX_CALCULATOR().calculateBoundingBox(GeoBoundingBoxCalculatorKt.makeSegments((Function1)((Function1)new Function1<Integer, Double>(xCoords){

            @NotNull
            public final Double invoke(int p0) {
                return (Double)((List)this.receiver).get(p0);
            }
        }), (Function1)((Function1)new Function1<Integer, Double>(xCoords){

            @NotNull
            public final Double invoke(int p0) {
                return (Double)((List)this.receiver).get(p0);
            }
        }), (int)xCoords.size()), GeoBoundingBoxCalculatorKt.makeSegments((Function1)((Function1)new Function1<Integer, Double>(yCoords){

            @NotNull
            public final Double invoke(int p0) {
                return (Double)((List)this.receiver).get(p0);
            }
        }), (Function1)((Function1)new Function1<Integer, Double>(yCoords){

            @NotNull
            public final Double invoke(int p0) {
                return (Double)((List)this.receiver).get(p0);
            }
        }), (int)xCoords.size()));
    }

    private final Rect<LonLat> calculateBoundingBox(List<Double> minXCoords, List<Double> minYCoords, List<Double> maxXCoords, List<Double> maxYCoords) {
        int count = minXCoords.size();
        if (!(minYCoords.size() == count && maxXCoords.size() == count && maxYCoords.size() == count)) {
            boolean bl = false;
            String string = "Counts of 'minLongitudes', 'minLatitudes', 'maxLongitudes', 'maxLatitudes' lists are not equal.";
            throw new IllegalArgumentException(string.toString());
        }
        return GeographicKt.getBBOX_CALCULATOR().calculateBoundingBox(GeoBoundingBoxCalculatorKt.makeSegments((Function1)((Function1)new Function1<Integer, Double>(minXCoords){

            @NotNull
            public final Double invoke(int p0) {
                return (Double)((List)this.receiver).get(p0);
            }
        }), (Function1)((Function1)new Function1<Integer, Double>(maxXCoords){

            @NotNull
            public final Double invoke(int p0) {
                return (Double)((List)this.receiver).get(p0);
            }
        }), (int)count), GeoBoundingBoxCalculatorKt.makeSegments((Function1)((Function1)new Function1<Integer, Double>(minYCoords){

            @NotNull
            public final Double invoke(int p0) {
                return (Double)((List)this.receiver).get(p0);
            }
        }), (Function1)((Function1)new Function1<Integer, Double>(maxYCoords){

            @NotNull
            public final Double invoke(int p0) {
                return (Double)((List)this.receiver).get(p0);
            }
        }), (int)count));
    }

    public static final /* synthetic */ MapRegion access$getWithIdList(ConfigUtil $this, Object data) {
        return $this.getWithIdList(data);
    }

    public static final /* synthetic */ GeoRectangle access$calculateGeoRectangle(ConfigUtil $this, List lonLatList) {
        return $this.calculateGeoRectangle(lonLatList);
    }

    public static final /* synthetic */ GeoRectangle access$calculateGeoRectangle(ConfigUtil $this, Map lonLatDataMap) {
        return $this.calculateGeoRectangle(lonLatDataMap);
    }
}

