/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.awt.plot.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.awt.plot.component.ApplicationContext;
import org.jetbrains.letsPlot.awt.plot.component.PlotComponentProvider;
import org.jetbrains.letsPlot.awt.plot.component.PlotPanelFigureModel;
import org.jetbrains.letsPlot.awt.plot.component.ResizeHook;
import org.jetbrains.letsPlot.commons.registration.Disposable;
import org.jetbrains.letsPlot.core.plot.builder.interact.tools.FigureModel;
import org.jetbrains.letsPlot.core.util.sizing.SizingPolicy;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0016\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B'\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J6\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\f\u001a\u00020\r2\u001a\b\u0002\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!0 H\u0002R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/letsPlot/awt/plot/component/PlotPanel;", "Ljavax/swing/JPanel;", "Lorg/jetbrains/letsPlot/commons/registration/Disposable;", "plotComponentProvider", "Lorg/jetbrains/letsPlot/awt/plot/component/PlotComponentProvider;", "preferredSizeFromPlot", "", "repaintDelay", "", "applicationContext", "Lorg/jetbrains/letsPlot/awt/plot/component/ApplicationContext;", "(Lorg/jetbrains/letsPlot/awt/plot/component/PlotComponentProvider;ZILorg/jetbrains/letsPlot/awt/plot/component/ApplicationContext;)V", "sizingPolicy", "Lorg/jetbrains/letsPlot/core/util/sizing/SizingPolicy;", "(Lorg/jetbrains/letsPlot/awt/plot/component/PlotComponentProvider;ZLorg/jetbrains/letsPlot/core/util/sizing/SizingPolicy;ILorg/jetbrains/letsPlot/awt/plot/component/ApplicationContext;)V", "figureModel", "Lorg/jetbrains/letsPlot/core/plot/builder/interact/tools/FigureModel;", "getFigureModel", "()Lorg/jetbrains/letsPlot/core/plot/builder/interact/tools/FigureModel;", "dispose", "", "handleChildRemoved", "child", "Ljava/awt/Component;", "handleChildRemovedIntern", "plotComponentCreated", "plotComponent", "Ljavax/swing/JComponent;", "rebuildProvidedComponent", "containerSize", "Ljava/awt/Dimension;", "specOverrideList", "", "", "", "", "Companion", "platf-awt"})
public class PlotPanel
extends JPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlotComponentProvider plotComponentProvider;
    @NotNull
    private final SizingPolicy sizingPolicy;
    @NotNull
    private final FigureModel figureModel;

    public PlotPanel(@NotNull PlotComponentProvider plotComponentProvider, boolean preferredSizeFromPlot, @NotNull SizingPolicy sizingPolicy, int repaintDelay, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)plotComponentProvider, (String)"plotComponentProvider");
        Intrinsics.checkNotNullParameter((Object)sizingPolicy, (String)"sizingPolicy");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.plotComponentProvider = plotComponentProvider;
        this.sizingPolicy = sizingPolicy;
        this.setLayout(new BorderLayout(0, 0));
        this.setOpaque(false);
        this.setBorder(null);
        this.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentRemoved(@NotNull ContainerEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Component component = e.getChild();
                Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getChild(...)");
                this.handleChildRemovedIntern(component);
            }
        });
        JComponent providedComponent = preferredSizeFromPlot ? PlotPanel.rebuildProvidedComponent$default(this, null, this.sizingPolicy, null, 4, null) : null;
        this.figureModel = new PlotPanelFigureModel(this, providedComponent, (Function2<? super Dimension, ? super List<? extends Map<String, ? extends Object>>, ? extends JComponent>)((Function2)new Function2<Dimension, List<? extends Map<String, ? extends Object>>, JComponent>(){

            @NotNull
            public final JComponent invoke(@NotNull Dimension containerSize, @NotNull List<? extends Map<String, ? extends Object>> specOverrideList) {
                Intrinsics.checkNotNullParameter((Object)containerSize, (String)"containerSize");
                Intrinsics.checkNotNullParameter(specOverrideList, (String)"specOverrideList");
                return this.rebuildProvidedComponent(containerSize, sizingPolicy, specOverrideList);
            }
        }), applicationContext);
        this.addComponentListener(new ResizeHook(this, providedComponent != null, providedComponent instanceof JScrollPane ? (JScrollPane)providedComponent : null, (PlotPanelFigureModel)this.figureModel, applicationContext, repaintDelay));
    }

    @Deprecated(message="Removed API: use constructor with sizingPolicy parameter", replaceWith=@ReplaceWith(expression="PlotPanel(plotComponentProvider = plotComponentProvider, preferredSizeFromPlot = preferredSizeFromPlot, sizingPolicy = SizingPolicy.fitContainerSize(preserveAspectRatio), repaintDelay = repaintDelay, applicationContext = applicationContext)", imports={"org.jetbrains.letsPlot.core.util.sizing.SizingPolicy"}), level=DeprecationLevel.ERROR)
    public PlotPanel(@NotNull PlotComponentProvider plotComponentProvider, boolean preferredSizeFromPlot, int repaintDelay, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)plotComponentProvider, (String)"plotComponentProvider");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this(plotComponentProvider, preferredSizeFromPlot, SizingPolicy.Companion.fitContainerSize(false), repaintDelay, applicationContext);
    }

    @NotNull
    public final FigureModel getFigureModel() {
        return this.figureModel;
    }

    public void dispose() {
        this.removeAll();
    }

    private final void handleChildRemovedIntern(Component child) {
        this.handleChildRemoved(child);
        Component component = child;
        if (component instanceof Disposable) {
            ((Disposable)child).dispose();
        } else if (component instanceof JScrollPane) {
            Component component2 = ((JScrollPane)child).getViewport().getView();
            Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"getView(...)");
            this.handleChildRemovedIntern(component2);
        }
    }

    protected void handleChildRemoved(@NotNull Component child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
    }

    protected void plotComponentCreated(@NotNull JComponent plotComponent) {
        Intrinsics.checkNotNullParameter((Object)plotComponent, (String)"plotComponent");
    }

    private final JComponent rebuildProvidedComponent(Dimension containerSize, SizingPolicy sizingPolicy, List<? extends Map<String, ? extends Object>> specOverrideList) {
        this.removeAll();
        JComponent providedComponent = this.plotComponentProvider.createComponent(containerSize, sizingPolicy, specOverrideList);
        this.plotComponentCreated(Companion.actualPlotComponentFromProvidedComponent(providedComponent));
        this.add(providedComponent);
        return providedComponent;
    }

    static /* synthetic */ JComponent rebuildProvidedComponent$default(PlotPanel plotPanel2, Dimension dimension, SizingPolicy sizingPolicy, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: rebuildProvidedComponent");
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return plotPanel2.rebuildProvidedComponent(dimension, sizingPolicy, list);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/awt/plot/component/PlotPanel$Companion;", "", "()V", "actualPlotComponentFromProvidedComponent", "Ljavax/swing/JComponent;", "providedComponent", "platf-awt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JComponent actualPlotComponentFromProvidedComponent(@NotNull JComponent providedComponent) {
            JComponent jComponent;
            Intrinsics.checkNotNullParameter((Object)providedComponent, (String)"providedComponent");
            if (providedComponent instanceof JScrollPane) {
                Component component = ((JScrollPane)providedComponent).getViewport().getView();
                Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JComponent");
                jComponent = (JComponent)component;
            } else {
                jComponent = providedComponent;
            }
            return jComponent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

