/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.awt.canvas;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.awt.canvas.AwtAnimationTimerPeer;
import org.jetbrains.letsPlot.awt.canvas.AwtCanvas;
import org.jetbrains.letsPlot.awt.canvas.AwtMouseEventMapper;
import org.jetbrains.letsPlot.awt.canvas.CanvasComponent;
import org.jetbrains.letsPlot.awt.canvas.CanvasPane;
import org.jetbrains.letsPlot.commons.encoding.Png;
import org.jetbrains.letsPlot.commons.event.MouseEvent;
import org.jetbrains.letsPlot.commons.event.MouseEventSource;
import org.jetbrains.letsPlot.commons.event.MouseEventSpec;
import org.jetbrains.letsPlot.commons.geometry.Rectangle;
import org.jetbrains.letsPlot.commons.geometry.Vector;
import org.jetbrains.letsPlot.commons.intern.async.Async;
import org.jetbrains.letsPlot.commons.intern.async.Asyncs;
import org.jetbrains.letsPlot.commons.intern.observable.event.EventHandler;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.commons.values.Bitmap;
import org.jetbrains.letsPlot.core.canvas.AnimationProvider;
import org.jetbrains.letsPlot.core.canvas.Canvas;
import org.jetbrains.letsPlot.core.canvas.CanvasControl;
import org.jetbrains.letsPlot.core.canvasFigure.CanvasFigure;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u001b\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0015H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/CanvasPane;", "Ljavax/swing/JLayeredPane;", "figure", "Lorg/jetbrains/letsPlot/core/canvasFigure/CanvasFigure;", "pixelDensity", "", "(Lorg/jetbrains/letsPlot/core/canvasFigure/CanvasFigure;D)V", "canvasControl", "Lorg/jetbrains/letsPlot/core/canvas/CanvasControl;", "value", "getFigure", "()Lorg/jetbrains/letsPlot/core/canvasFigure/CanvasFigure;", "setFigure", "(Lorg/jetbrains/letsPlot/core/canvasFigure/CanvasFigure;)V", "figureRegistration", "Lorg/jetbrains/letsPlot/commons/registration/Registration;", "mouseEventSource", "Lorg/jetbrains/letsPlot/commons/event/MouseEventSource;", "getMouseEventSource", "()Lorg/jetbrains/letsPlot/commons/event/MouseEventSource;", "isPaintingOrigin", "", "AwtCanvasControl", "platf-awt"})
public final class CanvasPane
extends JLayeredPane {
    private final double pixelDensity;
    @NotNull
    private final CanvasControl canvasControl;
    @NotNull
    private Registration figureRegistration;
    @NotNull
    private final MouseEventSource mouseEventSource;
    @Nullable
    private CanvasFigure figure;

    public CanvasPane(@Nullable CanvasFigure figure, double pixelDensity) {
        this.pixelDensity = pixelDensity;
        this.canvasControl = new AwtCanvasControl();
        this.figureRegistration = Registration.Companion.getEMPTY();
        this.mouseEventSource = new AwtMouseEventMapper(this, null, 2, null);
        this.setFigure(figure);
    }

    public /* synthetic */ CanvasPane(CanvasFigure canvasFigure, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            canvasFigure = null;
        }
        if ((n & 2) != 0) {
            d = 1.0;
        }
        this(canvasFigure, d);
    }

    @NotNull
    public final MouseEventSource getMouseEventSource() {
        return this.mouseEventSource;
    }

    @Nullable
    public final CanvasFigure getFigure() {
        return this.figure;
    }

    public final void setFigure(@Nullable CanvasFigure value) {
        if (Intrinsics.areEqual((Object)this.figure, (Object)value)) {
            return;
        }
        this.figureRegistration.remove();
        if (value != null) {
            this.figureRegistration = value.mapToCanvas(this.canvasControl);
            this.setBounds(new java.awt.Rectangle(0, 0, ((Rectangle)value.bounds().get()).getDimension().getX(), ((Rectangle)value.bounds().get()).getDimension().getY()));
        }
        this.figure = value;
    }

    @Override
    protected boolean isPaintingOrigin() {
        return true;
    }

    public CanvasPane() {
        this(null, 0.0, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020#0'2\u0006\u0010(\u001a\u00020)H\u0016J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020#0'2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010(\u001a\u00020)H\u0002J\u001c\u0010/\u001a\u00020\u00182\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001301H\u0016J\u0010\u00102\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\u001c\u00103\u001a\u00020\u0013\"\u0004\b\u0000\u001042\f\u00105\u001a\b\u0012\u0004\u0012\u0002H406H\u0016J\b\u00107\u001a\u00020#H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00068"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/CanvasPane$AwtCanvasControl;", "Lorg/jetbrains/letsPlot/core/canvas/CanvasControl;", "(Lorg/jetbrains/letsPlot/awt/canvas/CanvasPane;)V", "animationTimerPeer", "Lorg/jetbrains/letsPlot/awt/canvas/AwtAnimationTimerPeer;", "myMappedCanvases", "Ljava/util/HashMap;", "Lorg/jetbrains/letsPlot/core/canvas/Canvas;", "Ljavax/swing/JComponent;", "Lkotlin/collections/HashMap;", "pixelDensity", "", "getPixelDensity", "()D", "size", "Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "getSize", "()Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "addChild", "", "index", "", "canvas", "addEventHandler", "Lorg/jetbrains/letsPlot/commons/registration/Registration;", "eventSpec", "Lorg/jetbrains/letsPlot/commons/event/MouseEventSpec;", "eventHandler", "Lorg/jetbrains/letsPlot/commons/intern/observable/event/EventHandler;", "Lorg/jetbrains/letsPlot/commons/event/MouseEvent;", "createAnimationTimer", "Lorg/jetbrains/letsPlot/core/canvas/AnimationProvider$AnimationTimer;", "Lorg/jetbrains/letsPlot/core/canvas/AnimationProvider$AnimationEventHandler;", "createCanvas", "createSnapshot", "Lorg/jetbrains/letsPlot/core/canvas/Canvas$Snapshot;", "bitmap", "Lorg/jetbrains/letsPlot/commons/values/Bitmap;", "decodeDataImageUrl", "Lorg/jetbrains/letsPlot/commons/intern/async/Async;", "dataUrl", "", "decodePng", "png", "", "imagePngBase64ToImage", "Ljava/awt/image/BufferedImage;", "onResize", "listener", "Lkotlin/Function1;", "removeChild", "schedule", "T", "f", "Lkotlin/Function0;", "snapshot", "platf-awt"})
    public final class AwtCanvasControl
    implements CanvasControl {
        @NotNull
        private final AwtAnimationTimerPeer animationTimerPeer = new AwtAnimationTimerPeer(null, 0, 3, null);
        @NotNull
        private final HashMap<Canvas, JComponent> myMappedCanvases = new HashMap();

        public double getPixelDensity() {
            return CanvasPane.this.pixelDensity;
        }

        @NotNull
        public Vector getSize() {
            return new Vector(CanvasPane.this.getWidth(), CanvasPane.this.getHeight());
        }

        public void addChild(@NotNull Canvas canvas) {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            this.addChild(CanvasPane.this.getComponentCount(), canvas);
        }

        public void addChild(int index, @NotNull Canvas canvas) {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            CanvasComponent canvasComponent = new CanvasComponent((AwtCanvas)canvas);
            CanvasPane.this.add((Component)canvasComponent, CanvasPane.this.getComponentCount() - index);
            CanvasPane.this.revalidate();
            ((Map)this.myMappedCanvases).put(canvas, canvasComponent);
        }

        public void removeChild(@NotNull Canvas canvas) {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            CanvasPane.this.remove(this.myMappedCanvases.get(canvas));
            CanvasPane.this.revalidate();
            this.myMappedCanvases.remove(canvas);
        }

        @NotNull
        public Registration onResize(@NotNull Function1<? super Vector, Unit> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            ComponentAdapter sizeListener2 = new ComponentAdapter(listener, this){
                final /* synthetic */ Function1<Vector, Unit> $listener;
                final /* synthetic */ AwtCanvasControl this$0;
                {
                    this.$listener = $listener;
                    this.this$0 = $receiver;
                }

                public void componentResized(@Nullable ComponentEvent e) {
                    this.$listener.invoke((Object)this.this$0.getSize());
                }
            };
            CanvasPane.this.addComponentListener(sizeListener2);
            return new Registration(CanvasPane.this, sizeListener2){
                final /* synthetic */ CanvasPane this$0;
                final /* synthetic */ onResize.sizeListener.1 $sizeListener;
                {
                    this.this$0 = $receiver;
                    this.$sizeListener = $sizeListener;
                }

                protected void doRemove() {
                    this.this$0.removeComponentListener(this.$sizeListener);
                }
            };
        }

        @NotNull
        public Canvas.Snapshot snapshot() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @NotNull
        public AnimationProvider.AnimationTimer createAnimationTimer(@NotNull AnimationProvider.AnimationEventHandler eventHandler) {
            Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
            return new AnimationProvider.AnimationTimer(this, eventHandler, CanvasPane.this){
                final /* synthetic */ AwtCanvasControl this$0;
                final /* synthetic */ AnimationProvider.AnimationEventHandler $eventHandler;
                final /* synthetic */ CanvasPane this$1;
                {
                    this.this$0 = $receiver;
                    this.$eventHandler = $eventHandler;
                    this.this$1 = $receiver2;
                }

                public void start() {
                    AwtCanvasControl.access$getAnimationTimerPeer$p(this.this$0).addHandler((Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>((Object)this){

                        public final void invoke(long p0) {
                            (this.receiver).handle(p0);
                        }
                    }));
                }

                public void stop() {
                    AwtCanvasControl.access$getAnimationTimerPeer$p(this.this$0).removeHandler((Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>((Object)this){

                        public final void invoke(long p0) {
                            (this.receiver).handle(p0);
                        }
                    }));
                }

                public final void handle(long millisTime) {
                    if (this.$eventHandler.onEvent(millisTime)) {
                        this.this$1.repaint();
                    }
                }
            };
        }

        @NotNull
        public Canvas createCanvas(@NotNull Vector size) {
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            return (Canvas)AwtCanvas.Companion.create(size, this.getPixelDensity());
        }

        @NotNull
        public Canvas.Snapshot createSnapshot(@NotNull Bitmap bitmap) {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            BufferedImage img = new BufferedImage(bitmap.getWidth(), bitmap.getHeight(), 2);
            img.setRGB(0, 0, bitmap.getWidth(), bitmap.getHeight(), bitmap.getArgbInts(), 0, bitmap.getWidth());
            return new AwtCanvas.AwtSnapshot(img);
        }

        private final BufferedImage imagePngBase64ToImage(String dataUrl) {
            Bitmap img = Png.INSTANCE.decodeDataImage(dataUrl);
            BufferedImage bufImg = new BufferedImage(img.getWidth(), img.getHeight(), 2);
            bufImg.setRGB(0, 0, img.getWidth(), img.getHeight(), img.getArgbInts(), 0, img.getWidth());
            return bufImg;
        }

        @NotNull
        public Async<Canvas.Snapshot> decodeDataImageUrl(@NotNull String dataUrl) {
            Intrinsics.checkNotNullParameter((Object)dataUrl, (String)"dataUrl");
            System.out.println((Object)("CanvasPane.CanvasControl.createSnapshot(dataUrl): dataUrl.size = " + dataUrl.length()));
            return Asyncs.INSTANCE.constant((Object)new AwtCanvas.AwtSnapshot(this.imagePngBase64ToImage(dataUrl)));
        }

        @NotNull
        public Async<Canvas.Snapshot> decodePng(@NotNull byte[] png, @NotNull Vector size) {
            Intrinsics.checkNotNullParameter((Object)png, (String)"png");
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            BufferedImage src = ImageIO.read(new ByteArrayInputStream(png));
            BufferedImage dst = new BufferedImage(size.getX(), size.getY(), 2);
            Graphics2D graphics2D = dst.createGraphics();
            Intrinsics.checkNotNull((Object)graphics2D, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D graphics2D2 = graphics2D;
            graphics2D2.drawImage(src, 0, 0, size.getX(), size.getY(), null);
            graphics2D2.dispose();
            AwtCanvas.AwtSnapshot snapshot = new AwtCanvas.AwtSnapshot(dst);
            return Asyncs.INSTANCE.constant((Object)snapshot);
        }

        @NotNull
        public Registration addEventHandler(@NotNull MouseEventSpec eventSpec, @NotNull EventHandler<? super MouseEvent> eventHandler) {
            Intrinsics.checkNotNullParameter((Object)eventSpec, (String)"eventSpec");
            Intrinsics.checkNotNullParameter(eventHandler, (String)"eventHandler");
            return CanvasPane.this.getMouseEventSource().addEventHandler(eventSpec, eventHandler);
        }

        public <T> void schedule(@NotNull Function0<? extends T> f) {
            Intrinsics.checkNotNullParameter(f, (String)"f");
            this.animationTimerPeer.getExecutor().invoke((Object)new Function0<Unit>(f){
                final /* synthetic */ Function0<T> $f;
                {
                    this.$f = $f;
                    super(0);
                }

                public final void invoke() {
                    this.$f.invoke();
                }
            });
        }

        @NotNull
        public Canvas createCanvas(@NotNull Number width, @NotNull Number height) {
            return CanvasControl.DefaultImpls.createCanvas((CanvasControl)this, (Number)width, (Number)height);
        }

        public static final /* synthetic */ AwtAnimationTimerPeer access$getAnimationTimerPeer$p(AwtCanvasControl $this) {
            return $this.animationTimerPeer;
        }
    }
}

