/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.awt.canvas;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.awt.canvas.AwtAnimationTimerPeer;
import org.jetbrains.letsPlot.awt.canvas.AwtCanvas;
import org.jetbrains.letsPlot.awt.canvas.CanvasComponent;
import org.jetbrains.letsPlot.awt.canvas.CanvasContainerPanel;
import org.jetbrains.letsPlot.commons.encoding.Png;
import org.jetbrains.letsPlot.commons.event.MouseEvent;
import org.jetbrains.letsPlot.commons.event.MouseEventSource;
import org.jetbrains.letsPlot.commons.event.MouseEventSpec;
import org.jetbrains.letsPlot.commons.geometry.Vector;
import org.jetbrains.letsPlot.commons.intern.async.Async;
import org.jetbrains.letsPlot.commons.intern.async.Asyncs;
import org.jetbrains.letsPlot.commons.intern.observable.event.EventHandler;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.commons.values.Bitmap;
import org.jetbrains.letsPlot.core.canvas.AnimationProvider;
import org.jetbrains.letsPlot.core.canvas.Canvas;
import org.jetbrains.letsPlot.core.canvas.CanvasControl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016J\u0006\u0010\"\u001a\u00020\u0010J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020(0,2\u0006\u0010-\u001a\u00020.H\u0016J\u001e\u0010/\u001a\b\u0012\u0004\u0012\u00020(0,2\u0006\u00100\u001a\u0002012\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u00102\u001a\u0002032\u0006\u0010-\u001a\u00020.H\u0002J\u001c\u00104\u001a\u00020\u001c2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001706H\u0016J\u0010\u00107\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J\u001c\u00108\u001a\u00020\u0017\"\u0004\b\u0000\u001092\f\u0010:\u001a\b\u0012\u0004\u0012\u0002H90;H\u0016J\b\u0010<\u001a\u00020(H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006="}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtCanvasControl;", "Lorg/jetbrains/letsPlot/core/canvas/CanvasControl;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "animationTimerPeer", "Lorg/jetbrains/letsPlot/awt/canvas/AwtAnimationTimerPeer;", "mouseEventSource", "Lorg/jetbrains/letsPlot/commons/event/MouseEventSource;", "pixelDensity", "", "(Lorg/jetbrains/letsPlot/commons/geometry/Vector;Lorg/jetbrains/letsPlot/awt/canvas/AwtAnimationTimerPeer;Lorg/jetbrains/letsPlot/commons/event/MouseEventSource;D)V", "myComponent", "Lorg/jetbrains/letsPlot/awt/canvas/CanvasContainerPanel;", "myMappedCanvases", "Ljava/util/HashMap;", "Lorg/jetbrains/letsPlot/core/canvas/Canvas;", "Ljavax/swing/JComponent;", "Lkotlin/collections/HashMap;", "getPixelDensity", "()D", "getSize", "()Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "addChild", "", "index", "", "canvas", "addEventHandler", "Lorg/jetbrains/letsPlot/commons/registration/Registration;", "eventSpec", "Lorg/jetbrains/letsPlot/commons/event/MouseEventSpec;", "eventHandler", "Lorg/jetbrains/letsPlot/commons/intern/observable/event/EventHandler;", "Lorg/jetbrains/letsPlot/commons/event/MouseEvent;", "component", "createAnimationTimer", "Lorg/jetbrains/letsPlot/core/canvas/AnimationProvider$AnimationTimer;", "Lorg/jetbrains/letsPlot/core/canvas/AnimationProvider$AnimationEventHandler;", "createCanvas", "createSnapshot", "Lorg/jetbrains/letsPlot/core/canvas/Canvas$Snapshot;", "bitmap", "Lorg/jetbrains/letsPlot/commons/values/Bitmap;", "decodeDataImageUrl", "Lorg/jetbrains/letsPlot/commons/intern/async/Async;", "dataUrl", "", "decodePng", "png", "", "imagePngBase64ToImage", "Ljava/awt/image/BufferedImage;", "onResize", "listener", "Lkotlin/Function1;", "removeChild", "schedule", "T", "f", "Lkotlin/Function0;", "snapshot", "platf-awt"})
public final class AwtCanvasControl
implements CanvasControl {
    @NotNull
    private final Vector size;
    @NotNull
    private final AwtAnimationTimerPeer animationTimerPeer;
    @NotNull
    private final MouseEventSource mouseEventSource;
    private final double pixelDensity;
    @NotNull
    private final CanvasContainerPanel myComponent;
    @NotNull
    private final HashMap<Canvas, JComponent> myMappedCanvases;

    public AwtCanvasControl(@NotNull Vector size, @NotNull AwtAnimationTimerPeer animationTimerPeer, @NotNull MouseEventSource mouseEventSource, double pixelDensity) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)animationTimerPeer, (String)"animationTimerPeer");
        Intrinsics.checkNotNullParameter((Object)mouseEventSource, (String)"mouseEventSource");
        this.size = size;
        this.animationTimerPeer = animationTimerPeer;
        this.mouseEventSource = mouseEventSource;
        this.pixelDensity = pixelDensity;
        this.myComponent = new CanvasContainerPanel(this.getSize());
        this.myMappedCanvases = new HashMap();
    }

    public /* synthetic */ AwtCanvasControl(Vector vector, AwtAnimationTimerPeer awtAnimationTimerPeer, MouseEventSource mouseEventSource, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d = 1.0;
        }
        this(vector, awtAnimationTimerPeer, mouseEventSource, d);
    }

    @NotNull
    public Vector getSize() {
        return this.size;
    }

    public double getPixelDensity() {
        return this.pixelDensity;
    }

    @NotNull
    public final JComponent component() {
        return this.myComponent;
    }

    public void addChild(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.addChild(this.myComponent.getComponentCount(), canvas);
    }

    public void addChild(int index, @NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        CanvasComponent canvasComponent = new CanvasComponent((AwtCanvas)canvas);
        this.myComponent.add((Component)canvasComponent, this.myComponent.getComponentCount() - index);
        this.myComponent.revalidate();
        ((Map)this.myMappedCanvases).put(canvas, canvasComponent);
    }

    public void removeChild(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.myComponent.remove(this.myMappedCanvases.get(canvas));
        this.myComponent.revalidate();
        this.myMappedCanvases.remove(canvas);
    }

    @NotNull
    public Registration onResize(@NotNull Function1<? super Vector, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public Canvas.Snapshot snapshot() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public AnimationProvider.AnimationTimer createAnimationTimer(@NotNull AnimationProvider.AnimationEventHandler eventHandler) {
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        return new AnimationProvider.AnimationTimer(this, eventHandler){
            final /* synthetic */ AwtCanvasControl this$0;
            final /* synthetic */ AnimationProvider.AnimationEventHandler $eventHandler;
            {
                this.this$0 = $receiver;
                this.$eventHandler = $eventHandler;
            }

            public void start() {
                AwtCanvasControl.access$getAnimationTimerPeer$p(this.this$0).addHandler((Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>((Object)this){

                    public final void invoke(long p0) {
                        (this.receiver).handle(p0);
                    }
                }));
            }

            public void stop() {
                AwtCanvasControl.access$getAnimationTimerPeer$p(this.this$0).removeHandler((Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>((Object)this){

                    public final void invoke(long p0) {
                        (this.receiver).handle(p0);
                    }
                }));
            }

            public final void handle(long millisTime) {
                if (this.$eventHandler.onEvent(millisTime)) {
                    AwtCanvasControl.access$getMyComponent$p(this.this$0).repaint();
                }
            }
        };
    }

    @NotNull
    public Canvas createCanvas(@NotNull Vector size) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        return (Canvas)AwtCanvas.Companion.create(size, this.getPixelDensity());
    }

    @NotNull
    public Canvas.Snapshot createSnapshot(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        BufferedImage bufferedImage = new BufferedImage(bitmap.getWidth(), bitmap.getHeight(), 2);
        bufferedImage.setRGB(0, 0, bitmap.getWidth(), bitmap.getHeight(), bitmap.getArgbInts(), 0, bitmap.getWidth());
        return new AwtCanvas.AwtSnapshot(bufferedImage);
    }

    private final BufferedImage imagePngBase64ToImage(String dataUrl) {
        Bitmap img = Png.INSTANCE.decodeDataImage(dataUrl);
        BufferedImage bufImg = new BufferedImage(img.getWidth(), img.getHeight(), 2);
        bufImg.setRGB(0, 0, img.getWidth(), img.getHeight(), img.getArgbInts(), 0, img.getWidth());
        return bufImg;
    }

    @NotNull
    public Async<Canvas.Snapshot> decodeDataImageUrl(@NotNull String dataUrl) {
        Intrinsics.checkNotNullParameter((Object)dataUrl, (String)"dataUrl");
        return Asyncs.INSTANCE.constant((Object)new AwtCanvas.AwtSnapshot(this.imagePngBase64ToImage(dataUrl)));
    }

    @NotNull
    public Async<Canvas.Snapshot> decodePng(@NotNull byte[] png, @NotNull Vector size) {
        Intrinsics.checkNotNullParameter((Object)png, (String)"png");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        BufferedImage src = ImageIO.read(new ByteArrayInputStream(png));
        BufferedImage dst = new BufferedImage(size.getX(), size.getY(), 2);
        Graphics2D graphics2D = dst.createGraphics();
        Intrinsics.checkNotNull((Object)graphics2D, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D graphics2D2 = graphics2D;
        graphics2D2.drawImage(src, 0, 0, size.getX(), size.getY(), null);
        graphics2D2.dispose();
        AwtCanvas.AwtSnapshot snapshot = new AwtCanvas.AwtSnapshot(dst);
        return Asyncs.INSTANCE.constant((Object)snapshot);
    }

    @NotNull
    public Registration addEventHandler(@NotNull MouseEventSpec eventSpec, @NotNull EventHandler<? super MouseEvent> eventHandler) {
        Intrinsics.checkNotNullParameter((Object)eventSpec, (String)"eventSpec");
        Intrinsics.checkNotNullParameter(eventHandler, (String)"eventHandler");
        return this.mouseEventSource.addEventHandler(eventSpec, eventHandler);
    }

    public <T> void schedule(@NotNull Function0<? extends T> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        this.animationTimerPeer.getExecutor().invoke((Object)new Function0<Unit>(f){
            final /* synthetic */ Function0<T> $f;
            {
                this.$f = $f;
                super(0);
            }

            public final void invoke() {
                this.$f.invoke();
            }
        });
    }

    @NotNull
    public Canvas createCanvas(@NotNull Number width, @NotNull Number height) {
        return CanvasControl.DefaultImpls.createCanvas((CanvasControl)this, (Number)width, (Number)height);
    }

    public static final /* synthetic */ AwtAnimationTimerPeer access$getAnimationTimerPeer$p(AwtCanvasControl $this) {
        return $this.animationTimerPeer;
    }

    public static final /* synthetic */ CanvasContainerPanel access$getMyComponent$p(AwtCanvasControl $this) {
        return $this.myComponent;
    }
}

