/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.awt.canvas;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.awt.canvas.AwtContext2d;
import org.jetbrains.letsPlot.commons.geometry.Vector;
import org.jetbrains.letsPlot.commons.values.Bitmap;
import org.jetbrains.letsPlot.core.canvas.Canvas;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.core.canvas.ScaledCanvas;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0002\r\u000eB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtCanvas;", "Lorg/jetbrains/letsPlot/core/canvas/ScaledCanvas;", "image", "Ljava/awt/image/BufferedImage;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "pixelDensity", "", "(Ljava/awt/image/BufferedImage;Lorg/jetbrains/letsPlot/commons/geometry/Vector;D)V", "getImage", "()Ljava/awt/image/BufferedImage;", "takeSnapshot", "Lorg/jetbrains/letsPlot/core/canvas/Canvas$Snapshot;", "AwtSnapshot", "Companion", "platf-awt"})
public final class AwtCanvas
extends ScaledCanvas {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedImage image;

    private AwtCanvas(BufferedImage image, Vector size, double pixelDensity) {
        Graphics2D graphics2D = image.createGraphics();
        Intrinsics.checkNotNull((Object)graphics2D, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        super((Context2d)new AwtContext2d(graphics2D), size, pixelDensity);
        this.image = image;
    }

    @NotNull
    public final BufferedImage getImage() {
        return this.image;
    }

    @NotNull
    public Canvas.Snapshot takeSnapshot() {
        return new AwtSnapshot(this.image);
    }

    public /* synthetic */ AwtCanvas(BufferedImage image, Vector size, double pixelDensity, DefaultConstructorMarker $constructor_marker) {
        this(image, size, pixelDensity);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\b\u0010\u0010\u001a\u00020\u0000H\u0016J\u0013\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtCanvas$AwtSnapshot;", "Lorg/jetbrains/letsPlot/core/canvas/Canvas$Snapshot;", "image", "Ljava/awt/image/BufferedImage;", "(Ljava/awt/image/BufferedImage;)V", "bitmap", "Lorg/jetbrains/letsPlot/commons/values/Bitmap;", "getBitmap", "()Lorg/jetbrains/letsPlot/commons/values/Bitmap;", "getImage", "()Ljava/awt/image/BufferedImage;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "getSize", "()Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "platf-awt"})
    public static final class AwtSnapshot
    implements Canvas.Snapshot {
        @NotNull
        private final BufferedImage image;
        @NotNull
        private final Vector size;

        public AwtSnapshot(@NotNull BufferedImage image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            this.image = image;
            this.size = new Vector(this.image.getWidth(), this.image.getHeight());
        }

        @NotNull
        public final BufferedImage getImage() {
            return this.image;
        }

        @NotNull
        public Vector getSize() {
            return this.size;
        }

        @NotNull
        public Bitmap getBitmap() {
            int[] argbArray = new int[this.image.getWidth() * this.image.getHeight()];
            this.image.getRGB(0, 0, this.image.getWidth(), this.image.getHeight(), argbArray, 0, this.image.getWidth());
            return new Bitmap(this.image.getWidth(), this.image.getHeight(), argbArray);
        }

        @NotNull
        public AwtSnapshot copy() {
            BufferedImage b = new BufferedImage(this.image.getWidth(), this.image.getHeight(), this.image.getType());
            Graphics2D graphics2D = b.createGraphics();
            Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"createGraphics(...)");
            Graphics2D g = graphics2D;
            g.drawImage((Image)this.image, 0, 0, null);
            g.dispose();
            return new AwtSnapshot(b);
        }

        @NotNull
        public final BufferedImage component1() {
            return this.image;
        }

        @NotNull
        public final AwtSnapshot copy(@NotNull BufferedImage image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            return new AwtSnapshot(image);
        }

        public static /* synthetic */ AwtSnapshot copy$default(AwtSnapshot awtSnapshot, BufferedImage bufferedImage, int n, Object object) {
            if ((n & 1) != 0) {
                bufferedImage = awtSnapshot.image;
            }
            return awtSnapshot.copy(bufferedImage);
        }

        @NotNull
        public String toString() {
            return "AwtSnapshot(image=" + this.image + ')';
        }

        public int hashCode() {
            return this.image.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AwtSnapshot)) {
                return false;
            }
            AwtSnapshot awtSnapshot = (AwtSnapshot)other;
            return Intrinsics.areEqual((Object)this.image, (Object)awtSnapshot.image);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtCanvas$Companion;", "", "()V", "create", "Lorg/jetbrains/letsPlot/awt/canvas/AwtCanvas;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "pixelDensity", "", "platf-awt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AwtCanvas create(@NotNull Vector size, double pixelDensity) {
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            Vector s = Intrinsics.areEqual((Object)size, (Object)Vector.Companion.getZERO()) ? new Vector(1, 1) : size;
            return new AwtCanvas(new BufferedImage(s.getX(), s.getY(), 6), s, pixelDensity, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

