/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.awt.canvas;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.awt.canvas.AwtAnimationTimerPeer;
import org.jetbrains.letsPlot.awt.canvas.AwtCanvas;
import org.jetbrains.letsPlot.awt.canvas.CanvasComponent;
import org.jetbrains.letsPlot.awt.canvas.CanvasContainerPanel;
import org.jetbrains.letsPlot.commons.event.MouseEvent;
import org.jetbrains.letsPlot.commons.event.MouseEventSource;
import org.jetbrains.letsPlot.commons.event.MouseEventSpec;
import org.jetbrains.letsPlot.commons.geometry.Vector;
import org.jetbrains.letsPlot.commons.intern.async.Async;
import org.jetbrains.letsPlot.commons.intern.async.Asyncs;
import org.jetbrains.letsPlot.commons.intern.observable.event.EventHandler;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.core.canvas.AnimationProvider;
import org.jetbrains.letsPlot.core.canvas.Canvas;
import org.jetbrains.letsPlot.core.canvas.CanvasControl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J\u0006\u0010\u001f\u001a\u00020\u0010J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010-\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J\u001c\u0010.\u001a\u00020\u0014\"\u0004\b\u0000\u0010/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H/01H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00062"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtCanvasControl;", "Lorg/jetbrains/letsPlot/core/canvas/CanvasControl;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "animationTimerPeer", "Lorg/jetbrains/letsPlot/awt/canvas/AwtAnimationTimerPeer;", "mouseEventSource", "Lorg/jetbrains/letsPlot/commons/event/MouseEventSource;", "myPixelRatio", "", "(Lorg/jetbrains/letsPlot/commons/geometry/Vector;Lorg/jetbrains/letsPlot/awt/canvas/AwtAnimationTimerPeer;Lorg/jetbrains/letsPlot/commons/event/MouseEventSource;D)V", "myComponent", "Lorg/jetbrains/letsPlot/awt/canvas/CanvasContainerPanel;", "myMappedCanvases", "Ljava/util/HashMap;", "Lorg/jetbrains/letsPlot/core/canvas/Canvas;", "Ljavax/swing/JComponent;", "getSize", "()Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "addChild", "", "index", "", "canvas", "addEventHandler", "Lorg/jetbrains/letsPlot/commons/registration/Registration;", "eventSpec", "Lorg/jetbrains/letsPlot/commons/event/MouseEventSpec;", "eventHandler", "Lorg/jetbrains/letsPlot/commons/intern/observable/event/EventHandler;", "Lorg/jetbrains/letsPlot/commons/event/MouseEvent;", "component", "createAnimationTimer", "Lorg/jetbrains/letsPlot/core/canvas/AnimationProvider$AnimationTimer;", "Lorg/jetbrains/letsPlot/core/canvas/AnimationProvider$AnimationEventHandler;", "createCanvas", "createSnapshot", "Lorg/jetbrains/letsPlot/commons/intern/async/Async;", "Lorg/jetbrains/letsPlot/core/canvas/Canvas$Snapshot;", "bytes", "", "dataUrl", "", "imagePngBase64ToImage", "Ljava/awt/image/BufferedImage;", "removeChild", "schedule", "T", "f", "Lkotlin/Function0;", "platf-awt"})
@SourceDebugExtension(value={"SMAP\nAwtCanvasControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwtCanvasControl.kt\norg/jetbrains/letsPlot/awt/canvas/AwtCanvasControl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1#2:122\n*E\n"})
public final class AwtCanvasControl
implements CanvasControl {
    @NotNull
    private final Vector size;
    @NotNull
    private final AwtAnimationTimerPeer animationTimerPeer;
    @NotNull
    private final MouseEventSource mouseEventSource;
    private final double myPixelRatio;
    @NotNull
    private final CanvasContainerPanel myComponent;
    @NotNull
    private final HashMap<Canvas, JComponent> myMappedCanvases;

    public AwtCanvasControl(@NotNull Vector size, @NotNull AwtAnimationTimerPeer animationTimerPeer, @NotNull MouseEventSource mouseEventSource, double myPixelRatio) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)animationTimerPeer, (String)"animationTimerPeer");
        Intrinsics.checkNotNullParameter((Object)mouseEventSource, (String)"mouseEventSource");
        this.size = size;
        this.animationTimerPeer = animationTimerPeer;
        this.mouseEventSource = mouseEventSource;
        this.myPixelRatio = myPixelRatio;
        this.myComponent = new CanvasContainerPanel(this.getSize());
        this.myMappedCanvases = new HashMap();
    }

    public /* synthetic */ AwtCanvasControl(Vector vector, AwtAnimationTimerPeer awtAnimationTimerPeer, MouseEventSource mouseEventSource, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d = 1.0;
        }
        this(vector, awtAnimationTimerPeer, mouseEventSource, d);
    }

    @NotNull
    public Vector getSize() {
        return this.size;
    }

    @NotNull
    public final JComponent component() {
        return this.myComponent;
    }

    public void addChild(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.addChild(this.myComponent.getComponentCount(), canvas);
    }

    public void addChild(int index, @NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        CanvasComponent canvasComponent = new CanvasComponent((AwtCanvas)canvas);
        this.myComponent.add((Component)canvasComponent, this.myComponent.getComponentCount() - index);
        this.myComponent.revalidate();
        ((Map)this.myMappedCanvases).put(canvas, canvasComponent);
    }

    public void removeChild(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.myComponent.remove(this.myMappedCanvases.get(canvas));
        this.myComponent.revalidate();
        this.myMappedCanvases.remove(canvas);
    }

    @NotNull
    public AnimationProvider.AnimationTimer createAnimationTimer(@NotNull AnimationProvider.AnimationEventHandler eventHandler) {
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        return new AnimationProvider.AnimationTimer(this, eventHandler){
            final /* synthetic */ AwtCanvasControl this$0;
            final /* synthetic */ AnimationProvider.AnimationEventHandler $eventHandler;
            {
                this.this$0 = $receiver;
                this.$eventHandler = $eventHandler;
            }

            public void start() {
                AwtCanvasControl.access$getAnimationTimerPeer$p(this.this$0).addHandler((Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>((Object)this){

                    public final void invoke(long p0) {
                        (this.receiver).handle(p0);
                    }
                }));
            }

            public void stop() {
                AwtCanvasControl.access$getAnimationTimerPeer$p(this.this$0).removeHandler((Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>((Object)this){

                    public final void invoke(long p0) {
                        (this.receiver).handle(p0);
                    }
                }));
            }

            public final void handle(long millisTime) {
                if (this.$eventHandler.onEvent(millisTime)) {
                    AwtCanvasControl.access$getMyComponent$p(this.this$0).repaint();
                }
            }
        };
    }

    @NotNull
    public Canvas createCanvas(@NotNull Vector size) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        return AwtCanvas.Companion.create(size, this.myPixelRatio);
    }

    private final BufferedImage imagePngBase64ToImage(String dataUrl) {
        String imageString;
        String mediaType = "data:image/png;base64,";
        String string = imageString = StringsKt.replace$default((String)dataUrl, (String)mediaType, (String)"", (boolean)false, (int)4, null);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        try {
            InputStream p0 = Base64.getDecoder().wrap(byteArrayInputStream);
            boolean bl = false;
            BufferedImage bufferedImage = ImageIO.read(p0);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"let(...)");
            return bufferedImage;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @NotNull
    public Async<Canvas.Snapshot> createSnapshot(@NotNull String dataUrl) {
        Intrinsics.checkNotNullParameter((Object)dataUrl, (String)"dataUrl");
        return Asyncs.INSTANCE.constant((Object)new AwtCanvas.AwtSnapshot(this.imagePngBase64ToImage(dataUrl)));
    }

    @NotNull
    public Async<Canvas.Snapshot> createSnapshot(@NotNull byte[] bytes, @NotNull Vector size) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        BufferedImage src = ImageIO.read(new ByteArrayInputStream(bytes));
        BufferedImage dst = new BufferedImage(size.getX(), size.getY(), 2);
        Graphics2D graphics2D = dst.createGraphics();
        Intrinsics.checkNotNull((Object)graphics2D, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D graphics2D2 = graphics2D;
        graphics2D2.drawImage(src, 0, 0, size.getX(), size.getY(), null);
        graphics2D2.dispose();
        return Asyncs.INSTANCE.constant((Object)new AwtCanvas.AwtSnapshot(dst));
    }

    @NotNull
    public Registration addEventHandler(@NotNull MouseEventSpec eventSpec, @NotNull EventHandler<? super MouseEvent> eventHandler) {
        Intrinsics.checkNotNullParameter((Object)eventSpec, (String)"eventSpec");
        Intrinsics.checkNotNullParameter(eventHandler, (String)"eventHandler");
        return this.mouseEventSource.addEventHandler(eventSpec, eventHandler);
    }

    public <T> void schedule(@NotNull Function0<? extends T> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        this.animationTimerPeer.getExecutor().invoke((Object)new Function0<Unit>(f){
            final /* synthetic */ Function0<T> $f;
            {
                this.$f = $f;
                super(0);
            }

            public final void invoke() {
                this.$f.invoke();
            }
        });
    }

    @NotNull
    public Registration on(@NotNull MouseEventSpec eventSpec, @NotNull Function1<? super MouseEvent, Unit> eventHandler) {
        return CanvasControl.DefaultImpls.on((CanvasControl)this, (MouseEventSpec)eventSpec, eventHandler);
    }

    public static final /* synthetic */ AwtAnimationTimerPeer access$getAnimationTimerPeer$p(AwtCanvasControl $this) {
        return $this.animationTimerPeer;
    }

    public static final /* synthetic */ CanvasContainerPanel access$getMyComponent$p(AwtCanvasControl $this) {
        return $this.myComponent;
    }
}

