/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.letsPlot.spatial;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import jetbrains.letsPlot.intern.ToSpecConvertersKt;
import jetbrains.letsPlot.spatial.GeometryFormat;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 %2\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00030\u0001:\u0001%B3\b\u0002\u0012\u001a\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00030\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0002H\u0096\u0001J\u0019\u0010 \u001a\u00020\u001e2\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003H\u0096\u0001J\u001b\u0010\"\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u00032\u0006\u0010\u001f\u001a\u00020\u0002H\u0096\u0003J\t\u0010#\u001a\u00020\u001eH\u0096\u0001J\b\u0010$\u001a\u00020\u0002H\u0016R,\u0010\n\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00030\f0\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\"\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R \u0010\u0019\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00030\u001aX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006&"}, d2={"Ljetbrains/letsPlot/spatial/SpatialDataset;", "", "", "", "", "map", "geometryKey", "geometryFormat", "Ljetbrains/letsPlot/spatial/GeometryFormat;", "(Ljava/util/Map;Ljava/lang/String;Ljetbrains/letsPlot/spatial/GeometryFormat;)V", "entries", "", "", "getEntries", "()Ljava/util/Set;", "getGeometryFormat", "()Ljetbrains/letsPlot/spatial/GeometryFormat;", "getGeometryKey", "()Ljava/lang/String;", "keys", "getKeys", "size", "", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "containsKey", "", "key", "containsValue", "value", "get", "isEmpty", "toString", "Companion", "plot-api"})
public final class SpatialDataset
implements Map<String, List<? extends Object>>,
KMappedMarker {
    private final Map<String, List<Object>> map;
    @NotNull
    private final String geometryKey;
    @NotNull
    private final GeometryFormat geometryFormat;
    private static final List<String> GEO_COL_NAMES;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String toString() {
        return "SpatialDataset(" + (Object)((Object)this.geometryFormat) + ", key='" + this.geometryKey + "', map=" + this.map + ')';
    }

    @NotNull
    public final String getGeometryKey() {
        return this.geometryKey;
    }

    @NotNull
    public final GeometryFormat getGeometryFormat() {
        return this.geometryFormat;
    }

    private SpatialDataset(Map<String, ? extends List<? extends Object>> map2, String geometryKey, GeometryFormat geometryFormat) {
        this.map = map2;
        this.geometryKey = geometryKey;
        this.geometryFormat = geometryFormat;
    }

    static {
        Companion = new Companion(null);
        GEO_COL_NAMES = CollectionsKt.listOf((Object[])new String[]{"geometry", "shape", "coord", "coordinates"});
    }

    @NotNull
    public Set<Map.Entry<String, List<Object>>> getEntries() {
        return this.map.entrySet();
    }

    @NotNull
    public Set<String> getKeys() {
        return this.map.keySet();
    }

    public int getSize() {
        return this.map.size();
    }

    @NotNull
    public Collection<List<Object>> getValues() {
        return this.map.values();
    }

    public boolean containsKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.map.containsKey(key);
    }

    public boolean containsValue(@NotNull List<? extends Object> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.map.containsValue(value);
    }

    @Nullable
    public List<Object> get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public /* synthetic */ SpatialDataset(Map map2, String geometryKey, GeometryFormat geometryFormat, DefaultConstructorMarker $constructor_marker) {
        this(map2, geometryKey, geometryFormat);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public List<Object> compute(String string, BiFunction<? super String, ? super List<? extends Object>, ? extends List<? extends Object>> biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public List<Object> computeIfAbsent(String string, Function<? super String, ? extends List<? extends Object>> function) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public List<Object> computeIfPresent(String string, BiFunction<? super String, ? super List<? extends Object>, ? extends List<? extends Object>> biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public List<Object> merge(String string, List<? extends Object> list, BiFunction<? super List<? extends Object>, ? super List<? extends Object>, ? extends List<? extends Object>> biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public List<Object> put(String string, List<? extends Object> list) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<? extends Object>> map2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public List<Object> putIfAbsent(String string, List<? extends Object> list) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public List<Object> remove(Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object object, Object object2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean replace(String string, List<? extends Object> list, List<? extends Object> list2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public List<Object> replace(String string, List<? extends Object> list) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super List<? extends Object>, ? extends List<? extends Object>> biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object compute(Object object, BiFunction biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object computeIfAbsent(Object object, Function function) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object computeIfPresent(Object object, BiFunction biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object merge(Object object, Object object2, BiFunction biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object put(Object object, Object object2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object putIfAbsent(Object object, Object object2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ boolean replace(Object object, Object object2, Object object3) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object replace(Object object, Object object2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0002J2\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0010\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J(\u0010\u0011\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J(\u0010\u0012\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/letsPlot/spatial/SpatialDataset$Companion;", "", "()V", "GEO_COL_NAMES", "", "", "chooseGeometryColName", "usedNames", "", "create", "Ljetbrains/letsPlot/spatial/SpatialDataset;", "data", "", "geometry", "geometryFormat", "Ljetbrains/letsPlot/spatial/GeometryFormat;", "withGEOJSON", "withWKB", "withWKT", "plot-api"})
    public static final class Companion {
        @NotNull
        public final SpatialDataset withGEOJSON(@NotNull Map<String, ? extends Object> data, @NotNull List<String> geometry) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            Intrinsics.checkNotNullParameter(geometry, (String)"geometry");
            return this.create(data, geometry, GeometryFormat.GEOJSON);
        }

        @NotNull
        public final SpatialDataset withWKT(@NotNull Map<String, ? extends Object> data, @NotNull List<String> geometry) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            Intrinsics.checkNotNullParameter(geometry, (String)"geometry");
            return this.create(data, geometry, GeometryFormat.WKT);
        }

        @NotNull
        public final SpatialDataset withWKB(@NotNull Map<String, ? extends Object> data, @NotNull List<String> geometry) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            Intrinsics.checkNotNullParameter(geometry, (String)"geometry");
            return this.create(data, geometry, GeometryFormat.WKB);
        }

        private final SpatialDataset create(Map<String, ? extends Object> data, List<String> geometry, GeometryFormat geometryFormat) {
            Map<String, List<Object>> data2 = ToSpecConvertersKt.asPlotData(data);
            Iterable $this$forEach$iv = data2.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                boolean bl2 = ((List)it.getValue()).size() == geometry.size();
                boolean bl3 = false;
                boolean bl4 = false;
                if (bl2) continue;
                boolean bl5 = false;
                String string = "The size of data series '" + (String)it.getKey() + "' (" + ((List)it.getValue()).size() + ") must be equal to the size geometry collection: " + geometry.size() + '.';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            String geometryKey = this.chooseGeometryColName(data2.keySet());
            Map map2 = MapsKt.plus(data2, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)geometryKey, geometry)));
            return new SpatialDataset(map2, geometryKey, geometryFormat, null);
        }

        /*
         * WARNING - void declaration
         */
        private final String chooseGeometryColName(Set<String> usedNames) {
            int i = 0;
            while (true) {
                Iterator iterator;
                block4: {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = GEO_COL_NAMES;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        void var14_18 = i == 0 ? it : (String)it + '_' + i;
                        collection.add(var14_18);
                    }
                    Iterable iterable2 = (List)destination$iv$iv;
                    boolean bl = false;
                    iterable = iterable2;
                    boolean bl2 = false;
                    for (Iterator iterator2 : iterable) {
                        String it = (String)((Object)iterator2);
                        boolean bl3 = false;
                        if (!(!usedNames.contains(it))) continue;
                        iterator = iterator2;
                        break block4;
                    }
                    iterator = null;
                }
                String name = (String)((Object)iterator);
                if (name != null) {
                    return name;
                }
                int n = i;
                i = n + 1;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

