/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.letsPlot.intern;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.values.Color;
import jetbrains.letsPlot.intern.SeriesStandardizing;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001J\u0014\u0010\u0006\u001a\u00020\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002J\u0018\u0010\t\u001a\u0006\u0012\u0002\b\u00030\b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002J\u0018\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u001e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0001J\u000e\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u00a8\u0006\u0010"}, d2={"Ljetbrains/letsPlot/intern/SeriesStandardizing;", "", "()V", "isListy", "", "rawValue", "needToStandardizeValues", "series", "", "standardizeIterable", "standardizeList", "", "toList", "key", "", "toListOrPass", "plot-api"})
public final class SeriesStandardizing {
    @NotNull
    public static final SeriesStandardizing INSTANCE;

    public final boolean isListy(@Nullable Object rawValue) {
        Object object = rawValue;
        return object instanceof List ? true : (object instanceof Iterable ? true : (object instanceof Sequence ? true : (object instanceof Object[] ? true : (object instanceof byte[] ? true : (object instanceof short[] ? true : (object instanceof int[] ? true : (object instanceof long[] ? true : (object instanceof float[] ? true : (object instanceof double[] ? true : (object instanceof char[] ? true : object instanceof Pair))))))))));
    }

    @NotNull
    public final List<Object> toList(@NotNull String key, @NotNull Object rawValue) {
        List<?> list;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        Object object = rawValue;
        if (object instanceof List) {
            list = this.standardizeList((List)rawValue);
        } else if (object instanceof Iterable) {
            list = CollectionsKt.toList(this.standardizeIterable((Iterable)rawValue));
        } else if (object instanceof Sequence) {
            list = CollectionsKt.toList(this.standardizeIterable(SequencesKt.asIterable((Sequence)((Sequence)rawValue))));
        } else if (object instanceof Object[]) {
            list = this.standardizeList(ArraysKt.asList((Object[])((Object[])rawValue)));
        } else if (object instanceof byte[]) {
            list = this.standardizeList(ArraysKt.asList((byte[])((byte[])rawValue)));
        } else if (object instanceof short[]) {
            list = this.standardizeList(ArraysKt.asList((short[])((short[])rawValue)));
        } else if (object instanceof int[]) {
            list = this.standardizeList(ArraysKt.asList((int[])((int[])rawValue)));
        } else if (object instanceof long[]) {
            list = this.standardizeList(ArraysKt.asList((long[])((long[])rawValue)));
        } else if (object instanceof float[]) {
            list = this.standardizeList(ArraysKt.asList((float[])((float[])rawValue)));
        } else if (object instanceof double[]) {
            list = this.standardizeList(ArraysKt.asList((double[])((double[])rawValue)));
        } else if (object instanceof char[]) {
            list = this.standardizeList(ArraysKt.asList((char[])((char[])rawValue)));
        } else if (object instanceof Pair) {
            list = this.standardizeList(TuplesKt.toList((Pair)((Pair)rawValue)));
        } else {
            throw (Throwable)new IllegalArgumentException("Can't transform data[\"" + key + "\"] of type " + Reflection.getOrCreateKotlinClass(rawValue.getClass()).getQualifiedName() + " to a list");
        }
        return list;
    }

    @NotNull
    public final Object toListOrPass(@NotNull Object rawValue) {
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        if (this.isListy(rawValue)) {
            return this.toList("<key not provided>", rawValue);
        }
        return rawValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean needToStandardizeValues(Iterable<?> series) {
        boolean bl;
        Iterable<?> $this$any$iv = series;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator<?> iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            Object it = element$iv = iterator.next();
            boolean bl2 = false;
            if (it != null) {
                if (!(it instanceof String)) {
                    if (!(it instanceof Double)) return true;
                }
                if (it instanceof Double) {
                    double d = ((Number)it).doubleValue();
                    boolean bl3 = false;
                    double d2 = d;
                    boolean bl4 = false;
                    if (Double.isInfinite(d2)) return true;
                    d2 = d;
                    bl4 = false;
                    if (Double.isNaN(d2)) return true;
                    boolean bl5 = true;
                    if (!bl5) {
                        return true;
                    }
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final List<?> standardizeList(List<?> series) {
        Iterable<?> iterable = this.standardizeIterable((Iterable)series);
        if (iterable == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<*>");
        }
        return (List)iterable;
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<?> standardizeIterable(Iterable<?> series) {
        Iterable iterable;
        standardizeIterable.1 $fun$noTimeZoneError$1 = standardizeIterable.1.INSTANCE;
        standardizeIterable.2 $fun$toDouble$2 = standardizeIterable.2.INSTANCE;
        if (this.needToStandardizeValues(series)) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = series;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object;
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var13_13 = it;
                if (var13_13 == null) {
                    object = it;
                } else if (var13_13 instanceof String) {
                    object = it;
                } else if (var13_13 instanceof Number) {
                    object = standardizeIterable.2.INSTANCE.invoke((Number)it);
                } else if (var13_13 instanceof Character) {
                    object = it.toString();
                } else if (var13_13 instanceof Date) {
                    object = ((Date)it).getTime();
                } else if (var13_13 instanceof Instant) {
                    object = ((Instant)it).toEpochMilli();
                } else if (var13_13 instanceof ZonedDateTime) {
                    object = ((ZonedDateTime)it).toInstant().toEpochMilli();
                } else {
                    if (var13_13 instanceof LocalDate) {
                        Object object2 = standardizeIterable.1.INSTANCE.invoke(it);
                        throw new KotlinNothingValueException();
                    }
                    if (var13_13 instanceof LocalTime) {
                        Object object3 = standardizeIterable.1.INSTANCE.invoke(it);
                        throw new KotlinNothingValueException();
                    }
                    if (var13_13 instanceof LocalDateTime) {
                        Object object4 = standardizeIterable.1.INSTANCE.invoke(it);
                        throw new KotlinNothingValueException();
                    }
                    if (var13_13 instanceof Color) {
                        object = ((Color)it).toHexColor();
                    } else if (var13_13 instanceof java.awt.Color) {
                        String string = "#%02x%02x%02x";
                        Object[] objectArray = new Object[]{((java.awt.Color)it).getRed(), ((java.awt.Color)it).getGreen(), ((java.awt.Color)it).getBlue()};
                        boolean bl2 = false;
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        object = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
                    } else {
                        throw (Throwable)new IllegalArgumentException("Can't standardize the value \"" + it + "\" of type " + Reflection.getOrCreateKotlinClass(it.getClass()).getQualifiedName() + " as a string, number or date-time.");
                    }
                }
                void var18_18 = object;
                collection.add(var18_18);
            }
            iterable = (List)destination$iv$iv;
        } else {
            iterable = series;
        }
        return iterable;
    }

    private SeriesStandardizing() {
    }

    static {
        SeriesStandardizing seriesStandardizing;
        INSTANCE = seriesStandardizing = new SeriesStandardizing();
    }
}

