/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.letsPlot.export;

import java.io.File;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.PlotHtmlExport;
import jetbrains.datalore.plot.PlotHtmlHelper;
import jetbrains.datalore.plot.PlotImageExport;
import jetbrains.datalore.plot.PlotSvgExport;
import jetbrains.letsPlot.Figure;
import jetbrains.letsPlot.GGBunch;
import jetbrains.letsPlot.export.VersionChecker;
import jetbrains.letsPlot.intern.Plot;
import jetbrains.letsPlot.intern.ToSpecConvertersKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0003\u001a4\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a8\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"DEF_EXPORT_DIR", "", "exportRasterImage", "", "spec", "", "", "file", "Ljava/io/File;", "scalingFactor", "", "targetDPI", "ggsave", "plot", "Ljetbrains/letsPlot/Figure;", "filename", "scale", "", "dpi", "path", "plot-api"})
public final class GgsaveKt {
    private static final String DEF_EXPORT_DIR = "lets-plot-images";

    @NotNull
    public static final String ggsave(@NotNull Figure plot, @NotNull String filename, @NotNull Number scale, @Nullable Number dpi, @Nullable String path2) {
        Map<String, Object> map2;
        File file;
        Intrinsics.checkNotNullParameter((Object)plot, (String)"plot");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        String string = filename;
        boolean bl = false;
        String filename2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        boolean bl2 = StringsKt.indexOf$default((CharSequence)filename2, (char)'.', (int)0, (boolean)false, (int)6, null) >= 0;
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string2 = "File extension is missing: \"" + filename2 + "\".";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        CharSequence charSequence = StringsKt.substringBeforeLast((String)filename2, (char)'.', (String)"");
        bl = false;
        boolean bl5 = charSequence.length() > 0;
        bl = false;
        bl3 = false;
        if (!bl5) {
            boolean bl62 = false;
            String string3 = "Malformed filename: \"" + filename2 + "\".";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        CharSequence charSequence2 = StringsKt.substringAfterLast((String)filename2, (char)'.', (String)"");
        bl3 = false;
        String string4 = charSequence2;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        String ext = string5;
        charSequence2 = ext;
        bl3 = false;
        boolean bl7 = charSequence2.length() > 0;
        bl3 = false;
        boolean bl62 = false;
        if (!bl7) {
            boolean bl8 = false;
            String bl62 = "Missing file extension: \"" + filename2 + "\".";
            throw (Throwable)new IllegalArgumentException(bl62.toString());
        }
        String string6 = path2;
        if (string6 != null) {
            String string7 = string6;
            bl62 = false;
            boolean bl9 = false;
            String it = string7;
            boolean bl10 = false;
            file = new File(path2);
        } else {
            file = new File(System.getProperty("user.dir"), DEF_EXPORT_DIR);
        }
        File dir = file;
        dir.mkdir();
        File file2 = new File(dir.getCanonicalPath(), filename2);
        Object object = plot;
        if (object instanceof Plot) {
            map2 = ToSpecConvertersKt.toSpec((Plot)plot);
        } else if (object instanceof GGBunch) {
            map2 = ((GGBunch)plot).toSpec();
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported figure type: " + Reflection.getOrCreateKotlinClass(plot.getClass()).getSimpleName());
        }
        Map<String, Object> spec = map2;
        switch (ext) {
            case "svg": {
                String svg = PlotSvgExport.buildSvgImageFromRawSpecs$default((PlotSvgExport)PlotSvgExport.INSTANCE, spec, null, (int)2, null);
                file2.createNewFile();
                FilesKt.writeText$default((File)file2, (String)svg, null, (int)2, null);
                break;
            }
            case "htm": 
            case "html": {
                DoubleVector doubleVector = null;
                String string8 = PlotHtmlHelper.INSTANCE.scriptUrl(VersionChecker.INSTANCE.getLetsPlotVersion());
                boolean bl11 = true;
                String html = PlotHtmlExport.buildHtmlFromRawSpecs$default((PlotHtmlExport)PlotHtmlExport.INSTANCE, spec, (String)string8, (boolean)bl11, doubleVector, (int)8, null);
                file2.createNewFile();
                FilesKt.writeText$default((File)file2, (String)html, null, (int)2, null);
                break;
            }
            case "jpg": 
            case "tif": 
            case "tiff": 
            case "png": 
            case "jpeg": {
                Number number = dpi;
                GgsaveKt.exportRasterImage(spec, file2, scale.doubleValue(), number != null ? number.doubleValue() : Double.NaN);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException(StringsKt.trimIndent((String)("\n            Unsupported file extension: \"" + ext + "\".\n            Please use one of: \"svg\", \"html\", \"htm\", \"png\", \"jpeg\", \"jpg\", \"tiff\", \"tif\". \n        ")));
            }
        }
        String string9 = file2.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"file.canonicalPath");
        return string9;
    }

    public static /* synthetic */ String ggsave$default(Figure figure, String string, Number number, Number number2, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            number = 2;
        }
        if ((n & 8) != 0) {
            number2 = null;
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        return GgsaveKt.ggsave(figure, string, number, number2, string2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void exportRasterImage(Map<String, Object> spec, File file, double scalingFactor, double targetDPI) {
        byte[] byArray;
        try {
            PlotImageExport.Format format;
            String string;
            String string2 = FilesKt.getExtension((File)file);
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            switch (string = string4) {
                case "png": {
                    format = (PlotImageExport.Format)PlotImageExport.Format.PNG.INSTANCE;
                    break;
                }
                case "jpg": 
                case "jpeg": {
                    format = (PlotImageExport.Format)new PlotImageExport.Format.JPEG(0.0, 1, null);
                    break;
                }
                case "tif": 
                case "tiff": {
                    format = (PlotImageExport.Format)PlotImageExport.Format.TIFF.INSTANCE;
                    break;
                }
                default: {
                    void ext;
                    throw (Throwable)new IllegalArgumentException("Unsupported format: " + (String)ext);
                }
            }
            PlotImageExport.Format format2 = format;
            PlotImageExport.ImageData image2 = PlotImageExport.INSTANCE.buildImageFromRawSpecs(spec, format2, scalingFactor, targetDPI);
            byArray = image2.getBytes();
        }
        catch (Throwable e) {
            Throwable throwable = e;
            if (throwable instanceof ClassNotFoundException || throwable instanceof NoClassDefFoundError) {
                throw (Throwable)new IllegalStateException(StringsKt.trimIndent((String)("\n                    \n                    Can't export plot to raster formats: " + Reflection.getOrCreateKotlinClass(e.getClass()).getSimpleName() + " \"" + e.getMessage() + "\".\n                    Please add \"lets-plot-image-export-<version>.jar\" to your classpath. \n                ")));
            }
            throw e;
        }
        byte[] imageBytes = byArray;
        file.createNewFile();
        FilesKt.writeBytes((File)file, (byte[])imageBytes);
    }
}

