/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.letsPlot;

import java.util.List;
import java.util.Map;
import jetbrains.letsPlot.FrontendContext;
import jetbrains.letsPlot.frontend.DefaultSwingBatikFrontendContext;
import jetbrains.letsPlot.frontend.DefaultSwingJfxFrontendContext;
import jetbrains.letsPlot.frontend.NotebookFrontendContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0006\u0010\u0013\u001a\u00020\u0004J\b\u0010\u0014\u001a\u00020\u000bH\u0002J1\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0002\u0010\u001cR \u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Ljetbrains/letsPlot/LetsPlot;", "", "()V", "apiVersion", "", "getApiVersion$annotations", "getApiVersion", "()Ljava/lang/String;", "setApiVersion", "(Ljava/lang/String;)V", "frontendContext", "Ljetbrains/letsPlot/FrontendContext;", "getFrontendContext", "()Ljetbrains/letsPlot/FrontendContext;", "setFrontendContext", "(Ljetbrains/letsPlot/FrontendContext;)V", "getBooleanFromEnv", "", "name", "getInfo", "initDefaultFrontendContext", "setupNotebook", "Ljetbrains/letsPlot/frontend/NotebookFrontendContext;", "jsVersion", "isolatedFrame", "htmlRenderer", "Lkotlin/Function1;", "", "(Ljava/lang/String;Ljava/lang/Boolean;Lkotlin/jvm/functions/Function1;)Ljetbrains/letsPlot/frontend/NotebookFrontendContext;", "plot-api"})
public final class LetsPlot {
    @NotNull
    private static FrontendContext frontendContext;
    @NotNull
    private static String apiVersion;
    @NotNull
    public static final LetsPlot INSTANCE;

    @NotNull
    public final FrontendContext getFrontendContext() {
        return frontendContext;
    }

    public final void setFrontendContext(@NotNull FrontendContext frontendContext) {
        Intrinsics.checkNotNullParameter((Object)frontendContext, (String)"<set-?>");
        LetsPlot.frontendContext = frontendContext;
    }

    public static /* synthetic */ void getApiVersion$annotations() {
    }

    @NotNull
    public final String getApiVersion() {
        return apiVersion;
    }

    public final void setApiVersion(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        apiVersion = string;
    }

    @NotNull
    public final String getInfo() {
        return "Lets-Plot Kotlin API v." + apiVersion + ". Frontend: " + frontendContext.getInfo();
    }

    @NotNull
    public final NotebookFrontendContext setupNotebook(@NotNull String jsVersion, @Nullable Boolean isolatedFrame, @NotNull Function1<? super String, Unit> htmlRenderer) {
        Intrinsics.checkNotNullParameter((Object)jsVersion, (String)"jsVersion");
        Intrinsics.checkNotNullParameter(htmlRenderer, (String)"htmlRenderer");
        Boolean bl = isolatedFrame;
        boolean isolatedFrameContext = bl != null ? bl.booleanValue() : this.getBooleanFromEnv("LETS_PLOT_HTML_ISOLATED_FRAME");
        FrontendContext frontendContext = LetsPlot.frontendContext = (FrontendContext)new NotebookFrontendContext(jsVersion, isolatedFrameContext, htmlRenderer);
        if (frontendContext == null) {
            throw new NullPointerException("null cannot be cast to non-null type jetbrains.letsPlot.frontend.NotebookFrontendContext");
        }
        return (NotebookFrontendContext)frontendContext;
    }

    private final boolean getBooleanFromEnv(String name) {
        boolean bl;
        String value = System.getenv(name);
        CharSequence charSequence = value;
        boolean bl2 = false;
        boolean bl3 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            bl = false;
        } else {
            List list = CollectionsKt.listOf((Object[])new String[]{"true", "1", "t", "y", "yes"});
            charSequence = value;
            bl2 = false;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            charSequence = ((Object)StringsKt.trim((CharSequence)charSequence2)).toString();
            bl2 = false;
            CharSequence charSequence3 = charSequence;
            if (charSequence3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)charSequence3).toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase()");
            if (list.contains(string)) {
                bl = true;
            } else {
                List list2 = CollectionsKt.listOf((Object[])new String[]{"false", "0", "f", "n", "no"});
                charSequence = value;
                bl2 = false;
                CharSequence charSequence4 = charSequence;
                if (charSequence4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                charSequence = ((Object)StringsKt.trim((CharSequence)charSequence4)).toString();
                bl2 = false;
                CharSequence charSequence5 = charSequence;
                if (charSequence5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)charSequence5).toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
                if (list2.contains(string2)) {
                    bl = false;
                } else {
                    throw (Throwable)new IllegalArgumentException("Can't convert str to boolean : [" + name + "] : " + value);
                }
            }
        }
        return bl;
    }

    private final FrontendContext initDefaultFrontendContext() {
        FrontendContext frontendContext;
        FrontendContext frontendContext2 = DefaultSwingBatikFrontendContext.Companion.tryCreate();
        if (frontendContext2 == null) {
            frontendContext2 = frontendContext = DefaultSwingJfxFrontendContext.Companion.tryCreate();
        }
        if (frontendContext2 == null) {
            frontendContext = new FrontendContext(){

                public void display(@NotNull Map<String, Object> plotSpecRaw) {
                    Intrinsics.checkNotNullParameter(plotSpecRaw, (String)"plotSpecRaw");
                    throw (Throwable)new IllegalStateException("\nThe frontend context is not defined.\nTo define the frontend context please select one of the following options:\na. Add \"lets-plot-batik-<version>.jar\" to your classpath.   \nb. Add \"lets-plot-jfx-<version>.jar\" to your classpath.   \nc. Specify the frontend context explicitly: \"LetsPlot.frontendContext = ...\"\n   ");
                }

                @NotNull
                public String getInfo() {
                    return FrontendContext.DefaultImpls.getInfo(this);
                }
            };
        }
        return frontendContext;
    }

    private LetsPlot() {
    }

    static {
        LetsPlot letsPlot2;
        INSTANCE = letsPlot2 = new LetsPlot();
        frontendContext = letsPlot2.initDefaultFrontendContext();
        apiVersion = "Unknown";
    }
}

