/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.tooltip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.observable.property.Property;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.render.svg.SvgComponent;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.plot.builder.interact.TooltipSpec;
import jetbrains.datalore.plot.builder.presentation.Defaults;
import jetbrains.datalore.vis.svg.SvgGElement;
import jetbrains.datalore.vis.svg.SvgPathData;
import jetbrains.datalore.vis.svg.SvgPathDataBuilder;
import jetbrains.datalore.vis.svg.SvgPathElement;
import jetbrains.datalore.vis.svg.SvgSvgElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0004()*+B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0014J%\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017JU\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0002\u0010'R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006,"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/TooltipBox;", "Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "()V", "contentRect", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "getContentRect", "()Ljetbrains/datalore/base/geometry/DoubleRectangle;", "myPointerBox", "Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerBox;", "myTextBox", "Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$TextBox;", "pointerDirection", "Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerDirection;", "getPointerDirection$plot_builder", "()Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerDirection;", "buildComponent", "", "setPosition", "tooltipCoord", "Ljetbrains/datalore/base/geometry/DoubleVector;", "pointerCoord", "orientation", "Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$Orientation;", "setPosition$plot_builder", "update", "fillColor", "Ljetbrains/datalore/base/values/Color;", "textColor", "borderColor", "strokeWidth", "", "lines", "", "Ljetbrains/datalore/plot/builder/interact/TooltipSpec$Line;", "style", "", "rotate", "", "tooltipMinWidth", "(Ljetbrains/datalore/base/values/Color;Ljetbrains/datalore/base/values/Color;Ljetbrains/datalore/base/values/Color;DLjava/util/List;Ljava/lang/String;ZLjava/lang/Double;)V", "Orientation", "PointerBox", "PointerDirection", "TextBox", "plot-builder"})
public final class TooltipBox
extends SvgComponent {
    @NotNull
    private final PointerBox myPointerBox = new PointerBox();
    @NotNull
    private final TextBox myTextBox = new TextBox();

    @NotNull
    public final DoubleRectangle getContentRect() {
        return DoubleRectangle.Companion.span(DoubleVector.Companion.getZERO(), this.myTextBox.getDimension());
    }

    @Nullable
    public final PointerDirection getPointerDirection$plot_builder() {
        return this.myPointerBox.getPointerDirection$plot_builder();
    }

    @Override
    protected void buildComponent() {
        this.add(this.myPointerBox);
        this.add(this.myTextBox);
    }

    public final void update(@NotNull Color fillColor, @NotNull Color textColor2, @NotNull Color borderColor, double strokeWidth, @NotNull List<TooltipSpec.Line> lines, @NotNull String style, boolean rotate, @Nullable Double tooltipMinWidth) {
        Intrinsics.checkNotNullParameter((Object)fillColor, (String)"fillColor");
        Intrinsics.checkNotNullParameter((Object)textColor2, (String)"textColor");
        Intrinsics.checkNotNullParameter((Object)borderColor, (String)"borderColor");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        this.addClassName(style);
        this.myTextBox.update$plot_builder(lines, Defaults.Common.Tooltip.INSTANCE.getDARK_TEXT_COLOR(), textColor2, tooltipMinWidth, rotate);
        this.myPointerBox.updateStyle$plot_builder(fillColor, borderColor, strokeWidth);
    }

    public static /* synthetic */ void update$default(TooltipBox tooltipBox, Color color, Color color2, Color color3, double d, List list2, String string, boolean bl, Double d2, int n, Object object) {
        if ((n & 0x80) != 0) {
            d2 = null;
        }
        tooltipBox.update(color, color2, color3, d, list2, string, bl, d2);
    }

    public final void setPosition$plot_builder(@NotNull DoubleVector tooltipCoord, @NotNull DoubleVector pointerCoord, @NotNull Orientation orientation) {
        Intrinsics.checkNotNullParameter((Object)tooltipCoord, (String)"tooltipCoord");
        Intrinsics.checkNotNullParameter((Object)pointerCoord, (String)"pointerCoord");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        this.myPointerBox.update$plot_builder(pointerCoord.subtract(tooltipCoord), orientation);
        this.moveTo(tooltipCoord.getX(), tooltipCoord.getY());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$Orientation;", "", "(Ljava/lang/String;I)V", "VERTICAL", "HORIZONTAL", "plot-builder"})
    public static final class Orientation
    extends Enum<Orientation> {
        public static final /* enum */ Orientation VERTICAL = new Orientation();
        public static final /* enum */ Orientation HORIZONTAL = new Orientation();
        private static final /* synthetic */ Orientation[] $VALUES;

        public static Orientation[] values() {
            return (Orientation[])$VALUES.clone();
        }

        public static Orientation valueOf(String value) {
            return Enum.valueOf(Orientation.class, value);
        }

        static {
            $VALUES = orientationArray = new Orientation[]{Orientation.VERTICAL, Orientation.HORIZONTAL};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerDirection;", "", "(Ljava/lang/String;I)V", "LEFT", "RIGHT", "UP", "DOWN", "plot-builder"})
    public static final class PointerDirection
    extends Enum<PointerDirection> {
        public static final /* enum */ PointerDirection LEFT = new PointerDirection();
        public static final /* enum */ PointerDirection RIGHT = new PointerDirection();
        public static final /* enum */ PointerDirection UP = new PointerDirection();
        public static final /* enum */ PointerDirection DOWN = new PointerDirection();
        private static final /* synthetic */ PointerDirection[] $VALUES;

        public static PointerDirection[] values() {
            return (PointerDirection[])$VALUES.clone();
        }

        public static PointerDirection valueOf(String value) {
            return Enum.valueOf(PointerDirection.class, value);
        }

        static {
            $VALUES = pointerDirectionArray = new PointerDirection[]{PointerDirection.LEFT, PointerDirection.RIGHT, PointerDirection.UP, PointerDirection.DOWN};
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u001d\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J%\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerBox;", "Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "(Ljetbrains/datalore/plot/builder/tooltip/TooltipBox;)V", "myPointerPath", "Ljetbrains/datalore/vis/svg/SvgPathElement;", "pointerDirection", "Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerDirection;", "getPointerDirection$plot_builder", "()Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerDirection;", "setPointerDirection$plot_builder", "(Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerDirection;)V", "buildComponent", "", "calculatePointerFootingIndent", "", "sideLength", "update", "pointerCoord", "Ljetbrains/datalore/base/geometry/DoubleVector;", "orientation", "Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$Orientation;", "update$plot_builder", "updateStyle", "fillColor", "Ljetbrains/datalore/base/values/Color;", "borderColor", "strokeWidth", "updateStyle$plot_builder", "plot-builder"})
    private final class PointerBox
    extends SvgComponent {
        @NotNull
        private final SvgPathElement myPointerPath;
        @Nullable
        private PointerDirection pointerDirection;

        public PointerBox() {
            Intrinsics.checkNotNullParameter((Object)TooltipBox.this, (String)"this$0");
            this.myPointerPath = new SvgPathElement();
        }

        @Nullable
        public final PointerDirection getPointerDirection$plot_builder() {
            return this.pointerDirection;
        }

        public final void setPointerDirection$plot_builder(@Nullable PointerDirection pointerDirection) {
            this.pointerDirection = pointerDirection;
        }

        @Override
        protected void buildComponent() {
            this.add(this.myPointerPath);
        }

        public final void updateStyle$plot_builder(@NotNull Color fillColor, @NotNull Color borderColor, double strokeWidth) {
            Intrinsics.checkNotNullParameter((Object)fillColor, (String)"fillColor");
            Intrinsics.checkNotNullParameter((Object)borderColor, (String)"borderColor");
            SvgPathElement svgPathElement = this.myPointerPath;
            boolean bl = false;
            boolean bl2 = false;
            SvgPathElement $this$updateStyle_u24lambda_u2d0 = svgPathElement;
            boolean bl3 = false;
            $this$updateStyle_u24lambda_u2d0.strokeColor().set(borderColor);
            $this$updateStyle_u24lambda_u2d0.strokeOpacity().set(strokeWidth);
            $this$updateStyle_u24lambda_u2d0.fillColor().set(fillColor);
        }

        /*
         * WARNING - void declaration
         */
        public final void update$plot_builder(@NotNull DoubleVector pointerCoord, @NotNull Orientation orientation) {
            void $this$update_u24lambda_u2d2;
            PointerDirection pointerDirection;
            Intrinsics.checkNotNullParameter((Object)pointerCoord, (String)"pointerCoord");
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            Orientation orientation2 = orientation;
            int n = WhenMappings.$EnumSwitchMapping$0[orientation2.ordinal()];
            switch (n) {
                case 1: {
                    if (pointerCoord.getX() < TooltipBox.this.getContentRect().getLeft()) {
                        pointerDirection = PointerDirection.LEFT;
                        break;
                    }
                    if (pointerCoord.getX() > TooltipBox.this.getContentRect().getRight()) {
                        pointerDirection = PointerDirection.RIGHT;
                        break;
                    }
                    pointerDirection = null;
                    break;
                }
                case 2: {
                    if (pointerCoord.getY() > TooltipBox.this.getContentRect().getBottom()) {
                        pointerDirection = PointerDirection.DOWN;
                        break;
                    }
                    if (pointerCoord.getY() < TooltipBox.this.getContentRect().getTop()) {
                        pointerDirection = PointerDirection.UP;
                        break;
                    }
                    pointerDirection = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.pointerDirection = pointerDirection;
            double vertFootingIndent = -this.calculatePointerFootingIndent(TooltipBox.this.getContentRect().getHeight());
            double horFootingIndent = this.calculatePointerFootingIndent(TooltipBox.this.getContentRect().getWidth());
            SvgPathDataBuilder svgPathDataBuilder = new SvgPathDataBuilder(false, 1, null);
            TooltipBox tooltipBox = TooltipBox.this;
            boolean bl = false;
            boolean bl2 = false;
            SvgPathDataBuilder svgPathDataBuilder2 = svgPathDataBuilder;
            Property<SvgPathData> property2 = this.myPointerPath.d();
            boolean bl3 = false;
            DoubleRectangle doubleRectangle = tooltipBox.getContentRect();
            boolean bl4 = false;
            boolean bl5 = false;
            DoubleRectangle $this$update_u24lambda_u2d2_u24lambda_u2d1 = doubleRectangle;
            boolean bl6 = false;
            SvgPathDataBuilder.moveTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getRight(), $this$update_u24lambda_u2d2_u24lambda_u2d1.getBottom(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getRight(), $this$update_u24lambda_u2d2_u24lambda_u2d1.getBottom() + vertFootingIndent, false, 4, null);
            PointerBox.update$lambda-2$lambda-1$lineToIf((SvgPathDataBuilder)$this$update_u24lambda_u2d2, pointerCoord, this.getPointerDirection$plot_builder() == PointerDirection.RIGHT);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getRight(), $this$update_u24lambda_u2d2_u24lambda_u2d1.getTop() - vertFootingIndent, false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getRight(), $this$update_u24lambda_u2d2_u24lambda_u2d1.getTop(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getRight() - horFootingIndent, $this$update_u24lambda_u2d2_u24lambda_u2d1.getTop(), false, 4, null);
            PointerBox.update$lambda-2$lambda-1$lineToIf((SvgPathDataBuilder)$this$update_u24lambda_u2d2, pointerCoord, this.getPointerDirection$plot_builder() == PointerDirection.UP);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getLeft() + horFootingIndent, $this$update_u24lambda_u2d2_u24lambda_u2d1.getTop(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getLeft(), $this$update_u24lambda_u2d2_u24lambda_u2d1.getTop(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getLeft(), $this$update_u24lambda_u2d2_u24lambda_u2d1.getTop() - vertFootingIndent, false, 4, null);
            PointerBox.update$lambda-2$lambda-1$lineToIf((SvgPathDataBuilder)$this$update_u24lambda_u2d2, pointerCoord, this.getPointerDirection$plot_builder() == PointerDirection.LEFT);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getLeft(), $this$update_u24lambda_u2d2_u24lambda_u2d1.getBottom() + vertFootingIndent, false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getLeft(), $this$update_u24lambda_u2d2_u24lambda_u2d1.getBottom(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getLeft() + horFootingIndent, $this$update_u24lambda_u2d2_u24lambda_u2d1.getBottom(), false, 4, null);
            PointerBox.update$lambda-2$lambda-1$lineToIf((SvgPathDataBuilder)$this$update_u24lambda_u2d2, pointerCoord, this.getPointerDirection$plot_builder() == PointerDirection.DOWN);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getRight() - horFootingIndent, $this$update_u24lambda_u2d2_u24lambda_u2d1.getBottom(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u2d2, $this$update_u24lambda_u2d2_u24lambda_u2d1.getRight(), $this$update_u24lambda_u2d2_u24lambda_u2d1.getBottom(), false, 4, null);
            Unit unit = Unit.INSTANCE;
            property2.set(svgPathDataBuilder.build());
        }

        private final double calculatePointerFootingIndent(double sideLength) {
            double d = sideLength * 0.4;
            double d2 = 12.0;
            boolean bl = false;
            double footingLength = Math.min(d, d2);
            return (sideLength - footingLength) / (double)2;
        }

        private static final void update$lambda-2$lambda-1$lineToIf(SvgPathDataBuilder $this_apply, DoubleVector p, boolean isTrue) {
            if (isTrue) {
                $this_apply.lineTo(p);
            }
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Orientation.values().length];
                nArray[Orientation.HORIZONTAL.ordinal()] = 1;
                nArray[Orientation.VERTICAL.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0014J?\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$TextBox;", "Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "(Ljetbrains/datalore/plot/builder/tooltip/TooltipBox;)V", "dimension", "Ljetbrains/datalore/base/geometry/DoubleVector;", "getDimension", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "myContent", "Ljetbrains/datalore/vis/svg/SvgSvgElement;", "myLines", "buildComponent", "", "update", "lines", "", "Ljetbrains/datalore/plot/builder/interact/TooltipSpec$Line;", "labelTextColor", "Ljetbrains/datalore/base/values/Color;", "valueTextColor", "tooltipMinWidth", "", "rotate", "", "update$plot_builder", "(Ljava/util/List;Ljetbrains/datalore/base/values/Color;Ljetbrains/datalore/base/values/Color;Ljava/lang/Double;Z)V", "plot-builder"})
    private final class TextBox
    extends SvgComponent {
        @NotNull
        private final SvgSvgElement myLines;
        @NotNull
        private final SvgSvgElement myContent;

        /*
         * WARNING - void declaration
         */
        public TextBox() {
            void $this$myContent_u24lambda_u2d1;
            SvgSvgElement $this$myLines_u24lambda_u2d0;
            Intrinsics.checkNotNullParameter((Object)TooltipBox.this, (String)"this$0");
            SvgSvgElement svgSvgElement = new SvgSvgElement();
            boolean bl = false;
            boolean bl2 = false;
            SvgSvgElement svgSvgElement2 = svgSvgElement;
            TextBox textBox = this;
            boolean bl3 = false;
            $this$myLines_u24lambda_u2d0.x().set(0.0);
            $this$myLines_u24lambda_u2d0.y().set(0.0);
            $this$myLines_u24lambda_u2d0.width().set(0.0);
            $this$myLines_u24lambda_u2d0.height().set(0.0);
            Unit unit = Unit.INSTANCE;
            textBox.myLines = svgSvgElement;
            svgSvgElement = new SvgSvgElement();
            bl = false;
            bl2 = false;
            $this$myLines_u24lambda_u2d0 = svgSvgElement;
            textBox = this;
            boolean bl4 = false;
            $this$myContent_u24lambda_u2d1.x().set(0.0);
            $this$myContent_u24lambda_u2d1.y().set(0.0);
            $this$myContent_u24lambda_u2d1.width().set(0.0);
            $this$myContent_u24lambda_u2d1.height().set(0.0);
            unit = Unit.INSTANCE;
            textBox.myContent = svgSvgElement;
        }

        @NotNull
        public final DoubleVector getDimension() {
            SvgSvgElement svgSvgElement = this.myContent;
            boolean bl = false;
            boolean bl2 = false;
            SvgSvgElement $this$_get_dimension__u24lambda_u2d2 = svgSvgElement;
            boolean bl3 = false;
            Object ValueT = $this$_get_dimension__u24lambda_u2d2.width().get();
            Intrinsics.checkNotNull(ValueT);
            double d = ((Number)ValueT).doubleValue();
            Object ValueT2 = $this$_get_dimension__u24lambda_u2d2.height().get();
            Intrinsics.checkNotNull(ValueT2);
            return new DoubleVector(d, ((Number)ValueT2).doubleValue());
        }

        @Override
        protected void buildComponent() {
            this.add(this.myContent);
            this.myContent.children().add(this.myLines);
        }

        /*
         * WARNING - void declaration
         */
        public final void update$plot_builder(@NotNull List<TooltipSpec.Line> lines, @NotNull Color labelTextColor, @NotNull Color valueTextColor, @Nullable Double tooltipMinWidth, boolean rotate) {
            DoubleVector doubleVector;
            void $this$fold$iv;
            TextLabel valueComponent;
            Iterator $this$mapTo$iv$iv;
            Double $this$map$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Object object;
            boolean bl;
            boolean bl2;
            CharSequence charSequence;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Intrinsics.checkNotNullParameter((Object)labelTextColor, (String)"labelTextColor");
            Intrinsics.checkNotNullParameter((Object)valueTextColor, (String)"valueTextColor");
            Iterable $this$map$iv2 = lines;
            boolean $i$f$map = false;
            Object object2 = $this$map$iv2;
            Collection destination$iv$iv322 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                TextLabel textLabel;
                String string;
                String p0;
                Iterator line2;
                TooltipSpec.Line line3 = (TooltipSpec.Line)item$iv$iv;
                collection = destination$iv$iv322;
                boolean bl3 = false;
                String string2 = ((TooltipSpec.Line)((Object)line2)).getLabel();
                boolean bl4 = false;
                boolean bl5 = false;
                String string3 = string2;
                String string4 = ((TooltipSpec.Line)((Object)line2)).getLabel();
                boolean bl6 = false;
                charSequence = p0;
                bl2 = false;
                bl = false;
                boolean bl7 = charSequence == null || charSequence.length() == 0;
                String string5 = string4;
                String string6 = string = !bl7 ? string2 : null;
                if (string == null) {
                    textLabel = null;
                } else {
                    string2 = string;
                    bl4 = false;
                    bl5 = false;
                    p0 = string2;
                    string4 = string5;
                    boolean bl8 = false;
                    TextLabel textLabel2 = new TextLabel(p0);
                    string5 = string4;
                    textLabel = textLabel2;
                }
                TextLabel textLabel3 = new TextLabel(((TooltipSpec.Line)((Object)line2)).getValue());
                TextLabel textLabel4 = textLabel;
                String string7 = string5;
                object = new Triple((Object)string7, textLabel4, (Object)textLabel3);
                collection.add(object);
            }
            List linesInfo = (List)destination$iv$iv322;
            Iterable $this$onEach$iv = linesInfo;
            boolean $i$f$onEach = false;
            object2 = $this$onEach$iv;
            boolean destination$iv$iv322 = false;
            $i$f$mapTo = false;
            Iterable $this$apply$iv = object2;
            boolean bl9 = false;
            for (Object element$iv : $this$apply$iv) {
                Triple $dstr$_u24__u24$labelComponent$_u24__u24 = (Triple)element$iv;
                boolean bl10 = false;
                TextLabel labelComponent = (TextLabel)$dstr$_u24__u24$labelComponent$_u24__u24.component2();
                if (labelComponent == null) continue;
                labelComponent.textColor().set(labelTextColor);
                this.myLines.children().add(labelComponent.getRootGroup());
            }
            $this$onEach$iv = linesInfo;
            $i$f$onEach = false;
            object2 = $this$onEach$iv;
            destination$iv$iv322 = false;
            $i$f$mapTo = false;
            $this$apply$iv = object2;
            bl9 = false;
            for (Object element$iv : $this$apply$iv) {
                Triple $dstr$_u24__u24$_u24__u24$valueComponent = (Triple)element$iv;
                boolean bl11 = false;
                TextLabel valueComponent2 = (TextLabel)$dstr$_u24__u24$_u24__u24$valueComponent.component3();
                valueComponent2.textColor().set(valueTextColor);
                this.myLines.children().add(valueComponent2.getRootGroup());
            }
            Iterable destination$iv$iv322 = linesInfo;
            boolean $i$f$mapNotNull = false;
            $this$apply$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object bl11 = $this$forEach$iv$iv$iv.iterator();
            while (bl11.hasNext()) {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = bl11.next();
                boolean bl12 = false;
                Triple $dstr$_u24__u24$labelComponent$_u24__u24 = (Triple)element$iv$iv;
                boolean bl13 = false;
                TextLabel labelComponent = (TextLabel)$dstr$_u24__u24$labelComponent$_u24__u24.component2();
                if (labelComponent == null) continue;
                bl2 = false;
                bl = false;
                CharSequence it$iv$iv = charSequence;
                boolean bl14 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$map2 = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
            boolean $i$f$mapTo2 = false;
            $this$forEach$iv$iv$iv = $this$mapTo$iv$iv.iterator();
            while ($this$forEach$iv$iv$iv.hasNext()) {
                void it;
                Object item$iv$iv = $this$forEach$iv$iv$iv.next();
                bl11 = (TextLabel)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl15 = false;
                object = it.getRootGroup().getBBox().getWidth();
                collection.add(object);
            }
            object2 = CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
            double maxLabelWidth = object2 == null ? 0.0 : (Double)object2;
            double maxLineWidth = 0.0;
            $this$map$iv = tooltipMinWidth;
            maxLineWidth = $this$map$iv == null ? 0.0 : $this$map$iv;
            Iterable $this$forEach$iv = linesInfo;
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                Triple $dstr$_u24__u24$labelComponent$valueComponent = (Triple)element$iv;
                boolean bl16 = false;
                TextLabel labelComponent = (TextLabel)$dstr$_u24__u24$labelComponent$valueComponent.component2();
                valueComponent = (TextLabel)$dstr$_u24__u24$labelComponent$valueComponent.component3();
                double valueWidth = valueComponent.getRootGroup().getBBox().getWidth();
                double bl12 = maxLineWidth;
                double bl13 = labelComponent == null ? valueWidth : maxLabelWidth + valueWidth + 8.0;
                boolean bl17 = false;
                maxLineWidth = Math.max(bl12, bl13);
            }
            Iterable $i$f$forEach22 = linesInfo;
            DoubleVector initial$iv = DoubleVector.Companion.getZERO();
            boolean $i$f$fold = false;
            DoubleVector accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                Unit unit;
                Object object3;
                void $dstr$labelText$labelComponent$valueComponent;
                valueComponent = (Triple)element$iv;
                DoubleVector textDimension = accumulator$iv;
                boolean bl18 = false;
                String labelText = (String)$dstr$labelText$labelComponent$valueComponent.component1();
                TextLabel labelComponent = (TextLabel)$dstr$labelText$labelComponent$valueComponent.component2();
                TextLabel valueComponent3 = (TextLabel)$dstr$labelText$labelComponent$valueComponent.component3();
                DoubleRectangle valueBBox = valueComponent3.getRootGroup().getBBox();
                TextLabel textLabel = labelComponent;
                DoubleRectangle doubleRectangle = textLabel == null ? null : ((object3 = textLabel.getRootGroup()) == null ? null : ((SvgGElement)object3).getBBox());
                DoubleRectangle labelBBox = doubleRectangle == null ? new DoubleRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO()) : doubleRectangle;
                double bl14 = valueBBox.getTop();
                double d = labelBBox.getTop();
                boolean bl19 = false;
                double yPosition = textDimension.getY() - Math.min(bl14, d);
                valueComponent3.y().set(yPosition);
                object3 = labelComponent;
                if (object3 == null) {
                    unit = null;
                } else {
                    Property<Double> property2 = ((TextLabel)object3).y();
                    if (property2 == null) {
                        unit = null;
                    } else {
                        property2.set(yPosition);
                        unit = Unit.INSTANCE;
                    }
                }
                if (labelComponent != null) {
                    labelComponent.x().set(-labelBBox.getLeft());
                    valueComponent3.x().set(maxLineWidth);
                    valueComponent3.setHorizontalAnchor(TextLabel.HorizontalAnchor.RIGHT);
                } else if (valueBBox.getWidth() == maxLineWidth) {
                    valueComponent3.x().set(-valueBBox.getLeft());
                } else if (Intrinsics.areEqual((Object)labelText, (Object)"")) {
                    valueComponent3.x().set(maxLineWidth);
                    valueComponent3.setHorizontalAnchor(TextLabel.HorizontalAnchor.RIGHT);
                } else {
                    valueComponent3.setHorizontalAnchor(TextLabel.HorizontalAnchor.MIDDLE);
                    valueComponent3.x().set(maxLineWidth / (double)2);
                }
                Object ValueT = valueComponent3.y().get();
                Intrinsics.checkNotNull(ValueT);
                bl14 = valueBBox.getHeight() + valueBBox.getTop();
                d = labelBBox.getHeight() + labelBBox.getTop();
                bl19 = false;
                accumulator$iv = new DoubleVector(maxLineWidth, ((Number)ValueT).doubleValue() + Math.max(bl14, d) + 3.0);
            }
            Object object4 = accumulator$iv;
            boolean bl20 = false;
            boolean bl21 = false;
            DoubleVector textSize = object4;
            boolean bl22 = false;
            if (rotate) {
                void $this$onEach$iv2;
                Iterable element$iv = linesInfo;
                boolean $i$f$onEach2 = false;
                void var18_50 = $this$onEach$iv2;
                boolean bl23 = false;
                boolean bl24 = false;
                void $this$apply$iv2 = var18_50;
                $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv = false;
                for (Object element$iv2 : $this$apply$iv2) {
                    Unit unit;
                    Unit unit2;
                    Unit unit3;
                    Triple $dstr$_u24__u24$labelComponent$valueComponent = (Triple)element$iv2;
                    boolean bl25 = false;
                    TextLabel labelComponent = (TextLabel)$dstr$_u24__u24$labelComponent$valueComponent.component2();
                    TextLabel valueComponent4 = (TextLabel)$dstr$_u24__u24$labelComponent$valueComponent.component3();
                    TextLabel textLabel = labelComponent;
                    if (textLabel == null) {
                        unit3 = null;
                    } else {
                        textLabel.rotate(90.0);
                        unit3 = Unit.INSTANCE;
                    }
                    textLabel = labelComponent;
                    if (textLabel == null) {
                        unit2 = null;
                    } else {
                        Property<Double> property3 = textLabel.y();
                        if (property3 == null) {
                            unit2 = null;
                        } else {
                            Object ValueT = labelComponent.y().get();
                            Intrinsics.checkNotNull(ValueT);
                            property3.set(-((Number)ValueT).doubleValue());
                            unit2 = Unit.INSTANCE;
                        }
                    }
                    textLabel = labelComponent;
                    if (textLabel == null) {
                        unit = null;
                    } else {
                        textLabel.setVerticalAnchor(TextLabel.VerticalAnchor.CENTER);
                        unit = Unit.INSTANCE;
                    }
                    Property<Double> property4 = valueComponent4.y();
                    Object ValueT = valueComponent4.y().get();
                    Intrinsics.checkNotNull(ValueT);
                    property4.set(-((Number)ValueT).doubleValue());
                    valueComponent4.setVerticalAnchor(TextLabel.VerticalAnchor.CENTER);
                    valueComponent4.rotate(90.0);
                }
                doubleVector = textSize.flip();
            } else {
                doubleVector = textSize.subtract(new DoubleVector(0.0, 3.0));
            }
            DoubleVector textSize2 = doubleVector;
            object4 = this.myLines;
            bl20 = false;
            bl21 = false;
            Object $this$update_u24lambda_u2d13 = object4;
            boolean bl26 = false;
            ((SvgSvgElement)$this$update_u24lambda_u2d13).x().set(rotate ? 0.0 : 4.0);
            ((SvgSvgElement)$this$update_u24lambda_u2d13).y().set(4.0);
            ((SvgSvgElement)$this$update_u24lambda_u2d13).width().set(textSize2.getX() + 8.0);
            ((SvgSvgElement)$this$update_u24lambda_u2d13).height().set(textSize2.getY());
            object4 = this.myContent;
            bl20 = false;
            bl21 = false;
            Object $this$update_u24lambda_u2d14 = object4;
            boolean bl27 = false;
            ((SvgSvgElement)$this$update_u24lambda_u2d14).width().set(textSize2.getX() + 8.0);
            ((SvgSvgElement)$this$update_u24lambda_u2d14).height().set(textSize2.getY() + 8.0);
        }
    }
}

