/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.scale.mapper;

import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.base.values.Colors;
import jetbrains.datalore.base.values.HSV;
import jetbrains.datalore.plot.base.scale.Mappers;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0013\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u000b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u00040\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\"\u0010\u0013\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u00040\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fJB\u0010\u0014\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u00040\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0004JB\u0010\u0014\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u00040\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0015\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u001b"}, d2={"Ljetbrains/datalore/plot/builder/scale/mapper/ColorMapper;", "", "()V", "DEF_GRADIENT_HIGH", "Ljetbrains/datalore/base/values/Color;", "getDEF_GRADIENT_HIGH", "()Ljetbrains/datalore/base/values/Color;", "DEF_GRADIENT_LOW", "getDEF_GRADIENT_LOW", "NA_VALUE", "getNA_VALUE", "gradient", "Lkotlin/Function1;", "", "domain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "low", "high", "naColor", "gradientDefault", "gradientHSV", "lowHSV", "Ljetbrains/datalore/base/values/HSV;", "highHSV", "autoHueDirection", "", "", "plot-builder-portable"})
public final class ColorMapper {
    @NotNull
    public static final ColorMapper INSTANCE = new ColorMapper();
    @NotNull
    private static final Color NA_VALUE = Color.Companion.getGRAY();
    @NotNull
    private static final Color DEF_GRADIENT_LOW = Color.Companion.parseHex("#132B43");
    @NotNull
    private static final Color DEF_GRADIENT_HIGH = Color.Companion.parseHex("#56B1F7");

    private ColorMapper() {
    }

    @NotNull
    public final Color getNA_VALUE() {
        return NA_VALUE;
    }

    @NotNull
    public final Color getDEF_GRADIENT_LOW() {
        return DEF_GRADIENT_LOW;
    }

    @NotNull
    public final Color getDEF_GRADIENT_HIGH() {
        return DEF_GRADIENT_HIGH;
    }

    @NotNull
    public final Function1<Double, Color> gradientDefault(@NotNull ClosedRange<Double> domain) {
        Intrinsics.checkNotNullParameter(domain, (String)"domain");
        return this.gradient(domain, DEF_GRADIENT_LOW, DEF_GRADIENT_HIGH, NA_VALUE);
    }

    @NotNull
    public final Function1<Double, Color> gradient(@NotNull ClosedRange<Double> domain, @NotNull Color low, @NotNull Color high, @NotNull Color naColor) {
        Intrinsics.checkNotNullParameter(domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)low, (String)"low");
        Intrinsics.checkNotNullParameter((Object)high, (String)"high");
        Intrinsics.checkNotNullParameter((Object)naColor, (String)"naColor");
        return this.gradientHSV(domain, Colors.INSTANCE.hsvFromRgb(low), Colors.INSTANCE.hsvFromRgb(high), true, naColor);
    }

    @NotNull
    public final Function1<Double, Color> gradientHSV(@NotNull ClosedRange<Double> domain, @NotNull double[] lowHSV, @NotNull double[] highHSV, boolean autoHueDirection, @NotNull Color naColor) {
        Intrinsics.checkNotNullParameter(domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)lowHSV, (String)"lowHSV");
        Intrinsics.checkNotNullParameter((Object)highHSV, (String)"highHSV");
        Intrinsics.checkNotNullParameter((Object)naColor, (String)"naColor");
        return this.gradientHSV(domain, new HSV(lowHSV[0], lowHSV[1], lowHSV[2]), new HSV(highHSV[0], highHSV[1], highHSV[2]), autoHueDirection, naColor);
    }

    @NotNull
    public final Function1<Double, Color> gradientHSV(@NotNull ClosedRange<Double> domain, @NotNull HSV lowHSV, @NotNull HSV highHSV, boolean autoHueDirection, @NotNull Color naColor) {
        Intrinsics.checkNotNullParameter(domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)lowHSV, (String)"lowHSV");
        Intrinsics.checkNotNullParameter((Object)highHSV, (String)"highHSV");
        Intrinsics.checkNotNullParameter((Object)naColor, (String)"naColor");
        double lowHue = lowHSV.getH();
        double highHue = highHSV.getH();
        double lowS = lowHSV.getS();
        double highS = highHSV.getS();
        if (lowS < 1.0E-4) {
            lowHue = highHue;
        }
        if (highS < 1.0E-4) {
            highHue = lowHue;
        }
        if (autoHueDirection) {
            double d = highHue - lowHue;
            boolean bl = false;
            double dH = Math.abs(d);
            if (dH > 180.0) {
                if (highHue >= lowHue) {
                    lowHue += 360.0;
                } else {
                    highHue += 360.0;
                }
            }
        }
        Function1<Double, Double> mapperH = Mappers.INSTANCE.linear(domain, lowHue, highHue, Double.NaN);
        Function1<Double, Double> mapperS = Mappers.INSTANCE.linear(domain, lowS, highS, Double.NaN);
        Function1<Double, Double> mapperV = Mappers.INSTANCE.linear(domain, lowHSV.getV(), highHSV.getV(), Double.NaN);
        return (Function1)new Function1<Double, Color>(domain, naColor, mapperH, mapperS, mapperV){
            final /* synthetic */ ClosedRange<Double> $domain;
            final /* synthetic */ Color $naColor;
            final /* synthetic */ Function1<Double, Double> $mapperH;
            final /* synthetic */ Function1<Double, Double> $mapperS;
            final /* synthetic */ Function1<Double, Double> $mapperV;
            {
                this.$domain = $domain;
                this.$naColor = $naColor;
                this.$mapperH = $mapperH;
                this.$mapperS = $mapperS;
                this.$mapperV = $mapperV;
                super(1);
            }

            @NotNull
            public final Color invoke(@Nullable Double input) {
                Color color;
                if (input == null || !this.$domain.contains((Double)((Comparable)input))) {
                    color = this.$naColor;
                } else {
                    double hue = ((Number)this.$mapperH.invoke((Object)input)).doubleValue() % (double)360;
                    double H = hue >= 0.0 ? hue : (double)360 + hue;
                    double S = ((Number)this.$mapperS.invoke((Object)input)).doubleValue();
                    double V = ((Number)this.$mapperV.invoke((Object)input)).doubleValue();
                    color = Colors.INSTANCE.rgbFromHsv(H, S, V);
                }
                return color;
            }
        };
    }
}

