/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout.axis;

import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.plot.base.scale.Mappers;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.AxisLayoutInfo;
import jetbrains.datalore.plot.builder.layout.axis.AxisBreaksProvider;
import jetbrains.datalore.plot.builder.layout.axis.HorizontalAxisLayouter;
import jetbrains.datalore.plot.builder.layout.axis.VerticalAxisLayouter;
import jetbrains.datalore.plot.builder.layout.axis.label.AxisLabelsLayout;
import jetbrains.datalore.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J \u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00122\u0006\u0010\u000e\u001a\u00020\u0006H$J \u0010\u0013\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00122\u0006\u0010\u000e\u001a\u00020\u0006H\u0004R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/plot/builder/layout/axis/AxisLayouter;", "", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "domainRange", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "labelsLayout", "Ljetbrains/datalore/plot/builder/layout/axis/label/AxisLabelsLayout;", "(Ljetbrains/datalore/plot/builder/guide/Orientation;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/plot/builder/layout/axis/label/AxisLabelsLayout;)V", "getOrientation", "()Ljetbrains/datalore/plot/builder/guide/Orientation;", "doLayout", "Ljetbrains/datalore/plot/builder/layout/AxisLayoutInfo;", "axisLength", "maxTickLabelsBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "toAxisMapper", "Lkotlin/Function1;", "toScaleMapper", "Companion", "plot-builder-portable"})
public abstract class AxisLayouter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Orientation orientation;
    @NotNull
    private final ClosedRange<Double> domainRange;
    @NotNull
    private final AxisLabelsLayout labelsLayout;

    public AxisLayouter(@NotNull Orientation orientation, @NotNull ClosedRange<Double> domainRange, @NotNull AxisLabelsLayout labelsLayout) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter(domainRange, (String)"domainRange");
        Intrinsics.checkNotNullParameter((Object)labelsLayout, (String)"labelsLayout");
        this.orientation = orientation;
        this.domainRange = domainRange;
        this.labelsLayout = labelsLayout;
    }

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    @NotNull
    public final AxisLayoutInfo doLayout(double axisLength, @Nullable DoubleRectangle maxTickLabelsBounds) {
        AxisLabelsLayoutInfo labelsInfo = this.labelsLayout.doLayout(axisLength, this.toAxisMapper(axisLength), maxTickLabelsBounds);
        DoubleRectangle labelsBounds = labelsInfo.getBounds();
        AxisLayoutInfo.Builder builder = new AxisLayoutInfo.Builder().axisBreaks(labelsInfo.getBreaks()).axisLength(axisLength).orientation(this.orientation).axisDomain(this.domainRange).tickLabelsBoundsMax(maxTickLabelsBounds).tickLabelSmallFont(labelsInfo.getSmallFont()).tickLabelAdditionalOffsets(labelsInfo.getLabelAdditionalOffsets()).tickLabelHorizontalAnchor(labelsInfo.getLabelHorizontalAnchor()).tickLabelVerticalAnchor(labelsInfo.getLabelVerticalAnchor()).tickLabelRotationAngle(labelsInfo.getLabelRotationAngle()).tickLabelsBounds(labelsBounds);
        return builder.build();
    }

    @NotNull
    protected abstract Function1<Double, Double> toAxisMapper(double var1);

    @NotNull
    protected final Function1<Double, Double> toScaleMapper(double axisLength) {
        return Mappers.INSTANCE.mul(this.domainRange, axisLength);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/plot/builder/layout/axis/AxisLayouter$Companion;", "", "()V", "create", "Ljetbrains/datalore/plot/builder/layout/axis/AxisLayouter;", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "axisDomain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "breaksProvider", "Ljetbrains/datalore/plot/builder/layout/axis/AxisBreaksProvider;", "theme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AxisLayouter create(@NotNull Orientation orientation, @NotNull ClosedRange<Double> axisDomain, @NotNull AxisBreaksProvider breaksProvider, @NotNull AxisTheme theme) {
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            Intrinsics.checkNotNullParameter(axisDomain, (String)"axisDomain");
            Intrinsics.checkNotNullParameter((Object)breaksProvider, (String)"breaksProvider");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            if (orientation.isHorizontal()) {
                AxisLabelsLayout labelsLayout = breaksProvider.isFixedBreaks() ? AxisLabelsLayout.Companion.horizontalFixedBreaks(orientation, axisDomain, breaksProvider.getFixedBreaks(), theme) : AxisLabelsLayout.Companion.horizontalFlexBreaks(orientation, axisDomain, breaksProvider, theme);
                return new HorizontalAxisLayouter(orientation, axisDomain, labelsLayout);
            }
            AxisLabelsLayout labelsLayout = breaksProvider.isFixedBreaks() ? AxisLabelsLayout.Companion.verticalFixedBreaks(orientation, axisDomain, breaksProvider.getFixedBreaks(), theme) : AxisLabelsLayout.Companion.verticalFlexBreaks(orientation, axisDomain, breaksProvider, theme);
            return new VerticalAxisLayouter(orientation, axisDomain, labelsLayout);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

