/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout;

import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.AxisLayout;
import jetbrains.datalore.plot.builder.layout.AxisLayoutInfo;
import jetbrains.datalore.plot.builder.layout.TileLayout;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import jetbrains.datalore.plot.builder.layout.XYPlotLayoutUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ljetbrains/datalore/plot/builder/layout/XYPlotTileLayout;", "Ljetbrains/datalore/plot/builder/layout/TileLayout;", "xAxisLayout", "Ljetbrains/datalore/plot/builder/layout/AxisLayout;", "yAxisLayout", "(Ljetbrains/datalore/plot/builder/layout/AxisLayout;Ljetbrains/datalore/plot/builder/layout/AxisLayout;)V", "doLayout", "Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;", "preferredSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "Companion", "plot-builder-portable"})
public final class XYPlotTileLayout
implements TileLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AxisLayout xAxisLayout;
    @NotNull
    private final AxisLayout yAxisLayout;
    private static final double AXIS_STRETCH_RATIO = 0.1;

    public XYPlotTileLayout(@NotNull AxisLayout xAxisLayout, @NotNull AxisLayout yAxisLayout) {
        Intrinsics.checkNotNullParameter((Object)xAxisLayout, (String)"xAxisLayout");
        Intrinsics.checkNotNullParameter((Object)yAxisLayout, (String)"yAxisLayout");
        this.xAxisLayout = xAxisLayout;
        this.yAxisLayout = yAxisLayout;
    }

    @Override
    @NotNull
    public TileLayoutInfo doLayout(@NotNull DoubleVector preferredSize) {
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        Pair pair2 = XYPlotTileLayout.Companion.computeAxisInfos(this.xAxisLayout, this.yAxisLayout, preferredSize);
        Object xAxisInfo = null;
        xAxisInfo = pair2.component1();
        AxisLayoutInfo yAxisInfo = (AxisLayoutInfo)pair2.component2();
        DoubleRectangle geomBounds = null;
        geomBounds = XYPlotLayoutUtil.INSTANCE.geomBounds(((AxisLayoutInfo)xAxisInfo).axisBounds().getDimension().getY(), yAxisInfo.axisBounds().getDimension().getX(), preferredSize);
        XYPlotTileLayout xYPlotTileLayout = this;
        boolean bl = false;
        boolean bl2 = false;
        XYPlotTileLayout $this$doLayout_u24lambda_u2d0 = xYPlotTileLayout;
        boolean bl3 = false;
        DoubleRectangle maxTickLabelsBounds = XYPlotLayoutUtil.INSTANCE.maxTickLabelsBounds(Orientation.BOTTOM, 0.0, geomBounds, preferredSize);
        DoubleRectangle tickLabelsBounds = ((AxisLayoutInfo)xAxisInfo).getTickLabelsBounds();
        double d = maxTickLabelsBounds.getLeft();
        DoubleRectangle doubleRectangle = tickLabelsBounds;
        Intrinsics.checkNotNull((Object)doubleRectangle);
        double leftOverflow = d - doubleRectangle.getOrigin().getX();
        double rightOverflow = tickLabelsBounds.getOrigin().getX() + tickLabelsBounds.getDimension().getX() - maxTickLabelsBounds.getRight();
        if (leftOverflow > 0.0) {
            geomBounds = new DoubleRectangle(geomBounds.getOrigin().getX() + leftOverflow, geomBounds.getOrigin().getY(), geomBounds.getDimension().getX() - leftOverflow, geomBounds.getDimension().getY());
        }
        if (rightOverflow > 0.0) {
            geomBounds = new DoubleRectangle(geomBounds.getOrigin().getX(), geomBounds.getOrigin().getY(), geomBounds.getDimension().getX() - rightOverflow, geomBounds.getDimension().getY());
        }
        geomBounds = geomBounds.union(new DoubleRectangle(geomBounds.getOrigin(), XYPlotLayoutUtil.INSTANCE.getGEOM_MIN_SIZE()));
        DoubleRectangle geomWithAxisBounds = XYPlotTileLayout.Companion.tileBounds(((AxisLayoutInfo)xAxisInfo).axisBounds(), yAxisInfo.axisBounds(), geomBounds);
        xAxisInfo = ((AxisLayoutInfo)xAxisInfo).withAxisLength(geomBounds.getWidth()).build();
        yAxisInfo = yAxisInfo.withAxisLength(geomBounds.getHeight()).build();
        return new TileLayoutInfo(geomWithAxisBounds, geomBounds, XYPlotLayoutUtil.INSTANCE.clipBounds(geomBounds), (AxisLayoutInfo)xAxisInfo, yAxisInfo, false, false, 0, 96, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/plot/builder/layout/XYPlotTileLayout$Companion;", "", "()V", "AXIS_STRETCH_RATIO", "", "computeAxisInfos", "Lkotlin/Pair;", "Ljetbrains/datalore/plot/builder/layout/AxisLayoutInfo;", "xAxisLayout", "Ljetbrains/datalore/plot/builder/layout/AxisLayout;", "yAxisLayout", "plotSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "computeXAxisInfo", "axisLayout", "geomBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "computeYAxisInfo", "tileBounds", "xAxisBounds", "yAxisBounds", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final DoubleRectangle tileBounds(DoubleRectangle xAxisBounds, DoubleRectangle yAxisBounds, DoubleRectangle geomBounds) {
            DoubleVector leftTop = new DoubleVector(geomBounds.getLeft() - yAxisBounds.getWidth(), geomBounds.getTop() - 0.0);
            DoubleVector rightBottom = new DoubleVector(geomBounds.getRight() + 0.0, geomBounds.getBottom() + xAxisBounds.getHeight());
            return new DoubleRectangle(leftTop, rightBottom.subtract(leftTop));
        }

        private final Pair<AxisLayoutInfo, AxisLayoutInfo> computeAxisInfos(AxisLayout xAxisLayout, AxisLayout yAxisLayout, DoubleVector plotSize2) {
            AxisLayoutInfo yAxisInfo;
            double yAxisThickness;
            double xAxisThickness = xAxisLayout.initialThickness();
            AxisLayoutInfo xAxisInfo = this.computeXAxisInfo(xAxisLayout, plotSize2, XYPlotLayoutUtil.INSTANCE.geomBounds(xAxisThickness, yAxisThickness = (yAxisInfo = this.computeYAxisInfo(yAxisLayout, XYPlotLayoutUtil.INSTANCE.geomBounds(xAxisThickness, yAxisLayout.initialThickness(), plotSize2))).axisBounds().getDimension().getX(), plotSize2));
            if (xAxisInfo.axisBounds().getDimension().getY() > xAxisThickness) {
                yAxisInfo = this.computeYAxisInfo(yAxisLayout, XYPlotLayoutUtil.INSTANCE.geomBounds(xAxisInfo.axisBounds().getDimension().getY(), yAxisThickness, plotSize2));
            }
            return new Pair((Object)xAxisInfo, (Object)yAxisInfo);
        }

        private final AxisLayoutInfo computeXAxisInfo(AxisLayout axisLayout, DoubleVector plotSize2, DoubleRectangle geomBounds) {
            double axisLength = geomBounds.getDimension().getX();
            double stretch = axisLength * 0.1;
            DoubleRectangle maxTickLabelsBounds = XYPlotLayoutUtil.INSTANCE.maxTickLabelsBounds(Orientation.BOTTOM, stretch, geomBounds, plotSize2);
            return axisLayout.doLayout(geomBounds.getDimension(), maxTickLabelsBounds);
        }

        private final AxisLayoutInfo computeYAxisInfo(AxisLayout axisLayout, DoubleRectangle geomBounds) {
            return axisLayout.doLayout(geomBounds.getDimension(), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

