/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout;

import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.guide.Orientation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0007J&\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/builder/layout/XYPlotLayoutUtil;", "", "()V", "CLIP_EXTEND", "", "GEOM_MARGIN", "GEOM_MIN_SIZE", "Ljetbrains/datalore/base/geometry/DoubleVector;", "getGEOM_MIN_SIZE", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "clipBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "geomBounds", "xAxisThickness", "yAxisThickness", "plotSize", "maxTickLabelsBounds", "axisOrientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "stretch", "plot-builder-portable"})
public final class XYPlotLayoutUtil {
    @NotNull
    public static final XYPlotLayoutUtil INSTANCE = new XYPlotLayoutUtil();
    public static final double GEOM_MARGIN = 0.0;
    private static final double CLIP_EXTEND = 5.0;
    @NotNull
    private static final DoubleVector GEOM_MIN_SIZE = new DoubleVector(50.0, 50.0);

    private XYPlotLayoutUtil() {
    }

    @NotNull
    public final DoubleVector getGEOM_MIN_SIZE() {
        return GEOM_MIN_SIZE;
    }

    @NotNull
    public final DoubleRectangle geomBounds(double xAxisThickness, double yAxisThickness, @NotNull DoubleVector plotSize2) {
        Intrinsics.checkNotNullParameter((Object)plotSize2, (String)"plotSize");
        DoubleVector marginLeftTop = new DoubleVector(yAxisThickness, 0.0);
        DoubleVector marginRightBottom = new DoubleVector(0.0, xAxisThickness);
        DoubleVector geomSize = plotSize2.subtract(marginLeftTop).subtract(marginRightBottom);
        if (geomSize.getX() < GEOM_MIN_SIZE.getX()) {
            geomSize = new DoubleVector(GEOM_MIN_SIZE.getX(), geomSize.getY());
        }
        if (geomSize.getY() < GEOM_MIN_SIZE.getY()) {
            geomSize = new DoubleVector(geomSize.getX(), GEOM_MIN_SIZE.getY());
        }
        return new DoubleRectangle(marginLeftTop, geomSize);
    }

    @NotNull
    public final DoubleRectangle clipBounds(@NotNull DoubleRectangle geomBounds) {
        Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
        return new DoubleRectangle(geomBounds.getOrigin().subtract(new DoubleVector(5.0, 5.0)), new DoubleVector(geomBounds.getDimension().getX() + 10.0, geomBounds.getDimension().getY() + 10.0));
    }

    @NotNull
    public final DoubleRectangle maxTickLabelsBounds(@NotNull Orientation axisOrientation, double stretch, @NotNull DoubleRectangle geomBounds, @NotNull DoubleVector plotSize2) {
        Intrinsics.checkNotNullParameter((Object)((Object)axisOrientation), (String)"axisOrientation");
        Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
        Intrinsics.checkNotNullParameter((Object)plotSize2, (String)"plotSize");
        double geomPaddung = 10.0;
        DoubleRectangle maxGeomBounds = new DoubleRectangle(geomPaddung, geomPaddung, plotSize2.getX() - (double)2 * geomPaddung, plotSize2.getY() - (double)2 * geomPaddung);
        Orientation orientation = axisOrientation;
        int n = WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                double leftSpace = geomBounds.getLeft() - maxGeomBounds.getLeft() + stretch;
                double rightSpace = maxGeomBounds.getRight() - geomBounds.getRight() + stretch;
                double height = 1.0E42;
                Orientation orientation2 = axisOrientation;
                int n2 = WhenMappings.$EnumSwitchMapping$0[orientation2.ordinal()];
                double top = n2 == 1 ? -height : 0.0;
                double left = -leftSpace;
                double width2 = leftSpace + rightSpace + geomBounds.getWidth();
                return new DoubleRectangle(left, top, width2, height);
            }
        }
        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Orientation not supported: ", (Object)((Object)axisOrientation)));
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            nArray[Orientation.TOP.ordinal()] = 1;
            nArray[Orientation.BOTTOM.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

