/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout;

import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.layout.PlotLayoutBase;
import jetbrains.datalore.plot.builder.layout.PlotLayoutInfo;
import jetbrains.datalore.plot.builder.layout.TileLayout;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/builder/layout/SingleTilePlotLayout;", "Ljetbrains/datalore/plot/builder/layout/PlotLayoutBase;", "myTileLayout", "Ljetbrains/datalore/plot/builder/layout/TileLayout;", "(Ljetbrains/datalore/plot/builder/layout/TileLayout;)V", "doLayout", "Ljetbrains/datalore/plot/builder/layout/PlotLayoutInfo;", "preferredSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "plot-builder-portable"})
public final class SingleTilePlotLayout
extends PlotLayoutBase {
    @NotNull
    private final TileLayout myTileLayout;

    public SingleTilePlotLayout(@NotNull TileLayout myTileLayout) {
        Intrinsics.checkNotNullParameter((Object)myTileLayout, (String)"myTileLayout");
        this.myTileLayout = myTileLayout;
        this.setPadding(10.0, 10.0, 0.0, 0.0);
    }

    @Override
    @NotNull
    public PlotLayoutInfo doLayout(@NotNull DoubleVector preferredSize) {
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        DoubleVector tilePreferredSize = new DoubleVector(preferredSize.getX() - (this.getPaddingLeft() + this.getPaddingRight()), preferredSize.getY() - (this.getPaddingTop() + this.getPaddingBottom()));
        TileLayoutInfo tileInfo = this.myTileLayout.doLayout(tilePreferredSize);
        tileInfo = tileInfo.withOffset(new DoubleVector(this.getPaddingLeft(), this.getPaddingTop()));
        DoubleVector plotSize2 = tileInfo.getBounds().getDimension();
        plotSize2 = plotSize2.add(new DoubleVector(this.getPaddingRight(), this.getPaddingBottom()));
        return new PlotLayoutInfo(CollectionsKt.listOf((Object)tileInfo), plotSize2);
    }
}

