/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout;

import java.util.Collection;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.layout.PlotLayoutInfo;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import jetbrains.datalore.plot.builder.presentation.PlotLabelSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bJ\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/plot/builder/layout/PlotLayoutUtil;", "", "()V", "AXIS_TITLE_INNER_MARGIN", "", "AXIS_TITLE_OUTER_MARGIN", "LIVE_MAP_PLOT_MARGIN", "Ljetbrains/datalore/base/geometry/DoubleVector;", "LIVE_MAP_PLOT_PADDING", "TITLE_V_MARGIN", "absoluteGeomBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "origin", "plotLayoutInfo", "Ljetbrains/datalore/plot/builder/layout/PlotLayoutInfo;", "axisTitleDimensions", "text", "", "liveMapBounds", "container", "titleDimensions", "plot-builder-portable"})
public final class PlotLayoutUtil {
    @NotNull
    public static final PlotLayoutUtil INSTANCE = new PlotLayoutUtil();
    public static final double AXIS_TITLE_OUTER_MARGIN = 4.0;
    public static final double AXIS_TITLE_INNER_MARGIN = 4.0;
    private static final double TITLE_V_MARGIN = 4.0;
    @NotNull
    private static final DoubleVector LIVE_MAP_PLOT_PADDING = new DoubleVector(10.0, 0.0);
    @NotNull
    private static final DoubleVector LIVE_MAP_PLOT_MARGIN = new DoubleVector(10.0, 10.0);

    private PlotLayoutUtil() {
    }

    @NotNull
    public final DoubleVector titleDimensions(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence charSequence = text;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return DoubleVector.Companion.getZERO();
        }
        PlotLabelSpec labelSpec = PlotLabelSpec.PLOT_TITLE;
        return new DoubleVector(labelSpec.width(text.length()), labelSpec.height() + 8.0);
    }

    @NotNull
    public final DoubleVector axisTitleDimensions(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence charSequence = text;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return DoubleVector.Companion.getZERO();
        }
        PlotLabelSpec labelSpec = PlotLabelSpec.AXIS_TITLE;
        return new DoubleVector(labelSpec.width(text.length()), labelSpec.height());
    }

    @NotNull
    public final DoubleRectangle absoluteGeomBounds(@NotNull DoubleVector origin, @NotNull PlotLayoutInfo plotLayoutInfo) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)plotLayoutInfo, (String)"plotLayoutInfo");
        Collection collection = plotLayoutInfo.getTiles();
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "Plot is empty";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        DoubleRectangle result = null;
        for (TileLayoutInfo tile2 : plotLayoutInfo.getTiles()) {
            DoubleRectangle doubleRectangle;
            DoubleRectangle geomBounds = tile2.getAbsoluteGeomBounds(origin);
            DoubleRectangle doubleRectangle2 = result;
            result = doubleRectangle2 == null ? geomBounds : ((doubleRectangle = doubleRectangle2.union(geomBounds)) == null ? geomBounds : doubleRectangle);
        }
        DoubleRectangle doubleRectangle = result;
        Intrinsics.checkNotNull(doubleRectangle);
        return doubleRectangle;
    }

    @NotNull
    public final DoubleRectangle liveMapBounds(@NotNull DoubleRectangle container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        return new DoubleRectangle(container.getOrigin().add(LIVE_MAP_PLOT_PADDING), container.getDimension().subtract(LIVE_MAP_PLOT_MARGIN));
    }
}

