/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout;

import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.AxisLayout;
import jetbrains.datalore.plot.builder.layout.AxisLayoutInfo;
import jetbrains.datalore.plot.builder.layout.axis.AxisBreaksProvider;
import jetbrains.datalore.plot.builder.layout.axis.AxisBreaksProviderFactory;
import jetbrains.datalore.plot.builder.layout.axis.AxisLayouter;
import jetbrains.datalore.plot.builder.presentation.PlotLabelSpec;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018BC\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/datalore/plot/builder/layout/PlotAxisLayout;", "Ljetbrains/datalore/plot/builder/layout/AxisLayout;", "breaksProviderFactory", "Ljetbrains/datalore/plot/builder/layout/axis/AxisBreaksProviderFactory;", "domainX", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "domainY", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "theme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "(Ljetbrains/datalore/plot/builder/layout/axis/AxisBreaksProviderFactory;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/plot/builder/coord/CoordProvider;Ljetbrains/datalore/plot/builder/theme/AxisTheme;Ljetbrains/datalore/plot/builder/guide/Orientation;)V", "createLayouter", "Ljetbrains/datalore/plot/builder/layout/axis/AxisLayouter;", "displaySize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "doLayout", "Ljetbrains/datalore/plot/builder/layout/AxisLayoutInfo;", "maxTickLabelsBoundsStretched", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "initialThickness", "Companion", "plot-builder-portable"})
public final class PlotAxisLayout
implements AxisLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AxisBreaksProviderFactory breaksProviderFactory;
    @NotNull
    private final ClosedRange<Double> domainX;
    @NotNull
    private final ClosedRange<Double> domainY;
    @NotNull
    private final CoordProvider coordProvider;
    @NotNull
    private final AxisTheme theme;
    @NotNull
    private final Orientation orientation;
    @NotNull
    private static final PlotLabelSpec TICK_LABEL_SPEC = PlotLabelSpec.AXIS_TICK;

    public PlotAxisLayout(@NotNull AxisBreaksProviderFactory breaksProviderFactory, @NotNull ClosedRange<Double> domainX, @NotNull ClosedRange<Double> domainY, @NotNull CoordProvider coordProvider, @NotNull AxisTheme theme, @NotNull Orientation orientation) {
        Intrinsics.checkNotNullParameter((Object)breaksProviderFactory, (String)"breaksProviderFactory");
        Intrinsics.checkNotNullParameter(domainX, (String)"domainX");
        Intrinsics.checkNotNullParameter(domainY, (String)"domainY");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        this.breaksProviderFactory = breaksProviderFactory;
        this.domainX = domainX;
        this.domainY = domainY;
        this.coordProvider = coordProvider;
        this.theme = theme;
        this.orientation = orientation;
    }

    @Override
    public double initialThickness() {
        if (this.theme.showTickMarks() || this.theme.showLabels()) {
            double v = this.theme.tickLabelDistance();
            return this.theme.showLabels() ? v + PlotAxisLayout.Companion.initialTickLabelSize(this.orientation) : v;
        }
        return 0.0;
    }

    @Override
    @NotNull
    public AxisLayoutInfo doLayout(@NotNull DoubleVector displaySize, @Nullable DoubleRectangle maxTickLabelsBoundsStretched) {
        Intrinsics.checkNotNullParameter((Object)displaySize, (String)"displaySize");
        AxisLayouter layouter = this.createLayouter(displaySize);
        return layouter.doLayout(PlotAxisLayout.Companion.axisLength(displaySize, this.orientation), maxTickLabelsBoundsStretched);
    }

    private final AxisLayouter createLayouter(DoubleVector displaySize) {
        Pair<ClosedRange<Double>, ClosedRange<Double>> domains = this.coordProvider.adjustDomains(this.domainX, this.domainY, displaySize);
        ClosedRange axisDomain = PlotAxisLayout.Companion.axisDomain((Pair<? extends ClosedRange<Double>, ? extends ClosedRange<Double>>)domains, this.orientation);
        AxisBreaksProvider breaksProvider = this.breaksProviderFactory.createAxisBreaksProvider(axisDomain);
        return AxisLayouter.Companion.create(this.orientation, axisDomain, breaksProvider, this.theme);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u001e\u0010\b\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J@\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J@\u0010\u001a\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/datalore/plot/builder/layout/PlotAxisLayout$Companion;", "", "()V", "TICK_LABEL_SPEC", "Ljetbrains/datalore/plot/builder/presentation/PlotLabelSpec;", "axisDomain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "xyDomains", "Lkotlin/Pair;", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "axisLength", "displaySize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "bottom", "Ljetbrains/datalore/plot/builder/layout/AxisLayout;", "scale", "Ljetbrains/datalore/plot/base/Scale;", "xDomain", "yDomain", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "theme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "initialTickLabelSize", "left", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AxisLayout bottom(@NotNull Scale<Double> scale, @NotNull ClosedRange<Double> xDomain, @NotNull ClosedRange<Double> yDomain, @NotNull CoordProvider coordProvider, @NotNull AxisTheme theme) {
            Intrinsics.checkNotNullParameter(scale, (String)"scale");
            Intrinsics.checkNotNullParameter(xDomain, (String)"xDomain");
            Intrinsics.checkNotNullParameter(yDomain, (String)"yDomain");
            Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            return new PlotAxisLayout(AxisBreaksProviderFactory.Companion.forScale(scale), xDomain, yDomain, coordProvider, theme, Orientation.BOTTOM);
        }

        @NotNull
        public final AxisLayout left(@NotNull Scale<Double> scale, @NotNull ClosedRange<Double> xDomain, @NotNull ClosedRange<Double> yDomain, @NotNull CoordProvider coordProvider, @NotNull AxisTheme theme) {
            Intrinsics.checkNotNullParameter(scale, (String)"scale");
            Intrinsics.checkNotNullParameter(xDomain, (String)"xDomain");
            Intrinsics.checkNotNullParameter(yDomain, (String)"yDomain");
            Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            return new PlotAxisLayout(AxisBreaksProviderFactory.Companion.forScale(scale), xDomain, yDomain, coordProvider, theme, Orientation.LEFT);
        }

        private final double initialTickLabelSize(Orientation orientation) {
            return orientation.isHorizontal() ? TICK_LABEL_SPEC.height() : TICK_LABEL_SPEC.width(1);
        }

        private final double axisLength(DoubleVector displaySize, Orientation orientation) {
            return orientation.isHorizontal() ? displaySize.getX() : displaySize.getY();
        }

        private final ClosedRange<Double> axisDomain(Pair<? extends ClosedRange<Double>, ? extends ClosedRange<Double>> xyDomains, Orientation orientation) {
            return orientation.isHorizontal() ? (ClosedRange)xyDomains.getFirst() : (ClosedRange)xyDomains.getSecond();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

