/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.interact;

import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.registration.CompositeRegistration;
import jetbrains.datalore.base.registration.Disposable;
import jetbrains.datalore.base.registration.Registration;
import jetbrains.datalore.plot.base.interact.GeomTargetLocator;
import jetbrains.datalore.plot.builder.event.MouseEventPeer;
import jetbrains.datalore.plot.builder.interact.PlotInteractor;
import jetbrains.datalore.plot.builder.interact.PlotTooltipBounds;
import jetbrains.datalore.plot.builder.interact.TooltipRenderer;
import jetbrains.datalore.plot.builder.interact.ViewToolboxRenderer;
import jetbrains.datalore.plot.builder.interact.ui.EventsManager;
import jetbrains.datalore.plot.builder.theme.Theme;
import jetbrains.datalore.vis.svg.SvgNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J&\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J\u001c\u0010\u001f\u001a\u00020\u00162\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00160!H\u0016J\u0016\u0010\"\u001a\u00020\u00162\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160#H\u0016J\u001c\u0010$\u001a\u00020\u00162\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00160!H\u0016J\u001c\u0010%\u001a\u00020\u00162\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00160!H\u0016J\u001c\u0010&\u001a\u00020\u00162\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00160!H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Ljetbrains/datalore/plot/builder/interact/Interactor;", "Ljetbrains/datalore/plot/builder/interact/PlotInteractor;", "decorationLayer", "Ljetbrains/datalore/vis/svg/SvgNode;", "mouseEventPeer", "Ljetbrains/datalore/plot/builder/event/MouseEventPeer;", "plotSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "flippedAxis", "", "theme", "Ljetbrains/datalore/plot/builder/theme/Theme;", "(Ljetbrains/datalore/vis/svg/SvgNode;Ljetbrains/datalore/plot/builder/event/MouseEventPeer;Ljetbrains/datalore/base/geometry/DoubleVector;ZLjetbrains/datalore/plot/builder/theme/Theme;)V", "eventsManager", "Ljetbrains/datalore/plot/builder/interact/ui/EventsManager;", "reg", "Ljetbrains/datalore/base/registration/CompositeRegistration;", "tooltipRenderer", "Ljetbrains/datalore/plot/builder/interact/TooltipRenderer;", "viewToolboxRenderer", "Ljetbrains/datalore/plot/builder/interact/ViewToolboxRenderer;", "dispose", "", "onTileAdded", "geomBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "tooltipBounds", "Ljetbrains/datalore/plot/builder/interact/PlotTooltipBounds;", "targetLocators", "", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator;", "onViewPanning", "function", "Lkotlin/Function1;", "onViewReset", "Lkotlin/Function0;", "onViewZoomArea", "onViewZoomIn", "onViewZoomOut", "plot-builder"})
public final class Interactor
implements PlotInteractor {
    @NotNull
    private final CompositeRegistration reg;
    @NotNull
    private final EventsManager eventsManager;
    @NotNull
    private final TooltipRenderer tooltipRenderer;
    @Nullable
    private final ViewToolboxRenderer viewToolboxRenderer;

    public Interactor(@NotNull SvgNode decorationLayer, @NotNull MouseEventPeer mouseEventPeer, @NotNull DoubleVector plotSize2, boolean flippedAxis, @NotNull Theme theme) {
        Intrinsics.checkNotNullParameter((Object)decorationLayer, (String)"decorationLayer");
        Intrinsics.checkNotNullParameter((Object)mouseEventPeer, (String)"mouseEventPeer");
        Intrinsics.checkNotNullParameter((Object)plotSize2, (String)"plotSize");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.reg = new CompositeRegistration(new Registration[0]);
        this.eventsManager = new EventsManager();
        this.reg.add(Registration.Companion.from((Disposable)this.eventsManager));
        this.eventsManager.setEventSource(mouseEventPeer);
        this.tooltipRenderer = new TooltipRenderer(decorationLayer, flippedAxis, plotSize2, theme.axisX(flippedAxis), theme.axisY(flippedAxis), mouseEventPeer);
        this.reg.add(Registration.Companion.from((Disposable)this.tooltipRenderer));
        this.viewToolboxRenderer = null;
    }

    @Override
    public void onTileAdded(@NotNull DoubleRectangle geomBounds, @NotNull PlotTooltipBounds tooltipBounds, @NotNull List<? extends GeomTargetLocator> targetLocators) {
        Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
        Intrinsics.checkNotNullParameter((Object)tooltipBounds, (String)"tooltipBounds");
        Intrinsics.checkNotNullParameter(targetLocators, (String)"targetLocators");
        this.tooltipRenderer.addTileInfo(geomBounds, tooltipBounds, targetLocators);
    }

    @Override
    public void onViewReset(@NotNull Function0<Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        ViewToolboxRenderer viewToolboxRenderer = this.viewToolboxRenderer;
        if (viewToolboxRenderer != null) {
            viewToolboxRenderer.onViewReset(function);
        }
    }

    @Override
    public void onViewZoomIn(@NotNull Function1<? super DoubleVector, Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        ViewToolboxRenderer viewToolboxRenderer = this.viewToolboxRenderer;
        if (viewToolboxRenderer != null) {
            viewToolboxRenderer.onViewZoomIn(function);
        }
    }

    @Override
    public void onViewZoomArea(@NotNull Function1<? super DoubleRectangle, Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        ViewToolboxRenderer viewToolboxRenderer = this.viewToolboxRenderer;
        if (viewToolboxRenderer != null) {
            viewToolboxRenderer.onViewZoomArea(function);
        }
    }

    @Override
    public void onViewZoomOut(@NotNull Function1<? super DoubleVector, Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        ViewToolboxRenderer viewToolboxRenderer = this.viewToolboxRenderer;
        if (viewToolboxRenderer != null) {
            viewToolboxRenderer.onViewZoomOut(function);
        }
    }

    @Override
    public void onViewPanning(@NotNull Function1<? super DoubleVector, Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        ViewToolboxRenderer viewToolboxRenderer = this.viewToolboxRenderer;
        if (viewToolboxRenderer != null) {
            viewToolboxRenderer.onViewPanning(function);
        }
    }

    @Override
    public void dispose() {
        this.reg.dispose();
    }
}

