/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.guide;

import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.plot.builder.guide.LegendDirection;
import jetbrains.datalore.plot.builder.presentation.PlotLabelSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000  2\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\nR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Ljetbrains/datalore/plot/builder/guide/LegendBoxLayout;", "", "title", "", "legendDirection", "Ljetbrains/datalore/plot/builder/guide/LegendDirection;", "(Ljava/lang/String;Ljetbrains/datalore/plot/builder/guide/LegendDirection;)V", "graphOrigin", "Ljetbrains/datalore/base/geometry/DoubleVector;", "getGraphOrigin", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "graphSize", "getGraphSize", "isHorizontal", "", "()Z", "size", "getSize", "titleBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "getTitleBounds", "()Ljetbrains/datalore/base/geometry/DoubleRectangle;", "titleHorizontalAnchor", "Ljetbrains/datalore/plot/base/render/svg/TextLabel$HorizontalAnchor;", "getTitleHorizontalAnchor", "()Ljetbrains/datalore/plot/base/render/svg/TextLabel$HorizontalAnchor;", "titleLocation", "getTitleLocation", "titleVerticalAnchor", "Ljetbrains/datalore/plot/base/render/svg/TextLabel$VerticalAnchor;", "getTitleVerticalAnchor", "()Ljetbrains/datalore/plot/base/render/svg/TextLabel$VerticalAnchor;", "Companion", "plot-builder-portable"})
public abstract class LegendBoxLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String title;
    private final boolean isHorizontal;
    @NotNull
    private final TextLabel.HorizontalAnchor titleHorizontalAnchor;
    @NotNull
    private final TextLabel.VerticalAnchor titleVerticalAnchor;
    @NotNull
    private static final PlotLabelSpec TITLE_SPEC = PlotLabelSpec.LEGEND_TITLE;
    @NotNull
    private static final PlotLabelSpec LABEL_SPEC = PlotLabelSpec.LEGEND_ITEM;

    public LegendBoxLayout(@NotNull String title, @NotNull LegendDirection legendDirection) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)((Object)legendDirection), (String)"legendDirection");
        this.title = title;
        this.isHorizontal = legendDirection == LegendDirection.HORIZONTAL;
        this.titleHorizontalAnchor = TextLabel.HorizontalAnchor.LEFT;
        this.titleVerticalAnchor = this.isHorizontal ? TextLabel.VerticalAnchor.CENTER : TextLabel.VerticalAnchor.TOP;
    }

    @NotNull
    public abstract DoubleVector getGraphSize();

    public final boolean isHorizontal() {
        return this.isHorizontal;
    }

    @NotNull
    public final TextLabel.HorizontalAnchor getTitleHorizontalAnchor() {
        return this.titleHorizontalAnchor;
    }

    @NotNull
    public final TextLabel.VerticalAnchor getTitleVerticalAnchor() {
        return this.titleVerticalAnchor;
    }

    @NotNull
    public final DoubleRectangle getTitleBounds() {
        DoubleVector origin = this.getTitleLocation();
        DoubleVector size2 = LegendBoxLayout.Companion.titleSize(this.title);
        if (this.isHorizontal) {
            origin = new DoubleVector(origin.getX(), origin.getY() - size2.getY() / (double)2);
        }
        return new DoubleRectangle(origin, size2);
    }

    @NotNull
    public final DoubleVector getGraphOrigin() {
        return this.isHorizontal ? new DoubleVector(LegendBoxLayout.Companion.titleSize(this.title).getX(), 0.0) : new DoubleVector(0.0, LegendBoxLayout.Companion.titleSize(this.title).getY());
    }

    @NotNull
    public final DoubleVector getSize() {
        DoubleRectangle graphBounds = new DoubleRectangle(this.getGraphOrigin(), this.getGraphSize());
        DoubleRectangle titleAndContent = new DoubleRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO()).union(this.getTitleBounds()).union(graphBounds);
        return titleAndContent.getDimension();
    }

    @NotNull
    public final DoubleVector getTitleLocation() {
        DoubleVector doubleVector;
        if (this.isHorizontal) {
            DoubleVector graphSize = this.getGraphSize();
            doubleVector = new DoubleVector(0.0, graphSize.getY() / (double)2);
        } else {
            double y2 = -TITLE_SPEC.height() / (double)3;
            doubleVector = new DoubleVector(0.0, y2);
        }
        return doubleVector;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljetbrains/datalore/plot/builder/guide/LegendBoxLayout$Companion;", "", "()V", "LABEL_SPEC", "Ljetbrains/datalore/plot/builder/presentation/PlotLabelSpec;", "getLABEL_SPEC$plot_builder_portable", "()Ljetbrains/datalore/plot/builder/presentation/PlotLabelSpec;", "TITLE_SPEC", "titleSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "s", "", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PlotLabelSpec getLABEL_SPEC$plot_builder_portable() {
            return LABEL_SPEC;
        }

        private final DoubleVector titleSize(String s2) {
            return StringsKt.isBlank((CharSequence)s2) ? DoubleVector.Companion.getZERO() : TITLE_SPEC.dimensions(s2.length());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

