/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder;

import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.scale.ScaleBreaks;
import jetbrains.datalore.plot.builder.SquareFrameOfReference;
import jetbrains.datalore.plot.builder.TileFrameOfReference;
import jetbrains.datalore.plot.builder.TileFrameOfReferenceProvider;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.AxisLayoutInfo;
import jetbrains.datalore.plot.builder.layout.PlotAxisLayout;
import jetbrains.datalore.plot.builder.layout.TileLayout;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import jetbrains.datalore.plot.builder.layout.XYPlotTileLayout;
import jetbrains.datalore.plot.builder.layout.axis.AxisBreaksProviderFactory;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import jetbrains.datalore.plot.builder.theme.Theme;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\"BM\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J\b\u0010 \u001a\u00020!H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u000e\u0010\u001a\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ljetbrains/datalore/plot/builder/SquareFrameOfReferenceProvider;", "Ljetbrains/datalore/plot/builder/TileFrameOfReferenceProvider;", "xScaleProto", "Ljetbrains/datalore/plot/base/Scale;", "", "yScaleProto", "xAesRange", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "yAesRange", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "theme", "Ljetbrains/datalore/plot/builder/theme/Theme;", "(Ljetbrains/datalore/plot/base/Scale;Ljetbrains/datalore/plot/base/Scale;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/plot/builder/coord/CoordProvider;Ljetbrains/datalore/plot/builder/theme/Theme;)V", "flipAxis", "", "getFlipAxis", "()Z", "hAxisLabel", "", "getHAxisLabel", "()Ljava/lang/String;", "hAxisSpec", "Ljetbrains/datalore/plot/builder/SquareFrameOfReferenceProvider$AxisSpec;", "vAxisLabel", "getVAxisLabel", "vAxisSpec", "createFrameOfReference", "Ljetbrains/datalore/plot/builder/TileFrameOfReference;", "layoutInfo", "Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;", "debugDrawing", "createTileLayout", "Ljetbrains/datalore/plot/builder/layout/TileLayout;", "AxisSpec", "plot-builder-portable"})
public final class SquareFrameOfReferenceProvider
implements TileFrameOfReferenceProvider {
    @NotNull
    private final Scale<Double> xScaleProto;
    @NotNull
    private final Scale<Double> yScaleProto;
    @NotNull
    private final CoordProvider coordProvider;
    @NotNull
    private final Theme theme;
    private final boolean flipAxis;
    @NotNull
    private final AxisSpec vAxisSpec;
    @NotNull
    private final AxisSpec hAxisSpec;
    @Nullable
    private final String hAxisLabel;
    @Nullable
    private final String vAxisLabel;

    public SquareFrameOfReferenceProvider(@NotNull Scale<Double> xScaleProto, @NotNull Scale<Double> yScaleProto, @NotNull ClosedRange<Double> xAesRange, @NotNull ClosedRange<Double> yAesRange, @NotNull CoordProvider coordProvider, @NotNull Theme theme) {
        Intrinsics.checkNotNullParameter(xScaleProto, (String)"xScaleProto");
        Intrinsics.checkNotNullParameter(yScaleProto, (String)"yScaleProto");
        Intrinsics.checkNotNullParameter(xAesRange, (String)"xAesRange");
        Intrinsics.checkNotNullParameter(yAesRange, (String)"yAesRange");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.xScaleProto = xScaleProto;
        this.yScaleProto = yScaleProto;
        this.coordProvider = coordProvider;
        this.theme = theme;
        this.flipAxis = this.coordProvider.getFlipAxis();
        AxisSpec xAxisSpec = new AxisSpec(AxisBreaksProviderFactory.Companion.forScale(this.xScaleProto), xAesRange, this.xScaleProto.getName(), Theme.DefaultImpls.axisX$default(this.theme, false, 1, null));
        AxisSpec yAxisSpec = new AxisSpec(AxisBreaksProviderFactory.Companion.forScale(this.yScaleProto), yAesRange, this.yScaleProto.getName(), Theme.DefaultImpls.axisY$default(this.theme, false, 1, null));
        this.hAxisSpec = this.getFlipAxis() ? yAxisSpec : xAxisSpec;
        this.vAxisSpec = this.getFlipAxis() ? xAxisSpec : yAxisSpec;
        this.hAxisLabel = this.hAxisSpec.getTheme().showTitle() ? this.hAxisSpec.getLabel() : null;
        this.vAxisLabel = this.vAxisSpec.getTheme().showTitle() ? this.vAxisSpec.getLabel() : null;
    }

    @Override
    public boolean getFlipAxis() {
        return this.flipAxis;
    }

    @Override
    @Nullable
    public String getHAxisLabel() {
        return this.hAxisLabel;
    }

    @Override
    @Nullable
    public String getVAxisLabel() {
        return this.vAxisLabel;
    }

    @Override
    @NotNull
    public TileLayout createTileLayout() {
        ClosedRange<Double> hDomain = this.hAxisSpec.getAesRange();
        ClosedRange<Double> vDomain = this.vAxisSpec.getAesRange();
        PlotAxisLayout hAxisLayout = new PlotAxisLayout(this.hAxisSpec.getBreaksProviderFactory(), hDomain, vDomain, this.coordProvider, this.hAxisSpec.getTheme(), Orientation.BOTTOM);
        PlotAxisLayout vAxisLayout = new PlotAxisLayout(this.vAxisSpec.getBreaksProviderFactory(), hDomain, vDomain, this.coordProvider, this.vAxisSpec.getTheme(), Orientation.LEFT);
        return new XYPlotTileLayout(hAxisLayout, vAxisLayout);
    }

    @Override
    @NotNull
    public TileFrameOfReference createFrameOfReference(@NotNull TileLayoutInfo layoutInfo, boolean debugDrawing) {
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        AxisLayoutInfo axisLayoutInfo = layoutInfo.getXAxisInfo();
        Intrinsics.checkNotNull((Object)axisLayoutInfo);
        AxisLayoutInfo hAxisLayoutInfo = axisLayoutInfo;
        AxisLayoutInfo axisLayoutInfo2 = layoutInfo.getYAxisInfo();
        Intrinsics.checkNotNull((Object)axisLayoutInfo2);
        AxisLayoutInfo vAxisLayoutInfo = axisLayoutInfo2;
        Scale<Double> hScaleProto = this.getFlipAxis() ? this.yScaleProto : this.xScaleProto;
        Scale<Double> vScaleProto = this.getFlipAxis() ? this.xScaleProto : this.yScaleProto;
        ClosedRange<Double> closedRange = hAxisLayoutInfo.getAxisDomain();
        Intrinsics.checkNotNull(closedRange);
        double d = hAxisLayoutInfo.getAxisLength();
        ScaleBreaks scaleBreaks = hAxisLayoutInfo.getAxisBreaks();
        Intrinsics.checkNotNull((Object)scaleBreaks);
        Scale<Double> hScale = this.coordProvider.buildAxisScaleX(hScaleProto, closedRange, d, scaleBreaks);
        ClosedRange<Double> closedRange2 = vAxisLayoutInfo.getAxisDomain();
        Intrinsics.checkNotNull(closedRange2);
        double d2 = vAxisLayoutInfo.getAxisLength();
        ScaleBreaks scaleBreaks2 = vAxisLayoutInfo.getAxisBreaks();
        Intrinsics.checkNotNull((Object)scaleBreaks2);
        Scale<Double> vScale = this.coordProvider.buildAxisScaleY(vScaleProto, closedRange2, d2, scaleBreaks2);
        CoordinateSystem coord = this.coordProvider.createCoordinateSystem(hAxisLayoutInfo.getAxisDomain(), hAxisLayoutInfo.getAxisLength(), vAxisLayoutInfo.getAxisDomain(), vAxisLayoutInfo.getAxisLength());
        SquareFrameOfReference tileFrameOfReference = new SquareFrameOfReference(hScale, vScale, coord, layoutInfo, this.theme, this.getFlipAxis());
        tileFrameOfReference.setDebugDrawing(debugDrawing);
        return tileFrameOfReference;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/builder/SquareFrameOfReferenceProvider$AxisSpec;", "", "breaksProviderFactory", "Ljetbrains/datalore/plot/builder/layout/axis/AxisBreaksProviderFactory;", "aesRange", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "label", "", "theme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "(Ljetbrains/datalore/plot/builder/layout/axis/AxisBreaksProviderFactory;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljava/lang/String;Ljetbrains/datalore/plot/builder/theme/AxisTheme;)V", "getAesRange", "()Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "getBreaksProviderFactory", "()Ljetbrains/datalore/plot/builder/layout/axis/AxisBreaksProviderFactory;", "getLabel", "()Ljava/lang/String;", "getTheme", "()Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "plot-builder-portable"})
    private static final class AxisSpec {
        @NotNull
        private final AxisBreaksProviderFactory breaksProviderFactory;
        @NotNull
        private final ClosedRange<Double> aesRange;
        @Nullable
        private final String label;
        @NotNull
        private final AxisTheme theme;

        public AxisSpec(@NotNull AxisBreaksProviderFactory breaksProviderFactory, @NotNull ClosedRange<Double> aesRange, @Nullable String label, @NotNull AxisTheme theme) {
            Intrinsics.checkNotNullParameter((Object)breaksProviderFactory, (String)"breaksProviderFactory");
            Intrinsics.checkNotNullParameter(aesRange, (String)"aesRange");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            this.breaksProviderFactory = breaksProviderFactory;
            this.aesRange = aesRange;
            this.label = label;
            this.theme = theme;
        }

        @NotNull
        public final AxisBreaksProviderFactory getBreaksProviderFactory() {
            return this.breaksProviderFactory;
        }

        @NotNull
        public final ClosedRange<Double> getAesRange() {
            return this.aesRange;
        }

        @Nullable
        public final String getLabel() {
            return this.label;
        }

        @NotNull
        public final AxisTheme getTheme() {
            return this.theme;
        }
    }
}

