/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.scale.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.plot.base.ContinuousTransform;
import jetbrains.datalore.plot.base.scale.BreaksGenerator;
import jetbrains.datalore.plot.base.scale.MapperUtil;
import jetbrains.datalore.plot.base.scale.ScaleBreaks;
import jetbrains.datalore.plot.base.scale.transform.IdentityTransform;
import jetbrains.datalore.plot.base.scale.transform.LinearBreaksGen;
import jetbrains.datalore.plot.base.scale.transform.Log10Transform;
import jetbrains.datalore.plot.base.scale.transform.NonlinearBreaksGen;
import jetbrains.datalore.plot.base.scale.transform.ReverseTransform;
import jetbrains.datalore.plot.base.scale.transform.SqrtTransform;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0018"}, d2={"Ljetbrains/datalore/plot/base/scale/transform/Transforms;", "", "()V", "IDENTITY", "Ljetbrains/datalore/plot/base/ContinuousTransform;", "getIDENTITY", "()Ljetbrains/datalore/plot/base/ContinuousTransform;", "LOG10", "getLOG10", "REVERSE", "getREVERSE", "SQRT", "getSQRT", "createBreaksGeneratorForTransformedDomain", "Ljetbrains/datalore/plot/base/scale/BreaksGenerator;", "transform", "labelFormatter", "Lkotlin/Function1;", "", "ensureApplicableDomain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "dataRange", "BreaksGeneratorForTransformedDomain", "plot-base-portable"})
public final class Transforms {
    @NotNull
    public static final Transforms INSTANCE = new Transforms();
    @NotNull
    private static final ContinuousTransform IDENTITY = new IdentityTransform();
    @NotNull
    private static final ContinuousTransform REVERSE = new ReverseTransform();
    @NotNull
    private static final ContinuousTransform SQRT = new SqrtTransform();
    @NotNull
    private static final ContinuousTransform LOG10 = new Log10Transform();

    private Transforms() {
    }

    @NotNull
    public final ContinuousTransform getIDENTITY() {
        return IDENTITY;
    }

    @NotNull
    public final ContinuousTransform getREVERSE() {
        return REVERSE;
    }

    @NotNull
    public final ContinuousTransform getSQRT() {
        return SQRT;
    }

    @NotNull
    public final ContinuousTransform getLOG10() {
        return LOG10;
    }

    @NotNull
    public final BreaksGenerator createBreaksGeneratorForTransformedDomain(@NotNull ContinuousTransform transform2, @Nullable Function1<Object, String> labelFormatter2) {
        BreaksGenerator breaksGenerator;
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        ContinuousTransform continuousTransform = transform2;
        if (Intrinsics.areEqual((Object)continuousTransform, (Object)IDENTITY)) {
            breaksGenerator = new LinearBreaksGen(labelFormatter2);
        } else if (Intrinsics.areEqual((Object)continuousTransform, (Object)REVERSE)) {
            breaksGenerator = new LinearBreaksGen(labelFormatter2);
        } else if (Intrinsics.areEqual((Object)continuousTransform, (Object)SQRT)) {
            breaksGenerator = new NonlinearBreaksGen(SQRT, labelFormatter2);
        } else if (Intrinsics.areEqual((Object)continuousTransform, (Object)LOG10)) {
            breaksGenerator = new NonlinearBreaksGen(LOG10, labelFormatter2);
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Unexpected 'transform' type: ", (Object)Reflection.getOrCreateKotlinClass(transform2.getClass()).getSimpleName()));
        }
        BreaksGenerator breaksGenerator2 = breaksGenerator;
        return new BreaksGeneratorForTransformedDomain(transform2, breaksGenerator2);
    }

    public static /* synthetic */ BreaksGenerator createBreaksGeneratorForTransformedDomain$default(Transforms transforms, ContinuousTransform continuousTransform, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return transforms.createBreaksGeneratorForTransformedDomain(continuousTransform, (Function1<Object, String>)function1);
    }

    @NotNull
    public final ClosedRange<Double> ensureApplicableDomain(@Nullable ClosedRange<Double> dataRange, @NotNull ContinuousTransform transform2) {
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        if (dataRange == null) {
            return ContinuousTransform.DefaultImpls.createApplicableDomain$default(transform2, null, 1, null);
        }
        ClosedRange<Double> domain = transform2.toApplicableDomain(dataRange);
        return SeriesUtil.INSTANCE.isSubTiny(domain) ? transform2.createApplicableDomain(domain.getUpperEnd()) : domain;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/plot/base/scale/transform/Transforms$BreaksGeneratorForTransformedDomain;", "Ljetbrains/datalore/plot/base/scale/BreaksGenerator;", "transform", "Ljetbrains/datalore/plot/base/ContinuousTransform;", "breaksGenerator", "(Ljetbrains/datalore/plot/base/ContinuousTransform;Ljetbrains/datalore/plot/base/scale/BreaksGenerator;)V", "getBreaksGenerator", "()Ljetbrains/datalore/plot/base/scale/BreaksGenerator;", "generateBreaks", "Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "domain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "targetCount", "", "labelFormatter", "Lkotlin/Function1;", "", "", "plot-base-portable"})
    public static final class BreaksGeneratorForTransformedDomain
    implements BreaksGenerator {
        @NotNull
        private final ContinuousTransform transform;
        @NotNull
        private final BreaksGenerator breaksGenerator;

        public BreaksGeneratorForTransformedDomain(@NotNull ContinuousTransform transform2, @NotNull BreaksGenerator breaksGenerator) {
            Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
            Intrinsics.checkNotNullParameter((Object)breaksGenerator, (String)"breaksGenerator");
            this.transform = transform2;
            this.breaksGenerator = breaksGenerator;
        }

        @NotNull
        public final BreaksGenerator getBreaksGenerator() {
            return this.breaksGenerator;
        }

        @Override
        @NotNull
        public Function1<Object, String> labelFormatter(@NotNull ClosedRange<Double> domain, int targetCount) {
            Intrinsics.checkNotNullParameter(domain, (String)"domain");
            ClosedRange<Double> domainBeforeTransform2 = MapperUtil.INSTANCE.map(domain, (Function1<? super Double, Double>)((Function1)new Function1<Double, Double>(this){
                final /* synthetic */ BreaksGeneratorForTransformedDomain this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final Double invoke(@Nullable Double it) {
                    return BreaksGeneratorForTransformedDomain.access$getTransform$p(this.this$0).applyInverse(it);
                }
            }));
            return this.breaksGenerator.labelFormatter(domainBeforeTransform2, targetCount);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public ScaleBreaks generateBreaks(@NotNull ClosedRange<Double> domain, int targetCount) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(domain, (String)"domain");
            ClosedRange<Double> domainBeforeTransform2 = MapperUtil.INSTANCE.map(domain, (Function1<? super Double, Double>)((Function1)new Function1<Double, Double>(this){
                final /* synthetic */ BreaksGeneratorForTransformedDomain this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final Double invoke(@Nullable Double it) {
                    return BreaksGeneratorForTransformedDomain.access$getTransform$p(this.this$0).applyInverse(it);
                }
            }));
            ScaleBreaks scaleBreaks = this.breaksGenerator.generateBreaks(domainBeforeTransform2, targetCount);
            List<Object> originalBreaks = scaleBreaks.getDomainValues();
            Iterable $this$map$iv = this.transform.apply(originalBreaks);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Double d = (Double)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (it == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                }
                Double d2 = it.doubleValue();
                collection.add(d2);
            }
            List transformedBreaks = (List)destination$iv$iv;
            return new ScaleBreaks(originalBreaks, transformedBreaks, scaleBreaks.getLabels());
        }

        public static final /* synthetic */ ContinuousTransform access$getTransform$p(BreaksGeneratorForTransformedDomain $this) {
            return $this.transform;
        }
    }
}

