/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.render.svg;

import jetbrains.datalore.base.observable.property.Property;
import jetbrains.datalore.base.observable.property.WritableProperty;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.render.svg.SvgComponent;
import jetbrains.datalore.vis.svg.SvgTextElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002&'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0007J\u0010\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u001dJ\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001dJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u001bH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u001bH\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\"\u001a\u00020\u000fH\u0002J\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070$J\u000e\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070$R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Ljetbrains/datalore/plot/base/render/svg/TextLabel;", "Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "text", "", "(Ljava/lang/String;)V", "myFontFamily", "myFontSize", "", "myFontStyle", "myFontWeight", "myText", "Ljetbrains/datalore/vis/svg/SvgTextElement;", "myTextColor", "Ljetbrains/datalore/base/values/Color;", "buildComponent", "", "setFontFamily", "fontFamily", "setFontSize", "px", "setFontStyle", "cssName", "setFontWeight", "setHorizontalAnchor", "anchor", "Ljetbrains/datalore/plot/base/render/svg/TextLabel$HorizontalAnchor;", "setVerticalAnchor", "Ljetbrains/datalore/plot/base/render/svg/TextLabel$VerticalAnchor;", "textColor", "Ljetbrains/datalore/base/observable/property/WritableProperty;", "textOpacity", "toDY", "toDominantBaseline", "toTextAnchor", "updateStyleAttribute", "x", "Ljetbrains/datalore/base/observable/property/Property;", "y", "HorizontalAnchor", "VerticalAnchor", "plot-base-portable"})
public final class TextLabel
extends SvgComponent {
    @NotNull
    private final SvgTextElement myText;
    @Nullable
    private Color myTextColor;
    private double myFontSize;
    @Nullable
    private String myFontWeight;
    @Nullable
    private String myFontFamily;
    @Nullable
    private String myFontStyle;

    public TextLabel(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.myText = new SvgTextElement(text);
        this.getRootGroup().children().add(this.myText);
    }

    @Override
    protected void buildComponent() {
    }

    @NotNull
    public final WritableProperty<Color> textColor() {
        return new WritableProperty<Color>(this){
            final /* synthetic */ TextLabel this$0;
            {
                this.this$0 = $receiver;
            }

            public void set(@Nullable Color value) {
                TextLabel.access$getMyText$p(this.this$0).fillColor();
                TextLabel.access$setMyTextColor$p(this.this$0, value);
                TextLabel.access$updateStyleAttribute(this.this$0);
            }
        };
    }

    @NotNull
    public final WritableProperty<Double> textOpacity() {
        return this.myText.fillOpacity();
    }

    @NotNull
    public final Property<Double> x() {
        return this.myText.x();
    }

    @NotNull
    public final Property<Double> y() {
        return this.myText.y();
    }

    public final void setHorizontalAnchor(@NotNull HorizontalAnchor anchor) {
        Intrinsics.checkNotNullParameter((Object)((Object)anchor), (String)"anchor");
        this.myText.setAttribute("text-anchor", this.toTextAnchor(anchor));
    }

    public final void setVerticalAnchor(@NotNull VerticalAnchor anchor) {
        Intrinsics.checkNotNullParameter((Object)((Object)anchor), (String)"anchor");
        this.myText.setAttribute("dy", this.toDY(anchor));
    }

    public final void setFontSize(double px) {
        this.myFontSize = px;
        this.updateStyleAttribute();
    }

    public final void setFontWeight(@Nullable String cssName) {
        this.myFontWeight = cssName;
        this.updateStyleAttribute();
    }

    public final void setFontStyle(@Nullable String cssName) {
        this.myFontStyle = cssName;
        this.updateStyleAttribute();
    }

    public final void setFontFamily(@Nullable String fontFamily) {
        this.myFontFamily = fontFamily;
        this.updateStyleAttribute();
    }

    private final void updateStyleAttribute() {
        StringBuilder sb = new StringBuilder();
        if (this.myTextColor != null) {
            StringBuilder stringBuilder = sb.append("fill:");
            Color color = this.myTextColor;
            Intrinsics.checkNotNull((Object)color);
            stringBuilder.append(color.toHexColor()).append(';');
        }
        if (this.myFontSize > 0.0 && this.myFontFamily != null) {
            StringBuilder fnt = new StringBuilder();
            CharSequence charSequence = this.myFontStyle;
            boolean bl = false;
            boolean bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                String string = this.myFontStyle;
                Intrinsics.checkNotNull((Object)string);
                fnt.append(string).append(' ');
            }
            charSequence = this.myFontWeight;
            bl = false;
            bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                String string = this.myFontWeight;
                Intrinsics.checkNotNull((Object)string);
                fnt.append(string).append(' ');
            }
            fnt.append(this.myFontSize).append("px ");
            String string = this.myFontFamily;
            Intrinsics.checkNotNull((Object)string);
            fnt.append(string).append(";");
            sb.append("font:").append((CharSequence)fnt);
        } else {
            CharSequence charSequence = this.myFontStyle;
            boolean bl = false;
            boolean bl3 = false;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                StringBuilder stringBuilder = sb.append("font-style:");
                String string = this.myFontStyle;
                Intrinsics.checkNotNull((Object)string);
                stringBuilder.append(string).append(';');
            }
            charSequence = this.myFontWeight;
            bl = false;
            bl3 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                StringBuilder stringBuilder = sb.append("font-weight:");
                String string = this.myFontWeight;
                Intrinsics.checkNotNull((Object)string);
                stringBuilder.append(string).append(';');
            }
            if (this.myFontSize > 0.0) {
                sb.append("font-size:").append(this.myFontSize).append("px;");
            }
            charSequence = this.myFontFamily;
            bl = false;
            bl3 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                StringBuilder stringBuilder = sb.append("font-family:");
                String string = this.myFontFamily;
                Intrinsics.checkNotNull((Object)string);
                stringBuilder.append(string).append(';');
            }
        }
        this.myText.setAttribute("style", sb.toString());
    }

    private final String toTextAnchor(HorizontalAnchor anchor) {
        String string;
        HorizontalAnchor horizontalAnchor = anchor;
        int n = WhenMappings.$EnumSwitchMapping$0[horizontalAnchor.ordinal()];
        switch (n) {
            case 1: {
                string = null;
                break;
            }
            case 2: {
                string = "middle";
                break;
            }
            case 3: {
                string = "end";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String toDominantBaseline(VerticalAnchor anchor) {
        String string;
        VerticalAnchor verticalAnchor = anchor;
        int n = WhenMappings.$EnumSwitchMapping$1[verticalAnchor.ordinal()];
        switch (n) {
            case 1: {
                string = "hanging";
                break;
            }
            case 2: {
                string = "central";
                break;
            }
            case 3: {
                string = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String toDY(VerticalAnchor anchor) {
        String string;
        VerticalAnchor verticalAnchor = anchor;
        int n = WhenMappings.$EnumSwitchMapping$1[verticalAnchor.ordinal()];
        switch (n) {
            case 1: {
                string = "0.7em";
                break;
            }
            case 2: {
                string = "0.35em";
                break;
            }
            case 3: {
                string = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public static final /* synthetic */ SvgTextElement access$getMyText$p(TextLabel $this) {
        return $this.myText;
    }

    public static final /* synthetic */ void access$setMyTextColor$p(TextLabel $this, Color color) {
        $this.myTextColor = color;
    }

    public static final /* synthetic */ void access$updateStyleAttribute(TextLabel $this) {
        $this.updateStyleAttribute();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/plot/base/render/svg/TextLabel$HorizontalAnchor;", "", "(Ljava/lang/String;I)V", "LEFT", "RIGHT", "MIDDLE", "plot-base-portable"})
    public static final class HorizontalAnchor
    extends Enum<HorizontalAnchor> {
        public static final /* enum */ HorizontalAnchor LEFT = new HorizontalAnchor();
        public static final /* enum */ HorizontalAnchor RIGHT = new HorizontalAnchor();
        public static final /* enum */ HorizontalAnchor MIDDLE = new HorizontalAnchor();
        private static final /* synthetic */ HorizontalAnchor[] $VALUES;

        public static HorizontalAnchor[] values() {
            return (HorizontalAnchor[])$VALUES.clone();
        }

        public static HorizontalAnchor valueOf(String value) {
            return Enum.valueOf(HorizontalAnchor.class, value);
        }

        static {
            $VALUES = horizontalAnchorArray = new HorizontalAnchor[]{HorizontalAnchor.LEFT, HorizontalAnchor.RIGHT, HorizontalAnchor.MIDDLE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/plot/base/render/svg/TextLabel$VerticalAnchor;", "", "(Ljava/lang/String;I)V", "TOP", "BOTTOM", "CENTER", "plot-base-portable"})
    public static final class VerticalAnchor
    extends Enum<VerticalAnchor> {
        public static final /* enum */ VerticalAnchor TOP = new VerticalAnchor();
        public static final /* enum */ VerticalAnchor BOTTOM = new VerticalAnchor();
        public static final /* enum */ VerticalAnchor CENTER = new VerticalAnchor();
        private static final /* synthetic */ VerticalAnchor[] $VALUES;

        public static VerticalAnchor[] values() {
            return (VerticalAnchor[])$VALUES.clone();
        }

        public static VerticalAnchor valueOf(String value) {
            return Enum.valueOf(VerticalAnchor.class, value);
        }

        static {
            $VALUES = verticalAnchorArray = new VerticalAnchor[]{VerticalAnchor.TOP, VerticalAnchor.BOTTOM, VerticalAnchor.CENTER};
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[HorizontalAnchor.values().length];
            nArray[HorizontalAnchor.LEFT.ordinal()] = 1;
            nArray[HorizontalAnchor.MIDDLE.ordinal()] = 2;
            nArray[HorizontalAnchor.RIGHT.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[VerticalAnchor.values().length];
            nArray[VerticalAnchor.TOP.ordinal()] = 1;
            nArray[VerticalAnchor.CENTER.ordinal()] = 2;
            nArray[VerticalAnchor.BOTTOM.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

